/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WrappedByteChannel;

public class SocketChannelIOHelper {
    public static boolean read(ByteBuffer buf, WebSocketImpl ws, ByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.read(buf);
        buf.flip();
        if (read == -1) {
            ws.eot();
            return false;
        }
        return read != 0;
    }

    public static boolean readMore(ByteBuffer buf, WebSocketImpl ws, WrappedByteChannel channel) throws IOException {
        buf.clear();
        int read = channel.readMore(buf);
        buf.flip();
        if (read == -1) {
            ws.eot();
            return false;
        }
        return channel.isNeedRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean batch(WebSocketImpl ws, ByteChannel sockchannel) throws IOException {
        ByteBuffer buffer = (ByteBuffer)ws.outQueue.peek();
        WrappedByteChannel c = null;
        if (buffer == null) {
            if (sockchannel instanceof WrappedByteChannel && (c = (WrappedByteChannel)sockchannel).isNeedWrite()) {
                c.writeMore();
            }
        } else {
            do {
                sockchannel.write(buffer);
                if (buffer.remaining() > 0) {
                    return false;
                }
                ws.outQueue.poll();
            } while ((buffer = (ByteBuffer)ws.outQueue.peek()) != null);
        }
        if (ws.outQueue.isEmpty() && ws.isFlushAndClose()) {
            WebSocketImpl webSocketImpl = ws;
            synchronized (webSocketImpl) {
                ws.closeConnection();
            }
        }
        return c != null ? !((WrappedByteChannel)sockchannel).isNeedWrite() : true;
    }

    public static void writeBlocking(WebSocketImpl ws, ByteChannel channel) throws InterruptedException, IOException {
        assert (!(channel instanceof AbstractSelectableChannel) || ((AbstractSelectableChannel)((Object)channel)).isBlocking());
        assert (!(channel instanceof WrappedByteChannel) || ((WrappedByteChannel)channel).isBlocking());
        ByteBuffer buf = ws.outQueue.take();
        while (buf.hasRemaining()) {
            channel.write(buf);
        }
    }
}

