/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.concurrent.CountDownLatch;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SSLContextUtil;
import org.java_websocket.util.SocketUtil;
import org.junit.Assert;
import org.junit.Test;

public class Issue890Test {
    @Test(timeout=4000L)
    public void testWithSSLSession() throws IOException, URISyntaxException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, CertificateException, InterruptedException {
        int port = SocketUtil.getAvailablePort();
        final CountDownLatch countServerDownLatch = new CountDownLatch(1);
        WebSocketClient webSocket = new WebSocketClient(new URI("wss://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
                countServerDownLatch.countDown();
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        TestResult testResult = new TestResult();
        MyWebSocketServer server = new MyWebSocketServer(port, testResult, countServerDownLatch);
        SSLContext sslContext = SSLContextUtil.getContext();
        server.setWebSocketFactory((WebSocketServerFactory)new DefaultSSLWebSocketServerFactory(sslContext));
        webSocket.setSocketFactory((SocketFactory)sslContext.getSocketFactory());
        server.start();
        countServerDownLatch.await();
        webSocket.connectBlocking();
        Assert.assertTrue((boolean)testResult.hasSSLSupport);
        Assert.assertNotNull((Object)testResult.sslSession);
    }

    @Test(timeout=4000L)
    public void testWithOutSSLSession() throws IOException, URISyntaxException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, CertificateException, InterruptedException {
        int port = SocketUtil.getAvailablePort();
        final CountDownLatch countServerDownLatch = new CountDownLatch(1);
        WebSocketClient webSocket = new WebSocketClient(new URI("ws://localhost:" + port)){

            public void onOpen(ServerHandshake handshakedata) {
                countServerDownLatch.countDown();
            }

            public void onMessage(String message) {
            }

            public void onClose(int code, String reason, boolean remote) {
            }

            public void onError(Exception ex) {
            }
        };
        TestResult testResult = new TestResult();
        MyWebSocketServer server = new MyWebSocketServer(port, testResult, countServerDownLatch);
        server.start();
        countServerDownLatch.await();
        webSocket.connectBlocking();
        Assert.assertFalse((boolean)testResult.hasSSLSupport);
        Assert.assertNull((Object)testResult.sslSession);
    }

    private class TestResult {
        public SSLSession sslSession = null;
        public boolean hasSSLSupport = false;

        private TestResult() {
        }
    }

    private static class MyWebSocketServer
    extends WebSocketServer {
        private final TestResult testResult;
        private final CountDownLatch countServerDownLatch;

        public MyWebSocketServer(int port, TestResult testResult, CountDownLatch countServerDownLatch) {
            super(new InetSocketAddress(port));
            this.testResult = testResult;
            this.countServerDownLatch = countServerDownLatch;
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
            this.testResult.hasSSLSupport = conn.hasSSLSupport();
            try {
                this.testResult.sslSession = conn.getSSLSession();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        }

        public void onMessage(WebSocket conn, String message) {
        }

        public void onError(WebSocket conn, Exception ex) {
            ex.printStackTrace();
        }

        public void onStart() {
            this.countServerDownLatch.countDown();
        }
    }
}

