/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.util;

import java.nio.ByteBuffer;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.util.Charsetfunctions;
import org.junit.Assert;
import org.junit.Test;

public class CharsetfunctionsTest {
    @Test
    public void testAsciiBytes() {
        Assert.assertArrayEquals((byte[])new byte[]{102, 111, 111}, (byte[])Charsetfunctions.asciiBytes((String)"foo"));
    }

    @Test
    public void testStringUtf8ByteBuffer() throws InvalidDataException {
        Assert.assertEquals((Object)"foo", (Object)Charsetfunctions.stringUtf8((ByteBuffer)ByteBuffer.wrap(new byte[]{102, 111, 111})));
    }

    @Test
    public void testIsValidUTF8off() {
        Assert.assertFalse((boolean)Charsetfunctions.isValidUTF8((ByteBuffer)ByteBuffer.wrap(new byte[]{100}), (int)2));
        Assert.assertFalse((boolean)Charsetfunctions.isValidUTF8((ByteBuffer)ByteBuffer.wrap(new byte[]{-128}), (int)0));
        Assert.assertTrue((boolean)Charsetfunctions.isValidUTF8((ByteBuffer)ByteBuffer.wrap(new byte[]{100}), (int)0));
    }

    @Test
    public void testIsValidUTF8() {
        Assert.assertFalse((boolean)Charsetfunctions.isValidUTF8((ByteBuffer)ByteBuffer.wrap(new byte[]{-128})));
        Assert.assertTrue((boolean)Charsetfunctions.isValidUTF8((ByteBuffer)ByteBuffer.wrap(new byte[]{100})));
    }

    @Test
    public void testStringAscii1() {
        Assert.assertEquals((Object)"oBar", (Object)Charsetfunctions.stringAscii((byte[])new byte[]{102, 111, 111, 66, 97, 114}, (int)2, (int)4));
    }

    @Test
    public void testStringAscii2() {
        Assert.assertEquals((Object)"foo", (Object)Charsetfunctions.stringAscii((byte[])new byte[]{102, 111, 111}));
    }

    @Test
    public void testUtf8Bytes() {
        Assert.assertArrayEquals((byte[])new byte[]{102, 111, 111, 66, 97, 114}, (byte[])Charsetfunctions.utf8Bytes((String)"fooBar"));
    }
}

