/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.rx;

import com.github.davidmoten.rx.jdbc.Database;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.jooby.Env;
import org.jooby.jdbc.Jdbc;

public class RxJdbc
extends Jdbc {
    public RxJdbc(String name) {
        super(name);
    }

    public RxJdbc() {
        this("db");
    }

    public void configure(Env env, Config config, Binder binder) {
        super.configure(env, config, binder);
        Provider p = () -> {
            DataSource ds = (DataSource)this.dataSource().get();
            return Database.fromDataSource((DataSource)ds);
        };
        this.keys(Database.class, k -> {
            binder.bind(k).toProvider(p).asEagerSingleton();
            env.onStop(r -> ((Database)r.require(k)).close());
        });
    }
}

