/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.spi;

import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.spi.BuilderInfo;
import org.mapstruct.ap.spi.DefaultBuilderProvider;
import org.mapstruct.ap.spi.TypeHierarchyErroneousException;

public class ImmutablesBuilderProvider
extends DefaultBuilderProvider {
    private static final Pattern JAVA_JAVAX_PACKAGE = Pattern.compile("^javax?\\..*");
    private static final String IMMUTABLE_FQN = "org.immutables.value.Value.Immutable";

    @Override
    protected BuilderInfo findBuilderInfo(TypeElement typeElement) {
        BuilderInfo info;
        Name name = typeElement.getQualifiedName();
        if (name.length() == 0 || JAVA_JAVAX_PACKAGE.matcher(name).matches()) {
            return null;
        }
        TypeElement immutableAnnotation = this.elementUtils.getTypeElement(IMMUTABLE_FQN);
        if (immutableAnnotation != null && (info = this.findBuilderInfoForImmutables(typeElement, immutableAnnotation)) != null) {
            return info;
        }
        return super.findBuilderInfo(typeElement);
    }

    protected BuilderInfo findBuilderInfoForImmutables(TypeElement typeElement, TypeElement immutableAnnotation) {
        for (AnnotationMirror annotationMirror : this.elementUtils.getAllAnnotationMirrors(typeElement)) {
            if (!this.typeUtils.isSameType(annotationMirror.getAnnotationType(), immutableAnnotation.asType())) continue;
            TypeElement immutableElement = this.asImmutableElement(typeElement);
            if (immutableElement != null) {
                return super.findBuilderInfo(immutableElement);
            }
            throw new TypeHierarchyErroneousException(typeElement);
        }
        return null;
    }

    protected TypeElement asImmutableElement(TypeElement typeElement) {
        Element enclosingElement = typeElement.getEnclosingElement();
        StringBuilder builderQualifiedName = new StringBuilder(typeElement.getQualifiedName().length() + 17);
        if (enclosingElement.getKind() == ElementKind.PACKAGE) {
            builderQualifiedName.append(((PackageElement)enclosingElement).getQualifiedName().toString());
        } else {
            builderQualifiedName.append(((TypeElement)enclosingElement).getQualifiedName().toString());
        }
        if (builderQualifiedName.length() > 0) {
            builderQualifiedName.append(".");
        }
        builderQualifiedName.append("Immutable").append(typeElement.getSimpleName());
        return this.elementUtils.getTypeElement(builderQualifiedName);
    }
}

