/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;

public class TargetTypeSelector
implements MethodSelector {
    private final Types typeUtils;

    public TargetTypeSelector(Types typeUtils) {
        this.typeUtils = typeUtils;
    }

    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(Method mappingMethod, List<SelectedMethod<T>> methods, List<Type> sourceTypes, Type targetType, SelectionCriteria criteria) {
        TypeMirror qualifyingTypeMirror = criteria.getQualifyingResultType();
        if (qualifyingTypeMirror != null && !criteria.isLifecycleCallbackRequired()) {
            ArrayList<SelectedMethod<T>> candidatesWithQualifyingTargetType = new ArrayList<SelectedMethod<T>>(methods.size());
            for (SelectedMethod<T> method : methods) {
                TypeMirror resultTypeMirror = method.getMethod().getResultType().getTypeElement().asType();
                if (!this.typeUtils.isSameType(qualifyingTypeMirror, resultTypeMirror)) continue;
                candidatesWithQualifyingTargetType.add(method);
            }
            return candidatesWithQualifyingTargetType;
        }
        return methods;
    }
}

