/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.mapstruct.ap.internal.gem.CollectionMappingStrategyGem;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.BeanMappingOptions;
import org.mapstruct.ap.internal.model.source.EnumMappingOptions;
import org.mapstruct.ap.internal.model.source.IterableMappingOptions;
import org.mapstruct.ap.internal.model.source.MapMappingOptions;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.SubclassMappingOptions;
import org.mapstruct.ap.internal.model.source.SubclassValidator;
import org.mapstruct.ap.internal.model.source.ValueMappingOptions;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class MappingMethodOptions {
    private static final MappingMethodOptions EMPTY = new MappingMethodOptions(null, Collections.emptySet(), null, null, null, null, Collections.emptyList(), Collections.emptySet(), null);
    private MapperOptions mapper;
    private Set<MappingOptions> mappings;
    private IterableMappingOptions iterableMapping;
    private MapMappingOptions mapMapping;
    private BeanMappingOptions beanMapping;
    private EnumMappingOptions enumMappingOptions;
    private List<ValueMappingOptions> valueMappings;
    private boolean fullyInitialized;
    private Set<SubclassMappingOptions> subclassMappings;
    private SubclassValidator subclassValidator;

    public MappingMethodOptions(MapperOptions mapper, Set<MappingOptions> mappings, IterableMappingOptions iterableMapping, MapMappingOptions mapMapping, BeanMappingOptions beanMapping, EnumMappingOptions enumMappingOptions, List<ValueMappingOptions> valueMappings, Set<SubclassMappingOptions> subclassMappings, SubclassValidator subclassValidator) {
        this.mapper = mapper;
        this.mappings = mappings;
        this.iterableMapping = iterableMapping;
        this.mapMapping = mapMapping;
        this.beanMapping = beanMapping;
        this.enumMappingOptions = enumMappingOptions;
        this.valueMappings = valueMappings;
        this.subclassMappings = subclassMappings;
        this.subclassValidator = subclassValidator;
    }

    public static MappingMethodOptions empty() {
        return EMPTY;
    }

    public Set<MappingOptions> getMappings() {
        return this.mappings;
    }

    public IterableMappingOptions getIterableMapping() {
        return this.iterableMapping;
    }

    public MapMappingOptions getMapMapping() {
        return this.mapMapping;
    }

    public BeanMappingOptions getBeanMapping() {
        return this.beanMapping;
    }

    public EnumMappingOptions getEnumMappingOptions() {
        return this.enumMappingOptions;
    }

    public List<ValueMappingOptions> getValueMappings() {
        return this.valueMappings;
    }

    public Set<SubclassMappingOptions> getSubclassMappings() {
        return this.subclassMappings;
    }

    public void setIterableMapping(IterableMappingOptions iterableMapping) {
        this.iterableMapping = iterableMapping;
    }

    public void setMapMapping(MapMappingOptions mapMapping) {
        this.mapMapping = mapMapping;
    }

    public void setBeanMapping(BeanMappingOptions beanMapping) {
        this.beanMapping = beanMapping;
    }

    public void setEnumMappingOptions(EnumMappingOptions enumMappingOptions) {
        this.enumMappingOptions = enumMappingOptions;
    }

    public void setValueMappings(List<ValueMappingOptions> valueMappings) {
        this.valueMappings = valueMappings;
    }

    public MapperOptions getMapper() {
        return this.mapper;
    }

    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    public void markAsFullyInitialized() {
        this.fullyInitialized = true;
    }

    public void applyInheritedOptions(SourceMethod sourceMethod, SourceMethod templateMethod, boolean isInverse, AnnotationMirror annotationMirror) {
        MappingMethodOptions templateOptions = templateMethod.getOptions();
        if (null != templateOptions) {
            if (!this.getIterableMapping().hasAnnotation() && templateOptions.getIterableMapping().hasAnnotation()) {
                this.setIterableMapping(templateOptions.getIterableMapping());
            }
            if (!this.getMapMapping().hasAnnotation() && templateOptions.getMapMapping().hasAnnotation()) {
                this.setMapMapping(templateOptions.getMapMapping());
            }
            if (!this.getBeanMapping().hasAnnotation() && templateOptions.getBeanMapping().hasAnnotation()) {
                this.setBeanMapping(BeanMappingOptions.forInheritance(templateOptions.getBeanMapping()));
            }
            if (!this.getEnumMappingOptions().hasAnnotation() && templateOptions.getEnumMappingOptions().hasAnnotation()) {
                EnumMappingOptions newEnumMappingOptions = isInverse ? templateOptions.getEnumMappingOptions().inverse() : templateOptions.getEnumMappingOptions();
                this.setEnumMappingOptions(newEnumMappingOptions);
            }
            if (this.getValueMappings() == null) {
                if (templateOptions.getValueMappings() != null) {
                    this.setValueMappings(templateOptions.getValueMappings());
                } else {
                    this.setValueMappings(Collections.emptyList());
                }
            } else if (templateOptions.getValueMappings() != null) {
                for (ValueMappingOptions inheritedValueMapping : templateOptions.getValueMappings()) {
                    ValueMappingOptions valueMapping = isInverse ? inheritedValueMapping.inverse() : inheritedValueMapping;
                    if (valueMapping == null || this.getValueMappings().contains(valueMapping)) continue;
                    this.getValueMappings().add(valueMapping);
                }
            }
            if (isInverse) {
                List<SubclassMappingOptions> inheritedMappings = SubclassMappingOptions.copyForInverseInheritance(templateOptions.getSubclassMappings(), this.getBeanMapping());
                this.addAllNonRedefined(sourceMethod, annotationMirror, inheritedMappings);
            }
            LinkedHashSet<MappingOptions> newMappings = new LinkedHashSet<MappingOptions>();
            for (MappingOptions mapping : templateOptions.getMappings()) {
                if (isInverse) {
                    if (!mapping.canInverse()) continue;
                    newMappings.add(mapping.copyForInverseInheritance(templateMethod, this.getBeanMapping()));
                    continue;
                }
                newMappings.add(mapping.copyForForwardInheritance(templateMethod, this.getBeanMapping()));
            }
            this.addAllNonRedefined(newMappings);
            this.filterNestedTargetIgnores(this.mappings);
        }
    }

    private void addAllNonRedefined(SourceMethod sourceMethod, AnnotationMirror annotationMirror, List<SubclassMappingOptions> inheritedMappings) {
        HashSet<SubclassMappingOptions> redefinedSubclassMappings = new HashSet<SubclassMappingOptions>(this.subclassMappings);
        for (SubclassMappingOptions subclassMappingOption : inheritedMappings) {
            if (redefinedSubclassMappings.contains(subclassMappingOption) || !this.subclassValidator.isValidUsage(sourceMethod.getExecutable(), annotationMirror, subclassMappingOption.getSource())) continue;
            this.subclassMappings.add(subclassMappingOption);
        }
    }

    private void addAllNonRedefined(Set<MappingOptions> inheritedMappings) {
        HashSet<String> redefinedSources = new HashSet<String>();
        HashSet<String> redefinedTargets = new HashSet<String>();
        for (MappingOptions redefinedMappings : this.mappings) {
            if (redefinedMappings.getSourceName() != null) {
                redefinedSources.add(redefinedMappings.getSourceName());
            }
            if (redefinedMappings.getTargetName() == null) continue;
            redefinedTargets.add(redefinedMappings.getTargetName());
        }
        for (MappingOptions inheritedMapping : inheritedMappings) {
            if (!inheritedMapping.isIgnored() && (this.isRedefined(redefinedSources, inheritedMapping.getSourceName()) || this.isRedefined(redefinedTargets, inheritedMapping.getTargetName()))) continue;
            this.mappings.add(inheritedMapping);
        }
    }

    private boolean isRedefined(Set<String> redefinedNames, String inheritedName) {
        if (inheritedName != null) {
            for (String redefinedName : redefinedNames) {
                if (!this.elementsAreContainedIn(inheritedName, redefinedName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean elementsAreContainedIn(String redefinedName, String inheritedName) {
        if (inheritedName != null && redefinedName.startsWith(inheritedName) && redefinedName.length() > inheritedName.length()) {
            return '.' == redefinedName.charAt(inheritedName.length());
        }
        return false;
    }

    public void applyIgnoreAll(SourceMethod method, TypeFactory typeFactory, FormattingMessager messager) {
        CollectionMappingStrategyGem cms = method.getOptions().getMapper().getCollectionMappingStrategy();
        Type writeType = method.getResultType();
        if (!method.isUpdateMethod()) {
            writeType = typeFactory.effectiveResultTypeFor(writeType, method.getOptions().getBeanMapping().getBuilder());
        }
        Map<String, Accessor> writeAccessors = writeType.getPropertyWriteAccessors(cms);
        for (MappingOptions mapping : this.mappings) {
            String mappedTargetProperty = this.getFirstTargetPropertyName(mapping);
            if (!".".equals(mappedTargetProperty)) {
                writeAccessors.remove(mappedTargetProperty);
                continue;
            }
            messager.printMessage((Element)method.getExecutable(), this.getBeanMapping().getMirror(), Message.BEANMAPPING_IGNORE_BY_DEFAULT_WITH_MAPPING_TARGET_THIS, new Object[0]);
            return;
        }
        for (String targetPropertyName : writeAccessors.keySet()) {
            MappingOptions mapping = MappingOptions.forIgnore(targetPropertyName);
            this.mappings.add(mapping);
        }
    }

    private void filterNestedTargetIgnores(Set<MappingOptions> mappings) {
        Set<String> ignored = MappingOptions.getMappingTargetNamesBy(MappingOptions::isIgnored, mappings);
        mappings.removeIf(m -> this.isToBeIgnored(ignored, (MappingOptions)m));
    }

    private boolean isToBeIgnored(Set<String> ignored, MappingOptions mapping) {
        String[] propertyEntries = this.getPropertyEntries(mapping);
        return propertyEntries.length > 1 && ignored.contains(propertyEntries[0]);
    }

    private String[] getPropertyEntries(MappingOptions mapping) {
        return mapping.getTargetName().split("\\.");
    }

    private String getFirstTargetPropertyName(MappingOptions mapping) {
        String targetName = mapping.getTargetName();
        if (".".equals(targetName)) {
            return targetName;
        }
        return this.getPropertyEntries(mapping)[0];
    }

    public static MappingMethodOptions getForgedMethodInheritedOptions(MappingMethodOptions options) {
        return new MappingMethodOptions(options.mapper, options.mappings, options.iterableMapping, options.mapMapping, options.beanMapping, options.enumMappingOptions, options.valueMappings, Collections.emptySet(), null);
    }
}

