/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import org.mapstruct.ap.shaded.freemarker.core.ArithmeticEngine;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.template.SimpleNumber;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;

final class ArithmeticExpression
extends Expression {
    static final int TYPE_SUBSTRACTION = 0;
    static final int TYPE_MULTIPLICATION = 1;
    static final int TYPE_DIVISION = 2;
    static final int TYPE_MODULO = 3;
    private static final char[] OPERATOR_IMAGES = new char[]{'-', '*', '/', '%'};
    private final Expression lho;
    private final Expression rho;
    private final int operator;

    ArithmeticExpression(Expression lho, Expression rho, int operator) {
        this.lho = lho;
        this.rho = rho;
        this.operator = operator;
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        Number lhoNumber = this.lho.evalToNumber(env);
        Number rhoNumber = this.rho.evalToNumber(env);
        ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
        switch (this.operator) {
            case 0: {
                return new SimpleNumber(ae.subtract(lhoNumber, rhoNumber));
            }
            case 1: {
                return new SimpleNumber(ae.multiply(lhoNumber, rhoNumber));
            }
            case 2: {
                return new SimpleNumber(ae.divide(lhoNumber, rhoNumber));
            }
            case 3: {
                return new SimpleNumber(ae.modulus(lhoNumber, rhoNumber));
            }
        }
        throw new _MiscTemplateException((Expression)this, new Object[]{"Unknown operation: ", new Integer(this.operator)});
    }

    public String getCanonicalForm() {
        return this.lho.getCanonicalForm() + ' ' + OPERATOR_IMAGES[this.operator] + ' ' + this.rho.getCanonicalForm();
    }

    String getNodeTypeSymbol() {
        return String.valueOf(OPERATOR_IMAGES[this.operator]);
    }

    boolean isLiteral() {
        return this.constantValue != null || this.lho.isLiteral() && this.rho.isLiteral();
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new ArithmeticExpression(this.lho.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.rho.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.operator);
    }

    int getParameterCount() {
        return 3;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.lho;
            }
            case 1: {
                return this.rho;
            }
            case 2: {
                return new Integer(this.operator);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.LEFT_HAND_OPERAND;
            }
            case 1: {
                return ParameterRole.RIGHT_HAND_OPERAND;
            }
            case 2: {
                return ParameterRole.AST_NODE_SUBTYPE;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

