/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.xerces.dom.DOMXSImplementationSourceImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.pkg.DefaultErrorHandler;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfManifestSaxHandler;
import org.odftoolkit.odfdom.pkg.OdfPackageConstraint;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.Resolver;
import org.odftoolkit.odfdom.pkg.StreamHelper;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfdom.pkg.ZipHelper;
import org.odftoolkit.odfdom.pkg.manifest.Algorithm;
import org.odftoolkit.odfdom.pkg.manifest.EncryptionData;
import org.odftoolkit.odfdom.pkg.manifest.KeyDerivation;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfPackage
implements Closeable {
    private static final String DOUBLE_DOT = "..";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String ENCODED_APOSTROPHE = "&apos;";
    private static final String ENCODED_QUOTATION = "&quot;";
    private static final String EMPTY_STRING = "";
    private static final String XML_MEDIA_TYPE = "text/xml";
    private static final Pattern BACK_SLASH_PATTERN = Pattern.compile("\\\\");
    private static final Pattern DOUBLE_SLASH_PATTERN = Pattern.compile("//");
    private static final Pattern QUOTATION_PATTERN = Pattern.compile("\"");
    private static final Pattern APOSTROPHE_PATTERN = Pattern.compile("'");
    private static final Pattern CONTROL_CHAR_PATTERN = Pattern.compile("\\p{Cntrl}");
    private static Set<String> mCompressedFileTypes = new HashSet<String>();
    private String mMediaType = null;
    private String mBaseURI;
    private ZipHelper mZipFile;
    private Resolver mResolver = null;
    private Map<String, ZipEntry> mZipEntries;
    private HashMap<String, ZipEntry> mOriginalZipEntries;
    private Map<String, OdfFileEntry> mManifestEntries;
    private Map<String, OdfPackageDocument> mPkgDocuments = new HashMap<String, OdfPackageDocument>();
    private HashMap<String, Document> mPkgDoms = new HashMap();
    private HashMap<String, byte[]> mMemoryFileCache = new HashMap();
    private ErrorHandler mErrorHandler;
    private String mManifestVersion;

    private OdfPackage() {
        String errorHandlerProperty;
        this.mManifestEntries = new HashMap<String, OdfFileEntry>();
        if (this.mErrorHandler == null && (errorHandlerProperty = System.getProperty("org.odftoolkit.odfdom.validation")) != null) {
            if (errorHandlerProperty.equalsIgnoreCase("true")) {
                this.mErrorHandler = new DefaultErrorHandler();
                Logger.getLogger(OdfPackage.class.getName()).info("Activated validation with default ErrorHandler!");
            } else {
                try {
                    Class<?> cl = Class.forName(errorHandlerProperty);
                    Constructor<?> ctor = cl.getDeclaredConstructor(new Class[0]);
                    this.mErrorHandler = (ErrorHandler)ctor.newInstance(new Object[0]);
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.INFO, "Activated validation with ErrorHandler:''{0}''!", errorHandlerProperty);
                }
                catch (Exception ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, "Could not initiate validation with the given ErrorHandler: '" + errorHandlerProperty + "'", ex);
                }
            }
        }
    }

    private OdfPackage(File pkgFile) throws Exception {
        this();
        this.mBaseURI = OdfPackage.getBaseURLFromFile(pkgFile);
        this.initializeZip(new FileInputStream(pkgFile));
    }

    private OdfPackage(InputStream packageStream, String baseURI, ErrorHandler errorHandler) throws Exception {
        this();
        this.mErrorHandler = errorHandler;
        this.mBaseURI = baseURI;
        this.initializeZip(packageStream);
    }

    public static OdfPackage loadPackage(String path) throws Exception {
        File pkgFile = new File(path);
        return new OdfPackage(new FileInputStream(pkgFile), OdfPackage.getBaseURLFromFile(pkgFile), null);
    }

    public static OdfPackage loadPackage(File pkgFile) throws Exception {
        return new OdfPackage(new FileInputStream(pkgFile), OdfPackage.getBaseURLFromFile(pkgFile), null);
    }

    public static OdfPackage loadPackage(InputStream packageStream) throws Exception {
        return new OdfPackage(packageStream, null, null);
    }

    public static OdfPackage loadPackage(InputStream packageStream, String baseURI, ErrorHandler errorHandler) throws Exception {
        return new OdfPackage(packageStream, baseURI, errorHandler);
    }

    public static OdfPackage loadPackage(File pkgFile, ErrorHandler errorHandler) throws Exception {
        return new OdfPackage(new FileInputStream(pkgFile), OdfPackage.getBaseURLFromFile(pkgFile), errorHandler);
    }

    private void initializeZip(InputStream odfStream) throws Exception {
        ByteArrayOutputStream tempBuf = new ByteArrayOutputStream();
        StreamHelper.transformStream(odfStream, tempBuf);
        byte[] mTempByteBuf = tempBuf.toByteArray();
        tempBuf.close();
        if (mTempByteBuf.length < 3) {
            OdfValidationException ve = new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_IS_NO_ZIP, this.getBaseURI(), new Object[0]);
            if (this.mErrorHandler != null) {
                this.mErrorHandler.fatalError(ve);
            }
            throw new IllegalArgumentException(ve);
        }
        this.mZipFile = new ZipHelper(this, mTempByteBuf);
        this.readZip();
    }

    private void readZip() throws SAXException, IOException {
        this.mZipEntries = new HashMap<String, ZipEntry>();
        String firstEntryName = this.mZipFile.entriesToMap(this.mZipEntries);
        if (this.mZipEntries.isEmpty()) {
            OdfValidationException ve = new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_IS_NO_ZIP, this.getBaseURI(), new Object[0]);
            if (this.mErrorHandler != null) {
                this.mErrorHandler.fatalError(ve);
            }
            throw new IllegalArgumentException(ve);
        }
        this.parseManifest();
        this.initializeMediaType(firstEntryName);
        this.mOriginalZipEntries = new HashMap();
        this.mOriginalZipEntries.putAll(this.mZipEntries);
        this.mZipEntries.remove(OdfFile.MEDIA_TYPE.getPath());
        this.mZipEntries.remove(OdfFile.MANIFEST.getPath());
        this.mZipEntries.remove("META-INF/");
        if (this.mErrorHandler != null) {
            this.validateManifest();
        }
        for (String internalPath : this.mZipEntries.keySet()) {
            if (internalPath.equals(OdfFile.MANIFEST.getPath()) || internalPath.equals("META-INF/") || internalPath.equals(OdfFile.MEDIA_TYPE.getPath())) continue;
            this.ensureFileEntryExistence(internalPath);
        }
    }

    private void validateManifest() {
        Set<String> zipPaths = this.mZipEntries.keySet();
        Set<String> manifestPaths = this.mManifestEntries.keySet();
        HashSet<String> sharedPaths = new HashSet<String>(zipPaths);
        sharedPaths.retainAll(manifestPaths);
        if (sharedPaths.size() < zipPaths.size()) {
            HashSet<String> zipPathSuperset = new HashSet<String>(this.mZipEntries.keySet());
            zipPathSuperset.removeAll(sharedPaths);
            TreeSet<String> sortedSet = new TreeSet<String>(zipPathSuperset);
            Iterator iter = sortedSet.iterator();
            String documentURL = this.getBaseURI();
            while (iter.hasNext()) {
                String internalPath = (String)iter.next();
                if (internalPath.endsWith(SLASH)) continue;
                this.logValidationError(OdfPackageConstraint.MANIFEST_DOES_NOT_LIST_FILE, documentURL, internalPath);
            }
        }
        if (sharedPaths.size() < manifestPaths.size()) {
            HashSet<String> zipPathSubset = new HashSet<String>(this.mManifestEntries.keySet());
            zipPathSubset.removeAll(sharedPaths);
            zipPathSubset.remove(SLASH);
            for (String manifestOnlyPath : zipPathSubset) {
                if (manifestOnlyPath.endsWith(SLASH)) {
                    this.removeDirectory(manifestOnlyPath);
                    continue;
                }
                this.logValidationError(OdfPackageConstraint.MANIFEST_LISTS_NONEXISTENT_FILE, this.getBaseURI(), manifestOnlyPath);
                this.mManifestEntries.remove(manifestOnlyPath);
            }
        }
        for (String sharedPath : sharedPaths) {
            if (!sharedPath.endsWith(SLASH)) continue;
            this.removeDirectory(sharedPath);
        }
    }

    private void removeDirectory(String path) {
        String dirMimeType;
        if (path.endsWith(SLASH) && ((dirMimeType = this.mManifestEntries.get(path).getMediaTypeString()) == null || EMPTY_STRING.equals(dirMimeType))) {
            this.logValidationWarning(OdfPackageConstraint.MANIFEST_LISTS_DIRECTORY, this.getBaseURI(), path);
            this.mManifestEntries.remove(path);
        }
    }

    private void initializeMediaType(String firstEntryName) {
        ZipEntry mimetypeEntry = this.mZipEntries.get(OdfFile.MEDIA_TYPE.getPath());
        if (mimetypeEntry != null) {
            if (this.mErrorHandler != null) {
                this.validateMimeTypeEntry(mimetypeEntry, firstEntryName);
            }
            String entryMediaType = this.getMediaTypeFromEntry(mimetypeEntry);
            String manifestMediaType = this.getMediaTypeFromManifest();
            if (entryMediaType != null && !entryMediaType.equals(EMPTY_STRING)) {
                this.mMediaType = entryMediaType;
                if (this.mErrorHandler != null) {
                    if (manifestMediaType != null && !manifestMediaType.equals(EMPTY_STRING)) {
                        if (!entryMediaType.equals(manifestMediaType)) {
                            this.logValidationError(OdfPackageConstraint.MIMETYPE_DIFFERS_FROM_PACKAGE, this.getBaseURI(), CONTROL_CHAR_PATTERN.matcher(this.mMediaType).replaceAll(EMPTY_STRING), manifestMediaType);
                        }
                    } else {
                        this.logValidationError(OdfPackageConstraint.MIMETYPE_WITHOUT_MANIFEST_MEDIATYPE, this.getBaseURI(), CONTROL_CHAR_PATTERN.matcher(this.mMediaType).replaceAll(EMPTY_STRING), manifestMediaType);
                    }
                }
            } else if (manifestMediaType != null && !manifestMediaType.equals(EMPTY_STRING)) {
                this.mMediaType = manifestMediaType;
            }
        } else {
            String manifestMediaType = this.getMediaTypeFromManifest();
            if (manifestMediaType != null && !manifestMediaType.equals(EMPTY_STRING)) {
                this.mMediaType = manifestMediaType;
            }
            if (this.mErrorHandler != null) {
                this.logValidationWarning(OdfPackageConstraint.MIMETYPE_NOT_IN_PACKAGE, this.getBaseURI(), new Object[0]);
            }
        }
    }

    private void validateMimeTypeEntry(ZipEntry mimetypeEntry, String firstEntryName) {
        if (mimetypeEntry.getMethod() != 0) {
            this.logValidationError(OdfPackageConstraint.MIMETYPE_IS_COMPRESSED, this.getBaseURI(), new Object[0]);
        }
        if (mimetypeEntry.getExtra() != null) {
            this.logValidationError(OdfPackageConstraint.MIMETYPE_HAS_EXTRA_FIELD, this.getBaseURI(), new Object[0]);
        }
        if (!OdfFile.MEDIA_TYPE.getPath().equals(firstEntryName)) {
            this.logValidationError(OdfPackageConstraint.MIMETYPE_NOT_FIRST_IN_PACKAGE, this.getBaseURI(), new Object[0]);
        }
    }

    private String getMediaTypeFromManifest() {
        OdfFileEntry rootDocumentEntry = this.mManifestEntries.get(SLASH);
        if (rootDocumentEntry != null) {
            return rootDocumentEntry.getMediaTypeString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMediaTypeFromEntry(ZipEntry mimetypeEntry) {
        String entryMediaType = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            StreamHelper.transformStream(this.mZipFile.getInputStream(mimetypeEntry), out);
            entryMediaType = new String(out.toByteArray(), 0, out.size(), "UTF-8");
        }
        catch (Exception ex) {
            Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
                out = null;
            }
        }
        return entryMediaType;
    }

    void cacheDocument(OdfPackageDocument doc, String internalPath) {
        internalPath = OdfPackage.normalizeDirectoryPath(internalPath);
        this.updateFileEntry(this.ensureFileEntryExistence(internalPath), doc.getMediaTypeString());
        this.mPkgDocuments.put(internalPath, doc);
    }

    void setBaseURI(String baseURI) {
        this.mBaseURI = baseURI;
    }

    public String getBaseURI() {
        return this.mBaseURI;
    }

    public OdfPackageDocument loadDocument(String internalPath) {
        OdfPackageDocument doc = this.getCachedDocument(internalPath);
        if (doc == null) {
            String mediaTypeString = this.getMediaTypeString();
            OdfDocument.OdfMediaType odfMediaType = OdfDocument.OdfMediaType.getOdfMediaType(mediaTypeString);
            if (odfMediaType == null) {
                doc = new OdfPackageDocument(this, internalPath, mediaTypeString);
            } else {
                try {
                    String documentMediaType = this.getMediaTypeString(internalPath);
                    odfMediaType = OdfDocument.OdfMediaType.getOdfMediaType(documentMediaType);
                    if (odfMediaType == null) {
                        return null;
                    }
                    doc = OdfDocument.loadDocument(this, internalPath);
                }
                catch (Exception ex) {
                    Logger.getLogger(OdfPackageDocument.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return doc;
    }

    @Deprecated
    public OdfPackageDocument getCachedDocument(String internalPath) {
        internalPath = OdfPackage.normalizeDirectoryPath(internalPath);
        return this.mPkgDocuments.get(internalPath);
    }

    void cacheDom(Document dom, String internalPath) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        this.insert(dom, internalPath, null);
    }

    Document getCachedDom(String internalPath) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        return this.mPkgDoms.get(internalPath);
    }

    Map<String, Document> getCachedDoms() {
        return this.mPkgDoms;
    }

    public void removeDocument(String internalPath) {
        internalPath = OdfPackage.normalizeDirectoryPath(internalPath);
        try {
            Set<String> allPackageFileNames = this.getFilePaths();
            if (internalPath.equals(SLASH)) {
                for (String entryName : allPackageFileNames) {
                    this.remove(entryName);
                }
                this.remove(SLASH);
            } else {
                ArrayList<String> directoryEntryNames = new ArrayList<String>();
                for (String entryName : allPackageFileNames) {
                    if (!entryName.startsWith(internalPath)) continue;
                    directoryEntryNames.add(entryName);
                }
                for (String entryName : directoryEntryNames) {
                    this.remove(entryName);
                }
                this.remove(internalPath);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfPackageDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    Set<String> getCachedPackageDocuments() {
        return this.mPkgDocuments.keySet();
    }

    public OdfPackageDocument getRootDocument() {
        return this.mPkgDocuments.get(EMPTY_STRING);
    }

    public String getMediaTypeString(String internalPath) {
        String mediaType = null;
        if (internalPath != null) {
            if (internalPath.equals(EMPTY_STRING) || internalPath.equals(SLASH)) {
                return this.mMediaType;
            }
            mediaType = this.getMediaTypeFromEntry(OdfPackage.normalizePath(internalPath));
            if (mediaType == null) {
                mediaType = this.getMediaTypeFromEntry(OdfPackage.normalizeDirectoryPath(internalPath));
            }
        }
        return mediaType;
    }

    private String getMediaTypeFromEntry(String internalPath) {
        OdfFileEntry entry = this.getFileEntry(internalPath);
        if (entry != null) {
            return entry.getMediaTypeString();
        }
        return null;
    }

    public String getMediaTypeString() {
        return this.mMediaType;
    }

    void setMediaTypeString(String mediaType) {
        this.mMediaType = mediaType;
    }

    public OdfFileEntry getFileEntry(String internalPath) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        return this.mManifestEntries.get(internalPath);
    }

    public Set<String> getFilePaths() {
        return this.mManifestEntries.keySet();
    }

    public boolean contains(String internalPath) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        return this.mManifestEntries.containsKey(internalPath);
    }

    public void save(String odfPath) throws Exception {
        File f = new File(odfPath);
        this.save(f);
    }

    public void save(File pkgFile) throws Exception {
        String baseURL = OdfPackage.getBaseURLFromFile(pkgFile);
        FileOutputStream fos = new FileOutputStream(pkgFile);
        this.save(fos, baseURL);
    }

    public void save(OutputStream odfStream) throws Exception {
        this.save(odfStream, null);
    }

    private void save(OutputStream odfStream, String baseURL) {
        try {
            this.mBaseURI = baseURL;
            OdfFileEntry rootEntry = this.mManifestEntries.get(SLASH);
            if (rootEntry == null) {
                rootEntry = new OdfFileEntry(SLASH, this.mMediaType);
                this.mManifestEntries.put(SLASH, rootEntry);
            } else {
                rootEntry.setMediaTypeString(this.mMediaType);
            }
            ZipOutputStream zos = new ZipOutputStream(odfStream);
            this.mManifestEntries.remove(OdfFile.MEDIA_TYPE.getPath());
            Iterator<String> it = this.mManifestEntries.keySet().iterator();
            String path = null;
            boolean isFirstFile = true;
            CRC32 crc = new CRC32();
            long modTime = new Date().getTime();
            while (it.hasNext() || isFirstFile) {
                try {
                    byte[] data = null;
                    if (isFirstFile) {
                        isFirstFile = false;
                        data = this.mMediaType.getBytes("UTF-8");
                        this.createZipEntry(OdfFile.MEDIA_TYPE.getPath(), data, zos, modTime, crc);
                        this.createZipEntry("META-INF/", null, zos, modTime, crc);
                        data = this.getBytes(OdfFile.MANIFEST.getPath());
                        this.createZipEntry(OdfFile.MANIFEST.getPath(), data, zos, modTime, crc);
                        continue;
                    }
                    path = it.next();
                    if (path.endsWith(SLASH) || path.equals(OdfFile.MANIFEST.getPath()) || path.equals(OdfFile.MEDIA_TYPE.getPath())) continue;
                    data = this.getBytes(path);
                    this.createZipEntry(path, data, zos, modTime, crc);
                }
                catch (IOException ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            zos.close();
            odfStream.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void createZipEntry(String path, byte[] data, ZipOutputStream zos, long modTime, CRC32 crc) {
        ZipEntry ze = null;
        try {
            ze = this.mZipEntries.get(path);
            if (ze == null) {
                ze = new ZipEntry(path);
            }
            ze.setTime(modTime);
            if (this.fileNeedsCompression(path)) {
                ze.setMethod(8);
            } else {
                ze.setMethod(0);
            }
            crc.reset();
            if (data != null) {
                ze.setSize(data.length);
                crc.update(data);
                ze.setCrc(crc.getValue());
            } else {
                ze.setSize(0L);
                ze.setCrc(0L);
            }
            ze.setCompressedSize(-1L);
            zos.putNextEntry(ze);
            if (data != null) {
                zos.write(data, 0, data.length);
            }
            zos.closeEntry();
            this.mZipEntries.put(path, ze);
        }
        catch (IOException ex) {
            Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private boolean fileNeedsCompression(String internalPath) {
        String suffix;
        boolean result = true;
        if (internalPath.equals(OdfFile.MEDIA_TYPE.getPath())) {
            return false;
        }
        if (internalPath.lastIndexOf(DOT) > 0 && mCompressedFileTypes.contains((suffix = internalPath.substring(internalPath.lastIndexOf(DOT) + 1, internalPath.length())).toLowerCase())) {
            result = false;
        }
        return result;
    }

    @Override
    public void close() {
        if (this.mZipFile != null) {
            try {
                this.mZipFile.close();
            }
            catch (IOException ex) {
                Logger.getLogger(OdfPackage.class.getName()).log(Level.INFO, null, ex);
            }
        }
        this.mZipFile = null;
        this.mMediaType = null;
        this.mZipEntries = null;
        this.mPkgDoms = null;
        this.mMemoryFileCache = null;
        this.mManifestEntries = null;
        this.mBaseURI = null;
        this.mResolver = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseManifest() {
        InputStream is = null;
        try {
            ZipEntry entry = null;
            entry = this.mZipEntries.get(OdfFile.MANIFEST.internalPath);
            if (entry != null) {
                is = this.mZipFile.getInputStream(entry);
            }
            if (is == null) {
                this.logValidationError(OdfPackageConstraint.MANIFEST_NOT_IN_PACKAGE, this.getBaseURI(), new Object[0]);
                return;
            }
            XMLReader xmlReader = this.getXMLReader();
            xmlReader.setEntityResolver(this.getEntityResolver());
            xmlReader.setContentHandler(new OdfManifestSaxHandler(this));
            InputSource ins = new InputSource(is);
            String uri = this.mBaseURI + SLASH + OdfFile.MANIFEST.internalPath;
            ins.setSystemId(uri);
            xmlReader.parse(ins);
            this.mMemoryFileCache.remove(OdfFile.MANIFEST.internalPath);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        SAXParserFactoryImpl saxFactory = new SAXParserFactoryImpl();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        try {
            ((SAXParserFactory)saxFactory).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception ex) {
            Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
        SAXParser parser = ((SAXParserFactory)saxFactory).newSAXParser();
        XMLReader xmlReader = parser.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setFeature("http://xml.org/sax/features/xmlns-uris", true);
        return xmlReader;
    }

    private void createSubEntries(String internalPath) {
        StringTokenizer tok = new StringTokenizer(internalPath, SLASH);
        if (tok.countTokens() > 1) {
            String path = EMPTY_STRING;
            while (tok.hasMoreTokens()) {
                OdfFileEntry fileEntry;
                String directory = tok.nextToken();
                if (!tok.hasMoreTokens() || (fileEntry = this.mManifestEntries.get(path = path + directory + SLASH)) != null) continue;
                this.mManifestEntries.put(path, new OdfFileEntry(path, null));
            }
        }
    }

    public void insert(Document fileDOM, String internalPath, String mediaType) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        if (mediaType == null) {
            mediaType = XML_MEDIA_TYPE;
        }
        if (fileDOM == null) {
            this.mPkgDoms.remove(internalPath);
        } else {
            this.mPkgDoms.put(internalPath, fileDOM);
        }
        this.updateFileEntry(this.ensureFileEntryExistence(internalPath), mediaType);
        this.mMemoryFileCache.remove(internalPath);
    }

    public void insertDocument(OdfPackageDocument sourceDocument, String internalPath) {
        internalPath = OdfPackage.normalizeDirectoryPath(internalPath);
        this.flushDoms(sourceDocument);
        Map<String, OdfFileEntry> entryMapToCopy = sourceDocument.isRootDocument() ? sourceDocument.getPackage().getManifestEntries() : sourceDocument.getPackage().getSubDirectoryEntries(sourceDocument.getDocumentPath());
        internalPath = sourceDocument.setDocumentPath(internalPath);
        String documentDirectory = null;
        documentDirectory = internalPath.equals(SLASH) ? EMPTY_STRING : internalPath;
        Set<String> entryNameList = entryMapToCopy.keySet();
        for (String entryName : entryNameList) {
            OdfFileEntry entry = entryMapToCopy.get(entryName);
            if (entry == null) continue;
            try {
                if (entryName.endsWith(SLASH)) {
                    if (entryName.equals(SLASH)) {
                        this.insert((byte[])null, documentDirectory, sourceDocument.getMediaTypeString());
                        continue;
                    }
                    this.insert((byte[])null, documentDirectory + entry.getPath(), entry.getMediaTypeString());
                    continue;
                }
                String packagePath = documentDirectory + entry.getPath();
                this.insert(sourceDocument.getPackage().getInputStream(entryName), packagePath, entry.getMediaTypeString());
            }
            catch (Exception ex) {
                Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        OdfFileEntry embedDocumentRootEntry = new OdfFileEntry(internalPath, sourceDocument.getMediaTypeString());
        this.mManifestEntries.put(internalPath, embedDocumentRootEntry);
        sourceDocument.setPackage(this);
        this.cacheDocument(sourceDocument, internalPath);
    }

    void flushDoms(OdfPackageDocument parentDocument) {
        OdfPackage pkg = parentDocument.getPackage();
        if (parentDocument.isRootDocument()) {
            for (String xmlFilePath : pkg.getCachedDoms().keySet()) {
                pkg.insert(pkg.getCachedDom(xmlFilePath), xmlFilePath, XML_MEDIA_TYPE);
            }
        } else {
            String parentDocumentPath = parentDocument.getDocumentPath();
            for (String xmlFilePath : pkg.getCachedDoms().keySet()) {
                if (!xmlFilePath.startsWith(parentDocumentPath)) continue;
                pkg.insert(pkg.getCachedDom(xmlFilePath), xmlFilePath, XML_MEDIA_TYPE);
            }
        }
    }

    private Map<String, OdfFileEntry> getSubDirectoryEntries(String directory) {
        directory = OdfPackage.normalizeDirectoryPath(directory);
        HashMap<String, OdfFileEntry> subEntries = new HashMap<String, OdfFileEntry>();
        Map<String, OdfFileEntry> allEntries = this.getManifestEntries();
        Set<String> rootEntryNameSet = this.getFilePaths();
        for (String entryName : rootEntryNameSet) {
            String newEntryName;
            if (!entryName.startsWith(directory) || (newEntryName = entryName.substring(directory.length())).length() == 0) continue;
            OdfFileEntry srcFileEntry = allEntries.get(entryName);
            OdfFileEntry newFileEntry = new OdfFileEntry();
            newFileEntry.setEncryptionData(srcFileEntry.getEncryptionData());
            newFileEntry.setMediaTypeString(srcFileEntry.getMediaTypeString());
            newFileEntry.setPath(newEntryName);
            newFileEntry.setSize(srcFileEntry.getSize());
            subEntries.put(entryName, newFileEntry);
        }
        return subEntries;
    }

    public Set<String> getDocumentPaths() {
        return this.getDocumentPaths(null, null);
    }

    public Set<String> getDocumentPaths(String mediaTypeString) {
        return this.getDocumentPaths(mediaTypeString, null);
    }

    Set<String> getDocumentPaths(String mediaTypeString, String subDirectory) {
        HashSet<String> innerDocuments = new HashSet<String>();
        Set<String> packageFilePaths = this.getFilePaths();
        for (String filePath : packageFilePaths) {
            String fileMediaType;
            if (subDirectory != null && (!filePath.startsWith(subDirectory) || filePath.equals(subDirectory)) || filePath.length() <= 1 || !filePath.endsWith(SLASH) || (fileMediaType = this.getFileEntry(filePath).getMediaTypeString()) == null || fileMediaType.equals(EMPTY_STRING) || mediaTypeString != null && !mediaTypeString.equals(fileMediaType)) continue;
            innerDocuments.add(filePath);
        }
        return innerDocuments;
    }

    private OdfFileEntry ensureFileEntryExistence(String internalPath) {
        OdfFileEntry fileEntry = null;
        if (!OdfFile.MANIFEST.internalPath.equals(internalPath) || !internalPath.equals(EMPTY_STRING)) {
            if (this.mManifestEntries == null) {
                this.mManifestEntries = new HashMap<String, OdfFileEntry>();
            }
            if ((fileEntry = this.mManifestEntries.get(internalPath)) == null) {
                fileEntry = new OdfFileEntry(internalPath);
                this.mManifestEntries.put(internalPath, fileEntry);
                this.createSubEntries(internalPath);
            }
        }
        return fileEntry;
    }

    private void updateFileEntry(OdfFileEntry fileEntry, String mediaType) {
        fileEntry.setMediaTypeString(mediaType);
        fileEntry.setEncryptionData(null);
        fileEntry.setSize(-1);
    }

    public Document getDom(String internalPath) throws SAXException, ParserConfigurationException, IllegalArgumentException, TransformerConfigurationException, TransformerException, IOException {
        Document doc = this.mPkgDoms.get(internalPath);
        if (doc != null) {
            return doc;
        }
        InputStream is = this.getInputStream(internalPath);
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
        builder.setEntityResolver(this.getEntityResolver());
        String uri = this.getBaseURI() + internalPath;
        if (this.mErrorHandler != null) {
            builder.setErrorHandler(this.mErrorHandler);
        }
        InputSource ins = new InputSource(is);
        ins.setSystemId(uri);
        doc = builder.parse(ins);
        if (doc != null) {
            this.mPkgDoms.put(internalPath, doc);
            this.mMemoryFileCache.remove(internalPath);
        }
        return doc;
    }

    public void insert(URI sourceURI, String internalPath, String mediaType) throws Exception {
        InputStream is = null;
        is = sourceURI.isAbsolute() ? sourceURI.toURL().openStream() : new FileInputStream(sourceURI.toString());
        this.insert(is, internalPath, mediaType);
    }

    public void insert(InputStream fileStream, String internalPath, String mediaType) throws Exception {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        if (fileStream == null) {
            this.insert((byte[])null, internalPath, mediaType);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedInputStream bis = null;
            bis = fileStream instanceof BufferedInputStream ? (BufferedInputStream)fileStream : new BufferedInputStream(fileStream);
            StreamHelper.transformStream(bis, baos);
            byte[] data = baos.toByteArray();
            this.insert(data, internalPath, mediaType);
        }
    }

    public void insert(byte[] fileBytes, String internalPath, String mediaTypeString) {
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        if (OdfFile.MEDIA_TYPE.getPath().equals(internalPath)) {
            try {
                this.setMediaTypeString(new String(fileBytes, "UTF-8"));
            }
            catch (UnsupportedEncodingException useEx) {
                Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, "ODF file could not be created as string!", useEx);
            }
            return;
        }
        if (fileBytes != null) {
            this.mMemoryFileCache.put(internalPath, fileBytes);
            if (this.mPkgDoms.containsKey(internalPath)) {
                this.mPkgDoms.remove(internalPath);
            }
        }
        this.updateFileEntry(this.ensureFileEntryExistence(internalPath), mediaTypeString);
    }

    Map<String, OdfFileEntry> getManifestEntries() {
        return this.mManifestEntries;
    }

    public String getManifestAsString() {
        if (this.mManifestEntries == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\"");
        if (this.mManifestVersion != null) {
            buf.append(" manifest:version=\"" + this.mManifestVersion + "\"");
        }
        buf.append(" >\n");
        for (String key : new TreeSet<String>(this.mManifestEntries.keySet())) {
            EncryptionData enc;
            String s = null;
            OdfFileEntry fileEntry = this.mManifestEntries.get(key);
            if (fileEntry == null || ((s = fileEntry.getPath()) == null || s.endsWith(SLASH)) && fileEntry.getMediaTypeString().equals(EMPTY_STRING)) continue;
            buf.append(" <manifest:file-entry");
            if (s != null) {
                buf.append(" manifest:full-path=\"");
                buf.append(this.encodeXMLAttributes(s));
                buf.append("\"");
            }
            s = fileEntry.getMediaTypeString();
            buf.append(" manifest:media-type=\"");
            buf.append(this.encodeXMLAttributes(s));
            buf.append("\"");
            int i = fileEntry.getSize();
            if (i > 0) {
                buf.append(" manifest:size=\"");
                buf.append(i);
                buf.append("\"");
            }
            if ((enc = fileEntry.getEncryptionData()) != null) {
                KeyDerivation keyDerivation;
                buf.append(">\n");
                buf.append("  <manifest:encryption-data>\n");
                Algorithm alg = enc.getAlgorithm();
                if (alg != null) {
                    buf.append("   <manifest:algorithm");
                    s = alg.getName();
                    if (s != null) {
                        buf.append(" manifest:algorithm-name=\"");
                        buf.append(this.encodeXMLAttributes(s));
                        buf.append("\"");
                    }
                    if ((s = alg.getInitializationVector()) != null) {
                        buf.append(" manifest:initialization-vector=\"");
                        buf.append(this.encodeXMLAttributes(s));
                        buf.append("\"");
                    }
                    buf.append("/>\n");
                }
                if ((keyDerivation = enc.getKeyDerivation()) != null) {
                    buf.append("   <manifest:key-derivation");
                    s = keyDerivation.getName();
                    if (s != null) {
                        buf.append(" manifest:key-derivation-name=\"");
                        buf.append(this.encodeXMLAttributes(s));
                        buf.append("\"");
                    }
                    if ((s = keyDerivation.getSalt()) != null) {
                        buf.append(" manifest:salt=\"");
                        buf.append(this.encodeXMLAttributes(s));
                        buf.append("\"");
                    }
                    buf.append(" manifest:iteration-count=\"");
                    buf.append(keyDerivation.getIterationCount());
                    buf.append("\"/>\n");
                }
                buf.append("  </manifest:encryption-data>\n");
                buf.append(" </<manifest:file-entry>\n");
                continue;
            }
            buf.append("/>\n");
        }
        buf.append("</manifest:manifest>");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String internalPath) {
        if (internalPath == null || internalPath.equals(EMPTY_STRING)) {
            return null;
        }
        internalPath = OdfPackage.normalizeFilePath(internalPath);
        byte[] data = null;
        if (internalPath.equals(OdfFile.MEDIA_TYPE.getPath())) {
            if (this.mMediaType == null) {
                return null;
            }
            try {
                data = this.mMediaType.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException use) {
                Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, use);
                return null;
            }
        } else if (internalPath.equals(OdfFile.MANIFEST.internalPath)) {
            if (this.mManifestEntries == null) {
                return null;
            }
            String s = this.getManifestAsString();
            if (s == null) {
                return null;
            }
            try {
                data = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (this.mPkgDoms.get(internalPath) != null) {
            data = this.flushDom(this.mPkgDoms.get(internalPath));
            this.mMemoryFileCache.put(internalPath, data);
        } else if (this.mManifestEntries.containsKey(internalPath) && this.mMemoryFileCache.get(internalPath) != null) {
            data = this.mMemoryFileCache.get(internalPath);
        }
        if (data == null) {
            ZipEntry entry = null;
            entry = this.mZipEntries.get(internalPath);
            if (entry != null) {
                InputStream inputStream = null;
                try {
                    inputStream = this.mZipFile.getInputStream(entry);
                    if (inputStream != null) {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        StreamHelper.transformStream(inputStream, out);
                        data = out.toByteArray();
                        this.mMemoryFileCache.put(internalPath, data);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return data;
    }

    private byte[] flushDom(Document dom) {
        if (dom instanceof OdfFileDom) {
            OdfFileDom odfDom = (OdfFileDom)dom;
            Map<String, String> nsByUri = odfDom.getMapNamespacePrefixByUri();
            OdfElement root = odfDom.getRootElement();
            if (root != null) {
                for (Map.Entry<String, String> entry : nsByUri.entrySet()) {
                    root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + entry.getValue(), entry.getKey());
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMXSImplementationSourceImpl dis = new DOMXSImplementationSourceImpl();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)dis.getDOMImplementation("LS"));
        LSSerializer writer = impl.createLSSerializer();
        LSOutput output = impl.createLSOutput();
        output.setByteStream(baos);
        writer.write(dom, output);
        return baos.toByteArray();
    }

    public InputStream getInputStream(String internalPath) {
        byte[] data = this.getBytes(internalPath = OdfPackage.normalizeFilePath(internalPath));
        if (data != null && data.length != 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return bais;
        }
        return null;
    }

    public InputStream getInputStream(String internalPath, boolean useOriginal) {
        InputStream stream = null;
        if (useOriginal) {
            ZipEntry entry = this.mOriginalZipEntries.get(internalPath);
            if (entry != null) {
                try {
                    stream = this.mZipFile.getInputStream(entry);
                }
                catch (IOException ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            stream = this.getInputStream(internalPath);
        }
        return stream;
    }

    public InputStream getInputStream() throws Exception {
        final PipedOutputStream os = new PipedOutputStream();
        final PipedInputStream is = new PipedInputStream();
        is.connect(os);
        Thread thread1 = new Thread(){

            public void run() {
                try {
                    OdfPackage.this.save(os, OdfPackage.this.mBaseURI);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread thread2 = new Thread(){

            public void run() {
                try {
                    BufferedInputStream bis = new BufferedInputStream(is, 4096);
                    BufferedOutputStream bos = new BufferedOutputStream(os, 4096);
                    StreamHelper.transformStream(bis, bos);
                    is.close();
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread1.start();
        thread2.start();
        return is;
    }

    public OutputStream insertOutputStream(String internalPath) throws Exception {
        return this.insertOutputStream(internalPath, null);
    }

    public OutputStream insertOutputStream(String internalPath, String mediaType) throws Exception {
        final String fPath = internalPath = OdfPackage.normalizeFilePath(internalPath);
        final OdfFileEntry fFileEntry = this.getFileEntry(internalPath);
        final String fMediaType = mediaType;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(){

            public void close() {
                try {
                    byte[] data = this.toByteArray();
                    if (fMediaType == null || fMediaType.length() == 0) {
                        OdfPackage.this.insert(data, fPath, fFileEntry == null ? null : fFileEntry.getMediaTypeString());
                    } else {
                        OdfPackage.this.insert(data, fPath, fMediaType);
                    }
                    super.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        return baos;
    }

    public void remove(String internalPath) {
        internalPath = OdfPackage.normalizePath(internalPath);
        if (this.mZipEntries != null && this.mZipEntries.containsKey(internalPath)) {
            this.mZipEntries.remove(internalPath);
        }
        if (this.mManifestEntries != null && this.mManifestEntries.containsKey(internalPath)) {
            this.mManifestEntries.remove(internalPath);
        }
    }

    private String encodeXMLAttributes(String attributeValue) {
        String encodedValue = QUOTATION_PATTERN.matcher(attributeValue).replaceAll(ENCODED_QUOTATION);
        encodedValue = APOSTROPHE_PATTERN.matcher(encodedValue).replaceAll(ENCODED_APOSTROPHE);
        return encodedValue;
    }

    public EntityResolver getEntityResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver(this);
        }
        return this.mResolver;
    }

    public URIResolver getURIResolver() {
        if (this.mResolver == null) {
            this.mResolver = new Resolver(this);
        }
        return this.mResolver;
    }

    private static String getBaseURLFromFile(File file) throws Exception {
        String baseURL = file.getCanonicalFile().toURI().toString();
        baseURL = BACK_SLASH_PATTERN.matcher(baseURL).replaceAll(SLASH);
        return baseURL;
    }

    static String normalizeFilePath(String internalPath) {
        if (internalPath.equals(EMPTY_STRING)) {
            String errMsg = "The internalPath given by parameter is an empty string!";
            Logger.getLogger(OdfPackage.class.getName()).severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        return OdfPackage.normalizePath(internalPath);
    }

    static String normalizeDirectoryPath(String directoryPath) {
        if (!(directoryPath = OdfPackage.normalizePath(directoryPath)).equals(EMPTY_STRING) && !directoryPath.endsWith(SLASH)) {
            directoryPath = directoryPath + SLASH;
        }
        return directoryPath;
    }

    static String normalizePath(String path) {
        if (path == null) {
            String errMsg = "The internalPath given by parameter is NULL!";
            Logger.getLogger(OdfPackage.class.getName()).severe(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        if (!OdfPackage.mightBeExternalReference(path)) {
            if (path.equals(EMPTY_STRING)) {
                path = SLASH;
            } else {
                if (path.indexOf(92) != -1) {
                    path = BACK_SLASH_PATTERN.matcher(path).replaceAll(SLASH);
                }
                while (path.indexOf("//") != -1) {
                    path = DOUBLE_SLASH_PATTERN.matcher(path).replaceAll(SLASH);
                }
                if (path.indexOf("/.") != -1 || path.indexOf("./") != -1) {
                    path = OdfPackage.removeChangeDirectories(path);
                }
            }
        }
        return path;
    }

    private static boolean mightBeExternalReference(String internalPath) {
        boolean isExternalReference = false;
        if (internalPath.startsWith(DOUBLE_DOT) || internalPath.startsWith(SLASH) && !internalPath.equals(SLASH) || internalPath.contains(COLON)) {
            isExternalReference = true;
        }
        return isExternalReference;
    }

    private static String removeChangeDirectories(String path) {
        String lastPath;
        boolean isDirectory = path.endsWith(SLASH);
        StringTokenizer tokenizer = new StringTokenizer(path, SLASH);
        int tokenCount = tokenizer.countTokens();
        ArrayList<String> tokenList = new ArrayList<String>(tokenCount);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            tokenList.add(token);
        }
        if (!isDirectory && ((lastPath = (String)tokenList.get(tokenCount - 1)).equals(DOT) || lastPath.equals(DOUBLE_DOT))) {
            isDirectory = true;
        }
        int removeDirLevel = 0;
        StringBuilder out = new StringBuilder();
        for (int i = tokenCount - 1; i >= 0; --i) {
            String currentToken = (String)tokenList.get(i);
            if (currentToken.equals(DOUBLE_DOT)) {
                ++removeDirLevel;
                continue;
            }
            if (currentToken.equals(DOT)) continue;
            if (removeDirLevel > 0) {
                --removeDirLevel;
                continue;
            }
            out.insert(0, SLASH);
            out.insert(0, currentToken);
        }
        if (removeDirLevel > 0) {
            return EMPTY_STRING;
        }
        if (!isDirectory) {
            out.deleteCharAt(out.length() - 1);
        }
        return out.toString();
    }

    public static boolean isExternalReference(String internalPath) {
        if (OdfPackage.mightBeExternalReference(internalPath)) {
            return true;
        }
        return OdfPackage.mightBeExternalReference(OdfPackage.normalizePath(internalPath));
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.mErrorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.mErrorHandler;
    }

    void logValidationWarning(ValidationConstraint constraint, String baseURI, Object ... o) {
        try {
            int varCount = 0;
            if (o != null) {
                varCount = o.length;
            }
            switch (varCount) {
                case 0: {
                    this.mErrorHandler.warning(new OdfValidationException(constraint, baseURI, o));
                    break;
                }
                case 1: {
                    this.mErrorHandler.warning(new OdfValidationException(constraint, baseURI, o[0]));
                    break;
                }
                case 2: {
                    this.mErrorHandler.warning(new OdfValidationException(constraint, baseURI, o[0], o[1]));
                }
            }
        }
        catch (SAXException ex) {
            Logger.getLogger(OdfPackage.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    void logValidationError(ValidationConstraint constraint, String baseURI, Object ... o) {
        try {
            int varCount = 0;
            if (o != null) {
                varCount = o.length;
            }
            switch (varCount) {
                case 0: {
                    this.mErrorHandler.error(new OdfValidationException(constraint, baseURI, o));
                    break;
                }
                case 1: {
                    this.mErrorHandler.error(new OdfValidationException(constraint, baseURI, o[0]));
                    break;
                }
                case 2: {
                    this.mErrorHandler.error(new OdfValidationException(constraint, baseURI, o[0], o[1]));
                }
            }
        }
        catch (SAXException ex) {
            Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void setManifestVersion(String odfVersion) {
        this.mManifestVersion = odfVersion;
    }

    String getManifestVersion() {
        return this.mManifestVersion;
    }

    static {
        String[] typelist = new String[]{"jpg", "gif", "png", "zip", "rar", "jpeg", "mpe", "mpg", "mpeg", "mpeg4", "mp4", "7z", "ari", "arj", "jar", "gz", "tar", "war", "mov", "avi"};
        mCompressedFileTypes.addAll(Arrays.asList(typelist));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfFile {
        IMAGE_DIRECTORY("Pictures"),
        MANIFEST("META-INF/manifest.xml"),
        MEDIA_TYPE("mimetype");

        private final String internalPath;

        private OdfFile(String internalPath) {
            this.internalPath = internalPath;
        }

        public String getPath() {
            return this.internalPath;
        }
    }
}

