/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.io.File;
import java.io.InputStream;
import org.odftoolkit.odfdom.dom.element.office.OfficeDrawingElement;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.simple.Document;

public class GraphicsDocument
extends Document {
    private static final String EMPTY_GRAPHICS_DOCUMENT_PATH = "/OdfGraphicsDocument.odg";
    static final OdfPackageDocument.Resource EMPTY_GRAPHICS_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfGraphicsDocument.odg");

    public static GraphicsDocument newGraphicsDocument() throws Exception {
        return (GraphicsDocument)Document.loadTemplate(EMPTY_GRAPHICS_DOCUMENT_RESOURCE, Document.OdfMediaType.GRAPHICS);
    }

    public static GraphicsDocument newGraphicsTemplateDocument() throws Exception {
        GraphicsDocument doc = (GraphicsDocument)Document.loadTemplate(EMPTY_GRAPHICS_DOCUMENT_RESOURCE, Document.OdfMediaType.GRAPHICS_TEMPLATE);
        doc.changeMode(OdfMediaType.GRAPHICS_TEMPLATE);
        return doc;
    }

    protected GraphicsDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public static GraphicsDocument loadDocument(InputStream inputStream) throws Exception {
        return (GraphicsDocument)Document.loadDocument(inputStream);
    }

    public static GraphicsDocument loadDocument(String documentPath) throws Exception {
        return (GraphicsDocument)Document.loadDocument(documentPath);
    }

    public static GraphicsDocument loadDocument(File file) throws Exception {
        return (GraphicsDocument)Document.loadDocument(file);
    }

    public OfficeDrawingElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeDrawingElement.class);
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        GRAPHICS(Document.OdfMediaType.GRAPHICS),
        GRAPHICS_TEMPLATE(Document.OdfMediaType.GRAPHICS_TEMPLATE);

        private final Document.OdfMediaType mMediaType;

        private OdfMediaType(Document.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static Document.OdfMediaType getOdfMediaType(String mediaType) {
            return Document.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

