/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.io.File;
import java.io.InputStream;
import org.odftoolkit.odfdom.dom.element.office.OfficeSpreadsheetElement;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.simple.Document;

public class SpreadsheetDocument
extends Document {
    private static final String EMPTY_SPREADSHEET_DOCUMENT_PATH = "/OdfSpreadsheetDocument.ods";
    static final OdfPackageDocument.Resource EMPTY_SPREADSHEET_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfSpreadsheetDocument.ods");

    public static SpreadsheetDocument newSpreadsheetDocument() throws Exception {
        return (SpreadsheetDocument)Document.loadTemplate(EMPTY_SPREADSHEET_DOCUMENT_RESOURCE, Document.OdfMediaType.SPREADSHEET);
    }

    public static SpreadsheetDocument newSpreadsheetTemplateDocument() throws Exception {
        SpreadsheetDocument doc = (SpreadsheetDocument)Document.loadTemplate(EMPTY_SPREADSHEET_DOCUMENT_RESOURCE, Document.OdfMediaType.SPREADSHEET_TEMPLATE);
        doc.changeMode(OdfMediaType.SPREADSHEET_TEMPLATE);
        return doc;
    }

    protected SpreadsheetDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public static SpreadsheetDocument loadDocument(InputStream inputStream) throws Exception {
        return (SpreadsheetDocument)Document.loadDocument(inputStream);
    }

    public static SpreadsheetDocument loadDocument(String documentPath) throws Exception {
        return (SpreadsheetDocument)Document.loadDocument(documentPath);
    }

    public static SpreadsheetDocument loadDocument(File file) throws Exception {
        return (SpreadsheetDocument)Document.loadDocument(file);
    }

    public OfficeSpreadsheetElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeSpreadsheetElement.class);
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        SPREADSHEET(Document.OdfMediaType.SPREADSHEET),
        SPREADSHEET_TEMPLATE(Document.OdfMediaType.SPREADSHEET_TEMPLATE);

        private final Document.OdfMediaType mMediaType;

        private OdfMediaType(Document.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static Document.OdfMediaType getOdfMediaType(String mediaType) {
            return Document.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

