/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.Section;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocument
extends Document
implements ListContainer {
    private static final String EMPTY_TEXT_DOCUMENT_PATH = "/OdfTextDocument.odt";
    static final OdfPackageDocument.Resource EMPTY_TEXT_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfTextDocument.odt");
    private ListContainerImpl listContainerImpl = new ListContainerImpl();

    public static TextDocument newTextDocument() throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT);
    }

    public static TextDocument newTextDocument(OdfMediaType mimeType) throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT);
    }

    public static TextDocument newTextTemplateDocument() throws Exception {
        return (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_TEMPLATE);
    }

    public static TextDocument newTextMasterDocument() throws Exception {
        TextDocument doc = (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_MASTER);
        doc.changeMode(OdfMediaType.TEXT_MASTER);
        return doc;
    }

    public static TextDocument newTextWebDocument() throws Exception {
        TextDocument doc = (TextDocument)Document.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, Document.OdfMediaType.TEXT_WEB);
        doc.changeMode(OdfMediaType.TEXT_WEB);
        return doc;
    }

    public static TextDocument loadDocument(InputStream inputStream) throws Exception {
        return (TextDocument)Document.loadDocument(inputStream);
    }

    public static TextDocument loadDocument(String documentPath) throws Exception {
        return (TextDocument)Document.loadDocument(documentPath);
    }

    public static TextDocument loadDocument(File file) throws Exception {
        return (TextDocument)Document.loadDocument(file);
    }

    protected TextDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    @Override
    public OfficeTextElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeTextElement.class);
    }

    public OdfTextParagraph newParagraph(String text) throws Exception {
        OdfTextParagraph para = this.newParagraph();
        para.addContent(text);
        return para;
    }

    public OdfTextParagraph newParagraph() throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        return (OdfTextParagraph)odfText.newTextPElement();
    }

    public OdfTextParagraph addText(String text) throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        Node n = odfText.getLastChild();
        OdfTextParagraph para = OdfTextParagraph.class.isInstance(n) ? (OdfTextParagraph)n : this.newParagraph();
        para.addContent(text);
        return para;
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    public Section appendSection(Section section, boolean isResourceCopied) {
        boolean isForeignNode = false;
        try {
            if (section.getOdfElement().getOwnerDocument() != this.getContentDom()) {
                isForeignNode = true;
            }
            TextSectionElement oldSectionEle = section.getOdfElement();
            TextSectionElement newSectionEle = (TextSectionElement)oldSectionEle.cloneNode(true);
            if (isResourceCopied || isForeignNode) {
                this.copyLinkedRef(newSectionEle);
            }
            if (isForeignNode) {
                this.copyForeignStyleRef(newSectionEle, section.getOwnerDocument());
            }
            if (isForeignNode) {
                newSectionEle = (TextSectionElement)this.cloneForeignElement(newSectionEle, this.getContentDom(), true);
            }
            this.updateNames(newSectionEle);
            this.updateXMLIds(newSectionEle);
            OfficeTextElement contentRoot = this.getContentRoot();
            contentRoot.appendChild(newSectionEle);
            return Section.getInstance(newSectionEle);
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.listContainerImpl.getListContainerElement();
    }

    @Override
    public List addList() {
        return this.listContainerImpl.addList();
    }

    @Override
    public List addList(ListDecorator decorator) {
        return this.listContainerImpl.addList(decorator);
    }

    @Override
    public void clearList() {
        this.listContainerImpl.clearList();
    }

    @Override
    public Iterator<List> getListIterator() {
        return this.listContainerImpl.getListIterator();
    }

    @Override
    public boolean removeList(List list) {
        return this.listContainerImpl.removeList(list);
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            OfficeTextElement containerElement = null;
            try {
                containerElement = TextDocument.this.getContentRoot();
            }
            catch (Exception e) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            }
            return containerElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        TEXT(Document.OdfMediaType.TEXT),
        TEXT_TEMPLATE(Document.OdfMediaType.TEXT_TEMPLATE),
        TEXT_MASTER(Document.OdfMediaType.TEXT_MASTER),
        TEXT_WEB(Document.OdfMediaType.TEXT_WEB);

        private final Document.OdfMediaType mMediaType;

        private OdfMediaType(Document.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static Document.OdfMediaType getOdfMediaType(String mediaType) {
            return Document.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

