/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

public class TextExtractor
extends DefaultElementVisitor {
    protected static final char NewLineChar = '\r';
    protected static final char TabChar = '\t';
    protected final ExtractorStringBuilder mTextBuilder = new ExtractorStringBuilder();
    OdfElement mElement;

    public static synchronized String getText(OdfElement ele) {
        TextExtractor extractor = TextExtractor.newOdfTextExtractor(ele);
        return extractor.getText();
    }

    public static TextExtractor newOdfTextExtractor(OdfElement element) {
        return new TextExtractor(element);
    }

    public String getText() {
        this.visit(this.mElement);
        return this.mTextBuilder.toString();
    }

    protected TextExtractor() {
    }

    protected TextExtractor(OdfElement element) {
        this.mElement = element;
    }

    public void visit(OdfElement element) {
        this.appendElementText(element);
        if (element.getNamespaceURI().equals(OdfDocumentNamespace.META.getUri()) || element.getNamespaceURI().equals(OdfDocumentNamespace.DC.getUri())) {
            this.mTextBuilder.appendLine();
        }
    }

    public void visit(TextPElement ele) {
        this.appendElementText(ele);
        this.mTextBuilder.appendLine();
    }

    public void visit(TextHElement ele) {
        this.appendElementText(ele);
        this.mTextBuilder.appendLine();
    }

    public void visit(TextSElement ele) {
        Integer count = ele.getTextCAttribute();
        if (count == null) {
            count = 1;
        }
        for (int i = 0; i < count; ++i) {
            this.mTextBuilder.append(' ');
        }
    }

    public void visit(TextTabElement ele) {
        this.mTextBuilder.append('\t');
    }

    public void visit(TextLineBreakElement ele) {
        this.mTextBuilder.append('\r');
    }

    protected void appendElementText(OdfElement ele) {
        for (Node node = ele.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 3) {
                this.mTextBuilder.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            OdfElement element = (OdfElement)node;
            element.accept(this);
        }
    }

    protected static class ExtractorStringBuilder {
        private StringBuilder mBuilder = new StringBuilder();
        private boolean lastAppendNewLine = false;

        ExtractorStringBuilder() {
        }

        public void append(String str) {
            this.mBuilder.append(str);
        }

        public void append(char ch) {
            this.mBuilder.append(ch);
        }

        public void appendLine() {
            this.mBuilder.append('\r');
            this.lastAppendNewLine = true;
        }

        public String toString() {
            if (this.lastAppendNewLine) {
                this.mBuilder.deleteCharAt(this.mBuilder.length() - 1);
            }
            return this.mBuilder.toString();
        }
    }
}

