/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.presentation;

import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.xerces.dom.ElementImpl;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationNotesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.presentation.Notes;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slide
implements ListContainer {
    DrawPageElement maSlideElement;
    private ListContainerImpl listContainerImpl = new ListContainerImpl();

    private Slide(DrawPageElement pageElement) {
        this.maSlideElement = pageElement;
    }

    public static Slide getInstance(DrawPageElement pageElement) {
        PresentationDocument ownerDocument = (PresentationDocument)((OdfFileDom)pageElement.getOwnerDocument()).getDocument();
        return ownerDocument.getSlideBuilder().getSlideInstance(pageElement);
    }

    public DrawPageElement getOdfElement() {
        return this.maSlideElement;
    }

    public int getSlideIndex() {
        OdfFileDom contentDom = (OdfFileDom)this.maSlideElement.getOwnerDocument();
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)slideNodes.item(i);
            if (slideEle != this.maSlideElement) continue;
            return i;
        }
        return -1;
    }

    public String getSlideName() {
        String slideName = this.maSlideElement.getDrawNameAttribute();
        if (slideName == null) {
            slideName = this.makeUniqueSlideName();
            this.maSlideElement.setDrawNameAttribute(slideName);
        }
        return slideName;
    }

    public void setSlideName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("slide name is null is not accepted in the presentation document");
        }
        OdfFileDom contentDom = (OdfFileDom)this.maSlideElement.getOwnerDocument();
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)slideNodes.item(i);
            Slide slide = Slide.getInstance(slideEle);
            String slideName = slide.getSlideName();
            if (!slideName.equals(name)) continue;
            throw new IllegalArgumentException("the given slide name is already exist in the current presentation document");
        }
        this.maSlideElement.setDrawNameAttribute(name);
    }

    public Notes getNotesPage() {
        NodeList notesList = this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.PRESENTATION.getUri(), "notes");
        if (notesList.getLength() > 0) {
            PresentationNotesElement noteEle = (PresentationNotesElement)notesList.item(0);
            return Notes.getInstance(noteEle);
        }
        return null;
    }

    private String makeUniqueSlideName() {
        int index = this.getSlideIndex();
        String slideName = "page" + (index + 1) + "-" + String.format("a%06x", (int)(Math.random() * 1.6777215E7));
        return slideName;
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.listContainerImpl.getListContainerElement();
    }

    @Override
    public List addList() {
        return this.listContainerImpl.addList();
    }

    @Override
    public List addList(ListDecorator decorator) {
        return this.listContainerImpl.addList(decorator);
    }

    @Override
    public void clearList() {
        this.listContainerImpl.clearList();
    }

    @Override
    public Iterator<List> getListIterator() {
        return this.listContainerImpl.getListIterator();
    }

    @Override
    public boolean removeList(List list) {
        return this.listContainerImpl.removeList(list);
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            ElementImpl frame = null;
            DrawTextBoxElement textBox = null;
            NodeList frameList = Slide.this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "frame");
            if (frameList.getLength() > 0) {
                String presentationClass;
                for (int index = frameList.getLength() - 1; !(index < 0 || (presentationClass = ((DrawFrameElement)(frame = (DrawFrameElement)frameList.item(index))).getPresentationClassAttribute()) == null || "outline".equals(presentationClass) || "text".equals(presentationClass) || "subtitle".equals(presentationClass)); --index) {
                    frame = null;
                }
            }
            if (frame == null) {
                throw new UnsupportedOperationException("There is no list container in this slide, please chose a proper slide layout.");
            }
            NodeList textBoxList = frame.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "text-box");
            textBox = textBoxList.getLength() <= 0 ? ((DrawFrameElement)frame).newDrawTextBoxElement() : (DrawTextBoxElement)textBoxList.item(textBoxList.getLength() - 1);
            return textBox;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SlideLayout {
        BLANK("blank"),
        TITLE_ONLY("title_only"),
        TITLE_OUTLINE("title_outline"),
        TITLE_PLUS_TEXT("title_text"),
        TITLE_PLUS_2_TEXT_BLOCK("title_two_text_block");

        private String mValue;

        private SlideLayout(String aValue) {
            this.mValue = aValue;
        }

        public String toString() {
            return this.mValue;
        }

        public static String toString(SlideLayout aEnum) {
            return aEnum.toString();
        }

        public static SlideLayout enumValueOf(String aString) {
            for (SlideLayout aIter : SlideLayout.values()) {
                if (!aString.equals(aIter.toString())) continue;
                return aIter;
            }
            return null;
        }
    }

    public static class SlideBuilder {
        private final IdentityHashMap<DrawPageElement, Slide> maSlideRepository = new IdentityHashMap();

        public SlideBuilder(PresentationDocument doc) {
            if (doc.getSlideBuilder() != null) {
                throw new IllegalStateException("SlideBuilder only can be created in owner PresentationDocument constructor.");
            }
        }

        public synchronized Slide getSlideInstance(DrawPageElement pageElement) {
            if (this.maSlideRepository.containsKey(pageElement)) {
                return this.maSlideRepository.get(pageElement);
            }
            Slide newSlide = new Slide(pageElement);
            this.maSlideRepository.put(pageElement, newSlide);
            return newSlide;
        }
    }
}

