/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.style;

import org.odftoolkit.odfdom.dom.attribute.fo.FoTextAlignAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.simple.style.StyleTypeDefinitions;

public class ParagraphProperties {
    StyleParagraphPropertiesElement mElement;

    protected ParagraphProperties() {
    }

    protected ParagraphProperties(StyleParagraphPropertiesElement properties) {
        this.mElement = properties;
    }

    public void setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType alignType) {
        if (alignType == StyleTypeDefinitions.HorizontalAlignmentType.DEFAULT) {
            this.mElement.removeAttribute(FoTextAlignAttribute.ATTRIBUTE_NAME.getQName());
        } else {
            this.mElement.setFoTextAlignAttribute(alignType.getAlignmentString());
        }
    }

    public StyleTypeDefinitions.HorizontalAlignmentType getHorizontalAlignment() {
        String alignType = this.mElement.getFoTextAlignAttribute();
        if (alignType == null || alignType.length() == 0) {
            return StyleTypeDefinitions.HorizontalAlignmentType.DEFAULT;
        }
        FoTextAlignAttribute.Value value = FoTextAlignAttribute.Value.enumValueOf(alignType);
        switch (value) {
            case CENTER: {
                return StyleTypeDefinitions.HorizontalAlignmentType.CENTER;
            }
            case END: {
                return StyleTypeDefinitions.HorizontalAlignmentType.RIGHT;
            }
            case JUSTIFY: {
                return StyleTypeDefinitions.HorizontalAlignmentType.JUSTIFIED;
            }
            case LEFT: {
                return StyleTypeDefinitions.HorizontalAlignmentType.LEFT;
            }
            case RIGHT: {
                return StyleTypeDefinitions.HorizontalAlignmentType.RIGHT;
            }
            case START: {
                return StyleTypeDefinitions.HorizontalAlignmentType.LEFT;
            }
        }
        return null;
    }

    public static ParagraphProperties getOrCreateParagraphProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getOrCreatePropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
        return new ParagraphProperties((StyleParagraphPropertiesElement)properties);
    }

    public static ParagraphProperties getParagraphProperties(OdfStyleBase style) {
        OdfStylePropertiesBase properties = style.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
        if (properties != null) {
            return new ParagraphProperties((StyleParagraphPropertiesElement)properties);
        }
        return null;
    }
}

