/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.ParagraphProperties;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.style.TableCellProperties;
import org.odftoolkit.simple.style.TextProperties;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Column;
import org.odftoolkit.simple.table.Row;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CellStyleHandler {
    Cell mCell;
    Document mDocument;
    TableTableCellElementBase mCellElement;
    TextProperties mTextProperties;
    TextProperties mWritableTextProperties;
    TableCellProperties mTableCellProperties;
    TableCellProperties mWritableTableCellProperties;
    ParagraphProperties mParagraphProperties;
    ParagraphProperties mWritableParagraphProperties;
    OdfStyleBase mStyleElement;
    OdfStyle mWritableStyleElement;
    boolean isUseDefaultStyle = false;

    CellStyleHandler(Cell aCell) {
        this.mCell = aCell;
        this.mCellElement = this.mCell.getOdfElement();
        this.mDocument = (Document)((OdfFileDom)this.mCellElement.getOwnerDocument()).getDocument();
    }

    public TextProperties getTextPropertiesForRead() {
        if (this.mWritableTextProperties != null) {
            return this.mWritableTextProperties;
        }
        if (this.mTextProperties != null) {
            return this.mTextProperties;
        }
        OdfStyleBase style = this.getCellStyleElementForRead();
        if (style == null) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.INFO, "No style definition is found!", "");
            return null;
        }
        this.mTextProperties = TextProperties.getTextProperties(style);
        if (this.mTextProperties != null) {
            return this.mTextProperties;
        }
        Logger.getLogger(CellStyleHandler.class.getName()).log(Level.INFO, "No explicit text properties definition is found!", "");
        return null;
    }

    public TextProperties getTextPropertiesForWrite() {
        if (this.mWritableTextProperties != null) {
            return this.mWritableTextProperties;
        }
        OdfStyle style = this.getCellStyleElementForWrite();
        this.mWritableTextProperties = TextProperties.getOrCreateTextProperties(style);
        return this.mWritableTextProperties;
    }

    public TableCellProperties getTableCellPropertiesForRead() {
        if (this.mWritableTableCellProperties != null) {
            return this.mWritableTableCellProperties;
        }
        if (this.mTableCellProperties != null) {
            return this.mTableCellProperties;
        }
        OdfStyleBase style = this.getCellStyleElementForRead();
        if (style == null) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.INFO, "No style definition is found!", "");
            return null;
        }
        this.mTableCellProperties = TableCellProperties.getTableCellProperties(style);
        if (this.mTableCellProperties != null) {
            return this.mTableCellProperties;
        }
        Logger.getLogger(CellStyleHandler.class.getName()).log(Level.INFO, "No explicit table cell properties definition is found!", "");
        return null;
    }

    public TableCellProperties getTableCellPropertiesForWrite() {
        if (this.mWritableTableCellProperties != null) {
            return this.mWritableTableCellProperties;
        }
        OdfStyle style = this.getCellStyleElementForWrite();
        this.mWritableTableCellProperties = TableCellProperties.getOrCreateTableCellProperties(style);
        return this.mWritableTableCellProperties;
    }

    public ParagraphProperties getParagraphPropertiesForRead() {
        if (this.mWritableParagraphProperties != null) {
            return this.mWritableParagraphProperties;
        }
        if (this.mParagraphProperties != null) {
            return this.mParagraphProperties;
        }
        OdfStyleBase style = this.getCellStyleElementForRead();
        if (style == null) {
            Logger.getLogger(CellStyleHandler.class.getName()).log(Level.INFO, "No style definition is found!", "");
            return null;
        }
        this.mParagraphProperties = ParagraphProperties.getParagraphProperties(style);
        if (this.mParagraphProperties != null) {
            return this.mParagraphProperties;
        }
        Logger.getLogger(CellStyleHandler.class.getName()).log(Level.INFO, "No explicit paragraph properties definition is found!", "");
        return null;
    }

    public ParagraphProperties getParagraphPropertiesForWrite() {
        if (this.mWritableParagraphProperties != null) {
            return this.mWritableParagraphProperties;
        }
        OdfStyle style = this.getCellStyleElementForWrite();
        this.mWritableParagraphProperties = ParagraphProperties.getOrCreateParagraphProperties(style);
        return this.mWritableParagraphProperties;
    }

    protected OdfStyleBase getCellStyleElementForRead() {
        if (this.getCurrentUsedStyle() != null) {
            return this.getCurrentUsedStyle();
        }
        String styleName = this.mCellElement.getStyleName();
        OdfDefaultStyle defaultStyleElement = null;
        if (styleName == null || styleName.equals("")) {
            Row aRow = this.mCell.getTableRow();
            styleName = aRow.getOdfElement().getTableDefaultCellStyleNameAttribute();
        }
        if (styleName == null || styleName.equals("")) {
            Column aColumn = this.mCell.getTableColumn();
            styleName = aColumn.getOdfElement().getTableDefaultCellStyleNameAttribute();
        }
        if (styleName == null || styleName.equals("")) {
            defaultStyleElement = this.mDocument.getDocumentStyles().getDefaultStyle(OdfStyleFamily.TableCell);
            this.mStyleElement = defaultStyleElement;
            this.isUseDefaultStyle = true;
            return this.mStyleElement;
        }
        OdfStyle styleElement = this.mCellElement.getAutomaticStyles().getStyle(styleName, this.mCellElement.getStyleFamily());
        if (styleElement == null) {
            styleElement = this.mDocument.getDocumentStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        }
        if (styleElement == null) {
            styleElement = this.mCellElement.getDocumentStyle();
        }
        if (styleElement == null) {
            this.mStyleElement = null;
            return this.mStyleElement;
        }
        this.mStyleElement = styleElement;
        return this.mStyleElement;
    }

    protected OdfStyle getCellStyleElementForWrite() {
        if (this.mWritableStyleElement != null) {
            return this.mWritableStyleElement;
        }
        this.mCell.splitRepeatedCells();
        this.mCellElement = this.mCell.getOdfElement();
        boolean createNew = false;
        OdfStyle styleElement = null;
        OdfDefaultStyle defaultStyleElement = null;
        String styleName = this.mCellElement.getStyleName();
        if (styleName == null || styleName.equals("")) {
            Row aRow = this.mCell.getTableRow();
            styleName = aRow.getOdfElement().getTableDefaultCellStyleNameAttribute();
            createNew = true;
        }
        if (styleName == null || styleName.equals("")) {
            Column aColumn = this.mCell.getTableColumn();
            styleName = aColumn.getOdfElement().getTableDefaultCellStyleNameAttribute();
            createNew = true;
        }
        if (styleName == null || styleName.equals("")) {
            createNew = true;
            defaultStyleElement = this.mDocument.getDocumentStyles().getDefaultStyle(OdfStyleFamily.TableCell);
        } else {
            OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
            styleElement = styles.getStyle(styleName, this.mCellElement.getStyleFamily());
            if (styleElement == null && defaultStyleElement == null) {
                styleElement = this.mDocument.getDocumentStyles().getStyle(styleName, OdfStyleFamily.TableCell);
            }
            if (styleElement == null && defaultStyleElement == null) {
                styleElement = this.mCellElement.getDocumentStyle();
            }
            if (styleElement == null || styleElement.getStyleUserCount() > 1) {
                createNew = true;
            }
        }
        if (createNew) {
            NamedNodeMap attributes;
            OdfStyle newStyle = this.mCellElement.getAutomaticStyles().newStyle(OdfStyleFamily.TableCell);
            if (styleElement != null) {
                newStyle.setProperties(styleElement.getStylePropertiesDeep());
                attributes = styleElement.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    if (attr.getNodeName().equals("style:name")) continue;
                    newStyle.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
                }
            } else if (defaultStyleElement != null) {
                newStyle.setProperties(defaultStyleElement.getStylePropertiesDeep());
                attributes = defaultStyleElement.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    if (attr.getNodeName().equals("style:name")) continue;
                    newStyle.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
                }
                this.isUseDefaultStyle = true;
            }
            String newname = newStyle.getStyleNameAttribute();
            this.mCellElement.setStyleName(newname);
            this.mWritableStyleElement = newStyle;
            return this.mWritableStyleElement;
        }
        this.mWritableStyleElement = styleElement;
        return this.mWritableStyleElement;
    }

    private OdfDefaultStyle getCellDefaultStyle() {
        return this.mDocument.getDocumentStyles().getDefaultStyle(OdfStyleFamily.TableCell);
    }

    private OdfDefaultStyle getParagraphDefaultStyle() {
        return this.mDocument.getDocumentStyles().getDefaultStyle(OdfStyleFamily.Paragraph);
    }

    private OdfStyleBase getParentStyle(OdfStyle aStyle) {
        String parentName = aStyle.getStyleParentStyleNameAttribute();
        if (parentName == null || parentName.length() == 0) {
            return null;
        }
        if (parentName.equals("Default")) {
            return this.getCellDefaultStyle();
        }
        return this.getStyleByName(parentName);
    }

    private OdfStyle getStyleByName(String name) {
        OdfStyle styleElement = null;
        OdfOfficeAutomaticStyles styles = this.mCellElement.getAutomaticStyles();
        styleElement = styles.getStyle(name, OdfStyleFamily.TableCell);
        if (styleElement == null) {
            styleElement = this.mDocument.getDocumentStyles().getStyle(name, OdfStyleFamily.TableCell);
        }
        return styleElement;
    }

    private OdfStyleBase getCurrentUsedStyle() {
        if (this.mWritableStyleElement != null) {
            return this.mWritableStyleElement;
        }
        return this.mStyleElement;
    }

    public String getCountry(Document.ScriptType type) {
        String country = null;
        TextProperties textProperties = this.getTextPropertiesForRead();
        if (textProperties != null) {
            country = textProperties.getCountry(type);
        }
        if (country != null && country.length() > 0) {
            return country;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TextProperties parentStyleSetting = TextProperties.getTextProperties(parentStyle);
            country = parentStyleSetting.getCountry(type);
            if (country != null && country.length() > 0) {
                return country;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getCellDefaultStyle();
            TextProperties defaultStyleSetting = TextProperties.getTextProperties(defaultStyle);
            country = defaultStyleSetting.getCountry(type);
        }
        return country;
    }

    private void mergeFont(Font target, Font source) {
        if (target.getFamilyName() == null && source.getFamilyName() != null) {
            target.setFamilyName(source.getFamilyName());
        }
        if (target.getColor() == null && source.getColor() != null) {
            target.setColor(source.getColor());
        }
        if (target.getSize() == 0.0 && source.getSize() > 0.0) {
            target.setSize(source.getSize());
        }
        if (target.getFontStyle() == null && source.getFontStyle() != null) {
            target.setFontStyle(source.getFontStyle());
        }
        if (target.getTextLinePosition() == null && source.getTextLinePosition() != null) {
            target.setTextLinePosition(source.getTextLinePosition());
        }
    }

    public Font getFont(Document.ScriptType type) {
        Font font = null;
        TextProperties textProperties = this.getTextPropertiesForRead();
        font = textProperties != null ? textProperties.getFont(type) : new Font(null, null, 0.0, (StyleTypeDefinitions.TextLinePosition)null);
        if (font != null && font.getFamilyName() != null && font.getColor() != null && font.getSize() != 0.0 && font.getFontStyle() != null && font.getTextLinePosition() != null) {
            return font;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TextProperties parentStyleSetting = TextProperties.getTextProperties(parentStyle);
            Font tempFont = parentStyleSetting.getFont(type);
            this.mergeFont(font, tempFont);
            if (font.getFamilyName() != null && font.getColor() != null && font.getSize() > 0.0 && font.getFontStyle() != null && font.getTextLinePosition() != null) {
                return font;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getCellDefaultStyle();
            if (defaultStyle == null) {
                defaultStyle = this.getParagraphDefaultStyle();
            }
            TextProperties defaultStyleSetting = TextProperties.getTextProperties(defaultStyle);
            Font tempFont = defaultStyleSetting.getFont(type);
            this.mergeFont(font, tempFont);
        }
        if (font.getColor() == null) {
            font.setColor(Color.BLACK);
        }
        if (font.getFontStyle() == null) {
            font.setFontStyle(StyleTypeDefinitions.FontStyle.REGULAR);
        }
        if (font.getTextLinePosition() == null) {
            font.setTextLinePosition(StyleTypeDefinitions.TextLinePosition.REGULAR);
        }
        return font;
    }

    public String getLanguage(Document.ScriptType type) {
        String language = null;
        TextProperties textProperties = this.getTextPropertiesForRead();
        if (textProperties != null) {
            language = textProperties.getLanguage(type);
        }
        if (language != null && language.length() > 0) {
            return language;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TextProperties parentStyleSetting = TextProperties.getTextProperties(parentStyle);
            language = parentStyleSetting.getLanguage(type);
            if (language != null && language.length() > 0) {
                return language;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getCellDefaultStyle();
            TextProperties defaultStyleSetting = TextProperties.getTextProperties(defaultStyle);
            language = defaultStyleSetting.getLanguage(type);
        }
        return language;
    }

    public void setCountry(String country, Document.ScriptType type) {
        this.getTextPropertiesForWrite().setCountry(country, type);
    }

    public void setFont(Font font) {
        this.getTextPropertiesForWrite().setFont(font);
    }

    public void setFont(Font font, Locale language) {
        this.getTextPropertiesForWrite().setFont(font, language);
    }

    public void setLanguage(String language, Document.ScriptType type) {
        this.getTextPropertiesForWrite().setLanguage(language, type);
    }

    public Color getBackgroundColor() {
        Color tempColor = null;
        TableCellProperties properties = this.getTableCellPropertiesForRead();
        if (properties != null) {
            tempColor = properties.getBackgroundColor();
        }
        if (tempColor != null) {
            return tempColor;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TableCellProperties parentStyleSetting = TableCellProperties.getTableCellProperties(parentStyle);
            tempColor = parentStyleSetting.getBackgroundColor();
            if (tempColor != null) {
                return tempColor;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getCellDefaultStyle();
            TableCellProperties defaultStyleSetting = TableCellProperties.getTableCellProperties(defaultStyle);
            tempColor = defaultStyleSetting.getBackgroundColor();
        }
        if (tempColor == null) {
            return Color.WHITE;
        }
        return tempColor;
    }

    private Border getNullableBorder(TableCellProperties properties, StyleTypeDefinitions.CellBordersType type) {
        switch (type) {
            case LEFT: {
                return properties.getLeftBorder();
            }
            case RIGHT: {
                return properties.getRightBorder();
            }
            case TOP: {
                return properties.getTopBorder();
            }
            case BOTTOM: {
                return properties.getBottomBorder();
            }
            case DIAGONALBLTR: {
                return properties.getDiagonalBlTr();
            }
            case DIAGONALTLBR: {
                return properties.getDiagonalTlBr();
            }
        }
        throw new IllegalArgumentException("Only border type with a single border is accepted.");
    }

    public Border getBorder(StyleTypeDefinitions.CellBordersType type) {
        Border tempBorder = null;
        TableCellProperties properties = this.getTableCellPropertiesForRead();
        if (properties != null) {
            tempBorder = this.getNullableBorder(properties, type);
        }
        if (tempBorder != null) {
            return tempBorder;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TableCellProperties parentStyleSetting = TableCellProperties.getTableCellProperties(parentStyle);
            tempBorder = this.getNullableBorder(parentStyleSetting, type);
            if (tempBorder != null) {
                return tempBorder;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getCellDefaultStyle();
            TableCellProperties defaultStyleSetting = TableCellProperties.getTableCellProperties(defaultStyle);
            tempBorder = this.getNullableBorder(defaultStyleSetting, type);
        }
        if (tempBorder == null) {
            return Border.NONE;
        }
        return tempBorder;
    }

    public StyleTypeDefinitions.VerticalAlignmentType getVerticalAlignment() {
        StyleTypeDefinitions.VerticalAlignmentType tempAlign = null;
        TableCellProperties properties = this.getTableCellPropertiesForRead();
        if (properties != null) {
            tempAlign = properties.getVerticalAlignment();
        }
        if (tempAlign != null) {
            return tempAlign;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TableCellProperties parentStyleSetting = TableCellProperties.getTableCellProperties(parentStyle);
            tempAlign = parentStyleSetting.getVerticalAlignment();
            if (tempAlign != null) {
                return tempAlign;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getCellDefaultStyle();
            TableCellProperties defaultStyleSetting = TableCellProperties.getTableCellProperties(defaultStyle);
            tempAlign = defaultStyleSetting.getVerticalAlignment();
        }
        if (tempAlign == null) {
            return StyleTypeDefinitions.VerticalAlignmentType.DEFAULT;
        }
        return tempAlign;
    }

    public boolean isTextWrapped() {
        Boolean tempBool = null;
        TableCellProperties properties = this.getTableCellPropertiesForRead();
        if (properties != null) {
            tempBool = properties.isWrapped();
        }
        if (tempBool != null) {
            return tempBool;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            TableCellProperties parentStyleSetting = TableCellProperties.getTableCellProperties(parentStyle);
            tempBool = parentStyleSetting.isWrapped();
            if (tempBool != null) {
                return tempBool;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getCellDefaultStyle();
            TableCellProperties defaultStyleSetting = TableCellProperties.getTableCellProperties(defaultStyle);
            tempBool = defaultStyleSetting.isWrapped();
        }
        if (tempBool == null) {
            return false;
        }
        return tempBool;
    }

    public void setBackgroundColor(Color color) {
        this.getTableCellPropertiesForWrite().setBackgroundColor(color);
    }

    public void setBorders(Border border, StyleTypeDefinitions.CellBordersType bordersType) {
        this.getTableCellPropertiesForWrite().setBorders(bordersType, border);
    }

    public void setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType alignType) {
        this.getTableCellPropertiesForWrite().setVerticalAlignment(alignType);
    }

    public void setTextWrapped(boolean isWrapped) {
        this.getTableCellPropertiesForWrite().setWrapped(isWrapped);
    }

    public void setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType alignType) {
        this.getParagraphPropertiesForWrite().setHorizontalAlignment(alignType);
    }

    public StyleTypeDefinitions.HorizontalAlignmentType getHorizontalAlignment() {
        StyleTypeDefinitions.HorizontalAlignmentType tempAlign = null;
        ParagraphProperties properties = this.getParagraphPropertiesForRead();
        if (properties != null) {
            tempAlign = properties.getHorizontalAlignment();
        }
        if (tempAlign != null) {
            return tempAlign;
        }
        boolean isDefault = this.isUseDefaultStyle;
        OdfStyleBase parentStyle = null;
        if (!isDefault) {
            parentStyle = this.getParentStyle((OdfStyle)this.getCurrentUsedStyle());
        }
        while (!isDefault && parentStyle != null) {
            ParagraphProperties parentStyleSetting = ParagraphProperties.getParagraphProperties(parentStyle);
            tempAlign = parentStyleSetting.getHorizontalAlignment();
            if (tempAlign != null) {
                return tempAlign;
            }
            if (parentStyle instanceof OdfDefaultStyle) {
                isDefault = true;
                continue;
            }
            parentStyle = this.getParentStyle((OdfStyle)parentStyle);
        }
        if (!isDefault) {
            OdfDefaultStyle defaultStyle = this.getCellDefaultStyle();
            ParagraphProperties defaultStyleSetting = ParagraphProperties.getParagraphProperties(defaultStyle);
            tempAlign = defaultStyleSetting.getHorizontalAlignment();
        }
        if (tempAlign == null) {
            return StyleTypeDefinitions.HorizontalAlignmentType.DEFAULT;
        }
        return tempAlign;
    }
}

