/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.table.TableAlignAttribute;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentContentElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedExpressionsElement;
import org.odftoolkit.odfdom.dom.element.table.TableNamedRangeElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfTableProperties;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.odfdom.type.PositiveLength;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.CellCoverInfo;
import org.odftoolkit.simple.table.CellRange;
import org.odftoolkit.simple.table.Column;
import org.odftoolkit.simple.table.DomNodeList;
import org.odftoolkit.simple.table.Row;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    private final TableTableElement mTableElement;
    protected Document mDocument;
    protected boolean mIsSpreadsheet;
    protected boolean mIsCellStyleInheritance = true;
    private static final int DEFAULT_ROW_COUNT = 2;
    private static final int DEFAULT_COLUMN_COUNT = 5;
    private static final double DEFAULT_TABLE_WIDTH = 6.0;
    private static final int DEFAULT_REL_TABLE_WIDTH = 65535;
    private static final String DEFAULT_TABLE_ALIGN = "margins";
    private static final DecimalFormat IN_FORMAT = new DecimalFormat("##0.0000");
    IdentityHashMap<TableTableCellElementBase, Vector<Cell>> mCellRepository = new IdentityHashMap();
    IdentityHashMap<TableTableRowElement, Vector<Row>> mRowRepository = new IdentityHashMap();
    IdentityHashMap<TableTableColumnElement, Vector<Column>> mColumnRepository = new IdentityHashMap();

    private Table(Document doc, TableTableElement table) {
        this.mTableElement = table;
        this.mDocument = doc;
        this.mIsSpreadsheet = this.mDocument instanceof SpreadsheetDocument;
    }

    public static Table getInstance(TableTableElement odfElement) {
        Document ownerDocument = (Document)((OdfFileDom)odfElement.getOwnerDocument()).getDocument();
        return ownerDocument.getTableBuilder().getTableInstance(odfElement);
    }

    public static Table newTable(Document document) {
        return document.getTableBuilder().newTable();
    }

    public static Table newTable(Document document, int numRows, int numCols) {
        return document.getTableBuilder().newTable(numRows, numCols);
    }

    public static Table newTable(Document document, int numRows, int numCols, int headerRowNumber, int headerColumnNumber) {
        return document.getTableBuilder().newTable(numRows, numCols, headerRowNumber, headerColumnNumber);
    }

    public static Table newTable(Document document, String[] rowLabel, String[] columnLabel, double[][] data) {
        return document.getTableBuilder().newTable(rowLabel, columnLabel, data);
    }

    public static Table newTable(Document document, String[] rowLabel, String[] columnLabel, String[][] data) {
        return document.getTableBuilder().newTable(rowLabel, columnLabel, data);
    }

    Cell getCellInstance(TableTableCellElementBase cell, int repeatedColIndex, int repeatedRowIndex) {
        if (this.mCellRepository.containsKey(cell)) {
            Vector<Cell> list = this.mCellRepository.get(cell);
            Cell fCell = null;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getOdfElement() != cell || list.get((int)i).mnRepeatedColIndex != repeatedColIndex || list.get((int)i).mnRepeatedRowIndex != repeatedRowIndex) continue;
                fCell = list.get(i);
                break;
            }
            if (fCell == null) {
                fCell = new Cell(cell, repeatedColIndex, repeatedRowIndex);
                list.add(fCell);
            }
            return fCell;
        }
        Cell newCell = new Cell(cell, repeatedColIndex, repeatedRowIndex);
        Vector<Cell> list = new Vector<Cell>();
        list.add(newCell);
        this.mCellRepository.put(cell, list);
        return newCell;
    }

    Row getRowInstance(TableTableRowElement row, int repeatedRowIndex) {
        if (this.mRowRepository.containsKey(row)) {
            Row fCell;
            Vector<Row> list = this.mRowRepository.get(row);
            if (list.size() <= repeatedRowIndex) {
                list.setSize(repeatedRowIndex + 1);
            }
            if ((fCell = list.get(repeatedRowIndex)) == null) {
                fCell = new Row(row, repeatedRowIndex);
                list.set(repeatedRowIndex, fCell);
            }
            return fCell;
        }
        Row newRow = new Row(row, repeatedRowIndex);
        int size = repeatedRowIndex > 7 ? repeatedRowIndex + 1 : 8;
        Vector<Row> list = new Vector<Row>(size);
        list.setSize(repeatedRowIndex + 1);
        list.set(repeatedRowIndex, newRow);
        this.mRowRepository.put(row, list);
        return newRow;
    }

    Column getColumnInstance(TableTableColumnElement col, int repeatedColIndex) {
        if (this.mColumnRepository.containsKey(col)) {
            Column fClm;
            Vector<Column> list = this.mColumnRepository.get(col);
            if (list.size() <= repeatedColIndex) {
                list.setSize(repeatedColIndex + 1);
            }
            if ((fClm = list.get(repeatedColIndex)) == null) {
                fClm = new Column(col, repeatedColIndex);
                list.set(repeatedColIndex, fClm);
            }
            return fClm;
        }
        Column newColumn = new Column(col, repeatedColIndex);
        int size = repeatedColIndex > 7 ? repeatedColIndex + 1 : 8;
        Vector<Column> list = new Vector<Column>(size);
        list.setSize(repeatedColIndex + 1);
        list.set(repeatedColIndex, newColumn);
        this.mColumnRepository.put(col, list);
        return newColumn;
    }

    TableTableColumnElement getColumnElementByIndex(int colIndex) {
        int result = 0;
        TableTableColumnElement columnEle = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderColumnsElement) {
                TableTableHeaderColumnsElement headers = (TableTableHeaderColumnsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (m instanceof TableTableColumnElement) {
                        columnEle = (TableTableColumnElement)m;
                        result = columnEle.getTableNumberColumnsRepeatedAttribute() == null ? ++result : (result += columnEle.getTableNumberColumnsRepeatedAttribute().intValue());
                    }
                    if (result <= colIndex) continue;
                    break;
                }
            }
            if (n instanceof TableTableColumnElement) {
                columnEle = (TableTableColumnElement)n;
                result = columnEle.getTableNumberColumnsRepeatedAttribute() == null ? ++result : (result += columnEle.getTableNumberColumnsRepeatedAttribute().intValue());
            }
            if (result <= colIndex) continue;
            break;
        }
        return columnEle;
    }

    TableTableRowElement getRowElementByIndex(int rowIndex) {
        int result = 0;
        TableTableRowElement rowEle = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                TableTableHeaderRowsElement headers = (TableTableHeaderRowsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (m instanceof TableTableRowElement) {
                        rowEle = (TableTableRowElement)m;
                        result += rowEle.getTableNumberRowsRepeatedAttribute().intValue();
                    }
                    if (result <= rowIndex) continue;
                    break;
                }
            }
            if (n instanceof TableTableRowElement) {
                rowEle = (TableTableRowElement)n;
                result += ((TableTableRowElement)n).getTableNumberRowsRepeatedAttribute().intValue();
            }
            if (result <= rowIndex) continue;
            break;
        }
        return rowEle;
    }

    public long getWidth() {
        if (!this.mIsSpreadsheet) {
            String sWidth = this.mTableElement.getProperty(OdfTableProperties.Width);
            if (sWidth == null) {
                int colCount = this.getColumnCount();
                int tableWidth = 0;
                for (int i = 0; i < colCount; ++i) {
                    Column col = this.getColumnByIndex(i);
                    tableWidth = (int)((long)tableWidth + col.getWidth());
                }
                return tableWidth;
            }
            return PositiveLength.parseLong(sWidth, Length.Unit.MILLIMETER);
        }
        throw new UnsupportedOperationException();
    }

    public void setWidth(long width) {
        if (!this.mIsSpreadsheet) {
            String sWidthMM = String.valueOf(width) + Length.Unit.MILLIMETER.abbr();
            String sWidthIN = PositiveLength.mapToUnit(sWidthMM, Length.Unit.INCH);
            this.mTableElement.setProperty(OdfTableProperties.Width, sWidthIN);
            String alineStyle = this.mTableElement.getProperty(StyleTablePropertiesElement.Align);
            if (TableAlignAttribute.Value.MARGINS.toString().equals(alineStyle)) {
                this.mTableElement.setProperty(StyleTablePropertiesElement.Align, TableAlignAttribute.Value.LEFT.toString());
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    static void setLeftTopBorderStyleProperties(OdfStyle style) {
        style.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
        style.setProperty(StyleTableCellPropertiesElement.BorderLeft, "0.0007in solid #000000");
        style.setProperty(StyleTableCellPropertiesElement.BorderRight, "none");
        style.setProperty(StyleTableCellPropertiesElement.BorderTop, "0.0007in solid #000000");
        style.setProperty(StyleTableCellPropertiesElement.BorderBottom, "0.0007in solid #000000");
    }

    static void setRightTopBorderStyleProperties(OdfStyle style) {
        style.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
        style.setProperty(StyleTableCellPropertiesElement.Border, "0.0007in solid #000000");
    }

    static void setLeftBottomBorderStylesProperties(OdfStyle style) {
        style.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
        style.setProperty(StyleTableCellPropertiesElement.BorderLeft, "0.0007in solid #000000");
        style.setProperty(StyleTableCellPropertiesElement.BorderRight, "none");
        style.setProperty(StyleTableCellPropertiesElement.BorderTop, "none");
        style.setProperty(StyleTableCellPropertiesElement.BorderBottom, "0.0007in solid #000000");
    }

    static void setRightBottomBorderStylesProperties(OdfStyle style) {
        style.setProperty(StyleTableCellPropertiesElement.Padding, "0.0382in");
        style.setProperty(StyleTableCellPropertiesElement.Border, "0.0007in solid #000000");
        style.setProperty(StyleTableCellPropertiesElement.BorderTop, "none");
        style.setProperty(StyleTableCellPropertiesElement.BorderBottom, "0.0007in solid #000000");
    }

    private static TableTableElement createTable(Document document, int numRows, int numCols, int headerRowNumber, int headerColumnNumber) throws Exception {
        boolean isSpreadsheet = document instanceof SpreadsheetDocument;
        if (numRows < 1 || numCols < 1 || headerRowNumber < 0 || headerColumnNumber < 0 || headerRowNumber > numRows || headerColumnNumber > numCols) {
            throw new IllegalArgumentException("Can not create table with the given parameters:\nRows " + numRows + ", Columns " + numCols + ", HeaderRows " + headerRowNumber + ", HeaderColumns " + headerColumnNumber);
        }
        OdfContentDom dom = document.getContentDom();
        OdfOfficeAutomaticStyles styles = dom.getAutomaticStyles();
        TableTableElement newTEle = (TableTableElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table"));
        String tablename = Table.getUniqueTableName(document);
        newTEle.setTableNameAttribute(tablename);
        OdfStyle tableStyle = styles.newStyle(OdfStyleFamily.Table);
        String stylename = tableStyle.getStyleNameAttribute();
        tableStyle.setProperty(StyleTablePropertiesElement.Width, "6.0in");
        tableStyle.setProperty(StyleTablePropertiesElement.Align, DEFAULT_TABLE_ALIGN);
        newTEle.setStyleName(stylename);
        OdfStyle columnStyle = styles.newStyle(OdfStyleFamily.TableColumn);
        String columnStylename = columnStyle.getStyleNameAttribute();
        if (!isSpreadsheet) {
            columnStyle.setProperty(StyleTableColumnPropertiesElement.ColumnWidth, IN_FORMAT.format(6.0 / (double)numCols) + "in");
            columnStyle.setProperty(StyleTableColumnPropertiesElement.RelColumnWidth, Math.round(65535 / numCols) + "*");
        }
        if (headerColumnNumber > 0) {
            TableTableHeaderColumnsElement headercolumns = (TableTableHeaderColumnsElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-header-columns"));
            TableTableColumnElement headercolumn = (TableTableColumnElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-column"));
            headercolumn.setTableNumberColumnsRepeatedAttribute(headerColumnNumber);
            headercolumns.appendChild(headercolumn);
            newTEle.appendChild(headercolumns);
            headercolumn.setStyleName(columnStylename);
        }
        TableTableColumnElement columns = (TableTableColumnElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-column"));
        columns.setTableNumberColumnsRepeatedAttribute(numCols - headerColumnNumber);
        columns.setStyleName(columnStylename);
        newTEle.appendChild(columns);
        OdfStyle lefttopStyle = null;
        OdfStyle leftbottomStyle = null;
        OdfStyle righttopStyle = null;
        OdfStyle rightbottomStyle = null;
        if (!document.getMediaTypeString().equals(Document.OdfMediaType.SPREADSHEET.getMediaTypeString())) {
            lefttopStyle = styles.newStyle(OdfStyleFamily.TableCell);
            Table.setLeftTopBorderStyleProperties(lefttopStyle);
            leftbottomStyle = styles.newStyle(OdfStyleFamily.TableCell);
            Table.setLeftBottomBorderStylesProperties(leftbottomStyle);
            righttopStyle = styles.newStyle(OdfStyleFamily.TableCell);
            Table.setRightTopBorderStyleProperties(righttopStyle);
            rightbottomStyle = styles.newStyle(OdfStyleFamily.TableCell);
            Table.setRightBottomBorderStylesProperties(rightbottomStyle);
        }
        if (headerRowNumber > 0) {
            TableTableHeaderRowsElement headerrows = (TableTableHeaderRowsElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-header-rows"));
            for (int i = 0; i < headerRowNumber; ++i) {
                TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
                for (int j = 0; j < numCols; ++j) {
                    TableTableCellElement aCell = (TableTableCellElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell"));
                    if (!isSpreadsheet) {
                        if (j + 1 == numCols && i == 0) {
                            aCell.setStyleName(righttopStyle.getStyleNameAttribute());
                        } else if (i == 0) {
                            aCell.setStyleName(lefttopStyle.getStyleNameAttribute());
                        } else if (j + 1 == numCols && i > 0) {
                            aCell.setStyleName(rightbottomStyle.getStyleNameAttribute());
                        } else {
                            aCell.setStyleName(leftbottomStyle.getStyleNameAttribute());
                        }
                    }
                    aRow.appendChild(aCell);
                }
                headerrows.appendChild(aRow);
            }
            newTEle.appendChild(headerrows);
        }
        for (int i = headerRowNumber; i < numRows; ++i) {
            TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
            for (int j = 0; j < numCols; ++j) {
                TableTableCellElement aCell = (TableTableCellElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell"));
                if (!isSpreadsheet) {
                    if (j + 1 == numCols && i == 0) {
                        aCell.setStyleName(righttopStyle.getStyleNameAttribute());
                    } else if (i == 0) {
                        aCell.setStyleName(lefttopStyle.getStyleNameAttribute());
                    } else if (j + 1 == numCols && i > 0) {
                        aCell.setStyleName(rightbottomStyle.getStyleNameAttribute());
                    } else {
                        aCell.setStyleName(leftbottomStyle.getStyleNameAttribute());
                    }
                }
                aRow.appendChild(aCell);
            }
            newTEle.appendChild(aRow);
        }
        return newTEle;
    }

    private static String getUniqueTableName(Document document) {
        List<Table> tableList = document.getTableList();
        boolean notUnique = true;
        String tablename = "Table" + (tableList.size() + 1);
        while (notUnique) {
            notUnique = false;
            for (int i = 0; i < tableList.size(); ++i) {
                if (!tableList.get(i).getTableName().equalsIgnoreCase(tablename)) continue;
                notUnique = true;
                break;
            }
            if (!notUnique) continue;
            tablename = tablename + Math.round(Math.random() * 10.0);
        }
        return tablename;
    }

    public int getRowCount() {
        int result = 0;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                result += this.getHeaderRowCount((TableTableHeaderRowsElement)n);
            }
            if (n instanceof TableTableRowElement) {
                result += ((TableTableRowElement)n).getTableNumberRowsRepeatedAttribute().intValue();
            }
            if (!(n instanceof TableTableRowsElement)) continue;
            for (Node nn : new DomNodeList(n.getChildNodes())) {
                if (!(nn instanceof TableTableRowElement)) continue;
                result += ((TableTableRowElement)nn).getTableNumberRowsRepeatedAttribute().intValue();
            }
        }
        return result;
    }

    public int getColumnCount() {
        int result = 0;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderColumnsElement) {
                result += this.getHeaderColumnCount((TableTableHeaderColumnsElement)n);
            }
            if (n instanceof TableTableColumnElement) {
                result += ((TableTableColumnElement)n).getTableNumberColumnsRepeatedAttribute().intValue();
            }
            if (!(n instanceof TableTableHeaderRowsElement) && !(n instanceof TableTableRowsElement) && !(n instanceof TableTableRowGroupElement) && !(n instanceof TableTableRowElement)) continue;
            break;
        }
        return result;
    }

    private TableTableRowElement createDefaultRow(int columnCount, boolean createRepeatedCell) {
        OdfFileDom dom = (OdfFileDom)this.mTableElement.getOwnerDocument();
        TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
        if (createRepeatedCell) {
            TableTableCellElement aCell = (TableTableCellElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell"));
            if (columnCount > 1) {
                aCell.setTableNumberColumnsRepeatedAttribute(columnCount);
            }
            if (!this.mIsSpreadsheet) {
                OdfOfficeAutomaticStyles automaticStyles = this.mTableElement.getAutomaticStyles();
                OdfStyle borderStyle = automaticStyles.newStyle(OdfStyleFamily.TableCell);
                Table.setRightTopBorderStyleProperties(borderStyle);
                aCell.setStyleName(borderStyle.getStyleNameAttribute());
            }
        } else {
            OdfStyle lefttopStyle = null;
            OdfStyle righttopStyle = null;
            if (!this.mIsSpreadsheet) {
                OdfOfficeAutomaticStyles automaticStyles = this.mTableElement.getAutomaticStyles();
                lefttopStyle = automaticStyles.newStyle(OdfStyleFamily.TableCell);
                Table.setLeftTopBorderStyleProperties(lefttopStyle);
                righttopStyle = automaticStyles.newStyle(OdfStyleFamily.TableCell);
                Table.setRightTopBorderStyleProperties(righttopStyle);
            }
            for (int j = 0; j < columnCount; ++j) {
                TableTableCellElement aCell = (TableTableCellElement)OdfXMLFactory.newOdfElement(dom, OdfName.newName(OdfDocumentNamespace.TABLE, "table-cell"));
                if (!this.mIsSpreadsheet) {
                    if (j + 1 == columnCount) {
                        aCell.setStyleName(righttopStyle.getStyleNameAttribute());
                    } else {
                        aCell.setStyleName(lefttopStyle.getStyleNameAttribute());
                    }
                }
                aRow.appendChild(aCell);
            }
        }
        return aRow;
    }

    public Row appendRow() {
        Node childNode = this.mTableElement.getLastChild();
        Node positionNode = null;
        TableTableRowElement refRowElement = null;
        TableTableRowElement newRow = null;
        if (childNode instanceof TableNamedExpressionsElement) {
            positionNode = childNode = childNode.getPreviousSibling();
        }
        if (childNode instanceof TableTableRowElement) {
            refRowElement = (TableTableRowElement)childNode;
        }
        int columnCount = this.getColumnCount();
        if (refRowElement == null) {
            newRow = this.createDefaultRow(columnCount, true);
            this.mTableElement.appendChild(newRow);
        } else {
            newRow = (TableTableRowElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.mTableElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
            TableTableCellElementBase cellElement = (TableTableCellElementBase)refRowElement.getFirstChild();
            int i = 1;
            block0: while (cellElement != null && i <= columnCount) {
                TableTableCellElementBase newCoveredCellEle;
                int j;
                if (cellElement instanceof TableCoveredTableCellElement) {
                    TableCoveredTableCellElement coveredCellEle = (TableCoveredTableCellElement)cellElement;
                    TableTableRowElement aRowEle = (TableTableRowElement)coveredCellEle.getParentNode().getPreviousSibling();
                    while (aRowEle != null) {
                        TableTableCellElementBase coverCellEle = (TableTableCellElementBase)aRowEle.getFirstChild();
                        j = coverCellEle.getTableNumberColumnsRepeatedAttribute();
                        while (j < i) {
                            if ((coverCellEle = (TableTableCellElementBase)coverCellEle.getNextSibling()) instanceof TableTableCellElement) {
                                j += coverCellEle.getTableNumberColumnsRepeatedAttribute() * ((TableTableCellElement)coverCellEle).getTableNumberColumnsSpannedAttribute();
                                continue;
                            }
                            j += coverCellEle.getTableNumberColumnsRepeatedAttribute().intValue();
                        }
                        if (coverCellEle instanceof TableTableCellElement) {
                            TableTableCellElement newCellEle = (TableTableCellElement)coverCellEle.cloneNode(true);
                            this.cleanCell(newCellEle);
                            newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned");
                            newRow.appendChild(newCellEle);
                            if (this.mIsSpreadsheet) {
                                int columnsSpannedNumber = newCellEle.getTableNumberColumnsSpannedAttribute();
                                newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
                                int newColumnRepeatedNumber = newCellEle.getTableNumberColumnsRepeatedAttribute() * columnsSpannedNumber;
                                if (newColumnRepeatedNumber > 1) {
                                    newCellEle.setTableNumberColumnsRepeatedAttribute(newColumnRepeatedNumber);
                                }
                                int tempi = newColumnRepeatedNumber;
                                while (tempi > 0) {
                                    int iColumnRepeatedNumber = cellElement.getTableNumberColumnsRepeatedAttribute();
                                    if (iColumnRepeatedNumber > tempi && cellElement instanceof TableCoveredTableCellElement) {
                                        cellElement.setTableNumberColumnsRepeatedAttribute(iColumnRepeatedNumber - tempi);
                                        TableTableCellElementBase newCoveredCellEle2 = (TableTableCellElementBase)cellElement.cloneNode(true);
                                        this.cleanCell(newCoveredCellEle2);
                                        newCoveredCellEle2.setTableNumberColumnsRepeatedAttribute(tempi);
                                        refRowElement.insertBefore(newCoveredCellEle2, cellElement);
                                        cellElement = newCoveredCellEle2;
                                    }
                                    i += cellElement.getTableNumberColumnsRepeatedAttribute().intValue();
                                    if (!(cellElement instanceof TableCoveredTableCellElement) && (tempi -= cellElement.getTableNumberColumnsRepeatedAttribute().intValue()) > 0) {
                                        Logger.getLogger(Table.class.getName()).log(Level.INFO, "Not covered cell was ignored");
                                    }
                                    cellElement = (TableTableCellElementBase)cellElement.getNextSibling();
                                }
                                continue block0;
                            }
                            cellElement = (TableTableCellElementBase)cellElement.getNextSibling();
                            i += cellElement.getTableNumberColumnsRepeatedAttribute().intValue();
                            for (int newColumnSpanNumber = newCellEle.getTableNumberColumnsSpannedAttribute().intValue(); cellElement != null && cellElement instanceof TableCoveredTableCellElement && newColumnSpanNumber > 1; cellElement = (TableTableCellElementBase)cellElement.getNextSibling(), --newColumnSpanNumber) {
                                TableCoveredTableCellElement newCoveredCellElement = (TableCoveredTableCellElement)cellElement.cloneNode(true);
                                this.cleanCell(newCoveredCellElement);
                                newRow.appendChild(newCoveredCellElement);
                                i += cellElement.getTableNumberColumnsRepeatedAttribute().intValue();
                            }
                            continue block0;
                        }
                        Node preNode = aRowEle.getPreviousSibling();
                        if (preNode instanceof TableTableRowElement) {
                            aRowEle = (TableTableRowElement)preNode;
                            continue;
                        }
                        aRowEle = (TableTableRowElement)preNode.getLastChild();
                    }
                    continue;
                }
                TableTableCellElement newCellEle = (TableTableCellElement)cellElement.cloneNode(true);
                this.cleanCell(newCellEle);
                newRow.appendChild(newCellEle);
                Integer tableNumberColumnsRepeated = newCellEle.getTableNumberColumnsRepeatedAttribute();
                Integer tableNumberColumnsSpanned = newCellEle.getTableNumberColumnsSpannedAttribute();
                i += tableNumberColumnsRepeated * tableNumberColumnsSpanned;
                cellElement = (TableTableCellElementBase)cellElement.getNextSibling();
                if (tableNumberColumnsSpanned <= 1) continue;
                if (this.mIsSpreadsheet) {
                    newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
                    int newColumnRepeatedNumber = tableNumberColumnsRepeated * tableNumberColumnsSpanned;
                    if (newColumnRepeatedNumber > 1) {
                        newCellEle.setTableNumberColumnsRepeatedAttribute(newColumnRepeatedNumber);
                    }
                    int tempi = newColumnRepeatedNumber;
                    while (tempi > 1) {
                        int iColumnRepeatedNumber = cellElement.getTableNumberColumnsRepeatedAttribute();
                        if (iColumnRepeatedNumber > tempi + 1 && cellElement instanceof TableCoveredTableCellElement) {
                            cellElement.setTableNumberColumnsRepeatedAttribute(iColumnRepeatedNumber - tempi + 1);
                            TableTableCellElementBase newCoveredCellEle3 = (TableTableCellElementBase)cellElement.cloneNode(true);
                            this.cleanCell(newCoveredCellEle3);
                            newCoveredCellEle3.setTableNumberColumnsRepeatedAttribute(tempi - 1);
                            refRowElement.insertBefore(newCoveredCellEle3, cellElement);
                            cellElement = newCoveredCellEle3;
                        }
                        if (!(cellElement instanceof TableCoveredTableCellElement) && (tempi -= cellElement.getTableNumberColumnsRepeatedAttribute().intValue()) > 1) {
                            Logger.getLogger(Table.class.getName()).log(Level.INFO, "Not covered cell was ignored");
                        }
                        cellElement = (TableTableCellElementBase)cellElement.getNextSibling();
                    }
                    continue;
                }
                for (j = 1; j < tableNumberColumnsSpanned && cellElement != null; j += newCoveredCellEle.getTableNumberColumnsRepeatedAttribute().intValue(), cellElement = (TableTableCellElementBase)cellElement.getNextSibling()) {
                    int iColumnRepeatedNumber = cellElement.getTableNumberColumnsRepeatedAttribute();
                    if (iColumnRepeatedNumber > tableNumberColumnsSpanned - j && cellElement instanceof TableCoveredTableCellElement) {
                        cellElement.setTableNumberColumnsRepeatedAttribute(iColumnRepeatedNumber - tableNumberColumnsSpanned + j);
                        newCoveredCellEle = (TableTableCellElementBase)cellElement.cloneNode(true);
                        this.cleanCell(newCoveredCellEle);
                        newCoveredCellEle.setTableNumberColumnsRepeatedAttribute(tableNumberColumnsSpanned - j);
                        refRowElement.insertBefore(newCoveredCellEle, cellElement);
                        cellElement = newCoveredCellEle;
                    }
                    newCoveredCellEle = (TableTableCellElementBase)cellElement.cloneNode(true);
                    this.cleanCell(newCoveredCellEle);
                    newRow.appendChild(newCoveredCellEle);
                }
            }
            if (positionNode == null) {
                this.mTableElement.appendChild(newRow);
            } else {
                this.mTableElement.insertBefore(newRow, positionNode);
            }
        }
        return this.getRowInstance(newRow, 0);
    }

    public List<Row> appendRows(int rowCount) {
        return this.appendRows(rowCount, false);
    }

    List<Row> appendRows(int rowCount, boolean isCleanStyle) {
        ArrayList<Row> resultList = new ArrayList<Row>();
        if (rowCount <= 0) {
            return resultList;
        }
        for (int i = 0; i < rowCount; ++i) {
            Row firstRow = this.appendRow();
            resultList.add(firstRow);
        }
        if (isCleanStyle) {
            for (Row row : resultList) {
                for (Node cellE = row.getOdfElement().getFirstChild(); cellE != null; cellE = cellE.getNextSibling()) {
                    ((TableTableCellElementBase)cellE).removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
                }
            }
        }
        return resultList;
    }

    public Column appendColumn() {
        TableTableColumnElement newColumn;
        Row row1;
        List<Column> columnList = this.getColumnList();
        int columnCount = columnList.size();
        OdfElement positonElement = this.getRowElementByIndex(0);
        if (positonElement.getParentNode() instanceof TableTableHeaderRowsElement) {
            positonElement = (OdfElement)positonElement.getParentNode();
        }
        List<Row> rowList = this.getRowList();
        for (int i = 0; i < rowList.size(); i += row1.getRowsRepeatedNumber()) {
            row1 = rowList.get(i);
            row1.insertCellBefore(row1.getCellByIndex(columnCount - 1), null);
        }
        if (columnList.size() == 0) {
            OdfStyle columnStyle = this.mTableElement.getAutomaticStyles().newStyle(OdfStyleFamily.TableColumn);
            String columnStylename = columnStyle.getStyleNameAttribute();
            columnStyle.setProperty(StyleTableColumnPropertiesElement.ColumnWidth, "6.0in");
            columnStyle.setProperty(StyleTableColumnPropertiesElement.RelColumnWidth, "65535*");
            newColumn = (TableTableColumnElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.mTableElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "table-column"));
            newColumn.setStyleName(columnStylename);
            this.mTableElement.insertBefore(newColumn, positonElement);
        } else {
            TableTableColumnElement refColumn = columnList.get(columnList.size() - 1).getOdfElement();
            newColumn = (TableTableColumnElement)refColumn.cloneNode(true);
            newColumn.setTableNumberColumnsRepeatedAttribute(1);
            this.mTableElement.insertBefore(newColumn, positonElement);
        }
        return this.getColumnInstance(newColumn, 0);
    }

    public List<Column> appendColumns(int columnCount) {
        return this.appendColumns(columnCount, false);
    }

    List<Column> appendColumns(int columnCount, boolean isCleanStyle) {
        ArrayList<Column> resultList = new ArrayList<Column>();
        if (columnCount <= 0) {
            return resultList;
        }
        Column firstClm = this.appendColumn();
        resultList.add(firstClm);
        if (columnCount > 1) {
            List<Column> list = this.insertColumnsBefore(this.getColumnCount() - 1, columnCount - 1);
            resultList.addAll(list);
        }
        if (isCleanStyle) {
            for (Column column : resultList) {
                int length = column.getCellCount();
                for (int i = 0; i < length; ++i) {
                    TableTableCellElementBase cellElement = column.getCellByIndex((int)i).mCellElement;
                    cellElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
                }
            }
        }
        return resultList;
    }

    private List<Row> insertMultipleRowBefore(Row refRow, Row positionRow, int count) {
        Cell refCell;
        ArrayList<Row> resultList = new ArrayList<Row>();
        int j = 1;
        if (count <= 0) {
            return resultList;
        }
        Row firstRow = this.insertRowBefore(refRow, positionRow, this.getColumnCount());
        resultList.add(firstRow);
        if (count == 1) {
            return resultList;
        }
        TableTableRowElement rowEle = firstRow.getOdfElement();
        for (int i = 0; i < this.getColumnCount(); i += refCell.getColumnsRepeatedNumber()) {
            int coveredHeigth;
            refCell = refRow.getCellByIndex(i);
            if (refCell.isCoveredElement() || (coveredHeigth = refCell.getRowSpannedNumber()) <= 1) continue;
            refCell.setRowSpannedNumber(coveredHeigth + 1);
        }
        firstRow.setRowsRepeatedNumber(count);
        while (j < count) {
            resultList.add(this.getRowInstance(rowEle, j));
            ++j;
        }
        return resultList;
    }

    private Row insertRowBefore(Row refRow, Row positionRow, int columnCount) {
        TableTableRowElement aRow = (TableTableRowElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.mTableElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "table-row"));
        int coveredLength = 0;
        int coveredHeigth = 0;
        int i = 0;
        while (i < columnCount) {
            TableTableCellElementBase newCellEle;
            TableTableCellElementBase aCellEle;
            Cell refCell = refRow.getCellByIndex(i);
            if (!refCell.isCoveredElement()) {
                aCellEle = (TableTableCellElement)refCell.getOdfElement();
                coveredHeigth = ((TableTableCellElement)aCellEle).getTableNumberRowsSpannedAttribute();
                if (coveredHeigth == 1) {
                    newCellEle = (TableTableCellElement)aCellEle.cloneNode(true);
                    this.cleanCell(newCellEle);
                    aRow.appendChild(newCellEle);
                } else {
                    ((TableTableCellElement)aCellEle).setTableNumberRowsSpannedAttribute(coveredHeigth + 1);
                    newCellEle = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)this.mTableElement.getOwnerDocument(), OdfName.newName(OdfDocumentNamespace.TABLE, "covered-table-cell"));
                    newCellEle.setTableNumberColumnsRepeatedAttribute(refCell.getColumnsRepeatedNumber());
                    aRow.appendChild(newCellEle);
                }
                coveredLength = ((TableTableCellElement)aCellEle).getTableNumberColumnsSpannedAttribute() - refCell.getColumnsRepeatedNumber();
                i += refCell.getColumnsRepeatedNumber();
                continue;
            }
            aCellEle = (TableCoveredTableCellElement)refCell.getOdfElement();
            if (coveredLength >= 1) {
                newCellEle = (TableCoveredTableCellElement)aCellEle.cloneNode(true);
                aRow.appendChild(newCellEle);
                coveredLength -= newCellEle.getTableNumberColumnsRepeatedAttribute().intValue();
            } else {
                TableTableCellElement coveredCell = (TableTableCellElement)refCell.getCoverCell().getOdfElement();
                TableTableCellElement newCellEle2 = (TableTableCellElement)coveredCell.cloneNode(true);
                this.cleanCell(newCellEle2);
                newCellEle2.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-rows-spanned");
                aRow.appendChild(newCellEle2);
                coveredLength = coveredCell.getTableNumberColumnsSpannedAttribute() - refCell.getColumnsRepeatedNumber();
            }
            i += refCell.getColumnsRepeatedNumber();
        }
        if (positionRow == null) {
            this.mTableElement.appendChild(aRow);
        } else {
            this.mTableElement.insertBefore(aRow, positionRow.getOdfElement());
        }
        return this.getRowInstance(aRow, 0);
    }

    void cleanCell(TableTableCellElementBase newCellEle) {
        String officeNameSpaceURI = OdfDocumentNamespace.OFFICE.getUri();
        String tableNameSpaceURI = OdfDocumentNamespace.TABLE.getUri();
        newCellEle.removeAttributeNS(officeNameSpaceURI, "value");
        newCellEle.removeAttributeNS(officeNameSpaceURI, "date-value");
        newCellEle.removeAttributeNS(officeNameSpaceURI, "time-value");
        newCellEle.removeAttributeNS(officeNameSpaceURI, "boolean-value");
        newCellEle.removeAttributeNS(officeNameSpaceURI, "string-value");
        newCellEle.removeAttributeNS(tableNameSpaceURI, "formula");
        newCellEle.removeAttributeNS(officeNameSpaceURI, "value-type");
        if (!this.isCellStyleInheritance()) {
            newCellEle.removeAttributeNS(tableNameSpaceURI, "style-name");
        }
        Node n = newCellEle.getFirstChild();
        while (n != null) {
            Node m = n.getNextSibling();
            if (n instanceof TextPElement || n instanceof TextHElement || n instanceof TextListElement || n instanceof OfficeAnnotationElement) {
                newCellEle.removeChild(n);
            }
            n = m;
        }
    }

    public TableTableElement getOdfElement() {
        return this.mTableElement;
    }

    Document getOwnerDocument() {
        return this.mDocument;
    }

    public List<Column> insertColumnsBefore(int index, int columnCount) {
        Row row;
        ArrayList<Column> list = new ArrayList<Column>();
        int columncount = this.getColumnCount();
        if (index >= columncount) {
            throw new IndexOutOfBoundsException();
        }
        if (index == 0) {
            Column refColumn;
            int iRowCount = this.getRowCount();
            for (int i = 0; i < iRowCount; ++i) {
                Row row2 = this.getRowByIndex(i);
                row2.insertCellByIndex(index, columnCount);
            }
            Column positionCol = refColumn = this.getColumnByIndex(index);
            TableTableColumnElement newColumnEle = (TableTableColumnElement)refColumn.getOdfElement().cloneNode(true);
            newColumnEle.setTableNumberColumnsRepeatedAttribute(new Integer(columnCount));
            this.mTableElement.insertBefore(newColumnEle, positionCol.getOdfElement());
            for (int i = 0; i < columnCount; ++i) {
                list.add(this.getColumnInstance(newColumnEle, i));
            }
            return list;
        }
        int iRowCount = this.getRowCount();
        for (int i = iRowCount - 1; i >= 0; i -= row.getRowsRepeatedNumber()) {
            row = this.getRowByIndex(i);
            Cell refCell = row.getCellByIndex(index - 1);
            Cell positionCell = null;
            positionCell = row.getCellByIndex(index);
            row.insertCellBefore(refCell, positionCell, columnCount);
        }
        Column refColumn = this.getColumnByIndex(index - 1);
        Column positionCol = this.getColumnByIndex(index);
        if (refColumn.getOdfElement() == positionCol.getOdfElement()) {
            int i;
            TableTableColumnElement column = refColumn.getOdfElement();
            int repeatedCount = column.getTableNumberColumnsRepeatedAttribute();
            column.setTableNumberColumnsRepeatedAttribute(repeatedCount + columnCount);
            TableTableColumnElement columnEle = positionCol.getOdfElement();
            Column startCol = this.getColumnInstance(positionCol.getOdfElement(), 0);
            for (i = repeatedCount + columnCount - 1; i >= columnCount + (index - startCol.getColumnIndex()); --i) {
                this.updateColumnRepository(columnEle, i - columnCount, columnEle, i);
            }
            for (i = 0; i < columnCount; ++i) {
                list.add(this.getColumnInstance(column, refColumn.mnRepeatedIndex + 1 + i));
            }
        } else {
            TableTableColumnElement newColumnEle = (TableTableColumnElement)refColumn.getOdfElement().cloneNode(true);
            newColumnEle.setTableNumberColumnsRepeatedAttribute(new Integer(columnCount));
            this.mTableElement.insertBefore(newColumnEle, positionCol.getOdfElement());
            for (int i = 0; i < columnCount; ++i) {
                list.add(this.getColumnInstance(newColumnEle, i));
            }
        }
        return list;
    }

    public void removeColumnsByIndex(int startIndex, int deleteColCount) {
        if (deleteColCount <= 0) {
            return;
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex of the deleted columns should not be negative");
        }
        int colCount = this.getColumnCount();
        if (startIndex >= colCount) {
            throw new IndexOutOfBoundsException("Start column index is out of bound");
        }
        if (startIndex + deleteColCount >= colCount) {
            deleteColCount = colCount - startIndex;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            Row aRow = this.getRowByIndex(i);
            aRow.removeCellByIndex(startIndex, deleteColCount);
        }
        for (int i = 0; i < deleteColCount; ++i) {
            Column firstColumn = this.getColumnByIndex(startIndex);
            int repeatedAttr = firstColumn.getColumnsRepeatedNumber();
            if (repeatedAttr == 1) {
                TableTableColumnElement columnEle = OdfElement.findNextChildNode(TableTableColumnElement.class, firstColumn.getOdfElement());
                this.mTableElement.removeChild(firstColumn.getOdfElement());
                if (i >= deleteColCount - 1) continue;
                firstColumn = this.getColumnInstance(columnEle, 0);
                continue;
            }
            if (repeatedAttr <= firstColumn.mnRepeatedIndex) continue;
            firstColumn.setColumnsRepeatedNumber(repeatedAttr - 1);
            Column startCol = this.getColumnInstance(firstColumn.getOdfElement(), 0);
            this.updateColumnRepository(firstColumn.getOdfElement(), startIndex - startCol.getColumnIndex(), null, 0);
        }
    }

    private void reviseStyleFromTopRowToMediumRow(Row oldTopRow) {
        if (this.mIsSpreadsheet) {
            return;
        }
        int length = this.getColumnCount();
        int i = 0;
        while (i < length) {
            Cell cell = oldTopRow.getCellByIndex(i);
            if (cell.isCoveredElement()) {
                i += cell.getColumnsRepeatedNumber();
                continue;
            }
            OdfStyle styleEle = cell.getStyleHandler().getCellStyleElementForWrite();
            if (i < length - 1) {
                Table.setLeftBottomBorderStylesProperties(styleEle);
            } else {
                Table.setRightBottomBorderStylesProperties(styleEle);
            }
            i += cell.getColumnsRepeatedNumber();
        }
    }

    private void reviseStyleFromMediumRowToTopRow(Row newTopRow) {
        if (this.mIsSpreadsheet) {
            return;
        }
        int length = this.getColumnCount();
        int i = 0;
        while (i < length) {
            Cell cell = newTopRow.getCellByIndex(i);
            if (cell.isCoveredElement()) {
                i += cell.getColumnsRepeatedNumber();
                continue;
            }
            OdfStyle styleEle = cell.getStyleHandler().getCellStyleElementForWrite();
            if (i < length - 1) {
                Table.setLeftTopBorderStyleProperties(styleEle);
            } else {
                Table.setRightTopBorderStyleProperties(styleEle);
            }
            i += cell.getColumnsRepeatedNumber();
        }
    }

    public List<Row> insertRowsBefore(int index, int rowCount) {
        if (index >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<Row> list = new ArrayList<Row>();
        if (index == 0) {
            Row refRow;
            Row positionRow = refRow = this.getRowByIndex(index);
            Row newFirstRow = this.insertRowBefore(refRow, positionRow, this.getColumnCount());
            this.reviseStyleFromTopRowToMediumRow(refRow);
            list.add(newFirstRow);
            List<Row> rowList = this.insertMultipleRowBefore(refRow, refRow, rowCount - 1);
            for (int i = 0; i < rowList.size(); ++i) {
                list.add(rowList.get(i));
            }
            return list;
        }
        Row refRow = this.getRowByIndex(index - 1);
        Row positionRow = this.getRowByIndex(index);
        if (refRow.getOdfElement() == positionRow.getOdfElement()) {
            int i;
            TableTableRowElement row = refRow.getOdfElement();
            int repeatedCount = refRow.getRowsRepeatedNumber();
            refRow.setRowsRepeatedNumber(repeatedCount + rowCount);
            TableTableRowElement rowEle = positionRow.getOdfElement();
            Row startRow = this.getRowInstance(positionRow.getOdfElement(), 0);
            for (i = repeatedCount + rowCount - 1; i >= rowCount + (index - startRow.getRowIndex()); --i) {
                this.updateRowRepository(rowEle, i - rowCount, rowEle, i);
            }
            for (i = 0; i < rowCount; ++i) {
                list.add(this.getRowInstance(row, refRow.mnRepeatedIndex + 1 + i));
            }
        } else {
            List<Row> newRowList = this.insertMultipleRowBefore(refRow, positionRow, rowCount);
            if (index - 1 == 0) {
                this.reviseStyleFromTopRowToMediumRow(newRowList.get(0));
            }
            for (int i = 0; i < newRowList.size(); ++i) {
                list.add(newRowList.get(i));
            }
        }
        return list;
    }

    public List<Column> getColumnList() {
        ArrayList<Column> list = new ArrayList<Column>();
        TableTableColumnElement colEle = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderColumnsElement) {
                TableTableHeaderColumnsElement headers = (TableTableHeaderColumnsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (!(m instanceof TableTableColumnElement)) continue;
                    colEle = (TableTableColumnElement)m;
                    int columnsRepeatedNumber = colEle.getTableNumberColumnsRepeatedAttribute();
                    for (int i = 0; i < columnsRepeatedNumber; ++i) {
                        list.add(this.getColumnInstance(colEle, i));
                    }
                }
            }
            if (!(n instanceof TableTableColumnElement)) continue;
            colEle = (TableTableColumnElement)n;
            int columnsRepeatedNumber = colEle.getTableNumberColumnsRepeatedAttribute();
            for (int i = 0; i < columnsRepeatedNumber; ++i) {
                list.add(this.getColumnInstance(colEle, i));
            }
        }
        return list;
    }

    public List<Row> getRowList() {
        ArrayList<Row> list = new ArrayList<Row>();
        TableTableRowElement rowEle = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                TableTableHeaderRowsElement headers = (TableTableHeaderRowsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (!(m instanceof TableTableRowElement)) continue;
                    rowEle = (TableTableRowElement)m;
                    for (int i = 0; i < rowEle.getTableNumberRowsRepeatedAttribute(); ++i) {
                        list.add(this.getRowInstance(rowEle, i));
                    }
                }
            }
            if (!(n instanceof TableTableRowElement)) continue;
            rowEle = (TableTableRowElement)n;
            for (int i = 0; i < rowEle.getTableNumberRowsRepeatedAttribute(); ++i) {
                list.add(this.getRowInstance(rowEle, i));
            }
        }
        return list;
    }

    public Column getColumnByIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index should be nonnegative integer.");
        }
        int lastIndex = this.getColumnCount() - 1;
        if (index > lastIndex) {
            this.appendColumns(index - lastIndex);
        }
        int result = 0;
        Column col = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderColumnsElement) {
                col = this.getHeaderColumnByIndex((TableTableHeaderColumnsElement)n, index);
                if (col != null) {
                    return col;
                }
                result += this.getHeaderColumnCount((TableTableHeaderColumnsElement)n);
            }
            if (n instanceof TableTableColumnElement) {
                col = this.getColumnInstance((TableTableColumnElement)n, 0);
                result += col.getColumnsRepeatedNumber();
            }
            if (result <= index || col == null) continue;
            return this.getColumnInstance(col.getOdfElement(), index - (result - col.getColumnsRepeatedNumber()));
        }
        return null;
    }

    private Row getHeaderRowByIndex(TableTableHeaderRowsElement headers, int nIndex) {
        int result = 0;
        Row row = null;
        for (Node n : new DomNodeList(headers.getChildNodes())) {
            if (n instanceof TableTableRowElement) {
                row = this.getRowInstance((TableTableRowElement)n, 0);
                result += row.getRowsRepeatedNumber();
            }
            if (result <= nIndex || row == null) continue;
            return this.getRowInstance(row.getOdfElement(), nIndex - (result - row.getRowsRepeatedNumber()));
        }
        return null;
    }

    private Column getHeaderColumnByIndex(TableTableHeaderColumnsElement headers, int nIndex) {
        int result = 0;
        Column col = null;
        for (Node n : new DomNodeList(headers.getChildNodes())) {
            if (n instanceof TableTableColumnElement) {
                col = this.getColumnInstance((TableTableColumnElement)n, 0);
                result += col.getColumnsRepeatedNumber();
            }
            if (result <= nIndex) continue;
            return this.getColumnInstance(col.getOdfElement(), nIndex - (result - col.getColumnsRepeatedNumber()));
        }
        return null;
    }

    public Row getRowByIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index should be nonnegative integer.");
        }
        int lastIndex = this.getRowCount() - 1;
        if (index > lastIndex) {
            this.appendRows(index - lastIndex);
        }
        int result = 0;
        Row row = null;
        for (Node n : new DomNodeList(this.mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                row = this.getHeaderRowByIndex((TableTableHeaderRowsElement)n, index);
                if (row != null) {
                    return row;
                }
                result += this.getHeaderRowCount((TableTableHeaderRowsElement)n);
            }
            if (n instanceof TableTableRowElement) {
                row = this.getRowInstance((TableTableRowElement)n, 0);
                result += row.getRowsRepeatedNumber();
            }
            if (n instanceof TableTableRowsElement) {
                for (Node nn : new DomNodeList(n.getChildNodes())) {
                    if (!(nn instanceof TableTableRowElement) || (result += (row = this.getRowInstance((TableTableRowElement)nn, 0)).getRowsRepeatedNumber()) <= index) continue;
                    return this.getRowInstance(row.getOdfElement(), index - (result - row.getRowsRepeatedNumber()));
                }
            }
            if (result <= index) continue;
            return this.getRowInstance(row.getOdfElement(), index - (result - row.getRowsRepeatedNumber()));
        }
        return null;
    }

    public void removeRowsByIndex(int startIndex, int deleteRowCount) {
        boolean deleted = false;
        if (deleteRowCount <= 0) {
            return;
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex of the deleted rows should not be negative");
        }
        int rowCount = this.getRowCount();
        if (startIndex >= rowCount) {
            throw new IndexOutOfBoundsException("Start index out of bound");
        }
        if (startIndex + deleteRowCount >= rowCount) {
            deleteRowCount = rowCount - startIndex;
        }
        Row firstRow = this.getRowByIndex(startIndex);
        for (int i = startIndex; i < startIndex + deleteRowCount; ++i) {
            int repeatedAttr = firstRow.getRowsRepeatedNumber();
            if (repeatedAttr == 1) {
                TableTableRowElement rowEle = OdfElement.findNextChildNode(TableTableRowElement.class, firstRow.getOdfElement());
                firstRow.removeAllCellsRelationship();
                firstRow.getOdfElement().getParentNode().removeChild(firstRow.getOdfElement());
                this.updateRowRepository(firstRow.getOdfElement(), firstRow.mnRepeatedIndex, null, 0);
                if (i < startIndex + deleteRowCount - 1) {
                    firstRow = this.getRowInstance(rowEle, 0);
                }
                deleted = true;
                continue;
            }
            if (repeatedAttr <= firstRow.mnRepeatedIndex) continue;
            firstRow.setRowsRepeatedNumber(repeatedAttr - 1);
            Row startRow = this.getRowInstance(firstRow.getOdfElement(), 0);
            this.updateRowRepository(firstRow.getOdfElement(), i - startRow.getRowIndex(), null, 0);
        }
        if (deleted && startIndex == 0) {
            Row aRow = this.getRowByIndex(0);
            this.reviseStyleFromMediumRowToTopRow(aRow);
        }
    }

    public void remove() {
        this.mTableElement.getParentNode().removeChild(this.mTableElement);
    }

    private int getHeaderRowCount(TableTableHeaderRowsElement headers) {
        int result = 0;
        if (headers != null) {
            for (Node n : new DomNodeList(headers.getChildNodes())) {
                if (!(n instanceof TableTableRowElement)) continue;
                result += ((TableTableRowElement)n).getTableNumberRowsRepeatedAttribute().intValue();
            }
        }
        return result;
    }

    public int getHeaderRowCount() {
        TableTableHeaderRowsElement headers = OdfElement.findFirstChildNode(TableTableHeaderRowsElement.class, this.mTableElement);
        return this.getHeaderRowCount(headers);
    }

    private int getHeaderColumnCount(TableTableHeaderColumnsElement headers) {
        int result = 0;
        if (headers != null) {
            for (Node n : new DomNodeList(headers.getChildNodes())) {
                result += ((TableTableColumnElement)n).getTableNumberColumnsRepeatedAttribute().intValue();
            }
        }
        return result;
    }

    public int getHeaderColumnCount() {
        TableTableHeaderColumnsElement headers = OdfElement.findFirstChildNode(TableTableHeaderColumnsElement.class, this.mTableElement);
        return this.getHeaderColumnCount(headers);
    }

    public String getTableName() {
        return this.mTableElement.getTableNameAttribute();
    }

    public void setTableName(String tableName) {
        List<Table> tableList = this.mDocument.getTableList();
        for (int i = 0; i < tableList.size(); ++i) {
            Table table = tableList.get(i);
            if (!tableName.equals(table.getTableName()) || table == this) continue;
            throw new IllegalArgumentException("The table name is duplicate with one of tables in the current document.");
        }
        this.mTableElement.setTableNameAttribute(tableName);
    }

    public boolean isProtected() {
        if (this.mTableElement.getTableProtectedAttribute() != null) {
            return this.mTableElement.getTableProtectedAttribute();
        }
        return false;
    }

    public void setProtected(boolean isProtected) {
        this.mTableElement.setTableProtectedAttribute(isProtected);
    }

    protected boolean isCellStyleInheritance() {
        return this.mIsCellStyleInheritance;
    }

    protected void setCellStyleInheritance(boolean isEnabled) {
        this.mIsCellStyleInheritance = isEnabled;
    }

    public CellRange getCellRangeByPosition(int startCol, int startRow, int endCol, int endRow) {
        this.getCellByPosition(startCol, startRow);
        this.getCellByPosition(endCol, endRow);
        return new CellRange(this, startCol, startRow, endCol, endRow);
    }

    public CellRange getCellRangeByPosition(String startAddress, String endAddress) {
        return this.getCellRangeByPosition(this.getColIndexFromCellAddress(startAddress), this.getRowIndexFromCellAddress(startAddress), this.getColIndexFromCellAddress(endAddress), this.getRowIndexFromCellAddress(endAddress));
    }

    public CellRange getCellRangeByName(String name) {
        try {
            NodeList nameRanges = this.mTableElement.getOwnerDocument().getElementsByTagNameNS(OdfDocumentNamespace.TABLE.getUri(), "named-range");
            for (int i = 0; i < nameRanges.getLength(); ++i) {
                TableNamedRangeElement nameRange = (TableNamedRangeElement)nameRanges.item(i);
                if (!nameRange.getTableNameAttribute().equals(name)) continue;
                String cellRange = nameRange.getTableCellRangeAddressAttribute();
                String[] addresses = cellRange.split(":");
                return this.getCellRangeByPosition(addresses[0], addresses[1]);
            }
        }
        catch (Exception e) {
            Logger.getLogger(Table.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public Cell getCellByPosition(int colIndex, int rowIndex) {
        int lastColumnIndex;
        if (colIndex < 0 || rowIndex < 0) {
            throw new IllegalArgumentException("colIndex and rowIndex should be nonnegative integer.");
        }
        int lastRowIndex = this.getRowCount() - 1;
        if (rowIndex > lastRowIndex) {
            this.appendRows(rowIndex - lastRowIndex, true);
        }
        if (colIndex > (lastColumnIndex = this.getColumnCount() - 1)) {
            this.appendColumns(colIndex - lastColumnIndex, true);
        }
        Row row = this.getRowByIndex(rowIndex);
        return row.getCellByIndex(colIndex);
    }

    String[] splitCellAddress(String cellAddress) {
        StringTokenizer stDollar;
        String[] returnArray = new String[3];
        StringTokenizer stDot = new StringTokenizer(cellAddress, ".");
        String cell = "";
        if (stDot.countTokens() >= 2) {
            stDollar = new StringTokenizer(stDot.nextToken(), "$");
            returnArray[0] = stDollar.nextToken();
            cell = stDot.nextToken();
        } else {
            returnArray[0] = this.getTableName();
            cell = stDot.nextToken();
        }
        stDollar = new StringTokenizer(cell, "$");
        if (stDollar.countTokens() >= 2) {
            returnArray[1] = stDollar.nextToken();
            returnArray[2] = stDollar.nextToken();
        } else {
            cell = stDollar.nextToken();
            for (int i = 0; i < cell.length(); ++i) {
                if (Character.isLetter(cell.charAt(i))) continue;
                returnArray[1] = cell.substring(0, i);
                returnArray[2] = cell.substring(i);
                break;
            }
        }
        return returnArray;
    }

    public Cell getCellByPosition(String address) {
        return this.getCellByPosition(this.getColIndexFromCellAddress(address), this.getRowIndexFromCellAddress(address));
    }

    int getColIndexFromCellAddress(String cellAddress) {
        String[] returnArray = this.splitCellAddress(cellAddress);
        String colNum = returnArray[1];
        int colIndex = 0;
        for (int i = 0; i < colNum.length(); ++i) {
            colIndex = 26 * colIndex;
            colIndex += colNum.charAt(i) - 65 + 1;
        }
        return colIndex - 1;
    }

    int getRowIndexFromCellAddress(String cellAddress) {
        String[] returnArray = this.splitCellAddress(cellAddress);
        return Integer.parseInt(returnArray[2]) - 1;
    }

    String getAbsoluteCellAddress(int colIndex, int rowIndex) {
        int remainder = 0;
        int multiple = colIndex;
        String cellRange = "";
        while (multiple != 0) {
            multiple = colIndex / 26;
            remainder = colIndex % 26;
            char c = multiple == 0 ? (char)(65 + remainder) : (char)(65 + multiple - 1);
            cellRange = cellRange + String.valueOf(c);
            colIndex = remainder;
        }
        cellRange = "$" + cellRange + "$" + (rowIndex + 1);
        return cellRange;
    }

    Cell getOwnerCellByPosition(List<CellCoverInfo> coverList, int nCol, int nRow) {
        if (!this.isCoveredCellInOwnerTable(coverList, nCol, nRow)) {
            Cell cell = this.getCellByPosition(nCol, nRow);
            return cell;
        }
        for (int m = 0; m < coverList.size(); ++m) {
            CellCoverInfo info = coverList.get(m);
            if (!(nCol > info.nStartCol && nCol <= info.nEndCol && nRow == info.nStartRow && nRow == info.nEndRow || nCol == info.nStartCol && nCol == info.nEndCol && nRow > info.nStartRow && nRow <= info.nEndRow) && (nCol <= info.nStartCol || nCol > info.nEndCol || nRow <= info.nStartRow || nRow > info.nEndRow)) continue;
            Cell cell = this.getCellByPosition(info.nStartCol, info.nStartRow);
            return cell;
        }
        return null;
    }

    boolean isCoveredCellInOwnerTable(List<CellCoverInfo> coverList, int nCol, int nRow) {
        for (int m = 0; m < coverList.size(); ++m) {
            CellCoverInfo info = coverList.get(m);
            if (!(nCol > info.nStartCol && nCol <= info.nEndCol && nRow == info.nStartRow && nRow == info.nEndRow || nCol == info.nStartCol && nCol == info.nEndCol && nRow > info.nStartRow && nRow <= info.nEndRow) && (nCol <= info.nStartCol || nCol > info.nEndCol || nRow <= info.nStartRow || nRow > info.nEndRow)) continue;
            return true;
        }
        return false;
    }

    List<CellCoverInfo> getCellCoverInfos(int nStartCol, int nStartRow, int nEndCol, int nEndRow) {
        ArrayList<CellCoverInfo> coverList = new ArrayList<CellCoverInfo>();
        for (int i = nStartCol; i < nEndCol + 1; ++i) {
            for (int j = nStartRow; j < nEndRow + 1; ++j) {
                Cell cell = this.getCellByPosition(i, j);
                if (cell == null) continue;
                int nColSpan = cell.getColumnSpannedNumber();
                int nRowSpan = cell.getRowSpannedNumber();
                if (nColSpan <= 1 && nRowSpan <= 1) continue;
                coverList.add(new CellCoverInfo(i, j, nColSpan, nRowSpan));
            }
        }
        return coverList;
    }

    void updateColumnRepository(TableTableColumnElement oldElement, int oldRepeatIndex, TableTableColumnElement newElement, int newRepeatIndex) {
        Vector<Column> oldList;
        if (this.mColumnRepository.containsKey(oldElement) && oldRepeatIndex < (oldList = this.mColumnRepository.get(oldElement)).size()) {
            if (oldElement != newElement) {
                Column oldColumn = oldList.get(oldRepeatIndex);
                if (oldColumn != null) {
                    for (int i = oldRepeatIndex + 1; i < oldList.size(); ++i) {
                        Column column = oldList.get(i);
                        if (column == null) continue;
                        column.mnRepeatedIndex = i - 1;
                    }
                    oldList.remove(oldColumn);
                    if (newElement != null) {
                        oldColumn.maColumnElement = newElement;
                        oldColumn.mnRepeatedIndex = newRepeatIndex;
                        int size = newRepeatIndex > 7 ? newRepeatIndex + 1 : 8;
                        Vector<Column> list = new Vector<Column>(size);
                        list.setSize(newRepeatIndex + 1);
                        list.set(newRepeatIndex, oldColumn);
                        this.mColumnRepository.put(newElement, list);
                    } else {
                        oldColumn.maColumnElement = null;
                    }
                }
            } else {
                Column oldColumn = oldList.get(oldRepeatIndex);
                if (oldColumn != null) {
                    oldList.remove(oldColumn);
                    oldList.add(oldRepeatIndex, null);
                    oldColumn.mnRepeatedIndex = newRepeatIndex;
                    if (newRepeatIndex >= oldList.size()) {
                        oldList.setSize(newRepeatIndex + 1);
                    }
                    oldList.set(newRepeatIndex, oldColumn);
                } else {
                    this.getColumnInstance(newElement, newRepeatIndex);
                }
            }
        }
    }

    void updateRowRepository(TableTableRowElement oldElement, int oldRepeatIndex, TableTableRowElement newElement, int newRepeatIndex) {
        Vector<Row> oldList;
        if (this.mRowRepository.containsKey(oldElement) && oldRepeatIndex < (oldList = this.mRowRepository.get(oldElement)).size()) {
            if (oldElement != newElement) {
                Row oldRow = oldList.get(oldRepeatIndex);
                Vector<Cell> updateCellList = new Vector<Cell>();
                if (oldRow != null) {
                    for (int i = oldRepeatIndex + 1; i < oldList.size(); ++i) {
                        Row row = oldList.get(i);
                        if (row == null) continue;
                        int colNum = this.getColumnCount();
                        for (int j = 0; j < colNum; ++j) {
                            Cell cell = row.getCellByIndex(j);
                            updateCellList.add(cell);
                        }
                        row.mnRepeatedIndex = i - 1;
                    }
                    oldList.remove(oldRow);
                    if (newElement != null) {
                        int j;
                        int colNum = this.getColumnCount();
                        Cell[] oldCells = new Cell[colNum];
                        for (int j2 = 0; j2 < colNum; ++j2) {
                            oldCells[j2] = oldRow.getCellByIndex(j2);
                        }
                        oldRow.maRowElement = newElement;
                        oldRow.mnRepeatedIndex = newRepeatIndex;
                        int size = newRepeatIndex > 7 ? newRepeatIndex + 1 : 8;
                        Vector<Row> list = new Vector<Row>(size);
                        list.setSize(newRepeatIndex + 1);
                        list.set(newRepeatIndex, oldRow);
                        this.mRowRepository.put(newElement, list);
                        Cell[] newCells = new Cell[colNum];
                        for (j = 0; j < colNum; ++j) {
                            newCells[j] = oldRow.getCellByIndex(j);
                        }
                        for (j = 0; j < colNum; ++j) {
                            this.updateCellRepository(oldCells[j].getOdfElement(), oldCells[j].mnRepeatedColIndex, oldCells[j].mnRepeatedRowIndex, newCells[j].getOdfElement(), newCells[j].mnRepeatedColIndex, newCells[j].mnRepeatedRowIndex);
                        }
                        for (j = 0; j < updateCellList.size(); ++j) {
                            Cell cell = (Cell)updateCellList.get(j);
                            if (cell.mnRepeatedRowIndex <= oldRepeatIndex) continue;
                            --cell.mnRepeatedRowIndex;
                        }
                    } else {
                        oldRow.maRowElement = null;
                    }
                }
            } else {
                Row oldRow = oldList.get(oldRepeatIndex);
                if (oldRow != null) {
                    oldList.remove(oldRow);
                    oldList.add(oldRepeatIndex, null);
                    oldRow.mnRepeatedIndex = newRepeatIndex;
                    if (newRepeatIndex >= oldList.size()) {
                        oldList.setSize(newRepeatIndex + 1);
                    }
                    oldList.set(newRepeatIndex, oldRow);
                } else {
                    this.getRowInstance(newElement, newRepeatIndex);
                }
            }
        }
    }

    void updateCellRepository(TableTableCellElementBase oldElement, int oldRepeatColIndex, int oldRepeatRowIndex, TableTableCellElementBase newElement, int newRepeatColIndex, int newRepeatRowIndex) {
        if (this.mCellRepository.containsKey(oldElement)) {
            int i;
            Cell oldCell = null;
            Vector<Cell> oldList = this.mCellRepository.get(oldElement);
            for (i = 0; i < oldList.size(); ++i) {
                if (oldList.get(i).getOdfElement() != oldElement || oldList.get((int)i).mnRepeatedColIndex != oldRepeatColIndex || oldList.get((int)i).mnRepeatedRowIndex != oldRepeatRowIndex) continue;
                oldCell = oldList.get(i);
                break;
            }
            if (oldElement != newElement) {
                if (oldCell != null) {
                    for (i = 0; i < oldList.size(); ++i) {
                        Cell cell = oldList.get(i);
                        if (cell == null || cell.getOdfElement() != oldElement || cell.mnRepeatedRowIndex != oldRepeatRowIndex || cell.mnRepeatedColIndex <= oldRepeatColIndex) continue;
                        --cell.mnRepeatedColIndex;
                    }
                    oldList.remove(oldCell);
                    if (oldList.size() == 0) {
                        this.mCellRepository.remove(oldElement);
                    }
                    if (newElement != null) {
                        oldCell.mCellElement = newElement;
                        oldCell.mnRepeatedColIndex = newRepeatColIndex;
                        oldCell.mnRepeatedRowIndex = newRepeatRowIndex;
                        if (this.mCellRepository.containsKey(newElement)) {
                            Vector<Cell> list = this.mCellRepository.get(newElement);
                            boolean bReplaced = false;
                            for (int i2 = 0; i2 < list.size(); ++i2) {
                                Cell cell = list.get(i2);
                                if (cell == null || cell.getOdfElement() != newElement || cell.mnRepeatedColIndex != newRepeatColIndex || cell.mnRepeatedRowIndex != newRepeatRowIndex) continue;
                                list.remove(i2);
                                list.add(i2, oldCell);
                                bReplaced = true;
                                break;
                            }
                            if (!bReplaced) {
                                list.add(oldCell);
                            }
                        } else {
                            Vector<Cell> list = new Vector<Cell>();
                            list.add(oldCell);
                            this.mCellRepository.put(newElement, list);
                        }
                    } else {
                        oldCell.mCellElement = null;
                        oldCell.mnRepeatedColIndex = 0;
                        oldCell.mnRepeatedRowIndex = 0;
                    }
                }
            } else if (oldCell != null) {
                oldCell.mnRepeatedColIndex = newRepeatColIndex;
                oldCell.mnRepeatedRowIndex = newRepeatRowIndex;
            } else {
                this.getCellInstance(newElement, newRepeatColIndex, newRepeatRowIndex);
            }
        }
    }

    void updateRepositoryWhenCellElementChanged(int startRow, int endRow, int startClm, int endClm, TableTableCellElement newCellEle) {
        for (int i = startRow; i < endRow; ++i) {
            for (int j = startClm; j < endClm; ++j) {
                Cell cell = this.getCellByPosition(j, i);
                this.updateCellRepository(cell.getOdfElement(), cell.mnRepeatedColIndex, cell.mnRepeatedRowIndex, newCellEle, cell.mnRepeatedColIndex, cell.mnRepeatedRowIndex);
            }
        }
    }

    static {
        IN_FORMAT.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
    }

    public static class TableBuilder {
        private final Document ownerDocument;
        private final IdentityHashMap<TableTableElement, Table> mTableRepository = new IdentityHashMap();

        public TableBuilder(Document doc) {
            if (doc.getTableBuilder() != null) {
                throw new IllegalStateException("TableBuilder only can be created in owner Document constructor.");
            }
            this.ownerDocument = doc;
        }

        public synchronized Table getTableInstance(TableTableElement odfElement) {
            if (this.mTableRepository.containsKey(odfElement)) {
                return this.mTableRepository.get(odfElement);
            }
            Table newTable = new Table(this.ownerDocument, odfElement);
            this.mTableRepository.put(odfElement, newTable);
            return newTable;
        }

        public Table newTable() {
            return this.newTable(2, 5, 0, 0);
        }

        public Table newTable(int numRows, int numCols, int headerRowNumber, int headerColumnNumber) {
            try {
                TableTableElement newTEle = Table.createTable(this.ownerDocument, numRows, numCols, headerRowNumber, headerColumnNumber);
                OfficeDocumentContentElement root = this.ownerDocument.getContentDom().getRootElement();
                OfficeBodyElement officeBody = OdfElement.findFirstChildNode(OfficeBodyElement.class, root);
                OdfElement typedContent = OdfElement.findFirstChildNode(OdfElement.class, officeBody);
                typedContent.appendChild(newTEle);
                return this.getTableInstance(newTEle);
            }
            catch (DOMException e) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
            catch (Exception e) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
            return null;
        }

        public Table newTable(int numRows, int numCols) {
            return this.newTable(numRows, numCols, 0, 0);
        }

        public Table newTable(String[] rowLabel, String[] columnLabel, double[][] data) {
            int rowNumber = 2;
            int columnNumber = 5;
            if (data != null) {
                rowNumber = data.length;
                columnNumber = data[0].length;
            }
            int rowHeaders = 0;
            int columnHeaders = 0;
            if (rowLabel != null) {
                rowHeaders = 1;
            }
            if (columnLabel != null) {
                columnHeaders = 1;
            }
            try {
                TableTableElement newTEle = Table.createTable(this.ownerDocument, rowNumber + rowHeaders, columnNumber + columnHeaders, rowHeaders, columnHeaders);
                OfficeDocumentContentElement root = this.ownerDocument.getContentDom().getRootElement();
                OfficeBodyElement officeBody = OdfElement.findFirstChildNode(OfficeBodyElement.class, root);
                OdfElement typedContent = OdfElement.findFirstChildNode(OdfElement.class, officeBody);
                typedContent.appendChild(newTEle);
                Table table = this.getTableInstance(newTEle);
                List<Row> rowList = table.getRowList();
                for (int i = 0; i < rowNumber + rowHeaders; ++i) {
                    Row row = rowList.get(i);
                    for (int j = 0; j < columnNumber + columnHeaders; ++j) {
                        if (i == 0 && j == 0) continue;
                        Cell cell = row.getCellByIndex(j);
                        if (i == 0 && columnLabel != null) {
                            if (j <= columnLabel.length) {
                                cell.setStringValue(columnLabel[j - 1]);
                                continue;
                            }
                            cell.setStringValue("");
                            continue;
                        }
                        if (j == 0 && rowLabel != null) {
                            if (i <= rowLabel.length) {
                                cell.setStringValue(rowLabel[i - 1]);
                                continue;
                            }
                            cell.setStringValue("");
                            continue;
                        }
                        if (data == null || i < rowHeaders || j < columnHeaders) continue;
                        cell.setDoubleValue(data[i - rowHeaders][j - columnHeaders]);
                    }
                }
                return table;
            }
            catch (DOMException e) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
            catch (Exception e) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
            return null;
        }

        public Table newTable(String[] rowLabel, String[] columnLabel, String[][] data) {
            int rowNumber = 2;
            int columnNumber = 5;
            if (data != null) {
                rowNumber = data.length;
                columnNumber = data[0].length;
            }
            int rowHeaders = 0;
            int columnHeaders = 0;
            if (rowLabel != null) {
                rowHeaders = 1;
            }
            if (columnLabel != null) {
                columnHeaders = 1;
            }
            try {
                TableTableElement newTEle = Table.createTable(this.ownerDocument, rowNumber + rowHeaders, columnNumber + columnHeaders, rowHeaders, columnHeaders);
                OfficeDocumentContentElement root = this.ownerDocument.getContentDom().getRootElement();
                OfficeBodyElement officeBody = OdfElement.findFirstChildNode(OfficeBodyElement.class, root);
                OdfElement typedContent = OdfElement.findFirstChildNode(OdfElement.class, officeBody);
                typedContent.appendChild(newTEle);
                Table table = this.getTableInstance(newTEle);
                List<Row> rowList = table.getRowList();
                for (int i = 0; i < rowNumber + rowHeaders; ++i) {
                    Row row = rowList.get(i);
                    for (int j = 0; j < columnNumber + columnHeaders; ++j) {
                        if (i == 0 && j == 0) continue;
                        Cell cell = row.getCellByIndex(j);
                        if (i == 0 && columnLabel != null) {
                            if (j <= columnLabel.length) {
                                cell.setStringValue(columnLabel[j - 1]);
                                continue;
                            }
                            cell.setStringValue("");
                            continue;
                        }
                        if (j == 0 && rowLabel != null) {
                            if (i <= rowLabel.length) {
                                cell.setStringValue(rowLabel[i - 1]);
                                continue;
                            }
                            cell.setStringValue("");
                            continue;
                        }
                        if (data == null || i < rowHeaders || j < columnHeaders) continue;
                        cell.setStringValue(data[i - rowHeaders][j - columnHeaders]);
                    }
                }
                return table;
            }
            catch (DOMException e) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
            catch (Exception e) {
                Logger.getLogger(Table.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            }
            return null;
        }
    }
}

