/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;

public class Section {
    TextSectionElement mSectionElement;
    Document mDocument;

    private Section(Document doc, TextSectionElement element) {
        this.mSectionElement = element;
        this.mDocument = doc;
    }

    public static Section getInstance(TextSectionElement element) {
        return new Section((Document)((OdfFileDom)element.getOwnerDocument()).getDocument(), element);
    }

    public Document getOwnerDocument() {
        return this.mDocument;
    }

    public String getName() {
        return this.mSectionElement.getTextNameAttribute();
    }

    public void setName(String name) {
        this.mSectionElement.setTextNameAttribute(name);
    }

    public void remove() {
        this.mDocument.removeElementLinkedResource(this.mSectionElement);
        this.mSectionElement.getParentNode().removeChild(this.mSectionElement);
    }

    public TextSectionElement getOdfElement() {
        return this.mSectionElement;
    }

    boolean isInHeaderFooter() {
        try {
            if (this.mSectionElement.getOwnerDocument() == this.mDocument.getStylesDom()) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.getLogger(Section.class.getName()).log(Level.SEVERE, "Failed in isInHeaderFooter", e);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Section)) {
            return false;
        }
        Section aSection = (Section)obj;
        if (aSection == this) {
            return true;
        }
        return aSection.getOdfElement().equals(this.mSectionElement);
    }
}

