/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text.list;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelLabelAlignmentElement;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleImageElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.odftoolkit.simple.text.list.ListItem;
import org.w3c.dom.Node;

public class ImageDecorator
implements ListDecorator {
    private static String[] DEFAULT_MARGIN_LEFT_ATTRIBUTES = new String[]{"0.741cm", "1.482cm", "2.223cm", "2.963cm", "3.704cm", "4.445cm", "5.186cm", "5.927cm", "6.668cm", "7.408cm"};
    private static String DEFAULT_IMAGE_WIDTH = "0.54cm";
    private static String DEFAULT_IMAGE_HEIGHT = "0.54cm";
    private static String DEFAULT_NAME = "Simple_Default_Image_List";
    private static final String SLASH = "/";
    private OdfTextListStyle listStyle;
    private OdfStyle paragraphStyle;
    private OdfOfficeAutomaticStyles styles;

    public ImageDecorator(Document doc, URI imageUri) {
        try {
            OdfContentDom contentDocument = doc.getContentDom();
            this.styles = contentDocument.getAutomaticStyles();
            OdfOfficeStyles documentStyles = doc.getDocumentStyles();
            this.listStyle = this.styles.getListStyle(DEFAULT_NAME);
            if (this.listStyle == null) {
                this.listStyle = this.styles.newListStyle();
                String packagePath = null;
                try {
                    packagePath = this.insertImage(doc, imageUri);
                }
                catch (Exception e) {
                    Logger.getLogger(ImageDecorator.class.getName()).log(Level.SEVERE, null, e);
                }
                for (int i = 0; i < 10; ++i) {
                    TextListLevelStyleImageElement listLevelElement = this.listStyle.newTextListLevelStyleImageElement(i + 1);
                    listLevelElement.setXlinkHrefAttribute(packagePath);
                    listLevelElement.setXlinkTypeAttribute("simple");
                    listLevelElement.setXlinkShowAttribute("embed");
                    listLevelElement.setXlinkActuateAttribute("onLoad");
                    StyleListLevelPropertiesElement styleListLevelPropertiesElement = listLevelElement.newStyleListLevelPropertiesElement();
                    styleListLevelPropertiesElement.setTextListLevelPositionAndSpaceModeAttribute("label-alignment");
                    styleListLevelPropertiesElement.setStyleVerticalPosAttribute("middle");
                    styleListLevelPropertiesElement.setStyleVerticalRelAttribute("line");
                    styleListLevelPropertiesElement.setFoWidthAttribute(DEFAULT_IMAGE_WIDTH);
                    styleListLevelPropertiesElement.setFoHeightAttribute(DEFAULT_IMAGE_HEIGHT);
                    StyleListLevelLabelAlignmentElement styleListLevelLabelAlignmentElement = styleListLevelPropertiesElement.newStyleListLevelLabelAlignmentElement("listtab");
                    styleListLevelLabelAlignmentElement.setTextListTabStopPositionAttribute(DEFAULT_MARGIN_LEFT_ATTRIBUTES[i]);
                    styleListLevelLabelAlignmentElement.setFoTextIndentAttribute("-0.741cm");
                    styleListLevelLabelAlignmentElement.setFoMarginLeftAttribute(DEFAULT_MARGIN_LEFT_ATTRIBUTES[i]);
                }
            }
            this.paragraphStyle = this.styles.newStyle(OdfStyleFamily.Paragraph);
            this.getOrCreateStyleByName(documentStyles, this.styles, "Default_20_Text", OdfStyleFamily.Paragraph);
            this.paragraphStyle.setStyleParentStyleNameAttribute("Default_20_Text");
            this.paragraphStyle.setStyleListStyleNameAttribute(this.listStyle.getStyleNameAttribute());
        }
        catch (Exception e) {
            Logger.getLogger(ImageDecorator.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void decorateList(List list) {
        TextListElement listElement = list.getOdfElement();
        listElement.setTextStyleNameAttribute(this.listStyle.getStyleNameAttribute());
    }

    public void decorateListItem(ListItem item) {
        TextListItemElement listItemElement = item.getOdfElement();
        for (Node child = listItemElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof TextPElement)) continue;
            TextPElement pElement = (TextPElement)child;
            pElement.setTextStyleNameAttribute(this.paragraphStyle.getStyleNameAttribute());
        }
    }

    public ListDecorator.ListType getListType() {
        return ListDecorator.ListType.IMAGE;
    }

    private OdfStyle getOrCreateStyleByName(OdfOfficeStyles documentStyles, OdfOfficeAutomaticStyles styles, String styleName, OdfStyleFamily styleFamily) {
        OdfStyle odfStyle = documentStyles.getStyle(styleName, styleFamily);
        if (odfStyle == null) {
            styles.getStyle(styleName, styleFamily);
        }
        if (odfStyle == null) {
            odfStyle = styles.newStyle(styleFamily);
            odfStyle.setStyleNameAttribute(styleName);
            odfStyle.setStyleDisplayNameAttribute(styleName);
        }
        return odfStyle;
    }

    private String insertImage(Document doc, URI imageUri) throws Exception {
        String imageRef = null;
        imageRef = !imageUri.isAbsolute() ? System.getProperty("user.dir") + '/' + imageUri.toString() : imageUri.toString();
        String mediaType = OdfFileEntry.getMediaTypeString(imageRef);
        if (imageRef.contains(SLASH)) {
            imageRef = imageRef.substring(imageRef.lastIndexOf(SLASH) + 1, imageRef.length());
        }
        String packagePath = OdfPackage.OdfFile.IMAGE_DIRECTORY.getPath() + SLASH + imageRef;
        packagePath = doc.getDocumentPath() + packagePath;
        doc.getPackage().insert(imageUri, packagePath, mediaType);
        return packagePath;
    }
}

