/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text.list;

import java.util.Iterator;
import org.apache.xerces.dom.ParentNode;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextNumberElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListItem
implements ListContainer {
    private TextListItemElement listItemElement;
    private ListDecorator paragraphDecorator;
    private ListContainerImpl listContainerImpl = new ListContainerImpl();

    ListItem(TextListItemElement element) {
        this(element, null);
    }

    ListItem(TextListItemElement element, String content) {
        this.listItemElement = element;
        this.setTextContent(content);
    }

    public TextListItemElement getOdfElement() {
        return this.listItemElement;
    }

    public String getTextContent() {
        for (Node child = this.listItemElement.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof TextPElement)) continue;
            return child.getTextContent();
        }
        return null;
    }

    public void setTextContent(String content) {
        if (content != null) {
            Node child = this.listItemElement.getFirstChild();
            Node positionNode = null;
            ParentNode pElement = null;
            while (child != null) {
                if (child instanceof TextNumberElement) {
                    positionNode = child.getNextSibling();
                    child = child.getNextSibling();
                    continue;
                }
                if (child instanceof TextPElement && pElement == null) {
                    pElement = (TextPElement)child;
                    child = child.getNextSibling();
                    continue;
                }
                if (child instanceof TextListElement && positionNode == null) {
                    positionNode = child;
                    child = child.getNextSibling();
                    continue;
                }
                Node tmp = child;
                child = child.getNextSibling();
                this.listItemElement.removeChild(tmp);
            }
            if (pElement == null) {
                if (positionNode == null) {
                    pElement = this.listItemElement.newTextPElement();
                } else {
                    pElement = ((OdfFileDom)this.listItemElement.getOwnerDocument()).newOdfElement(TextPElement.class);
                    this.listItemElement.insertBefore(pElement, positionNode);
                }
            }
            pElement.setTextContent(content);
            if (this.paragraphDecorator != null) {
                this.paragraphDecorator.decorateListItem(this);
            } else {
                String pElementStyleName = null;
                block1: for (Node previousSibling = this.listItemElement.getPreviousSibling(); previousSibling != null; previousSibling = previousSibling.getPreviousSibling()) {
                    if (!(previousSibling instanceof TextListItemElement)) continue;
                    for (Node previousChild = previousSibling.getFirstChild(); previousChild != null; previousChild = previousChild.getNextSibling()) {
                        if (!(previousChild instanceof TextPElement)) continue;
                        TextPElement previousPElement = (TextPElement)previousChild;
                        pElementStyleName = previousPElement.getTextStyleNameAttribute();
                        break block1;
                    }
                    break;
                }
                if (pElementStyleName != null) {
                    ((TextParagraphElementBase)pElement).setTextStyleNameAttribute(pElementStyleName);
                }
            }
        }
    }

    public void remove() {
        Node parentElement = this.listItemElement.getParentNode();
        OdfFileDom ownerDocument = (OdfFileDom)this.listItemElement.getOwnerDocument();
        Document doc = (Document)ownerDocument.getDocument();
        doc.removeElementLinkedResource(this.listItemElement);
        parentElement.removeChild(this.listItemElement);
    }

    public Integer getStartNumber() {
        if (this.getOwnerList().getType() == ListDecorator.ListType.NUMBER) {
            return this.listItemElement.getTextStartValueAttribute();
        }
        return null;
    }

    public void setStartNumber(Integer number) {
        if (number < 0) {
            throw new IllegalArgumentException("start number should be a non-negative integer.");
        }
        if (this.getOwnerList().getType() == ListDecorator.ListType.NUMBER) {
            this.listItemElement.setTextStartValueAttribute(number);
        }
    }

    public String getNumberFormat() {
        Node child;
        String format = null;
        if (this.getOwnerList().getType() == ListDecorator.ListType.NUMBER && (child = this.listItemElement.getFirstChild()) != null && child instanceof TextNumberElement) {
            format = ((TextNumberElement)child).getTextContent();
        }
        return format;
    }

    public void setNumberFormat(String format) {
        if (this.getOwnerList().getType() == ListDecorator.ListType.NUMBER) {
            TextNumberElement textNumberElement = null;
            Node child = this.listItemElement.getFirstChild();
            if (child == null) {
                textNumberElement = this.listItemElement.newTextNumberElement();
            } else if (child instanceof TextNumberElement) {
                textNumberElement = (TextNumberElement)child;
            } else {
                textNumberElement = ((OdfFileDom)this.listItemElement.getOwnerDocument()).newOdfElement(TextNumberElement.class);
                this.listItemElement.insertBefore(textNumberElement, child);
            }
            textNumberElement.setTextContent(format);
        }
    }

    public int getIndex() {
        int i = 0;
        for (Node firstNode = this.listItemElement.getParentNode().getFirstChild(); firstNode != null; firstNode = firstNode.getNextSibling()) {
            if (!(firstNode instanceof TextListItemElement)) continue;
            if (firstNode == this.listItemElement) break;
            ++i;
        }
        return i;
    }

    public List getOwnerList() {
        Node parent = this.listItemElement.getParentNode();
        if (parent instanceof TextListElement) {
            return new List((TextListElement)parent);
        }
        return null;
    }

    public String toString() {
        String textContent;
        StringBuilder strBuilder = new StringBuilder();
        String numberFormat = this.getNumberFormat();
        String splitStr = "";
        if (numberFormat != null) {
            strBuilder.append(numberFormat);
            strBuilder.append(" ");
            splitStr = "\n";
        }
        if ((textContent = this.getTextContent()) != null) {
            strBuilder.append(textContent);
            splitStr = "\n";
        }
        Iterator<List> lists = this.getListIterator();
        while (lists.hasNext()) {
            strBuilder.append(splitStr);
            strBuilder.append(lists.next().toString());
        }
        return strBuilder.toString();
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.listContainerImpl.getListContainerElement();
    }

    @Override
    public List addList() {
        return this.listContainerImpl.addList();
    }

    @Override
    public List addList(ListDecorator decorator) {
        return this.listContainerImpl.addList(decorator);
    }

    @Override
    public void clearList() {
        this.listContainerImpl.clearList();
    }

    @Override
    public Iterator<List> getListIterator() {
        return this.listContainerImpl.getListIterator();
    }

    @Override
    public boolean removeList(List list) {
        return this.listContainerImpl.removeList(list);
    }

    void setParagraphDecorator(ListDecorator decorator) {
        this.paragraphDecorator = decorator;
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            return ListItem.this.listItemElement;
        }
    }
}

