/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarManifest {
    private static final String CURRENT_CLASS_RESOURCE_PATH = "org/odftoolkit/simple/JarManifest.class";
    private static final String MANIFEST_JAR_PATH = "META-INF/MANIFEST.MF";
    private static String SIMPLE_NAME;
    private static String SIMPLE_VERSION;
    private static String SIMPLE_WEBSITE;
    private static String SIMPLE_BUILD_BY;
    private static String SIMPLE_BUILD_DATE;
    private static String SIMPLE_SUPPORTED_ODF_VERSION;

    private static InputStream getManifestAsStream() {
        String versionRef = JarManifest.class.getClassLoader().getResource(CURRENT_CLASS_RESOURCE_PATH).toString();
        String manifestRef = versionRef.substring(0, versionRef.lastIndexOf(CURRENT_CLASS_RESOURCE_PATH)) + MANIFEST_JAR_PATH;
        URL manifestURL = null;
        InputStream in = null;
        try {
            manifestURL = new URL(manifestRef);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            in = manifestURL.openStream();
        }
        catch (IOException ex) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, ex);
        }
        return in;
    }

    private JarManifest() {
    }

    public static void main(String[] args) throws IOException {
        System.out.println(JarManifest.getSimpleTitle() + " (build " + JarManifest.getSimpleBuildDate() + ')' + "\nfrom " + JarManifest.getSimpleWebsite() + " supporting ODF " + JarManifest.getSimpleSupportedOdfVersion());
    }

    public static String getSimpleName() {
        return SIMPLE_NAME;
    }

    public static String getSimpleTitle() {
        return JarManifest.getSimpleName() + ' ' + JarManifest.getSimpleVersion();
    }

    public static String getSimpleVersion() {
        return SIMPLE_VERSION;
    }

    public static String getSimpleWebsite() {
        return SIMPLE_WEBSITE;
    }

    public static String getSimpleBuildResponsible() {
        return SIMPLE_BUILD_BY;
    }

    public static String getSimpleBuildDate() {
        return SIMPLE_BUILD_DATE;
    }

    public static String getSimpleSupportedOdfVersion() {
        return SIMPLE_SUPPORTED_ODF_VERSION;
    }

    static {
        try {
            Manifest manifest = new Manifest(JarManifest.getManifestAsStream());
            Attributes attr = manifest.getEntries().get("SIMPLE");
            SIMPLE_NAME = attr.getValue("SIMPLE-Name");
            SIMPLE_VERSION = attr.getValue("SIMPLE-Version");
            SIMPLE_WEBSITE = attr.getValue("SIMPLE-Website");
            SIMPLE_BUILD_BY = attr.getValue("SIMPLE-Built-By");
            SIMPLE_BUILD_DATE = attr.getValue("SIMPLE-Built-Date");
            SIMPLE_SUPPORTED_ODF_VERSION = attr.getValue("SIMPLE-Supported-Odf-Version");
        }
        catch (Exception e) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, e);
        }
    }
}

