/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.net.URI;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.parser.model.AbsOpenApiSchema;
import org.openapi4j.parser.model.OpenApiSchema;

public abstract class AbsRefOpenApiSchema<M extends OpenApiSchema<M>>
extends AbsOpenApiSchema<M> {
    @JsonProperty(value="$ref")
    private String ref;
    @JsonProperty(value="abs$ref")
    @JsonView(value={AbsOpenApiSchema.Views.Internal.class})
    private String canonicalRef;

    public String getRef() {
        return this.ref;
    }

    public boolean isRef() {
        return this.ref != null;
    }

    protected void setRef(String ref) {
        this.ref = ref;
    }

    protected void setCanonicalRef(String canonicalRef) {
        this.canonicalRef = canonicalRef;
    }

    public String getCanonicalRef() {
        return this.canonicalRef;
    }

    public Reference getReference(OAIContext context) {
        return context.getReferenceRegistry().getRef(this.canonicalRef != null ? this.canonicalRef : this.ref);
    }

    public Reference setReference(OAIContext context, URI uri, String ref) {
        Reference reference = context.getReferenceRegistry().addRef(uri, ref);
        this.setRef(reference.getRef());
        this.setCanonicalRef(reference.getCanonicalRef());
        return reference;
    }

    @Override
    public M copy(OAIContext context, boolean followRefs) {
        if (this.isRef()) {
            if (followRefs) {
                Reference reference = this.getReference(context);
                if (reference != null) {
                    OpenApiSchema copy = (OpenApiSchema)TreeUtil.json.convertValue((Object)reference.getContent(), this.getClass());
                    return copy.copy(context, true);
                }
            } else {
                return this.copyReference(context);
            }
        }
        return this.copyContent(context, followRefs);
    }

    protected abstract M copyReference(OAIContext var1);

    protected abstract M copyContent(OAIContext var1, boolean var2);
}

