/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openapi4j.core.model.OAI;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;

public abstract class ValidatorBase<O extends OAI, T>
implements Validator<O, T> {
    private static final ValidationResult MALFORMED_SPEC = new ValidationResult(ValidationSeverity.ERROR, 100, "Malformed spec around '%s'");
    private static final ValidationResult DUPLICATED_VALUES = new ValidationResult(ValidationSeverity.ERROR, 101, "Duplicated values in '%s'");
    private static final ValidationResult INVALID_PATTERN = new ValidationResult(ValidationSeverity.ERROR, 102, "Pattern '%s' is not valid");
    private static final ValidationResult POSITIVE_STRICT_VALUE = new ValidationResult(ValidationSeverity.ERROR, 103, "Value '%s' must be strictly positive");
    private static final ValidationResult POSITIVE_VALUE = new ValidationResult(ValidationSeverity.ERROR, 104, "Value '%s' must be positive or 0");
    private static final ValidationResult MISSING_REQUIRED_FIELD = new ValidationResult(ValidationSeverity.ERROR, 105, "Required field is missing '%s'");
    private static final ValidationResult PATTERN_NOT_MATCHED = new ValidationResult(ValidationSeverity.ERROR, 106, "String value '%s' does not match required pattern '%s'");
    private static final ValidationResult INVALID_KEY = new ValidationResult(ValidationSeverity.ERROR, 107, "Invalid key '%s' in map '%s'");
    private static final ValidationResult INVALID_URI = new ValidationResult(ValidationSeverity.ERROR, 144, "Invalid (or not absolute) URI '%s'");
    protected static final Pattern EMAIL_REGEX = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");

    protected <V> void validate(ValidationContext<O> context, O api, V value, ValidationResults results, String crumb, Validator<O, V> validator) {
        if (validator != null) {
            if (value == null) {
                results.add(MALFORMED_SPEC, new Object[]{crumb});
            } else {
                context.validate(api, value, validator, results);
            }
        }
    }

    protected <V> void validateField(ValidationContext<O> context, O api, V value, ValidationResults results, boolean required, String crumb, Validator<O, V> validator) {
        results.withCrumb(crumb, () -> {
            if (this.validateRequired(value, results, required, crumb)) {
                this.validate(context, api, value, results, crumb, validator);
            }
        });
    }

    protected <V> void validateList(ValidationContext<O> context, O api, Collection<? extends V> value, ValidationResults results, boolean required, String crumb, Validator<O, V> validator) {
        results.withCrumb(crumb, () -> {
            if (this.validateRequired(value, results, required, crumb)) {
                HashSet set = new HashSet(value);
                if (set.size() != value.size()) {
                    results.add(crumb, DUPLICATED_VALUES, new Object[]{crumb});
                }
                if (validator != null) {
                    for (Object element : value) {
                        this.validate(context, api, element, results, crumb, validator);
                    }
                }
            }
        });
    }

    protected void validatePattern(String pattern, ValidationResults results, boolean required, String crumb) {
        if (this.validateRequired(pattern, results, required, crumb)) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                results.add(crumb, INVALID_PATTERN, new Object[]{pattern});
            }
        }
    }

    protected <V extends Number> void validatePositive(V value, ValidationResults results, boolean required, String crumb) {
        if (this.validateRequired(value, results, required, crumb) && value.doubleValue() <= 0.0) {
            results.add(crumb, POSITIVE_STRICT_VALUE, new Object[]{value});
        }
    }

    protected <V extends Number> void validateNonNegative(V value, ValidationResults results, boolean required, String crumb) {
        if (this.validateRequired(value, results, required, crumb) && value.doubleValue() < 0.0) {
            results.add(crumb, POSITIVE_VALUE, new Object[]{value});
        }
    }

    protected boolean validateRequired(Object value, ValidationResults results, boolean required, String crumb) {
        boolean isPresent;
        boolean bl = isPresent = value != null;
        if (required && !isPresent) {
            results.add(crumb, MISSING_REQUIRED_FIELD, new Object[]{crumb});
            return false;
        }
        return isPresent;
    }

    protected void validateString(String value, ValidationResults results, boolean required, String crumb) {
        this.validateString(value, results, required, (Pattern)null, crumb);
    }

    protected void validateString(String value, ValidationResults results, boolean required, String pattern, String crumb) {
        this.validateString(value, results, required, Pattern.compile(pattern), crumb);
    }

    protected void validateString(String value, ValidationResults results, boolean required, Pattern pattern, String crumb) {
        if (this.validateRequired(value, results, required, crumb) && pattern != null && !pattern.matcher(value).matches()) {
            results.add(crumb, PATTERN_NOT_MATCHED, new Object[]{value, pattern});
        }
    }

    protected <V> void validateMap(ValidationContext<O> context, O api, Map<String, ? extends V> value, ValidationResults results, boolean required, String crumb, Pattern pattern, Validator<O, V> validator) {
        results.withCrumb(crumb, () -> {
            if (this.validateRequired(value, results, required, crumb)) {
                for (Map.Entry entry : value.entrySet()) {
                    results.withCrumb((String)entry.getKey(), () -> {
                        this.checkKey((String)entry.getKey(), pattern, results);
                        this.validate(context, api, entry.getValue(), results, crumb, validator);
                    });
                }
            }
        });
    }

    protected void validateUri(String value, ValidationResults results, boolean required, boolean allowRelative, String crumb) {
        this.validateString(value, results, required, (Pattern)null, crumb);
        if (value != null) {
            try {
                URI uri = new URI(value);
                if (!allowRelative && !uri.isAbsolute()) {
                    results.add(crumb, INVALID_URI, new Object[]{value});
                }
            }
            catch (URISyntaxException e) {
                results.add(crumb, INVALID_URI, new Object[]{value});
            }
        }
    }

    private void checkKey(String key, Pattern pattern, ValidationResults results) {
        if (pattern != null && !pattern.matcher(key).matches()) {
            results.add(INVALID_KEY, new Object[]{key, pattern});
        }
    }
}

