/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Map;
import java.util.Set;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.EncodingProperty;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.EncodingPropertyValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.SchemaValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class MediaTypeValidator
extends Validator3Base<OpenApi3, MediaType> {
    private static final ValidationResult ENCODING_MISMATCH = new ValidationResult(ValidationSeverity.ERROR, 119, "Encoding property '%s' is not a corresponding schema property");
    private static final Validator<OpenApi3, MediaType> INSTANCE = new MediaTypeValidator();

    private MediaTypeValidator() {
    }

    public static Validator<OpenApi3, MediaType> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, MediaType mediaType, ValidationResults results) {
        this.validateMap(context, api, mediaType.getEncodings(), results, false, "encoding", Regexes.NOEXT_NAME_REGEX, EncodingPropertyValidator.instance());
        this.validateMap(context, api, mediaType.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        this.validateField(context, api, mediaType.getSchema(), results, false, "schema", SchemaValidator.instance());
        this.checkEncodingProperties(mediaType, results);
    }

    private void checkEncodingProperties(MediaType mediaType, ValidationResults results) {
        Schema schema = mediaType.getSchema();
        if (schema == null) {
            return;
        }
        Map<String, Schema> schemaProps = schema.getProperties();
        Map<String, EncodingProperty> mediaEncodings = mediaType.getEncodings();
        if (schemaProps != null && mediaEncodings != null) {
            Set<String> propNames = schemaProps.keySet();
            for (String encodingPropertyName : mediaEncodings.keySet()) {
                if (propNames.contains(encodingPropertyName)) continue;
                results.add(encodingPropertyName, ENCODING_MISMATCH, new Object[]{encodingPropertyName});
            }
        }
    }
}

