/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OAuthFlow;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class OAuthFlowValidator
extends Validator3Base<OpenApi3, OAuthFlow> {
    private static final ValidationResult AUTH_URL_NOT_ALLOWED = new ValidationResult(ValidationSeverity.ERROR, 120, "'authorizationUrl' is not allowed when OAuth2 configuration is 'implicit' or 'authorizationCode'.");
    private static final ValidationResult TOKEN_URL_NOT_ALLOWED = new ValidationResult(ValidationSeverity.ERROR, 121, "'tokenUrl' is not allowed when OAuth2 configuration is 'implicit'.");
    private static final Validator<OpenApi3, OAuthFlow> INSTANCE = new OAuthFlowValidator();

    private OAuthFlowValidator() {
    }

    public static Validator<OpenApi3, OAuthFlow> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, OAuthFlow oauthFlow, ValidationResults results) {
        String conf = oauthFlow.getConfiguration();
        if ("implicit".equals(conf) || "authorizationCode".equals(conf)) {
            this.validateUrl(api, oauthFlow.getAuthorizationUrl(), results, true, true, "authorizationUrl");
        } else if (oauthFlow.getAuthorizationUrl() != null) {
            results.add("authorizationUrl", AUTH_URL_NOT_ALLOWED, new Object[0]);
        }
        if ("password".equals(conf) || "clientCredentials".equals(conf) || "authorizationCode".equals(conf)) {
            this.validateUrl(api, oauthFlow.getTokenUrl(), results, true, true, "tokenUrl");
        } else if (oauthFlow.getTokenUrl() != null) {
            results.add("tokenUrl", TOKEN_URL_NOT_ALLOWED, new Object[0]);
        }
        this.validateUrl(api, oauthFlow.getRefreshUrl(), results, false, true, "refreshUrl");
        this.validateMap(context, api, oauthFlow.getScopes(), results, true, "scopes", Regexes.NOEXT_REGEX, null);
        this.validateMap(context, api, oauthFlow.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
    }
}

