/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.geom.AffineTransform;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.AtomSymbolElement;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public class ElementUtility
implements IDrawVisitor {
    private List<IRenderingElement> elements = new ArrayList<IRenderingElement>();
    private AffineTransform transform;
    private RendererModel model;
    private boolean getElementGroups = false;

    public int numberOfElements() {
        return this.elements.size();
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public void visit(IRenderingElement element) {
        if (element instanceof ElementGroup) {
            if (this.getElementGroups) {
                this.elements.add(element);
            }
            ((ElementGroup)element).visitChildren((IRenderingVisitor)this);
        } else if (element instanceof MarkedElement) {
            this.visit(((MarkedElement)element).element());
        } else if (element instanceof Bounds) {
            this.visit(((Bounds)element).root());
        } else {
            this.elements.add(element);
        }
    }

    public List<IRenderingElement> getElements() {
        return this.elements;
    }

    public List<IRenderingElement> getAllSimpleElements(IRenderingElement root) {
        this.elements.clear();
        this.getElementGroups = false;
        root.accept((IRenderingVisitor)this);
        return new ArrayList<IRenderingElement>(this.elements);
    }

    public int[] transformPoint(double x, double y) {
        double[] src = new double[]{x, y};
        double[] dest = new double[2];
        this.transform.transform(src, 0, dest, 0, 1);
        return new int[]{(int)dest[0], (int)dest[1]};
    }

    public void setFontManager(IFontManager fontManager) {
    }

    public void setRendererModel(RendererModel rendererModel) {
        this.model = rendererModel;
    }

    public RendererModel getModel() {
        return this.model;
    }

    public String toString(int[] p) {
        return String.format("(%d, %d)", p[0], p[1]);
    }

    public String toString(double x, double y) {
        return String.format("(%+3.1f, %+3.1f)", x, y);
    }

    public String toString(double x, double y, double r) {
        return String.format("(%+3.1f, %+3.1f, %+3.1f)", x, y, r);
    }

    public String toString(IRenderingElement element) {
        if (element instanceof LineElement) {
            LineElement e = (LineElement)element;
            String p1 = this.toString(e.firstPointX, e.firstPointY);
            String p2 = this.toString(e.secondPointX, e.secondPointY);
            String p1T = this.toString(this.transformPoint(e.firstPointX, e.firstPointY));
            String p2T = this.toString(this.transformPoint(e.secondPointX, e.secondPointY));
            String lineFormat = "Line [%s, %s] -> [%s, %s]\n";
            return String.format(lineFormat, p1, p2, p1T, p2T);
        }
        if (element instanceof OvalElement) {
            OvalElement e = (OvalElement)element;
            double r = e.radius;
            String c = this.toString(e.xCoord, e.yCoord, r);
            String p1 = this.toString(this.transformPoint(e.xCoord - r, e.yCoord - r));
            String p2 = this.toString(this.transformPoint(e.xCoord + r, e.yCoord + r));
            return String.format("Oval [%s] -> [%s, %s]\n", c, p1, p2);
        }
        if (element instanceof AtomSymbolElement) {
            AtomSymbolElement e = (AtomSymbolElement)element;
            return String.format("AtomSymbol [%s]\n", e.text);
        }
        if (element instanceof ElementGroup) {
            return "Element Group\n";
        }
        return "Unknown element\n";
    }

    public void printToStream(IRenderingElement root, PrintStream stream) {
        root.accept((IRenderingVisitor)this);
        for (IRenderingElement element : this.elements) {
            stream.print(this.toString(element));
        }
    }
}

