/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements;

import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;

public class LineElement
implements IRenderingElement {
    public final double firstPointX;
    public final double firstPointY;
    public final double secondPointX;
    public final double secondPointY;
    public final double width;
    public final Color color;

    public LineElement(double firstPointX, double firstPointY, double secondPointX, double secondPointY, double width, Color color) {
        this.firstPointX = firstPointX;
        this.firstPointY = firstPointY;
        this.secondPointX = secondPointX;
        this.secondPointY = secondPointY;
        this.width = width;
        this.color = color;
    }

    public void accept(IRenderingVisitor visitor) {
        visitor.visit((IRenderingElement)this);
    }

    public Area toArea() {
        return this.toArea(true);
    }

    public Area toArea(boolean endCaps) {
        Point2d b = new Point2d(this.firstPointX, this.firstPointY);
        Point2d e = new Point2d(this.secondPointX, this.secondPointY);
        Vector2d v = new Vector2d(e.x - b.x, e.y - b.y);
        Vector2d o = new Vector2d(-v.y, v.x);
        v.normalize();
        v.scale(this.width / 2.0);
        o.normalize();
        o.scale(this.width / 2.0);
        Path2D.Double path = new Path2D.Double(0);
        ((Path2D)path).moveTo(b.x + o.x, b.y + o.y);
        ((Path2D)path).lineTo(e.x + o.x, e.y + o.y);
        if (endCaps) {
            ((Path2D)path).curveTo(e.x + o.x + v.x / 2.0, e.y + o.y + o.y / 2.0, e.x + v.x + o.x / 2.0, e.y + v.y + o.y / 2.0, e.x + v.x, e.y + v.y);
            ((Path2D)path).curveTo(e.x + v.x - o.x / 2.0, e.y + v.y - o.y / 2.0, e.x - o.x + v.x / 2.0, e.y - o.y + v.y / 2.0, e.x - o.x, e.y - o.y);
        } else {
            ((Path2D)path).lineTo(e.x + v.x, e.y + v.y);
            ((Path2D)path).lineTo(e.x - o.x, e.y - o.y);
        }
        ((Path2D)path).lineTo(b.x - o.x, b.y - o.y);
        if (endCaps) {
            ((Path2D)path).curveTo(b.x - o.x - v.x / 2.0, b.y - o.y - v.y / 2.0, b.x - v.x - o.x / 2.0, b.y - v.y - o.y / 2.0, b.x - v.x, b.y - v.y);
            ((Path2D)path).curveTo(b.x - v.x + o.x / 2.0, b.y - v.y + o.y / 2.0, b.x + o.x - v.x / 2.0, b.y + o.y - v.y / 2.0, b.x + o.x, b.y + o.y);
        } else {
            ((Path2D)path).lineTo(b.x - v.x, b.y - v.y);
        }
        path.closePath();
        return new Area(path);
    }

    public static enum LineType {
        SINGLE(1),
        DOUBLE(2),
        TRIPLE(3),
        QUADRUPLE(4);

        final int n;

        private LineType(int n2) {
            this.n = n2;
        }

        public int count() {
            return this.n;
        }
    }
}

