/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import javax.vecmath.Vector2d;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.path.Type;
import org.openscience.cdk.tools.LoggingToolFactory;

final class AwtArea {
    AwtArea() {
    }

    public static Area toArea(IRenderingElement e) {
        if (e instanceof LineElement) {
            return ((LineElement)e).toArea();
        }
        if (e instanceof GeneralPath) {
            return ((GeneralPath)e).toArea();
        }
        if (e instanceof ElementGroup) {
            Area total = null;
            ElementGroup grp = (ElementGroup)e;
            for (IRenderingElement child : grp) {
                Area childArea = AwtArea.toArea(child);
                if (childArea == null) continue;
                if (total == null) {
                    total = childArea;
                    continue;
                }
                total.add(childArea);
            }
            return total;
        }
        if (e == null) {
            return null;
        }
        LoggingToolFactory.createLoggingTool(AwtArea.class).warn((Object)("Unsupported awt.Area of rendering element: " + e.getClass().getSimpleName()));
        return null;
    }

    private static Vector2d newVector(double x, double y, double len) {
        Vector2d v = new Vector2d(x, y);
        v.normalize();
        v.scale(len);
        return v;
    }

    static Area expand(Area area, double width) {
        Path2D.Double path = new Path2D.Double();
        boolean started = false;
        double[] first = new double[2];
        double[] p = new double[2];
        double[] data = new double[6];
        boolean flip = false;
        Type[] types = Type.values();
        PathIterator it = area.getPathIterator(new AffineTransform());
        while (!it.isDone()) {
            Type type = types[it.currentSegment(data)];
            switch (type) {
                case MoveTo: {
                    p[0] = data[0];
                    p[1] = data[1];
                    first[0] = p[0];
                    first[1] = p[1];
                    break;
                }
                case LineTo: {
                    Vector2d v;
                    double dx = data[0] - p[0];
                    double dy = data[1] - p[1];
                    if (!started) {
                        Vector2d p1 = AwtArea.newVector(dy, -dx, 0.01);
                        double[] mid = new double[]{p[0] + dx / 2.0, p[1] + dy / 2.0};
                        flip = !area.contains(mid[0] + p1.x, mid[1] + p1.y) && area.contains(mid[0] - p1.x, mid[1] - p1.y);
                    }
                    Vector2d vector2d = v = flip ? AwtArea.newVector(dy, -dx, width) : AwtArea.newVector(-dy, dx, width);
                    if (started) {
                        ((Path2D)path).lineTo(p[0] + v.x, p[1] + v.y);
                        ((Path2D)path).lineTo(data[0] + v.x, data[1] + v.y);
                    } else {
                        ((Path2D)path).moveTo(p[0] + v.x, p[1] + v.y);
                        ((Path2D)path).lineTo(data[0] + v.x, data[1] + v.y);
                    }
                    p[0] = data[0];
                    p[1] = data[1];
                    started = true;
                    break;
                }
                case CubicTo: {
                    Vector2d v;
                    double dx = data[4] - p[0];
                    double dy = data[5] - p[1];
                    Vector2d vector2d = v = flip ? AwtArea.newVector(dy, -dx, width) : AwtArea.newVector(-dy, dx, width);
                    if (started) {
                        ((Path2D)path).lineTo(p[0] + v.x, p[1] + v.y);
                        ((Path2D)path).lineTo(data[0] + v.x, data[1] + v.y);
                    } else {
                        ((Path2D)path).moveTo(p[0] + v.x, p[1] + v.y);
                        ((Path2D)path).lineTo(data[0] + v.x, data[1] + v.y);
                    }
                    p[0] = data[0];
                    p[1] = data[1];
                    started = true;
                    break;
                }
                case QuadTo: {
                    double dx = data[2] - p[0];
                    double dy = data[3] - p[1];
                    Vector2d v = flip ? AwtArea.newVector(dy, -dx, width) : AwtArea.newVector(-dy, dx, width);
                    v.normalize();
                    v.scale(width);
                    if (started) {
                        ((Path2D)path).lineTo(p[0] + v.x, p[1] + v.y);
                        ((Path2D)path).lineTo(data[0] + v.x, data[1] + v.y);
                    } else {
                        ((Path2D)path).moveTo(p[0] + v.x, p[1] + v.y);
                        ((Path2D)path).lineTo(data[0] + v.x, data[1] + v.y);
                    }
                    p[0] = data[0];
                    p[1] = data[1];
                    started = true;
                    break;
                }
                case Close: {
                    Vector2d v;
                    double dx = first[0] - p[0];
                    double dy = first[1] - p[1];
                    if (Math.abs(dx) >= 0.01 || Math.abs(dy) >= 0.01) {
                        v = flip ? AwtArea.newVector(dy, -dx, width) : AwtArea.newVector(-dy, dx, width);
                        v.normalize();
                        v.scale(width);
                        ((Path2D)path).lineTo(p[0] + v.x, p[1] + v.y);
                        ((Path2D)path).lineTo(first[0] + v.x, first[1] + v.y);
                    }
                    path.closePath();
                    started = false;
                }
            }
            it.next();
        }
        return new Area(path);
    }
}

