/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.SymbolVisibility;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.color.UniColor;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;
import org.openscience.cdk.renderer.generators.standard.AtomSymbol;
import org.openscience.cdk.renderer.generators.standard.HydrogenPosition;
import org.openscience.cdk.renderer.generators.standard.SelectionVisibility;
import org.openscience.cdk.renderer.generators.standard.StandardAtomGenerator;
import org.openscience.cdk.renderer.generators.standard.StandardBondGenerator;
import org.openscience.cdk.renderer.generators.standard.StandardSgroupGenerator;
import org.openscience.cdk.renderer.generators.standard.TextOutline;
import org.openscience.cdk.renderer.generators.standard.VecmathUtil;

public final class StandardGenerator
implements IGenerator<IAtomContainer> {
    public static final String HIGHLIGHT_COLOR = "stdgen.highlight.color";
    public static final String ANNOTATION_LABEL = "stdgen.annotation.label";
    public static final String ITALIC_DISPLAY_PREFIX = "std.itl:";
    public static final String HIDDEN = "stdgen.hidden";
    public static final String HIDDEN_FULLY = "stdgen.hidden.fully";
    private final Font font;
    private final StandardAtomGenerator atomGenerator;
    private final IGeneratorParameter<?> atomColor = new AtomColor();
    private final IGeneratorParameter<?> visibility = new Visibility();
    private final IGeneratorParameter<?> strokeRatio = new StrokeRatio();
    private final IGeneratorParameter<?> separationRatio = new BondSeparation();
    private final IGeneratorParameter<?> wedgeRatio = new WedgeRatio();
    private final IGeneratorParameter<?> marginRatio = new SymbolMarginRatio();
    private final IGeneratorParameter<?> hatchSections = new HashSpacing();
    private final IGeneratorParameter<?> dashSections = new DashSection();
    private final IGeneratorParameter<?> waveSections = new WaveSpacing();
    private final IGeneratorParameter<?> fancyBoldWedges = new FancyBoldWedges();
    private final IGeneratorParameter<?> fancyHashedWedges = new FancyHashedWedges();
    private final IGeneratorParameter<?> highlighting = new Highlighting();
    private final IGeneratorParameter<?> glowWidth = new OuterGlowWidth();
    private final IGeneratorParameter<?> annCol = new AnnotationColor();
    private final IGeneratorParameter<?> annDist = new AnnotationDistance();
    private final IGeneratorParameter<?> annFontSize = new AnnotationFontScale();
    private final IGeneratorParameter<?> sgroupBracketDepth = new SgroupBracketDepth();
    private final IGeneratorParameter<?> sgroupFontScale = new SgroupFontScale();
    private final IGeneratorParameter<?> omitMajorIsotopes = new OmitMajorIsotopes();
    private final IGeneratorParameter<?> forceDonuts = new ForceDelocalisedBondDisplay();

    public StandardGenerator(Font font) {
        this.font = font;
        this.atomGenerator = new StandardAtomGenerator(font);
    }

    public IRenderingElement generate(IAtomContainer container, RendererModel parameters) {
        GeneralPath path;
        Color color;
        IAtom atom;
        Color highlight;
        int i;
        if (container.getAtomCount() == 0) {
            return new ElementGroup();
        }
        HashMap<IAtom, String> symbolRemap = new HashMap<IAtom, String>();
        StandardSgroupGenerator.prepareDisplayShortcuts(container, symbolRemap);
        double scale = (Double)parameters.get(BasicSceneGenerator.Scale.class);
        SymbolVisibility visibility = (SymbolVisibility)parameters.get(Visibility.class);
        IAtomColorer coloring = (IAtomColorer)parameters.get(AtomColor.class);
        Color annotationColor = (Color)parameters.get(AnnotationColor.class);
        Color foreground = coloring.getAtomColor((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        double fontStroke = new TextOutline("|", this.font).resize(1.0 / scale, 1.0 / scale).getBounds().getWidth();
        double stroke = (Double)parameters.get(StrokeRatio.class) * fontStroke;
        ElementGroup annotations = new ElementGroup();
        AtomSymbol[] symbols = this.generateAtomSymbols(container, symbolRemap, visibility, parameters, annotations, foreground, stroke);
        IRenderingElement[] bondElements = StandardBondGenerator.generateBonds(container, symbols, parameters, stroke, this.font, annotations);
        HighlightStyle style = (HighlightStyle)((Object)parameters.get(Highlighting.class));
        double glowWidth = (Double)parameters.get(OuterGlowWidth.class);
        ElementGroup backLayer = new ElementGroup();
        ElementGroup middleLayer = new ElementGroup();
        ElementGroup frontLayer = new ElementGroup();
        for (i = 0; i < container.getBondCount(); ++i) {
            IBond bond = container.getBond(i);
            if (StandardGenerator.isHidden((IChemObject)bond)) continue;
            highlight = this.getHighlightColor((IChemObject)bond, parameters);
            if (highlight != null && (style == HighlightStyle.OuterGlow || style == HighlightStyle.OuterGlowWhiteEdge)) {
                backLayer.add(MarkedElement.markup(StandardGenerator.outerGlow(bondElements[i], highlight, glowWidth, stroke), "outerglow"));
            }
            if (highlight != null && style == HighlightStyle.Colored) {
                frontLayer.add(MarkedElement.markupBond(StandardGenerator.recolor(bondElements[i], highlight), bond));
                continue;
            }
            middleLayer.add(MarkedElement.markupBond(bondElements[i], bond));
        }
        for (i = 0; i < container.getAtomCount(); ++i) {
            atom = container.getAtom(i);
            if (StandardGenerator.isHidden((IChemObject)atom)) continue;
            highlight = this.getHighlightColor((IChemObject)atom, parameters);
            color = this.getColorOfAtom(symbolRemap, coloring, foreground, style, atom, highlight);
            if (symbols[i] == null) {
                if (highlight == null || style != HighlightStyle.OuterGlow && style != HighlightStyle.OuterGlowWhiteEdge) continue;
                double glowWidthExt = glowWidth;
                if (style == HighlightStyle.OuterGlowWhiteEdge && highlight.equals(Color.WHITE)) {
                    glowWidthExt *= 1.75;
                }
                backLayer.add(MarkedElement.markup(new OvalElement(atom.getPoint2d().x, atom.getPoint2d().y, 1.75 * glowWidthExt * stroke, true, highlight), "outerglow"));
                continue;
            }
            ElementGroup symbolElements = new ElementGroup();
            for (Shape shape : symbols[i].getOutlines()) {
                path = GeneralPath.shapeOf(shape, color);
                symbolElements.add(path);
            }
            for (Shape shape : symbols[i].getAnnotationOutlines()) {
                annotations.add(MarkedElement.markup(GeneralPath.shapeOf(shape, annotationColor), "annotation"));
            }
            if (highlight != null && (style == HighlightStyle.OuterGlow || style == HighlightStyle.OuterGlowWhiteEdge)) {
                double glowWidthExt = glowWidth;
                if (style == HighlightStyle.OuterGlowWhiteEdge && highlight.equals(Color.WHITE)) {
                    glowWidthExt *= 1.75;
                }
                backLayer.add(MarkedElement.markup(StandardGenerator.outerGlow(symbolElements, highlight, glowWidthExt, stroke), "outerglow"));
            }
            if (highlight != null && style == HighlightStyle.Colored) {
                frontLayer.add(MarkedElement.markupAtom(symbolElements, atom));
                continue;
            }
            middleLayer.add(MarkedElement.markupAtom(symbolElements, atom));
        }
        if (style == HighlightStyle.OuterGlowWhiteEdge) {
            for (i = 0; i < container.getAtomCount(); ++i) {
                atom = container.getAtom(i);
                if (StandardGenerator.isHidden((IChemObject)atom)) continue;
                highlight = this.getHighlightColor((IChemObject)atom, parameters);
                Color color2 = color = highlight != null ? highlight : coloring.getAtomColor(atom);
                if (symbols[i] == null) continue;
                ElementGroup symbolElements = new ElementGroup();
                for (Shape shape : symbols[i].getOutlines()) {
                    path = GeneralPath.shapeOf(shape, color);
                    symbolElements.add(path);
                }
                if (highlight == null || highlight.equals(Color.WHITE)) continue;
                backLayer.add(MarkedElement.markup(StandardGenerator.outerGlow(symbolElements, Color.WHITE, 10.0 * stroke, stroke), "outerglow"));
            }
        }
        IRenderingElement sgroups = StandardSgroupGenerator.generate(parameters, stroke, this.font, foreground, this.atomGenerator, symbols, container);
        frontLayer.add(sgroups);
        frontLayer.add(annotations);
        ElementGroup group = new ElementGroup();
        group.add(backLayer);
        group.add(middleLayer);
        group.add(frontLayer);
        return MarkedElement.markupMol(group, container);
    }

    private Color getColorOfAtom(Map<IAtom, String> symbolRemap, IAtomColorer coloring, Color foreground, HighlightStyle style, IAtom atom, Color highlight) {
        if (highlight != null && style == HighlightStyle.Colored) {
            return highlight;
        }
        if (symbolRemap.containsKey(atom)) {
            return foreground;
        }
        return coloring.getAtomColor(atom);
    }

    private AtomSymbol[] generateAtomSymbols(IAtomContainer container, Map<IAtom, String> symbolRemap, SymbolVisibility visibility, RendererModel parameters, ElementGroup annotations, Color foreground, double stroke) {
        double scale = (Double)parameters.get(BasicSceneGenerator.Scale.class);
        double annDist = (Double)parameters.get(AnnotationDistance.class) * ((Double)parameters.get(BasicSceneGenerator.BondLength.class) / scale);
        double annScale = 1.0 / scale * (Double)parameters.get(AnnotationFontScale.class);
        Color annColor = (Color)parameters.get(AnnotationColor.class);
        double halfStroke = stroke / 2.0;
        AtomSymbol[] symbols = new AtomSymbol[container.getAtomCount()];
        IChemObjectBuilder builder = container.getBuilder();
        ArrayList<IPseudoAtom> attachPoints = new ArrayList<IPseudoAtom>();
        int maxAttach = 0;
        for (int i = 0; i < container.getAtomCount(); ++i) {
            String label;
            IAtom atom = container.getAtom(i);
            if (StandardGenerator.isHiddenFully((IChemObject)atom)) continue;
            if (atom instanceof IPseudoAtom) {
                int attachNum = ((IPseudoAtom)atom).getAttachPointNum();
                if (attachNum > 0) {
                    attachPoints.add((IPseudoAtom)atom);
                }
                if (attachNum > maxAttach) {
                    maxAttach = attachNum;
                }
            }
            boolean remapped = symbolRemap.containsKey(atom);
            List bonds = container.getConnectedBondsList(atom);
            List neighbors = container.getConnectedAtomsList(atom);
            ArrayList<IAtom> visNeighbors = new ArrayList<IAtom>();
            for (IAtom neighbor : neighbors) {
                if (remapped && StandardGenerator.isHidden((IChemObject)neighbor)) continue;
                visNeighbors.add(neighbor);
            }
            ArrayList<Vector2d> auxVectors = new ArrayList<Vector2d>(1);
            if (visibility.visible(atom, bonds, parameters) || remapped) {
                HydrogenPosition hPosition = HydrogenPosition.position(atom, visNeighbors);
                if (atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() > 0) {
                    auxVectors.add(hPosition.vector());
                }
                symbols[i] = remapped ? this.atomGenerator.generateAbbreviatedSymbol(symbolRemap.get(atom), hPosition) : this.atomGenerator.generateSymbol(container, atom, hPosition, parameters);
                if (symbols[i] != null) {
                    Point2d p;
                    if (visNeighbors.size() < 4) {
                        symbols[i] = hPosition == HydrogenPosition.Left ? symbols[i].alignTo(AtomSymbol.SymbolAlignment.Right) : symbols[i].alignTo(AtomSymbol.SymbolAlignment.Left);
                    }
                    if ((p = atom.getPoint2d()) == null) {
                        throw new IllegalArgumentException("Atom did not have 2D coordinates");
                    }
                    symbols[i] = symbols[i].resize(1.0 / scale, 1.0 / -scale).center(p.x, p.y);
                }
            }
            if ((label = StandardGenerator.getAnnotationLabel((IChemObject)atom)) == null) continue;
            double strokeAdjust = symbols[i] != null ? -halfStroke : 0.0;
            Vector2d vector = StandardGenerator.newAtomAnnotationVector(atom, bonds, auxVectors);
            TextOutline annOutline = StandardGenerator.generateAnnotation(atom.getPoint2d(), label, vector, annDist + strokeAdjust, annScale, this.font, symbols[i]);
            if (symbols[i] != null) {
                symbols[i] = symbols[i].addAnnotation(annOutline);
                continue;
            }
            annotations.add(GeneralPath.shapeOf(annOutline.getOutline(), annColor));
        }
        if (maxAttach > 1) {
            ArrayList<TextOutline> attachNumOutlines = new ArrayList<TextOutline>();
            double maxRadius = 0.0;
            for (IPseudoAtom atom : attachPoints) {
                double h;
                int attachNum = atom.getAttachPointNum();
                double strokeAdjust = -halfStroke;
                Vector2d vector = StandardGenerator.newAttachPointAnnotationVector((IAtom)atom, container.getConnectedBondsList((IAtom)atom), new ArrayList<Vector2d>());
                TextOutline outline = StandardGenerator.generateAnnotation(atom.getPoint2d(), Integer.toString(attachNum), vector, 1.75 * annDist + strokeAdjust, annScale, this.font.deriveFont(1), null);
                attachNumOutlines.add(outline);
                double w = outline.getBounds().getWidth();
                double r = Math.sqrt(w * w + (h = outline.getBounds().getHeight()) * h) / 2.0;
                if (!(r > maxRadius)) continue;
                maxRadius = r;
            }
            for (TextOutline outline : attachNumOutlines) {
                ElementGroup group = new ElementGroup();
                double radius = 2.0 * stroke + maxRadius;
                Ellipse2D.Double shape = new Ellipse2D.Double(outline.getCenter().getX() - radius, outline.getCenter().getY() - radius, 2.0 * radius, 2.0 * radius);
                Area area1 = new Area(shape);
                area1.subtract(new Area(outline.getOutline()));
                group.add(GeneralPath.shapeOf(area1, foreground));
                annotations.add(group);
            }
        }
        return symbols;
    }

    static TextOutline generateAnnotation(Point2d basePoint, String label, Vector2d direction, double distance, double scale, Font font, AtomSymbol symbol) {
        Point2D intersect;
        Point2D center;
        boolean italicHint = label.startsWith(ITALIC_DISPLAY_PREFIX);
        label = italicHint ? label.substring(ITALIC_DISPLAY_PREFIX.length()) : label;
        Font annFont = italicHint ? font.deriveFont(2) : font;
        TextOutline annOutline = new TextOutline(label, annFont).resize(scale, -scale);
        Point2D point2D = direction.x > 0.3 ? annOutline.getFirstGlyphCenter() : (center = direction.x < -0.3 ? annOutline.getLastGlyphCenter() : annOutline.getCenter());
        if (symbol != null && (intersect = symbol.getConvexHull().intersect(VecmathUtil.toAwtPoint(basePoint), VecmathUtil.toAwtPoint(new Point2d((Tuple2d)VecmathUtil.sum((Tuple2d)basePoint, (Tuple2d)direction))))) != null) {
            basePoint = VecmathUtil.toVecmathPoint(intersect);
        }
        direction.scale(distance);
        direction.add((Tuple2d)basePoint);
        return annOutline.translate(direction.x - center.getX(), direction.y - center.getY());
    }

    public static IRenderingElement embedText(Font font, String text, Color color, double scale) {
        String[] lines = text.split("\n");
        ElementGroup group = new ElementGroup();
        double yOffset = 0.0;
        double lineHeight = 1.4;
        for (String line : lines) {
            TextOutline outline = new TextOutline(line, font).resize(scale, -scale);
            Point2D center = outline.getCenter();
            outline = outline.translate(-center.getX(), -(center.getY() + yOffset));
            yOffset += lineHeight * outline.getBounds().getHeight();
            group.add(GeneralPath.shapeOf(outline.getOutline(), color));
            Rectangle2D logicalBounds = outline.getLogicalBounds();
            group.add(new Bounds(logicalBounds.getMinX(), logicalBounds.getMinY(), logicalBounds.getMaxX(), logicalBounds.getMaxY()));
        }
        return group;
    }

    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.atomColor, this.visibility, this.strokeRatio, this.separationRatio, this.wedgeRatio, this.marginRatio, this.hatchSections, this.dashSections, this.waveSections, this.fancyBoldWedges, this.fancyHashedWedges, this.highlighting, this.glowWidth, this.annCol, this.annDist, this.annFontSize, this.sgroupBracketDepth, this.sgroupFontScale, this.omitMajorIsotopes, this.forceDonuts);
    }

    static String getAnnotationLabel(IChemObject chemObject) {
        Object obj = chemObject.getProperty((Object)ANNOTATION_LABEL);
        return obj != null ? obj.toString() : null;
    }

    private Color getHighlightColor(IChemObject bond, RendererModel parameters) {
        Color propCol = StandardGenerator.getColorProperty(bond, HIGHLIGHT_COLOR);
        if (propCol != null) {
            return propCol;
        }
        if (parameters.getSelection() != null && parameters.getSelection().contains(bond)) {
            return (Color)parameters.get(RendererModel.SelectionColor.class);
        }
        return null;
    }

    static Color getColorProperty(IChemObject object, String key) {
        Object value = object.getProperty((Object)key);
        if (value instanceof Color) {
            return (Color)value;
        }
        if (value != null) {
            throw new IllegalArgumentException(key + " property should be a java.awt.Color");
        }
        return null;
    }

    private static IRenderingElement recolor(IRenderingElement element, Color color) {
        if (element instanceof ElementGroup) {
            ElementGroup orgGroup = (ElementGroup)element;
            ElementGroup newGroup = new ElementGroup();
            for (IRenderingElement child : orgGroup) {
                newGroup.add(StandardGenerator.recolor(child, color));
            }
            return newGroup;
        }
        if (element instanceof LineElement) {
            LineElement lineElement = (LineElement)element;
            return new LineElement(lineElement.firstPointX, lineElement.firstPointY, lineElement.secondPointX, lineElement.secondPointY, lineElement.width, color);
        }
        if (element instanceof GeneralPath) {
            return ((GeneralPath)element).recolor(color);
        }
        throw new IllegalArgumentException("Cannot highlight rendering element, " + element.getClass());
    }

    static IRenderingElement outerGlow(IRenderingElement element, Color color, double glowWidth, double stroke) {
        if (element instanceof ElementGroup) {
            ElementGroup orgGroup = (ElementGroup)element;
            ElementGroup newGroup = new ElementGroup();
            for (IRenderingElement child : orgGroup) {
                newGroup.add(StandardGenerator.outerGlow(child, color, glowWidth, stroke));
            }
            return newGroup;
        }
        if (element instanceof LineElement) {
            LineElement lineElement = (LineElement)element;
            return new LineElement(lineElement.firstPointX, lineElement.firstPointY, lineElement.secondPointX, lineElement.secondPointY, stroke + 2.0 * (glowWidth * stroke), color);
        }
        if (element instanceof GeneralPath) {
            GeneralPath org = (GeneralPath)element;
            if (org.fill) {
                return org.outline(2.0 * (glowWidth * stroke)).recolor(color);
            }
            return org.outline(stroke + 2.0 * (glowWidth * stroke)).recolor(color);
        }
        throw new IllegalArgumentException("Cannot generate glow for rendering element, " + element.getClass());
    }

    static Vector2d newAtomAnnotationVector(IAtom atom, List<IBond> bonds, List<Vector2d> auxVectors) {
        ArrayList<Vector2d> vectors = new ArrayList<Vector2d>(bonds.size());
        for (IBond bond : bonds) {
            vectors.add(VecmathUtil.newUnitVector(atom, bond));
        }
        if (vectors.size() == 0) {
            if (auxVectors.size() == 0) {
                return new Vector2d(0.0, -1.0);
            }
            if (auxVectors.size() == 1) {
                return VecmathUtil.negate((Tuple2d)auxVectors.get(0));
            }
            return VecmathUtil.newVectorInLargestGap(auxVectors);
        }
        if (vectors.size() == 1) {
            if (auxVectors.size() == 0) {
                return VecmathUtil.negate((Tuple2d)vectors.get(0));
            }
            vectors.addAll(auxVectors);
            return VecmathUtil.newVectorInLargestGap(vectors);
        }
        if (vectors.size() == 2 && auxVectors.size() == 0) {
            Vector2d combined = VecmathUtil.sum((Tuple2d)vectors.get(0), (Tuple2d)vectors.get(1));
            if (((Vector2d)vectors.get(0)).angle((Vector2d)vectors.get(1)) < Math.toRadians(65.0)) {
                combined.negate();
            } else if (!(StandardGenerator.isPlainBond(bonds.get(0)) && StandardGenerator.isPlainBond(bonds.get(1)) || StandardGenerator.isWedged(bonds.get(0)) && StandardGenerator.isWedged(bonds.get(1)))) {
                combined.negate();
            }
            combined.normalize();
            if (Double.isNaN(combined.length())) {
                return VecmathUtil.newVectorInLargestGap(vectors);
            }
            return combined;
        }
        if (vectors.size() == 3 && auxVectors.size() == 0) {
            ArrayList<Object> plainVectors = new ArrayList<Object>();
            ArrayList<Vector2d> wedgeVectors = new ArrayList<Vector2d>();
            for (IBond bond : bonds) {
                if (StandardGenerator.isPlainBond(bond)) {
                    plainVectors.add(VecmathUtil.newUnitVector(atom, bond));
                }
                if (!StandardGenerator.isWedged(bond)) continue;
                wedgeVectors.add(VecmathUtil.newUnitVector(atom, bond));
            }
            if (plainVectors.size() == 2) {
                return VecmathUtil.sum((Tuple2d)plainVectors.get(0), (Tuple2d)plainVectors.get(1));
            }
            if (plainVectors.size() + wedgeVectors.size() == 2) {
                plainVectors.addAll(wedgeVectors);
                return VecmathUtil.sum((Tuple2d)plainVectors.get(0), (Tuple2d)plainVectors.get(1));
            }
        }
        if (auxVectors.size() > 0) {
            vectors.addAll(auxVectors);
        }
        return VecmathUtil.newVectorInLargestGap(vectors);
    }

    static Vector2d newAttachPointAnnotationVector(IAtom atom, List<IBond> bonds, List<Vector2d> auxVectors) {
        if (bonds.isEmpty()) {
            return new Vector2d(0.0, -1.0);
        }
        if (bonds.size() > 1) {
            return StandardGenerator.newAtomAnnotationVector(atom, bonds, auxVectors);
        }
        Vector2d bondVector = VecmathUtil.newUnitVector(atom, bonds.get(0));
        Vector2d perpVector = VecmathUtil.newPerpendicularVector(bondVector);
        if (perpVector.y > 0.0) {
            perpVector.negate();
        }
        Vector2d vector = new Vector2d((bondVector.x + perpVector.x) / 2.0, (bondVector.y + perpVector.y) / 2.0);
        vector.normalize();
        return vector;
    }

    static boolean isPlainBond(IBond bond) {
        return bond.getOrder() == IBond.Order.SINGLE && (bond.getStereo() == IBond.Stereo.NONE || bond.getStereo() == null);
    }

    static boolean isWedged(IBond bond) {
        return bond.getStereo() == IBond.Stereo.UP || bond.getStereo() == IBond.Stereo.DOWN || bond.getStereo() == IBond.Stereo.UP_INVERTED || bond.getStereo() == IBond.Stereo.DOWN_INVERTED;
    }

    static boolean isHidden(IChemObject chemobj) {
        return Boolean.TRUE.equals(chemobj.getProperty((Object)HIDDEN));
    }

    static boolean isHiddenFully(IChemObject chemobj) {
        return Boolean.TRUE.equals(chemobj.getProperty((Object)HIDDEN_FULLY));
    }

    static void hide(IChemObject chemobj) {
        chemobj.setProperty((Object)HIDDEN, (Object)true);
    }

    static void hideFully(IChemObject chemobj) {
        chemobj.setProperty((Object)HIDDEN_FULLY, (Object)true);
    }

    static void unhide(IChemObject chemobj) {
        chemobj.setProperty((Object)HIDDEN, (Object)false);
        chemobj.setProperty((Object)HIDDEN_FULLY, (Object)false);
    }

    public static final class ForceDelocalisedBondDisplay
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return false;
        }
    }

    public static final class OmitMajorIsotopes
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return false;
        }
    }

    public static final class SgroupFontScale
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 0.6;
        }
    }

    public static final class SgroupBracketDepth
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 0.18;
        }
    }

    public static final class AnnotationFontScale
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 0.5;
        }
    }

    public static final class AnnotationDistance
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 0.25;
        }
    }

    public static final class AnnotationColor
    extends AbstractGeneratorParameter<Color> {
        public Color getDefault() {
            return Color.RED;
        }
    }

    public static final class Highlighting
    extends AbstractGeneratorParameter<HighlightStyle> {
        public HighlightStyle getDefault() {
            return HighlightStyle.Colored;
        }
    }

    public static final class OuterGlowWidth
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 2.0;
        }
    }

    public static final class FancyHashedWedges
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return true;
        }
    }

    public static final class FancyBoldWedges
    extends AbstractGeneratorParameter<Boolean> {
        public Boolean getDefault() {
            return true;
        }
    }

    public static final class DashSection
    extends AbstractGeneratorParameter<Integer> {
        public Integer getDefault() {
            return 8;
        }
    }

    public static final class WaveSpacing
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 5.0;
        }
    }

    public static final class HashSpacing
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 5.0;
        }
    }

    public static final class WedgeRatio
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 6.0;
        }
    }

    public static final class SymbolMarginRatio
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 2.0;
        }
    }

    public static final class BondSeparation
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 0.18;
        }
    }

    public static final class StrokeRatio
    extends AbstractGeneratorParameter<Double> {
        public Double getDefault() {
            return 1.0;
        }
    }

    public static final class Visibility
    extends AbstractGeneratorParameter<SymbolVisibility> {
        public SymbolVisibility getDefault() {
            return SelectionVisibility.disconnected(SymbolVisibility.iupacRecommendationsWithoutTerminalCarbon());
        }
    }

    public static final class AtomColor
    extends AbstractGeneratorParameter<IAtomColorer> {
        public IAtomColorer getDefault() {
            return new UniColor(new Color(0x444444));
        }
    }

    public static enum HighlightStyle {
        None,
        Colored,
        OuterGlow,
        OuterGlowWhiteEdge;

    }
}

