/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Rectangle;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.renderer.AtomContainerRenderer;
import org.openscience.cdk.renderer.ElementUtility;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.AWTFontManager;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class AtomContainerRendererTest {
    private IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();
    private StructureDiagramGenerator sdg = new StructureDiagramGenerator();

    public IAtomContainer layout(IAtomContainer molecule) {
        this.sdg.setMolecule(molecule);
        try {
            this.sdg.generateCoordinates();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return this.sdg.getMolecule();
    }

    public IAtomContainer makeSquare() {
        IAtomContainer square = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        square.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"}));
        square.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"}));
        square.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"}));
        square.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"}));
        square.addBond(0, 1, IBond.Order.SINGLE);
        square.addBond(0, 3, IBond.Order.SINGLE);
        square.addBond(1, 2, IBond.Order.SINGLE);
        square.addBond(2, 3, IBond.Order.SINGLE);
        return this.layout(square);
    }

    @Test
    public void testSquareMolecule() {
        IAtomContainer square = this.makeSquare();
        ArrayList<Object> generators = new ArrayList<Object>();
        generators.add(new BasicSceneGenerator());
        generators.add(new BasicBondGenerator());
        BasicAtomGenerator atomGenerator = new BasicAtomGenerator();
        generators.add(atomGenerator);
        AtomContainerRenderer renderer = new AtomContainerRenderer(generators, (IFontManager)new AWTFontManager());
        RendererModel model = renderer.getRenderer2DModel();
        ((BasicAtomGenerator.CompactShape)model.getParameter(BasicAtomGenerator.CompactShape.class)).setValue((Object)BasicAtomGenerator.Shape.OVAL);
        ((BasicAtomGenerator.CompactAtom)model.getParameter(BasicAtomGenerator.CompactAtom.class)).setValue((Object)true);
        ((BasicAtomGenerator.KekuleStructure)model.getParameter(BasicAtomGenerator.KekuleStructure.class)).setValue((Object)true);
        ((BasicAtomGenerator.ShowEndCarbons)model.getParameter(BasicAtomGenerator.ShowEndCarbons.class)).setValue((Object)true);
        ElementUtility visitor = new ElementUtility();
        Rectangle screen = new Rectangle(0, 0, 100, 100);
        renderer.setup(square, screen);
        renderer.paint(square, (IDrawVisitor)visitor);
        for (IRenderingElement element : visitor.getElements()) {
            Assert.assertTrue((visitor.toString(element).contains("Line") || visitor.toString(element).contains("Oval") ? 1 : 0) != 0);
        }
    }
}

