/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.List;
import javax.vecmath.Point2d;
import org.junit.Assert;
import org.junit.Test;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.renderer.ElementUtility;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public abstract class AbstractGeneratorTest {
    protected IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();
    protected RendererModel model;
    protected ElementUtility elementUtil;
    protected BasicSceneGenerator sceneGenerator;
    private IGenerator testedGenerator;

    public void setTestedGenerator(IGenerator generator) {
        this.testedGenerator = generator;
    }

    public void setup() {
        if (this.model != null) {
            return;
        }
        this.model = new RendererModel();
        this.elementUtil = new ElementUtility();
        this.elementUtil.setTransform(this.getTransform());
        this.sceneGenerator = new BasicSceneGenerator();
        this.model.registerParameters((IGenerator)this.sceneGenerator);
    }

    public <T> boolean containsParameterType(List<IGeneratorParameter<?>> list, Class<T> type) {
        for (IGeneratorParameter<?> item : list) {
            if (!item.getClass().getName().equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    public List<IRenderingElement> getAllSimpleElements(IGenerator generator, IAtomContainer container) {
        IRenderingElement root = generator.generate((IChemObject)container, this.model);
        return this.elementUtil.getAllSimpleElements(root);
    }

    public abstract Rectangle getCustomCanvas();

    public Rectangle getDefaultCanvas() {
        return new Rectangle(0, 0, 100, 100);
    }

    public AffineTransform getTransform() {
        Rectangle canvas = this.getCustomCanvas();
        if (canvas == null) {
            canvas = this.getDefaultCanvas();
        }
        return this.makeTransform(canvas);
    }

    public AffineTransform makeTransform(Rectangle canvas) {
        AffineTransform transform = new AffineTransform();
        int cX = canvas.x + canvas.width / 2;
        int cY = canvas.y + canvas.height / 2;
        transform.translate(cX, cY);
        return transform;
    }

    public static double length(LineElement line) {
        return AbstractGeneratorTest.distance(line.firstPointX, line.firstPointY, line.secondPointX, line.secondPointY);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
    }

    public static Point2d center(List<IRenderingElement> elements) {
        double centerX = 0.0;
        double centerY = 0.0;
        double counter = 0.0;
        for (IRenderingElement element : elements) {
            if (element instanceof OvalElement) {
                OvalElement o = (OvalElement)element;
                centerX += o.xCoord;
                centerY += o.yCoord;
                counter += 1.0;
                continue;
            }
            if (!(element instanceof LineElement)) continue;
            LineElement l = (LineElement)element;
            centerX += l.firstPointX;
            centerX += l.secondPointX;
            centerY += l.firstPointY;
            centerY += l.secondPointY;
            counter += 2.0;
        }
        if (counter > 0.0) {
            return new Point2d(centerX / counter, centerY / counter);
        }
        return new Point2d(0.0, 0.0);
    }

    public IAtomContainer makeSingleAtom() {
        IAtomContainer container = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(0.0, 0.0)}));
        return container;
    }

    public IAtomContainer makeSingleAtom(String elementSymbol) {
        IAtomContainer container = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{elementSymbol, new Point2d(0.0, 0.0)}));
        return container;
    }

    public IAtomContainer makeMethane() {
        IAtomContainer methane = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        methane.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(0.0, 0.0)}));
        methane.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"H", new Point2d(1.0, 1.0)}));
        methane.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"H", new Point2d(1.0, -1.0)}));
        methane.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"H", new Point2d(-1.0, 1.0)}));
        methane.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"H", new Point2d(-1.0, -1.0)}));
        return methane;
    }

    public IAtomContainer makeSingleBond() {
        IAtomContainer container = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(0.0, -1.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(0.0, 1.0)}));
        container.addBond(0, 1, IBond.Order.SINGLE);
        return container;
    }

    public IAtomContainer makeCCC() {
        IAtomContainer container = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(-1.0, -1.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(0.0, 0.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(1.0, -1.0)}));
        container.addBond(0, 1, IBond.Order.SINGLE);
        container.addBond(1, 2, IBond.Order.SINGLE);
        return container;
    }

    public IAtomContainer makeSquare() {
        IAtomContainer container = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(-1.0, -1.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(1.0, -1.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(1.0, 1.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C", new Point2d(-1.0, 1.0)}));
        container.addBond(0, 1, IBond.Order.SINGLE);
        container.addBond(0, 3, IBond.Order.SINGLE);
        container.addBond(1, 2, IBond.Order.SINGLE);
        container.addBond(2, 3, IBond.Order.SINGLE);
        return container;
    }

    public IAtomContainer makeSNOPSquare() {
        IAtomContainer container = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"S", new Point2d(-1.0, -1.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"N", new Point2d(1.0, -1.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"O", new Point2d(1.0, 1.0)}));
        container.addAtom((IAtom)this.builder.newInstance(IAtom.class, new Object[]{"P", new Point2d(-1.0, 1.0)}));
        container.addBond(0, 1, IBond.Order.SINGLE);
        container.addBond(0, 3, IBond.Order.SINGLE);
        container.addBond(1, 2, IBond.Order.SINGLE);
        container.addBond(2, 3, IBond.Order.SINGLE);
        return container;
    }

    @Test
    public void testGetParameters() {
        Assert.assertNotNull((String)"The tested generator is not set.", (Object)this.testedGenerator);
        Assert.assertNotNull((String)"The getParameters() must not return a null value.", (Object)this.testedGenerator.getParameters());
    }
}

