/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Rectangle;
import java.util.List;
import javax.vecmath.Point2d;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.generators.AbstractGeneratorTest;
import org.openscience.cdk.renderer.generators.BasicBondGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;

public class BasicBondGeneratorTest
extends AbstractGeneratorTest {
    private BasicBondGenerator generator;

    static IRenderingElement unbox(IRenderingElement element) {
        if (element instanceof MarkedElement) {
            return ((MarkedElement)element).element();
        }
        return element;
    }

    @Override
    public Rectangle getCustomCanvas() {
        return null;
    }

    @Override
    @Before
    public void setup() {
        super.setup();
        this.generator = new BasicBondGenerator();
        this.model.registerParameters((IGenerator)this.generator);
        super.setTestedGenerator((IGenerator)this.generator);
    }

    @Test
    public void testSingleAtom() {
        IAtomContainer singleAtom = this.makeSingleAtom();
        IRenderingElement root = this.generator.generate(singleAtom, this.model);
        List<IRenderingElement> elements = this.elementUtil.getAllSimpleElements(root);
        Assert.assertEquals((long)0L, (long)elements.size());
    }

    @Test
    public void testSingleBond() {
        IAtomContainer container = this.makeSingleBond();
        IRenderingElement root = this.generator.generate(container, this.model);
        List<IRenderingElement> elements = this.elementUtil.getAllSimpleElements(root);
        Assert.assertEquals((long)1L, (long)elements.size());
        LineElement line = (LineElement)elements.get(0);
        Assert.assertNotSame((Object)0, (Object)AbstractGeneratorTest.length(line));
    }

    @Test
    public void testSquare() {
        IAtomContainer square = this.makeSquare();
        IRenderingElement root = this.generator.generate(square, this.model);
        List<IRenderingElement> elements = this.elementUtil.getAllSimpleElements(root);
        Assert.assertEquals((long)4L, (long)elements.size());
        Assert.assertEquals((Object)new Point2d(0.0, 0.0), (Object)BasicBondGeneratorTest.center(elements));
    }
}

