/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import org.junit.Test;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.silent.AtomContainer;

public class BoundsCalculatorTest {
    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IAtomContainer_SingleAtom() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        BoundsCalculator.calculateBounds((IAtomContainer)container);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IAtomContainer() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        BoundsCalculator.calculateBounds((IAtomContainer)container);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IAtomContainerSet_SingleAtom() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        IAtomContainerSet set = (IAtomContainerSet)container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        set.addAtomContainer((IAtomContainer)container);
        BoundsCalculator.calculateBounds((IAtomContainerSet)set);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IAtomContainerSet() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        IAtomContainerSet set = (IAtomContainerSet)container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        set.addAtomContainer((IAtomContainer)container);
        BoundsCalculator.calculateBounds((IAtomContainerSet)set);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IReactionSet_SingleAtom() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        IReaction reaction = (IReaction)container.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant((IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[]{container}));
        IReactionSet set = (IReactionSet)container.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        set.addReaction(reaction);
        BoundsCalculator.calculateBounds((IReactionSet)set);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IReactionSet() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        IReaction reaction = (IReaction)container.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant((IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[]{container}));
        IReactionSet set = (IReactionSet)container.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        set.addReaction(reaction);
        BoundsCalculator.calculateBounds((IReactionSet)set);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IChemModel_SingleAtom() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        IAtomContainerSet set = (IAtomContainerSet)container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        set.addAtomContainer((IAtomContainer)container);
        IChemModel model = (IChemModel)container.getBuilder().newInstance(IChemModel.class, new Object[0]);
        model.setMoleculeSet(set);
        BoundsCalculator.calculateBounds((IChemModel)model);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IChemModel() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        IAtomContainerSet set = (IAtomContainerSet)container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        set.addAtomContainer((IAtomContainer)container);
        IChemModel model = (IChemModel)container.getBuilder().newInstance(IChemModel.class, new Object[0]);
        model.setMoleculeSet(set);
        BoundsCalculator.calculateBounds((IChemModel)model);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IReaction_SingleAtom() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        IReaction reaction = (IReaction)container.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant((IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[]{container}));
        BoundsCalculator.calculateBounds((IReaction)reaction);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCalculateBounds_IReaction() {
        AtomContainer container = new AtomContainer();
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        container.addAtom((IAtom)container.getBuilder().newInstance(IAtom.class, new Object[]{"C"}));
        IReaction reaction = (IReaction)container.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant((IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[]{container}));
        BoundsCalculator.calculateBounds((IReaction)reaction);
    }
}

