/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Point2d;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.elements.AtomSymbolElement;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.AbstractGeneratorTest;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.validate.ProblemMarker;

public class BasicAtomGeneratorTest
extends AbstractGeneratorTest {
    private BasicAtomGenerator generator;

    static IRenderingElement unbox(IRenderingElement element) {
        if (element instanceof MarkedElement) {
            return ((MarkedElement)element).element();
        }
        return element;
    }

    @Override
    public Rectangle getCustomCanvas() {
        return null;
    }

    @Override
    @Before
    public void setup() {
        super.setup();
        this.generator = new BasicAtomGenerator();
        this.model.registerParameters((IGenerator)this.generator);
        super.setTestedGenerator((IGenerator)this.generator);
    }

    @Test
    public void generateElementTest() {
        IAtom atom = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"});
        atom.setPoint2d(new Point2d(2.0, 3.0));
        atom.setImplicitHydrogenCount(Integer.valueOf(0));
        int alignment = 1;
        AtomSymbolElement element = this.generator.generateElement(atom, alignment, this.model);
        Assert.assertEquals((double)atom.getPoint2d().x, (double)element.xCoord, (double)0.01);
        Assert.assertEquals((double)atom.getPoint2d().y, (double)element.yCoord, (double)0.01);
        Assert.assertEquals((Object)atom.getSymbol(), (Object)element.text);
        Assert.assertEquals((long)atom.getFormalCharge().intValue(), (long)element.formalCharge);
        Assert.assertEquals((long)atom.getImplicitHydrogenCount().intValue(), (long)element.hydrogenCount);
        Assert.assertEquals((long)alignment, (long)element.alignment);
        Assert.assertEquals((Object)this.generator.getAtomColor(atom, this.model), (Object)element.color);
    }

    @Test
    public void hasCoordinatesTest() {
        IAtom atomWithCoordinates = (IAtom)this.builder.newInstance(IAtom.class, new Object[0]);
        atomWithCoordinates.setPoint2d(new Point2d(0.0, 0.0));
        Assert.assertTrue((boolean)this.generator.hasCoordinates(atomWithCoordinates));
        IAtom atomWithoutCoordinates = (IAtom)this.builder.newInstance(IAtom.class, new Object[0]);
        atomWithoutCoordinates.setPoint2d(null);
        Assert.assertFalse((boolean)this.generator.hasCoordinates(atomWithoutCoordinates));
        IAtom nullAtom = null;
        Assert.assertFalse((boolean)this.generator.hasCoordinates(nullAtom));
    }

    @Test
    public void canDrawTest() {
        IAtom drawableCAtom = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"});
        drawableCAtom.setPoint2d(new Point2d(0.0, 0.0));
        IAtom drawableHAtom = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"H"});
        drawableHAtom.setPoint2d(new Point2d(0.0, 0.0));
        IAtomContainer dummyContainer = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        this.model.set(BasicAtomGenerator.KekuleStructure.class, (Object)true);
        this.model.set(BasicAtomGenerator.ShowExplicitHydrogens.class, (Object)true);
        Assert.assertTrue((boolean)this.generator.canDraw(drawableCAtom, dummyContainer, this.model));
        Assert.assertTrue((boolean)this.generator.canDraw(drawableHAtom, dummyContainer, this.model));
    }

    @Test
    public void invisibleHydrogenTest() {
        IAtom hydrogen = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"H"});
        this.model.set(BasicAtomGenerator.ShowExplicitHydrogens.class, (Object)false);
        Assert.assertTrue((boolean)this.generator.invisibleHydrogen(hydrogen, this.model));
        this.model.set(BasicAtomGenerator.ShowExplicitHydrogens.class, (Object)true);
        Assert.assertFalse((boolean)this.generator.invisibleHydrogen(hydrogen, this.model));
        IAtom nonHydrogen = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"});
        this.model.set(BasicAtomGenerator.ShowExplicitHydrogens.class, (Object)false);
        Assert.assertFalse((boolean)this.generator.invisibleHydrogen(nonHydrogen, this.model));
        this.model.set(BasicAtomGenerator.ShowExplicitHydrogens.class, (Object)true);
        Assert.assertFalse((boolean)this.generator.invisibleHydrogen(nonHydrogen, this.model));
    }

    @Test
    public void invisibleCarbonTest() {
        IAtom carbon = (IAtom)this.builder.newInstance(IAtom.class, new Object[]{"C"});
        IAtomContainer dummyContainer = (IAtomContainer)this.builder.newInstance(IAtomContainer.class, new Object[0]);
        this.model.set(BasicAtomGenerator.KekuleStructure.class, (Object)true);
        Assert.assertFalse((boolean)this.generator.invisibleCarbon(carbon, dummyContainer, this.model));
    }

    @Test
    public void showCarbon_KekuleTest() {
        IAtomContainer atomContainer = super.makeCCC();
        IAtom carbon = atomContainer.getAtom(1);
        this.model.set(BasicAtomGenerator.KekuleStructure.class, (Object)true);
        Assert.assertTrue((boolean)this.generator.showCarbon(carbon, atomContainer, this.model));
    }

    @Test
    public void showCarbon_FormalChargeTest() {
        IAtomContainer atomContainer = super.makeCCC();
        IAtom carbon = atomContainer.getAtom(1);
        carbon.setFormalCharge(Integer.valueOf(1));
        Assert.assertTrue((boolean)this.generator.showCarbon(carbon, atomContainer, this.model));
    }

    @Test
    public void showCarbon_SingleCarbonTest() {
        IAtomContainer atomContainer = super.makeSingleAtom("C");
        IAtom carbon = atomContainer.getAtom(0);
        Assert.assertTrue((boolean)this.generator.showCarbon(carbon, atomContainer, this.model));
    }

    @Test
    public void showCarbon_ShowEndCarbonsTest() {
        IAtomContainer atomContainer = super.makeCCC();
        IAtom carbon = atomContainer.getAtom(0);
        this.model.set(BasicAtomGenerator.ShowEndCarbons.class, (Object)true);
        Assert.assertTrue((boolean)this.generator.showCarbon(carbon, atomContainer, this.model));
    }

    @Test
    public void showCarbon_ErrorMarker() {
        IAtomContainer atomContainer = super.makeCCC();
        IAtom carbon = atomContainer.getAtom(1);
        ProblemMarker.markWithError((IChemObject)carbon);
        Assert.assertTrue((boolean)this.generator.showCarbon(carbon, atomContainer, this.model));
    }

    @Test
    public void showCarbon_ConnectedSingleElectrons() {
        IAtomContainer atomContainer = super.makeCCC();
        IAtom carbon = atomContainer.getAtom(1);
        atomContainer.addSingleElectron(1);
        Assert.assertTrue((boolean)this.generator.showCarbon(carbon, atomContainer, this.model));
    }

    @Test
    public void ovalShapeTest() {
        IAtomContainer singleAtom = this.makeSingleAtom();
        this.model.set(BasicAtomGenerator.CompactShape.class, (Object)BasicAtomGenerator.Shape.OVAL);
        this.model.set(BasicAtomGenerator.CompactAtom.class, (Object)true);
        List<IRenderingElement> elements = this.getAllSimpleElements((IGenerator)this.generator, singleAtom);
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals(OvalElement.class, elements.get(0).getClass());
    }

    @Test
    public void squareShapeTest() {
        IAtomContainer singleAtom = this.makeSingleAtom();
        this.model.set(BasicAtomGenerator.CompactShape.class, (Object)BasicAtomGenerator.Shape.SQUARE);
        this.model.set(BasicAtomGenerator.CompactAtom.class, (Object)true);
        List<IRenderingElement> elements = this.getAllSimpleElements((IGenerator)this.generator, singleAtom);
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals(RectangleElement.class, elements.get(0).getClass());
    }

    @Test
    public void getAtomColorTest() {
        Color testColor = Color.RED;
        IAtomContainer singleAtom = this.makeSingleAtom("O");
        this.model.set(BasicAtomGenerator.AtomColor.class, (Object)testColor);
        this.model.set(BasicAtomGenerator.ColorByType.class, (Object)false);
        this.generator.getAtomColor(singleAtom.getAtom(0), this.model);
        List<IRenderingElement> elements = this.getAllSimpleElements((IGenerator)this.generator, singleAtom);
        Assert.assertEquals((long)1L, (long)elements.size());
        AtomSymbolElement element = (AtomSymbolElement)BasicAtomGeneratorTest.unbox(elements.get(0));
        Assert.assertEquals((Object)testColor, (Object)element.color);
    }

    @Test
    public void atomColorerTest() {
        IAtomContainer cnop = this.makeSNOPSquare();
        final HashMap<String, Color> colorMap = new HashMap<String, Color>();
        colorMap.put("S", Color.YELLOW);
        colorMap.put("N", Color.BLUE);
        colorMap.put("O", Color.RED);
        colorMap.put("P", Color.MAGENTA);
        IAtomColorer atomColorer = new IAtomColorer(){

            public Color getAtomColor(IAtom atom) {
                String symbol = atom.getSymbol();
                if (colorMap.containsKey(symbol)) {
                    return (Color)colorMap.get(symbol);
                }
                return null;
            }

            public Color getAtomColor(IAtom atom, Color defaultColor) {
                Color color = this.getAtomColor(atom);
                if (color == null) {
                    return defaultColor;
                }
                return color;
            }
        };
        this.model.set(BasicAtomGenerator.AtomColorer.class, (Object)atomColorer);
        List<IRenderingElement> elements = this.getAllSimpleElements((IGenerator)this.generator, cnop);
        Assert.assertEquals((long)4L, (long)elements.size());
        for (IRenderingElement element : elements) {
            AtomSymbolElement symbolElement = (AtomSymbolElement)BasicAtomGeneratorTest.unbox(element);
            String symbol = symbolElement.text;
            Assert.assertTrue((boolean)colorMap.containsKey(symbol));
            Assert.assertEquals(colorMap.get(symbol), (Object)symbolElement.color);
        }
    }

    @Test
    public void colorByTypeTest() {
        IAtomContainer snop = this.makeSNOPSquare();
        this.model.set(BasicAtomGenerator.ColorByType.class, (Object)false);
        List<IRenderingElement> elements = this.getAllSimpleElements((IGenerator)this.generator, snop);
        Color defaultColor = (Color)this.model.getDefault(BasicAtomGenerator.AtomColor.class);
        for (IRenderingElement element : elements) {
            AtomSymbolElement symbolElement = (AtomSymbolElement)BasicAtomGeneratorTest.unbox(element);
            Assert.assertEquals((Object)defaultColor, (Object)symbolElement.color);
        }
    }

    @Test
    public void showExplicitHydrogensTest() {
        IAtomContainer methane = this.makeMethane();
        this.model.set(BasicAtomGenerator.ShowExplicitHydrogens.class, (Object)false);
        List<IRenderingElement> carbonOnly = this.getAllSimpleElements((IGenerator)this.generator, methane);
        Assert.assertEquals((long)1L, (long)carbonOnly.size());
        this.model.set(BasicAtomGenerator.ShowExplicitHydrogens.class, (Object)true);
        List<IRenderingElement> carbonPlusHydrogen = this.getAllSimpleElements((IGenerator)this.generator, methane);
        Assert.assertEquals((long)5L, (long)carbonPlusHydrogen.size());
    }

    @Test
    public void kekuleTest() {
        IAtomContainer singleBond = this.makeSingleBond();
        this.model.set(BasicAtomGenerator.KekuleStructure.class, (Object)true);
        Assert.assertEquals((long)2L, (long)this.getAllSimpleElements((IGenerator)this.generator, singleBond).size());
        this.model.set(BasicAtomGenerator.KekuleStructure.class, (Object)false);
        Assert.assertEquals((long)0L, (long)this.getAllSimpleElements((IGenerator)this.generator, singleBond).size());
    }

    @Test
    public void showEndCarbonsTest() {
        IAtomContainer singleBond = this.makeCCC();
        this.model.set(BasicAtomGenerator.ShowEndCarbons.class, (Object)true);
        Assert.assertEquals((long)2L, (long)this.getAllSimpleElements((IGenerator)this.generator, singleBond).size());
        this.model.set(BasicAtomGenerator.ShowEndCarbons.class, (Object)false);
        Assert.assertEquals((long)0L, (long)this.getAllSimpleElements((IGenerator)this.generator, singleBond).size());
    }

    @Test
    public void testSingleAtom() {
        IAtomContainer singleAtom = this.makeSingleAtom();
        IRenderingElement root = this.generator.generate(singleAtom, singleAtom.getAtom(0), this.model);
        List<IRenderingElement> elements = this.elementUtil.getAllSimpleElements(root);
        Assert.assertEquals((long)1L, (long)elements.size());
    }

    @Test
    public void testSingleBond() {
        IAtomContainer container = this.makeSingleBond();
        this.model.set(BasicAtomGenerator.CompactAtom.class, (Object)true);
        this.model.set(BasicAtomGenerator.CompactShape.class, (Object)BasicAtomGenerator.Shape.OVAL);
        this.model.set(BasicAtomGenerator.ShowEndCarbons.class, (Object)true);
        IRenderingElement root = this.generator.generate(container, this.model);
        List<IRenderingElement> elements = this.elementUtil.getAllSimpleElements(root);
        Assert.assertEquals((long)2L, (long)elements.size());
        OvalElement ovalA = (OvalElement)elements.get(0);
        OvalElement ovalB = (OvalElement)elements.get(1);
        Assert.assertNotSame((Object)0, (Object)BasicAtomGeneratorTest.distance(ovalA.xCoord, ovalA.yCoord, ovalB.xCoord, ovalB.yCoord));
    }

    @Test
    public void testSquare() {
        IAtomContainer square = this.makeSquare();
        this.model.set(BasicAtomGenerator.KekuleStructure.class, (Object)true);
        IRenderingElement root = this.generator.generate(square, this.model);
        List<IRenderingElement> elements = this.elementUtil.getAllSimpleElements(root);
        Assert.assertEquals((long)4L, (long)elements.size());
        Assert.assertEquals((Object)new Point2d(0.0, 0.0), (Object)BasicAtomGeneratorTest.center(elements));
    }

    @Test
    public void getParametersTest() {
        List parameters = this.generator.getParameters();
        this.containsParameterType(parameters, BasicAtomGenerator.AtomColor.class);
        this.containsParameterType(parameters, BasicAtomGenerator.AtomColorer.class);
        this.containsParameterType(parameters, BasicAtomGenerator.AtomRadius.class);
        this.containsParameterType(parameters, BasicAtomGenerator.ColorByType.class);
        this.containsParameterType(parameters, BasicAtomGenerator.CompactShape.class);
        this.containsParameterType(parameters, BasicAtomGenerator.CompactAtom.class);
        this.containsParameterType(parameters, BasicAtomGenerator.KekuleStructure.class);
        this.containsParameterType(parameters, BasicAtomGenerator.ShowEndCarbons.class);
        this.containsParameterType(parameters, BasicAtomGenerator.ShowExplicitHydrogens.class);
    }
}

