/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.openscience.cdk.renderer.generators.standard.AbbreviationLabel;

public class AbbreviationLabelTest {
    @Test
    public void carboxylicacid() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"COOH", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"C", "O", "O", "H"}));
    }

    @Test
    public void carboxylate() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"COO-", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"C", "O", "O", "-"}));
    }

    @Test
    public void trifluromethyl() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"CF3", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"C", "F3"}));
    }

    @Test
    public void triphenylmethyl() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"CPh3", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"C", "Ph3"}));
    }

    @Test
    public void tertbutyls() {
        ArrayList tokens = new ArrayList(1);
        for (String str : Arrays.asList("tBu", "tertBu", "t-Bu", "t-Butyl", "tertButyl")) {
            tokens.clear();
            Assert.assertTrue((String)str, (boolean)AbbreviationLabel.parse((String)str, tokens));
            MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)1));
        }
    }

    @Test
    public void peglinker() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"CH2CH2OCH2CH2O", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"C", "H2", "C", "H2", "O", "C", "H2", "C", "H2", "O"}));
    }

    @Test
    public void parseFeacac3() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"Fe(acac)3", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"Fe", "(", "acac", ")", "3"}));
    }

    @Test
    public void formatFeacac3() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"Fe(acac)3", tokens));
        List formatted = AbbreviationLabel.format(tokens);
        AbbreviationLabel.reduce((List)formatted, (int)0, (int)formatted.size());
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)0)).text, (Matcher)CoreMatchers.is((Object)"Fe(acac)"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)0)).style, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)1)).text, (Matcher)CoreMatchers.is((Object)"3"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)1)).style, (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    public void formatRubpy3Cl2() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"Ru(bpy)3Cl2", tokens));
        List formatted = AbbreviationLabel.format(tokens);
        AbbreviationLabel.reduce((List)formatted, (int)0, (int)formatted.size());
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)0)).text, (Matcher)CoreMatchers.is((Object)"Ru(bpy)"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)0)).style, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)1)).text, (Matcher)CoreMatchers.is((Object)"3"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)1)).style, (Matcher)CoreMatchers.is((Object)-1));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)2)).text, (Matcher)CoreMatchers.is((Object)"Cl"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)2)).style, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)3)).text, (Matcher)CoreMatchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)3)).style, (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    public void CO2Et() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"CO2Et", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"C", "O2", "Et"}));
    }

    @Test
    public void parseBrackets() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"N(CH2CH2O)CH2", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)10));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"N", "(", "C", "H2", "C", "H2", "O", ")", "C", "H2"}));
    }

    @Test
    public void reversingBrackets() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"N(CH2CH2O)CH2", tokens));
        AbbreviationLabel.reverse(tokens);
        MatcherAssert.assertThat((Object)Joiner.on((String)"").join(tokens), (Matcher)CoreMatchers.is((Object)"H2C(OH2CH2C)N"));
    }

    @Test
    public void reversingFormatPOOHOEt() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"PO(OH)OEt", tokens));
        AbbreviationLabel.reverse(tokens);
        AbbreviationLabel.format(tokens);
        MatcherAssert.assertThat((Object)Joiner.on((String)"").join(tokens), (Matcher)CoreMatchers.is((Object)"EtO(HO)OP"));
    }

    @Test
    public void reversingBracketsWithNumbers() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"B(OH)2", tokens));
        AbbreviationLabel.reverse(tokens);
        MatcherAssert.assertThat((Object)Joiner.on((String)"").join(tokens), (Matcher)CoreMatchers.is((Object)"(HO)2B"));
    }

    @Test
    public void hydrateFormatting() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"SnCl4.2H2O", tokens));
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.is(Arrays.asList("Sn", "Cl4", ".", "2", "H2", "O")));
    }

    @Test
    public void nonAbbreviationLabel() {
        ArrayList tokens = new ArrayList();
        Assert.assertFalse((boolean)AbbreviationLabel.parse((String)"A Random Label - Don't Reverse", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void formatOPO3() {
        List<String> tokens = Arrays.asList("O", "P", "O3", "-2");
        List texts = AbbreviationLabel.format(tokens);
        AbbreviationLabel.reduce((List)texts, (int)0, (int)texts.size());
        MatcherAssert.assertThat((Object)texts.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)0)).text, (Matcher)CoreMatchers.is((Object)"OPO"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)0)).style, (Matcher)CoreMatchers.is((Object)AbbreviationLabel.STYLE_NORMAL));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)1)).text, (Matcher)CoreMatchers.is((Object)"3"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)1)).style, (Matcher)CoreMatchers.is((Object)AbbreviationLabel.STYLE_SUBSCRIPT));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)2)).text, (Matcher)CoreMatchers.is((Object)"2\u2212"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)2)).style, (Matcher)CoreMatchers.is((Object)AbbreviationLabel.STYLE_SUPSCRIPT));
    }

    @Test
    public void formatTBu() {
        List<String> tokens = Arrays.asList("tBu");
        List texts = AbbreviationLabel.format(tokens);
        MatcherAssert.assertThat((Object)texts.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)0)).text, (Matcher)CoreMatchers.is((Object)"t"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)0)).style, (Matcher)CoreMatchers.is((Object)AbbreviationLabel.STYLE_ITALIC));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)1)).text, (Matcher)CoreMatchers.is((Object)"Bu"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)1)).style, (Matcher)CoreMatchers.is((Object)AbbreviationLabel.STYLE_NORMAL));
    }

    @Test
    public void NEt3DotHCl() {
        ArrayList tokens = new ArrayList();
        Assert.assertTrue((boolean)AbbreviationLabel.parse((String)"NEt3\u00b7HCl", tokens));
        MatcherAssert.assertThat((Object)tokens.size(), (Matcher)CoreMatchers.is((Object)5));
        MatcherAssert.assertThat(tokens.get(0), (Matcher)CoreMatchers.is((Object)"N"));
        MatcherAssert.assertThat(tokens.get(1), (Matcher)CoreMatchers.is((Object)"Et3"));
        MatcherAssert.assertThat(tokens.get(2), (Matcher)CoreMatchers.is((Object)"\u00b7"));
        MatcherAssert.assertThat(tokens.get(3), (Matcher)CoreMatchers.is((Object)"H"));
        MatcherAssert.assertThat(tokens.get(4), (Matcher)CoreMatchers.is((Object)"Cl"));
        List formatted = AbbreviationLabel.format(tokens);
        AbbreviationLabel.reduce((List)formatted, (int)0, (int)formatted.size());
        MatcherAssert.assertThat((Object)formatted.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)0)).text, (Matcher)CoreMatchers.is((Object)"NEt"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)0)).style, (Matcher)CoreMatchers.is((Object)AbbreviationLabel.STYLE_NORMAL));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)1)).text, (Matcher)CoreMatchers.is((Object)"3"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)1)).style, (Matcher)CoreMatchers.is((Object)AbbreviationLabel.STYLE_SUBSCRIPT));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)2)).text, (Matcher)CoreMatchers.is((Object)"\u00b7HCl"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)formatted.get((int)2)).style, (Matcher)CoreMatchers.is((Object)AbbreviationLabel.STYLE_NORMAL));
    }

    @Test
    public void formatOPO3H2() {
        List<String> tokens = Arrays.asList("O", "P", "O3", "H2");
        List texts = AbbreviationLabel.format(tokens);
        AbbreviationLabel.reduce((List)texts, (int)0, (int)texts.size());
        MatcherAssert.assertThat((Object)texts.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)0)).text, (Matcher)CoreMatchers.is((Object)"OPO"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)0)).style, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)1)).text, (Matcher)CoreMatchers.is((Object)"3"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)1)).style, (Matcher)CoreMatchers.is((Object)-1));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)2)).text, (Matcher)CoreMatchers.is((Object)"H"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)2)).style, (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)3)).text, (Matcher)CoreMatchers.is((Object)"2"));
        MatcherAssert.assertThat((Object)((AbbreviationLabel.FormattedText)texts.get((int)3)).style, (Matcher)CoreMatchers.is((Object)-1));
    }

    @Test
    public void hydrate() {
        ArrayList tokens = new ArrayList();
        AbbreviationLabel.parse((String)"\u2022H2O", tokens);
        MatcherAssert.assertThat(tokens, (Matcher)CoreMatchers.is(Arrays.asList("\u2022", "H2", "O")));
    }

    @Test
    public void het() {
        Assert.assertFalse((boolean)AbbreviationLabel.parse((String)"Het", new ArrayList()));
    }

    @Test
    public void parseChargeOnly() {
        Assert.assertFalse((boolean)AbbreviationLabel.parse((String)"+", new ArrayList()));
    }

    @Test
    public void parseNumberOnly() {
        Assert.assertFalse((boolean)AbbreviationLabel.parse((String)"1", new ArrayList()));
    }

    @Test
    public void nonAsciiLabel() {
        Assert.assertFalse((boolean)AbbreviationLabel.parse((String)"\u82ef\u57fa", new ArrayList()));
    }
}

