/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.IsCloseTo;
import org.junit.Test;
import org.openscience.cdk.renderer.generators.standard.ConvexHull;

public class ConvexHullTest {
    @Test
    public void ofOvalShape() throws Exception {
        RoundRectangle2D.Double oval = new RoundRectangle2D.Double(-5.0, -5.0, 10.0, 10.0, 5.0, 5.0);
        ConvexHull hull = ConvexHull.ofShape((Shape)oval);
        Rectangle2D bounds = hull.outline().getBounds2D();
        MatcherAssert.assertThat((Object)bounds.getMinX(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMinY(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
    }

    @Test
    public void ofTriangle() throws Exception {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-5.0, 0.0);
        ((Path2D)path).lineTo(0.0, 10.0);
        ((Path2D)path).lineTo(5.0, 0.0);
        path.closePath();
        ConvexHull hull = ConvexHull.ofShape((Shape)path);
        Rectangle2D bounds = hull.outline().getBounds2D();
        MatcherAssert.assertThat((Object)bounds.getMinX(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMinY(), (Matcher)IsCloseTo.closeTo((double)0.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)10.0, (double)0.01));
    }

    @Test
    public void ofRectangles() throws Exception {
        Rectangle2D.Double rect1 = new Rectangle2D.Double(-10.0, -10.0, 5.0, 5.0);
        Rectangle2D.Double rect2 = new Rectangle2D.Double(15.0, 16.0, 20.0, 25.0);
        Rectangle2D.Double rect3 = new Rectangle2D.Double(-15.0, 6.0, 2.0, 5.0);
        ConvexHull hull = ConvexHull.ofShapes(Arrays.asList(rect1, rect2, rect3));
        Rectangle2D bounds = hull.outline().getBounds2D();
        MatcherAssert.assertThat((Object)bounds.getMinX(), (Matcher)IsCloseTo.closeTo((double)-15.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMinY(), (Matcher)IsCloseTo.closeTo((double)-10.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)35.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)41.0, (double)0.01));
    }

    @Test
    public void transformDoesNotModifyOriginal() throws Exception {
        Rectangle2D.Double rect1 = new Rectangle2D.Double(-10.0, -10.0, 5.0, 5.0);
        Rectangle2D.Double rect2 = new Rectangle2D.Double(15.0, 16.0, 20.0, 25.0);
        Rectangle2D.Double rect3 = new Rectangle2D.Double(-15.0, 6.0, 2.0, 5.0);
        ConvexHull hull = ConvexHull.ofShapes(Arrays.asList(rect1, rect2, rect3));
        ConvexHull transformedHull = hull.transform(AffineTransform.getTranslateInstance(10.0, 15.0));
        Rectangle2D bounds = hull.outline().getBounds2D();
        Rectangle2D transformedBounds = transformedHull.outline().getBounds2D();
        MatcherAssert.assertThat((Object)bounds.getMinX(), (Matcher)CoreMatchers.not((Matcher)IsCloseTo.closeTo((double)transformedBounds.getMinX(), (double)0.01)));
        MatcherAssert.assertThat((Object)bounds.getMinY(), (Matcher)CoreMatchers.not((Matcher)IsCloseTo.closeTo((double)transformedBounds.getMinY(), (double)0.01)));
        MatcherAssert.assertThat((Object)bounds.getMaxX(), (Matcher)CoreMatchers.not((Matcher)IsCloseTo.closeTo((double)transformedBounds.getMaxX(), (double)0.01)));
        MatcherAssert.assertThat((Object)bounds.getMaxY(), (Matcher)CoreMatchers.not((Matcher)IsCloseTo.closeTo((double)transformedBounds.getMaxY(), (double)0.01)));
    }

    @Test
    public void testShapeOf() throws Exception {
        List<Point2D> points = Arrays.asList(new Point2D.Double(-5.0, -5.0), new Point2D.Double(-5.0, 5.0), new Point2D.Double(5.0, 5.0), new Point2D.Double(5.0, -5.0));
        Rectangle2D bounds = ConvexHull.shapeOf(points).getBounds2D();
        MatcherAssert.assertThat((Object)bounds.getMinX(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMinY(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMaxX(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
        MatcherAssert.assertThat((Object)bounds.getMaxY(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
    }

    @Test
    public void emptyShapeDoesBreak() throws Exception {
        Shape shape = ConvexHull.shapeOf(Collections.emptyList());
    }

    @Test
    public void testPointsOf() throws Exception {
        Rectangle2D.Double rect = new Rectangle2D.Double(-5.0, -5.0, 10.0, 10.0);
        List points = ConvexHull.pointsOf((Shape)rect);
        MatcherAssert.assertThat((Object)points.size(), (Matcher)CoreMatchers.is((Object)4));
        MatcherAssert.assertThat((Object)((Point2D)points.get(0)).getX(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)((Point2D)points.get(0)).getY(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)((Point2D)points.get(1)).getX(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
        MatcherAssert.assertThat((Object)((Point2D)points.get(1)).getY(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)((Point2D)points.get(2)).getX(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
        MatcherAssert.assertThat((Object)((Point2D)points.get(2)).getY(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
        MatcherAssert.assertThat((Object)((Point2D)points.get(3)).getX(), (Matcher)IsCloseTo.closeTo((double)-5.0, (double)0.01));
        MatcherAssert.assertThat((Object)((Point2D)points.get(3)).getY(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
    }

    @Test
    public void intersectionOfRect() throws Exception {
        Rectangle2D.Double rect = new Rectangle2D.Double(-5.0, -5.0, 10.0, 10.0);
        ConvexHull hull = ConvexHull.ofShape((Shape)rect);
        Point2D intersect = hull.intersect((Point2D)new Point2D.Double(0.0, 0.0), (Point2D)new Point2D.Double(10.0, 0.0));
        MatcherAssert.assertThat((Object)intersect.getX(), (Matcher)IsCloseTo.closeTo((double)5.0, (double)0.01));
        MatcherAssert.assertThat((Object)intersect.getY(), (Matcher)IsCloseTo.closeTo((double)0.0, (double)0.01));
    }
}

