package org.patternfly.icon;

import javax.annotation.processing.Generated;

/**
 * This interface provides methods for accessing all icons in PatternFly Java. The icons are grouped in four interfaces:
 * <dl>
 *     <dt>{@link fab}</dt>
 *     <dd><a href="https://fontawesome.com/search?o=r&m=free&f=brands">Fontawesome brand icons</a></dd>
 *     <dt>{@link far}</dt>
 *     <dd><a href="https://fontawesome.com/search?o=r&m=free&s=regular">Fontawesome regular icons</a></dd>
 *     <dt>{@link fas}</dt>
 *     <dd><a href="https://fontawesome.com/search?o=r&m=free&s=solid">Fontawesome solid icons</a></dd>
 *     <dt>{@link patternfly}</dt>
 *     <dd><a href="https://www.patternfly.org/design-foundations/icons/#patternfly-icons">PatternFly icons</a></dd>
 * </dl>
 * <p>The icons are retunred as {@link PredefinedIcon}s and can be adjusted if necessary.</p>
 * @see <a href="https://www.patternfly.org/design-foundations/icons/">https://www.patternfly.org/design-foundations/icons/</a>
 * @see <a href="https://fontawesome.com/icons?d=gallery&m=free">https://fontawesome.com/icons?d=gallery&m=free</a>
 */
@Generated("generate.ts")
@SuppressWarnings("SpellCheckingInspection")
// WARNING: This class is generated. Do not modify.
public interface IconSets {
    public interface fab {
        static PredefinedIcon fiveHundredPx() { return new PredefinedIcon(IconSpecs.fab.fiveHundredPx.iconSpec); }
        static PredefinedIcon accessibleIcon() { return new PredefinedIcon(IconSpecs.fab.accessibleIcon.iconSpec); }
        static PredefinedIcon accusoft() { return new PredefinedIcon(IconSpecs.fab.accusoft.iconSpec); }
        static PredefinedIcon acquisitionsIncorporated() { return new PredefinedIcon(IconSpecs.fab.acquisitionsIncorporated.iconSpec); }
        static PredefinedIcon adn() { return new PredefinedIcon(IconSpecs.fab.adn.iconSpec); }
        static PredefinedIcon adversal() { return new PredefinedIcon(IconSpecs.fab.adversal.iconSpec); }
        static PredefinedIcon affiliatetheme() { return new PredefinedIcon(IconSpecs.fab.affiliatetheme.iconSpec); }
        static PredefinedIcon airbnb() { return new PredefinedIcon(IconSpecs.fab.airbnb.iconSpec); }
        static PredefinedIcon algolia() { return new PredefinedIcon(IconSpecs.fab.algolia.iconSpec); }
        static PredefinedIcon alipay() { return new PredefinedIcon(IconSpecs.fab.alipay.iconSpec); }
        static PredefinedIcon amazon() { return new PredefinedIcon(IconSpecs.fab.amazon.iconSpec); }
        static PredefinedIcon amazonPay() { return new PredefinedIcon(IconSpecs.fab.amazonPay.iconSpec); }
        static PredefinedIcon amilia() { return new PredefinedIcon(IconSpecs.fab.amilia.iconSpec); }
        static PredefinedIcon android() { return new PredefinedIcon(IconSpecs.fab.android.iconSpec); }
        static PredefinedIcon angellist() { return new PredefinedIcon(IconSpecs.fab.angellist.iconSpec); }
        static PredefinedIcon angrycreative() { return new PredefinedIcon(IconSpecs.fab.angrycreative.iconSpec); }
        static PredefinedIcon angular() { return new PredefinedIcon(IconSpecs.fab.angular.iconSpec); }
        static PredefinedIcon appStore() { return new PredefinedIcon(IconSpecs.fab.appStore.iconSpec); }
        static PredefinedIcon appStoreIos() { return new PredefinedIcon(IconSpecs.fab.appStoreIos.iconSpec); }
        static PredefinedIcon apper() { return new PredefinedIcon(IconSpecs.fab.apper.iconSpec); }
        static PredefinedIcon apple() { return new PredefinedIcon(IconSpecs.fab.apple.iconSpec); }
        static PredefinedIcon applePay() { return new PredefinedIcon(IconSpecs.fab.applePay.iconSpec); }
        static PredefinedIcon artstation() { return new PredefinedIcon(IconSpecs.fab.artstation.iconSpec); }
        static PredefinedIcon asymmetrik() { return new PredefinedIcon(IconSpecs.fab.asymmetrik.iconSpec); }
        static PredefinedIcon atlassian() { return new PredefinedIcon(IconSpecs.fab.atlassian.iconSpec); }
        static PredefinedIcon audible() { return new PredefinedIcon(IconSpecs.fab.audible.iconSpec); }
        static PredefinedIcon autoprefixer() { return new PredefinedIcon(IconSpecs.fab.autoprefixer.iconSpec); }
        static PredefinedIcon avianex() { return new PredefinedIcon(IconSpecs.fab.avianex.iconSpec); }
        static PredefinedIcon aviato() { return new PredefinedIcon(IconSpecs.fab.aviato.iconSpec); }
        static PredefinedIcon aws() { return new PredefinedIcon(IconSpecs.fab.aws.iconSpec); }
        static PredefinedIcon bandcamp() { return new PredefinedIcon(IconSpecs.fab.bandcamp.iconSpec); }
        static PredefinedIcon battleNet() { return new PredefinedIcon(IconSpecs.fab.battleNet.iconSpec); }
        static PredefinedIcon behance() { return new PredefinedIcon(IconSpecs.fab.behance.iconSpec); }
        static PredefinedIcon behanceSquare() { return new PredefinedIcon(IconSpecs.fab.behanceSquare.iconSpec); }
        static PredefinedIcon bimobject() { return new PredefinedIcon(IconSpecs.fab.bimobject.iconSpec); }
        static PredefinedIcon bitbucket() { return new PredefinedIcon(IconSpecs.fab.bitbucket.iconSpec); }
        static PredefinedIcon bitcoin() { return new PredefinedIcon(IconSpecs.fab.bitcoin.iconSpec); }
        static PredefinedIcon bity() { return new PredefinedIcon(IconSpecs.fab.bity.iconSpec); }
        static PredefinedIcon blackTie() { return new PredefinedIcon(IconSpecs.fab.blackTie.iconSpec); }
        static PredefinedIcon blackberry() { return new PredefinedIcon(IconSpecs.fab.blackberry.iconSpec); }
        static PredefinedIcon blogger() { return new PredefinedIcon(IconSpecs.fab.blogger.iconSpec); }
        static PredefinedIcon bloggerB() { return new PredefinedIcon(IconSpecs.fab.bloggerB.iconSpec); }
        static PredefinedIcon bluetooth() { return new PredefinedIcon(IconSpecs.fab.bluetooth.iconSpec); }
        static PredefinedIcon bluetoothB() { return new PredefinedIcon(IconSpecs.fab.bluetoothB.iconSpec); }
        static PredefinedIcon bootstrap() { return new PredefinedIcon(IconSpecs.fab.bootstrap.iconSpec); }
        static PredefinedIcon btc() { return new PredefinedIcon(IconSpecs.fab.btc.iconSpec); }
        static PredefinedIcon buffer() { return new PredefinedIcon(IconSpecs.fab.buffer.iconSpec); }
        static PredefinedIcon buromobelexperte() { return new PredefinedIcon(IconSpecs.fab.buromobelexperte.iconSpec); }
        static PredefinedIcon buyNLarge() { return new PredefinedIcon(IconSpecs.fab.buyNLarge.iconSpec); }
        static PredefinedIcon buysellads() { return new PredefinedIcon(IconSpecs.fab.buysellads.iconSpec); }
        static PredefinedIcon canadianMapleLeaf() { return new PredefinedIcon(IconSpecs.fab.canadianMapleLeaf.iconSpec); }
        static PredefinedIcon ccAmazonPay() { return new PredefinedIcon(IconSpecs.fab.ccAmazonPay.iconSpec); }
        static PredefinedIcon ccAmex() { return new PredefinedIcon(IconSpecs.fab.ccAmex.iconSpec); }
        static PredefinedIcon ccApplePay() { return new PredefinedIcon(IconSpecs.fab.ccApplePay.iconSpec); }
        static PredefinedIcon ccDinersClub() { return new PredefinedIcon(IconSpecs.fab.ccDinersClub.iconSpec); }
        static PredefinedIcon ccDiscover() { return new PredefinedIcon(IconSpecs.fab.ccDiscover.iconSpec); }
        static PredefinedIcon ccJcb() { return new PredefinedIcon(IconSpecs.fab.ccJcb.iconSpec); }
        static PredefinedIcon ccMastercard() { return new PredefinedIcon(IconSpecs.fab.ccMastercard.iconSpec); }
        static PredefinedIcon ccPaypal() { return new PredefinedIcon(IconSpecs.fab.ccPaypal.iconSpec); }
        static PredefinedIcon ccStripe() { return new PredefinedIcon(IconSpecs.fab.ccStripe.iconSpec); }
        static PredefinedIcon ccVisa() { return new PredefinedIcon(IconSpecs.fab.ccVisa.iconSpec); }
        static PredefinedIcon centercode() { return new PredefinedIcon(IconSpecs.fab.centercode.iconSpec); }
        static PredefinedIcon centos() { return new PredefinedIcon(IconSpecs.fab.centos.iconSpec); }
        static PredefinedIcon chrome() { return new PredefinedIcon(IconSpecs.fab.chrome.iconSpec); }
        static PredefinedIcon chromecast() { return new PredefinedIcon(IconSpecs.fab.chromecast.iconSpec); }
        static PredefinedIcon cloudflare() { return new PredefinedIcon(IconSpecs.fab.cloudflare.iconSpec); }
        static PredefinedIcon cloudscale() { return new PredefinedIcon(IconSpecs.fab.cloudscale.iconSpec); }
        static PredefinedIcon cloudsmith() { return new PredefinedIcon(IconSpecs.fab.cloudsmith.iconSpec); }
        static PredefinedIcon cloudversify() { return new PredefinedIcon(IconSpecs.fab.cloudversify.iconSpec); }
        static PredefinedIcon codepen() { return new PredefinedIcon(IconSpecs.fab.codepen.iconSpec); }
        static PredefinedIcon codiepie() { return new PredefinedIcon(IconSpecs.fab.codiepie.iconSpec); }
        static PredefinedIcon confluence() { return new PredefinedIcon(IconSpecs.fab.confluence.iconSpec); }
        static PredefinedIcon connectdevelop() { return new PredefinedIcon(IconSpecs.fab.connectdevelop.iconSpec); }
        static PredefinedIcon contao() { return new PredefinedIcon(IconSpecs.fab.contao.iconSpec); }
        static PredefinedIcon cottonBureau() { return new PredefinedIcon(IconSpecs.fab.cottonBureau.iconSpec); }
        static PredefinedIcon cpanel() { return new PredefinedIcon(IconSpecs.fab.cpanel.iconSpec); }
        static PredefinedIcon creativeCommons() { return new PredefinedIcon(IconSpecs.fab.creativeCommons.iconSpec); }
        static PredefinedIcon creativeCommonsBy() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsBy.iconSpec); }
        static PredefinedIcon creativeCommonsNc() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsNc.iconSpec); }
        static PredefinedIcon creativeCommonsNcEu() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsNcEu.iconSpec); }
        static PredefinedIcon creativeCommonsNcJp() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsNcJp.iconSpec); }
        static PredefinedIcon creativeCommonsNd() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsNd.iconSpec); }
        static PredefinedIcon creativeCommonsPd() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsPd.iconSpec); }
        static PredefinedIcon creativeCommonsPdAlt() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsPdAlt.iconSpec); }
        static PredefinedIcon creativeCommonsRemix() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsRemix.iconSpec); }
        static PredefinedIcon creativeCommonsSa() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsSa.iconSpec); }
        static PredefinedIcon creativeCommonsSampling() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsSampling.iconSpec); }
        static PredefinedIcon creativeCommonsSamplingPlus() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsSamplingPlus.iconSpec); }
        static PredefinedIcon creativeCommonsShare() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsShare.iconSpec); }
        static PredefinedIcon creativeCommonsZero() { return new PredefinedIcon(IconSpecs.fab.creativeCommonsZero.iconSpec); }
        static PredefinedIcon criticalRole() { return new PredefinedIcon(IconSpecs.fab.criticalRole.iconSpec); }
        static PredefinedIcon css3() { return new PredefinedIcon(IconSpecs.fab.css3.iconSpec); }
        static PredefinedIcon css3Alt() { return new PredefinedIcon(IconSpecs.fab.css3Alt.iconSpec); }
        static PredefinedIcon cuttlefish() { return new PredefinedIcon(IconSpecs.fab.cuttlefish.iconSpec); }
        static PredefinedIcon dAndD() { return new PredefinedIcon(IconSpecs.fab.dAndD.iconSpec); }
        static PredefinedIcon dAndDBeyond() { return new PredefinedIcon(IconSpecs.fab.dAndDBeyond.iconSpec); }
        static PredefinedIcon dailymotion() { return new PredefinedIcon(IconSpecs.fab.dailymotion.iconSpec); }
        static PredefinedIcon dashcube() { return new PredefinedIcon(IconSpecs.fab.dashcube.iconSpec); }
        static PredefinedIcon deezer() { return new PredefinedIcon(IconSpecs.fab.deezer.iconSpec); }
        static PredefinedIcon delicious() { return new PredefinedIcon(IconSpecs.fab.delicious.iconSpec); }
        static PredefinedIcon deploydog() { return new PredefinedIcon(IconSpecs.fab.deploydog.iconSpec); }
        static PredefinedIcon deskpro() { return new PredefinedIcon(IconSpecs.fab.deskpro.iconSpec); }
        static PredefinedIcon dev() { return new PredefinedIcon(IconSpecs.fab.dev.iconSpec); }
        static PredefinedIcon deviantart() { return new PredefinedIcon(IconSpecs.fab.deviantart.iconSpec); }
        static PredefinedIcon dhl() { return new PredefinedIcon(IconSpecs.fab.dhl.iconSpec); }
        static PredefinedIcon diaspora() { return new PredefinedIcon(IconSpecs.fab.diaspora.iconSpec); }
        static PredefinedIcon digg() { return new PredefinedIcon(IconSpecs.fab.digg.iconSpec); }
        static PredefinedIcon digitalOcean() { return new PredefinedIcon(IconSpecs.fab.digitalOcean.iconSpec); }
        static PredefinedIcon discord() { return new PredefinedIcon(IconSpecs.fab.discord.iconSpec); }
        static PredefinedIcon discourse() { return new PredefinedIcon(IconSpecs.fab.discourse.iconSpec); }
        static PredefinedIcon dochub() { return new PredefinedIcon(IconSpecs.fab.dochub.iconSpec); }
        static PredefinedIcon docker() { return new PredefinedIcon(IconSpecs.fab.docker.iconSpec); }
        static PredefinedIcon draft2Digital() { return new PredefinedIcon(IconSpecs.fab.draft2Digital.iconSpec); }
        static PredefinedIcon dribbble() { return new PredefinedIcon(IconSpecs.fab.dribbble.iconSpec); }
        static PredefinedIcon dribbbleSquare() { return new PredefinedIcon(IconSpecs.fab.dribbbleSquare.iconSpec); }
        static PredefinedIcon dropbox() { return new PredefinedIcon(IconSpecs.fab.dropbox.iconSpec); }
        static PredefinedIcon drupal() { return new PredefinedIcon(IconSpecs.fab.drupal.iconSpec); }
        static PredefinedIcon dyalog() { return new PredefinedIcon(IconSpecs.fab.dyalog.iconSpec); }
        static PredefinedIcon earlybirds() { return new PredefinedIcon(IconSpecs.fab.earlybirds.iconSpec); }
        static PredefinedIcon ebay() { return new PredefinedIcon(IconSpecs.fab.ebay.iconSpec); }
        static PredefinedIcon edge() { return new PredefinedIcon(IconSpecs.fab.edge.iconSpec); }
        static PredefinedIcon edgeLegacy() { return new PredefinedIcon(IconSpecs.fab.edgeLegacy.iconSpec); }
        static PredefinedIcon elementor() { return new PredefinedIcon(IconSpecs.fab.elementor.iconSpec); }
        static PredefinedIcon ello() { return new PredefinedIcon(IconSpecs.fab.ello.iconSpec); }
        static PredefinedIcon ember() { return new PredefinedIcon(IconSpecs.fab.ember.iconSpec); }
        static PredefinedIcon empire() { return new PredefinedIcon(IconSpecs.fab.empire.iconSpec); }
        static PredefinedIcon envira() { return new PredefinedIcon(IconSpecs.fab.envira.iconSpec); }
        static PredefinedIcon erlang() { return new PredefinedIcon(IconSpecs.fab.erlang.iconSpec); }
        static PredefinedIcon ethereum() { return new PredefinedIcon(IconSpecs.fab.ethereum.iconSpec); }
        static PredefinedIcon etsy() { return new PredefinedIcon(IconSpecs.fab.etsy.iconSpec); }
        static PredefinedIcon evernote() { return new PredefinedIcon(IconSpecs.fab.evernote.iconSpec); }
        static PredefinedIcon expeditedssl() { return new PredefinedIcon(IconSpecs.fab.expeditedssl.iconSpec); }
        static PredefinedIcon facebook() { return new PredefinedIcon(IconSpecs.fab.facebook.iconSpec); }
        static PredefinedIcon facebookF() { return new PredefinedIcon(IconSpecs.fab.facebookF.iconSpec); }
        static PredefinedIcon facebookMessenger() { return new PredefinedIcon(IconSpecs.fab.facebookMessenger.iconSpec); }
        static PredefinedIcon facebookSquare() { return new PredefinedIcon(IconSpecs.fab.facebookSquare.iconSpec); }
        static PredefinedIcon fantasyFlightGames() { return new PredefinedIcon(IconSpecs.fab.fantasyFlightGames.iconSpec); }
        static PredefinedIcon fedex() { return new PredefinedIcon(IconSpecs.fab.fedex.iconSpec); }
        static PredefinedIcon fedora() { return new PredefinedIcon(IconSpecs.fab.fedora.iconSpec); }
        static PredefinedIcon figma() { return new PredefinedIcon(IconSpecs.fab.figma.iconSpec); }
        static PredefinedIcon firefox() { return new PredefinedIcon(IconSpecs.fab.firefox.iconSpec); }
        static PredefinedIcon firefoxBrowser() { return new PredefinedIcon(IconSpecs.fab.firefoxBrowser.iconSpec); }
        static PredefinedIcon firstOrder() { return new PredefinedIcon(IconSpecs.fab.firstOrder.iconSpec); }
        static PredefinedIcon firstOrderAlt() { return new PredefinedIcon(IconSpecs.fab.firstOrderAlt.iconSpec); }
        static PredefinedIcon firstdraft() { return new PredefinedIcon(IconSpecs.fab.firstdraft.iconSpec); }
        static PredefinedIcon flickr() { return new PredefinedIcon(IconSpecs.fab.flickr.iconSpec); }
        static PredefinedIcon flipboard() { return new PredefinedIcon(IconSpecs.fab.flipboard.iconSpec); }
        static PredefinedIcon fly() { return new PredefinedIcon(IconSpecs.fab.fly.iconSpec); }
        static PredefinedIcon fontAwesome() { return new PredefinedIcon(IconSpecs.fab.fontAwesome.iconSpec); }
        static PredefinedIcon fontAwesomeAlt() { return new PredefinedIcon(IconSpecs.fab.fontAwesomeAlt.iconSpec); }
        static PredefinedIcon fontAwesomeFlag() { return new PredefinedIcon(IconSpecs.fab.fontAwesomeFlag.iconSpec); }
        static PredefinedIcon fonticons() { return new PredefinedIcon(IconSpecs.fab.fonticons.iconSpec); }
        static PredefinedIcon fonticonsFi() { return new PredefinedIcon(IconSpecs.fab.fonticonsFi.iconSpec); }
        static PredefinedIcon fortAwesome() { return new PredefinedIcon(IconSpecs.fab.fortAwesome.iconSpec); }
        static PredefinedIcon fortAwesomeAlt() { return new PredefinedIcon(IconSpecs.fab.fortAwesomeAlt.iconSpec); }
        static PredefinedIcon forumbee() { return new PredefinedIcon(IconSpecs.fab.forumbee.iconSpec); }
        static PredefinedIcon foursquare() { return new PredefinedIcon(IconSpecs.fab.foursquare.iconSpec); }
        static PredefinedIcon freeCodeCamp() { return new PredefinedIcon(IconSpecs.fab.freeCodeCamp.iconSpec); }
        static PredefinedIcon freebsd() { return new PredefinedIcon(IconSpecs.fab.freebsd.iconSpec); }
        static PredefinedIcon fulcrum() { return new PredefinedIcon(IconSpecs.fab.fulcrum.iconSpec); }
        static PredefinedIcon galacticRepublic() { return new PredefinedIcon(IconSpecs.fab.galacticRepublic.iconSpec); }
        static PredefinedIcon galacticSenate() { return new PredefinedIcon(IconSpecs.fab.galacticSenate.iconSpec); }
        static PredefinedIcon getPocket() { return new PredefinedIcon(IconSpecs.fab.getPocket.iconSpec); }
        static PredefinedIcon gg() { return new PredefinedIcon(IconSpecs.fab.gg.iconSpec); }
        static PredefinedIcon ggCircle() { return new PredefinedIcon(IconSpecs.fab.ggCircle.iconSpec); }
        static PredefinedIcon git() { return new PredefinedIcon(IconSpecs.fab.git.iconSpec); }
        static PredefinedIcon gitAlt() { return new PredefinedIcon(IconSpecs.fab.gitAlt.iconSpec); }
        static PredefinedIcon gitSquare() { return new PredefinedIcon(IconSpecs.fab.gitSquare.iconSpec); }
        static PredefinedIcon github() { return new PredefinedIcon(IconSpecs.fab.github.iconSpec); }
        static PredefinedIcon githubAlt() { return new PredefinedIcon(IconSpecs.fab.githubAlt.iconSpec); }
        static PredefinedIcon githubSquare() { return new PredefinedIcon(IconSpecs.fab.githubSquare.iconSpec); }
        static PredefinedIcon gitkraken() { return new PredefinedIcon(IconSpecs.fab.gitkraken.iconSpec); }
        static PredefinedIcon gitlab() { return new PredefinedIcon(IconSpecs.fab.gitlab.iconSpec); }
        static PredefinedIcon gitter() { return new PredefinedIcon(IconSpecs.fab.gitter.iconSpec); }
        static PredefinedIcon glide() { return new PredefinedIcon(IconSpecs.fab.glide.iconSpec); }
        static PredefinedIcon glideG() { return new PredefinedIcon(IconSpecs.fab.glideG.iconSpec); }
        static PredefinedIcon gofore() { return new PredefinedIcon(IconSpecs.fab.gofore.iconSpec); }
        static PredefinedIcon goodreads() { return new PredefinedIcon(IconSpecs.fab.goodreads.iconSpec); }
        static PredefinedIcon goodreadsG() { return new PredefinedIcon(IconSpecs.fab.goodreadsG.iconSpec); }
        static PredefinedIcon google() { return new PredefinedIcon(IconSpecs.fab.google.iconSpec); }
        static PredefinedIcon googleDrive() { return new PredefinedIcon(IconSpecs.fab.googleDrive.iconSpec); }
        static PredefinedIcon googlePay() { return new PredefinedIcon(IconSpecs.fab.googlePay.iconSpec); }
        static PredefinedIcon googlePlay() { return new PredefinedIcon(IconSpecs.fab.googlePlay.iconSpec); }
        static PredefinedIcon googlePlus() { return new PredefinedIcon(IconSpecs.fab.googlePlus.iconSpec); }
        static PredefinedIcon googlePlusG() { return new PredefinedIcon(IconSpecs.fab.googlePlusG.iconSpec); }
        static PredefinedIcon googlePlusSquare() { return new PredefinedIcon(IconSpecs.fab.googlePlusSquare.iconSpec); }
        static PredefinedIcon googleWallet() { return new PredefinedIcon(IconSpecs.fab.googleWallet.iconSpec); }
        static PredefinedIcon gratipay() { return new PredefinedIcon(IconSpecs.fab.gratipay.iconSpec); }
        static PredefinedIcon grav() { return new PredefinedIcon(IconSpecs.fab.grav.iconSpec); }
        static PredefinedIcon gripfire() { return new PredefinedIcon(IconSpecs.fab.gripfire.iconSpec); }
        static PredefinedIcon grunt() { return new PredefinedIcon(IconSpecs.fab.grunt.iconSpec); }
        static PredefinedIcon guilded() { return new PredefinedIcon(IconSpecs.fab.guilded.iconSpec); }
        static PredefinedIcon gulp() { return new PredefinedIcon(IconSpecs.fab.gulp.iconSpec); }
        static PredefinedIcon hackerNews() { return new PredefinedIcon(IconSpecs.fab.hackerNews.iconSpec); }
        static PredefinedIcon hackerNewsSquare() { return new PredefinedIcon(IconSpecs.fab.hackerNewsSquare.iconSpec); }
        static PredefinedIcon hackerrank() { return new PredefinedIcon(IconSpecs.fab.hackerrank.iconSpec); }
        static PredefinedIcon hips() { return new PredefinedIcon(IconSpecs.fab.hips.iconSpec); }
        static PredefinedIcon hireAHelper() { return new PredefinedIcon(IconSpecs.fab.hireAHelper.iconSpec); }
        static PredefinedIcon hive() { return new PredefinedIcon(IconSpecs.fab.hive.iconSpec); }
        static PredefinedIcon hooli() { return new PredefinedIcon(IconSpecs.fab.hooli.iconSpec); }
        static PredefinedIcon hornbill() { return new PredefinedIcon(IconSpecs.fab.hornbill.iconSpec); }
        static PredefinedIcon hotjar() { return new PredefinedIcon(IconSpecs.fab.hotjar.iconSpec); }
        static PredefinedIcon houzz() { return new PredefinedIcon(IconSpecs.fab.houzz.iconSpec); }
        static PredefinedIcon html5() { return new PredefinedIcon(IconSpecs.fab.html5.iconSpec); }
        static PredefinedIcon hubspot() { return new PredefinedIcon(IconSpecs.fab.hubspot.iconSpec); }
        static PredefinedIcon ideal() { return new PredefinedIcon(IconSpecs.fab.ideal.iconSpec); }
        static PredefinedIcon imdb() { return new PredefinedIcon(IconSpecs.fab.imdb.iconSpec); }
        static PredefinedIcon innosoft() { return new PredefinedIcon(IconSpecs.fab.innosoft.iconSpec); }
        static PredefinedIcon instagram() { return new PredefinedIcon(IconSpecs.fab.instagram.iconSpec); }
        static PredefinedIcon instagramSquare() { return new PredefinedIcon(IconSpecs.fab.instagramSquare.iconSpec); }
        static PredefinedIcon instalod() { return new PredefinedIcon(IconSpecs.fab.instalod.iconSpec); }
        static PredefinedIcon intercom() { return new PredefinedIcon(IconSpecs.fab.intercom.iconSpec); }
        static PredefinedIcon internetExplorer() { return new PredefinedIcon(IconSpecs.fab.internetExplorer.iconSpec); }
        static PredefinedIcon invision() { return new PredefinedIcon(IconSpecs.fab.invision.iconSpec); }
        static PredefinedIcon ioxhost() { return new PredefinedIcon(IconSpecs.fab.ioxhost.iconSpec); }
        static PredefinedIcon itchIo() { return new PredefinedIcon(IconSpecs.fab.itchIo.iconSpec); }
        static PredefinedIcon itunes() { return new PredefinedIcon(IconSpecs.fab.itunes.iconSpec); }
        static PredefinedIcon itunesNote() { return new PredefinedIcon(IconSpecs.fab.itunesNote.iconSpec); }
        static PredefinedIcon java() { return new PredefinedIcon(IconSpecs.fab.java.iconSpec); }
        static PredefinedIcon jediOrder() { return new PredefinedIcon(IconSpecs.fab.jediOrder.iconSpec); }
        static PredefinedIcon jenkins() { return new PredefinedIcon(IconSpecs.fab.jenkins.iconSpec); }
        static PredefinedIcon jira() { return new PredefinedIcon(IconSpecs.fab.jira.iconSpec); }
        static PredefinedIcon joget() { return new PredefinedIcon(IconSpecs.fab.joget.iconSpec); }
        static PredefinedIcon joomla() { return new PredefinedIcon(IconSpecs.fab.joomla.iconSpec); }
        static PredefinedIcon js() { return new PredefinedIcon(IconSpecs.fab.js.iconSpec); }
        static PredefinedIcon jsSquare() { return new PredefinedIcon(IconSpecs.fab.jsSquare.iconSpec); }
        static PredefinedIcon jsfiddle() { return new PredefinedIcon(IconSpecs.fab.jsfiddle.iconSpec); }
        static PredefinedIcon kaggle() { return new PredefinedIcon(IconSpecs.fab.kaggle.iconSpec); }
        static PredefinedIcon keybase() { return new PredefinedIcon(IconSpecs.fab.keybase.iconSpec); }
        static PredefinedIcon keycdn() { return new PredefinedIcon(IconSpecs.fab.keycdn.iconSpec); }
        static PredefinedIcon kickstarter() { return new PredefinedIcon(IconSpecs.fab.kickstarter.iconSpec); }
        static PredefinedIcon kickstarterK() { return new PredefinedIcon(IconSpecs.fab.kickstarterK.iconSpec); }
        static PredefinedIcon korvue() { return new PredefinedIcon(IconSpecs.fab.korvue.iconSpec); }
        static PredefinedIcon laravel() { return new PredefinedIcon(IconSpecs.fab.laravel.iconSpec); }
        static PredefinedIcon lastfm() { return new PredefinedIcon(IconSpecs.fab.lastfm.iconSpec); }
        static PredefinedIcon lastfmSquare() { return new PredefinedIcon(IconSpecs.fab.lastfmSquare.iconSpec); }
        static PredefinedIcon leanpub() { return new PredefinedIcon(IconSpecs.fab.leanpub.iconSpec); }
        static PredefinedIcon less() { return new PredefinedIcon(IconSpecs.fab.less.iconSpec); }
        static PredefinedIcon line() { return new PredefinedIcon(IconSpecs.fab.line.iconSpec); }
        static PredefinedIcon linkedin() { return new PredefinedIcon(IconSpecs.fab.linkedin.iconSpec); }
        static PredefinedIcon linkedinIn() { return new PredefinedIcon(IconSpecs.fab.linkedinIn.iconSpec); }
        static PredefinedIcon linode() { return new PredefinedIcon(IconSpecs.fab.linode.iconSpec); }
        static PredefinedIcon linux() { return new PredefinedIcon(IconSpecs.fab.linux.iconSpec); }
        static PredefinedIcon lyft() { return new PredefinedIcon(IconSpecs.fab.lyft.iconSpec); }
        static PredefinedIcon magento() { return new PredefinedIcon(IconSpecs.fab.magento.iconSpec); }
        static PredefinedIcon mailchimp() { return new PredefinedIcon(IconSpecs.fab.mailchimp.iconSpec); }
        static PredefinedIcon mandalorian() { return new PredefinedIcon(IconSpecs.fab.mandalorian.iconSpec); }
        static PredefinedIcon markdown() { return new PredefinedIcon(IconSpecs.fab.markdown.iconSpec); }
        static PredefinedIcon mastodon() { return new PredefinedIcon(IconSpecs.fab.mastodon.iconSpec); }
        static PredefinedIcon maxcdn() { return new PredefinedIcon(IconSpecs.fab.maxcdn.iconSpec); }
        static PredefinedIcon mdb() { return new PredefinedIcon(IconSpecs.fab.mdb.iconSpec); }
        static PredefinedIcon medapps() { return new PredefinedIcon(IconSpecs.fab.medapps.iconSpec); }
        static PredefinedIcon medium() { return new PredefinedIcon(IconSpecs.fab.medium.iconSpec); }
        static PredefinedIcon mediumM() { return new PredefinedIcon(IconSpecs.fab.mediumM.iconSpec); }
        static PredefinedIcon medrt() { return new PredefinedIcon(IconSpecs.fab.medrt.iconSpec); }
        static PredefinedIcon meetup() { return new PredefinedIcon(IconSpecs.fab.meetup.iconSpec); }
        static PredefinedIcon megaport() { return new PredefinedIcon(IconSpecs.fab.megaport.iconSpec); }
        static PredefinedIcon mendeley() { return new PredefinedIcon(IconSpecs.fab.mendeley.iconSpec); }
        static PredefinedIcon microblog() { return new PredefinedIcon(IconSpecs.fab.microblog.iconSpec); }
        static PredefinedIcon microsoft() { return new PredefinedIcon(IconSpecs.fab.microsoft.iconSpec); }
        static PredefinedIcon mix() { return new PredefinedIcon(IconSpecs.fab.mix.iconSpec); }
        static PredefinedIcon mixcloud() { return new PredefinedIcon(IconSpecs.fab.mixcloud.iconSpec); }
        static PredefinedIcon mixer() { return new PredefinedIcon(IconSpecs.fab.mixer.iconSpec); }
        static PredefinedIcon mizuni() { return new PredefinedIcon(IconSpecs.fab.mizuni.iconSpec); }
        static PredefinedIcon modx() { return new PredefinedIcon(IconSpecs.fab.modx.iconSpec); }
        static PredefinedIcon monero() { return new PredefinedIcon(IconSpecs.fab.monero.iconSpec); }
        static PredefinedIcon napster() { return new PredefinedIcon(IconSpecs.fab.napster.iconSpec); }
        static PredefinedIcon neos() { return new PredefinedIcon(IconSpecs.fab.neos.iconSpec); }
        static PredefinedIcon nimblr() { return new PredefinedIcon(IconSpecs.fab.nimblr.iconSpec); }
        static PredefinedIcon node() { return new PredefinedIcon(IconSpecs.fab.node.iconSpec); }
        static PredefinedIcon nodeJs() { return new PredefinedIcon(IconSpecs.fab.nodeJs.iconSpec); }
        static PredefinedIcon npm() { return new PredefinedIcon(IconSpecs.fab.npm.iconSpec); }
        static PredefinedIcon ns8() { return new PredefinedIcon(IconSpecs.fab.ns8.iconSpec); }
        static PredefinedIcon nutritionix() { return new PredefinedIcon(IconSpecs.fab.nutritionix.iconSpec); }
        static PredefinedIcon octopusDeploy() { return new PredefinedIcon(IconSpecs.fab.octopusDeploy.iconSpec); }
        static PredefinedIcon odnoklassniki() { return new PredefinedIcon(IconSpecs.fab.odnoklassniki.iconSpec); }
        static PredefinedIcon odnoklassnikiSquare() { return new PredefinedIcon(IconSpecs.fab.odnoklassnikiSquare.iconSpec); }
        static PredefinedIcon oldRepublic() { return new PredefinedIcon(IconSpecs.fab.oldRepublic.iconSpec); }
        static PredefinedIcon opencart() { return new PredefinedIcon(IconSpecs.fab.opencart.iconSpec); }
        static PredefinedIcon openid() { return new PredefinedIcon(IconSpecs.fab.openid.iconSpec); }
        static PredefinedIcon opera() { return new PredefinedIcon(IconSpecs.fab.opera.iconSpec); }
        static PredefinedIcon optinMonster() { return new PredefinedIcon(IconSpecs.fab.optinMonster.iconSpec); }
        static PredefinedIcon orcid() { return new PredefinedIcon(IconSpecs.fab.orcid.iconSpec); }
        static PredefinedIcon osi() { return new PredefinedIcon(IconSpecs.fab.osi.iconSpec); }
        static PredefinedIcon page4() { return new PredefinedIcon(IconSpecs.fab.page4.iconSpec); }
        static PredefinedIcon pagelines() { return new PredefinedIcon(IconSpecs.fab.pagelines.iconSpec); }
        static PredefinedIcon palfed() { return new PredefinedIcon(IconSpecs.fab.palfed.iconSpec); }
        static PredefinedIcon patreon() { return new PredefinedIcon(IconSpecs.fab.patreon.iconSpec); }
        static PredefinedIcon paypal() { return new PredefinedIcon(IconSpecs.fab.paypal.iconSpec); }
        static PredefinedIcon pennyArcade() { return new PredefinedIcon(IconSpecs.fab.pennyArcade.iconSpec); }
        static PredefinedIcon perbyte() { return new PredefinedIcon(IconSpecs.fab.perbyte.iconSpec); }
        static PredefinedIcon periscope() { return new PredefinedIcon(IconSpecs.fab.periscope.iconSpec); }
        static PredefinedIcon phabricator() { return new PredefinedIcon(IconSpecs.fab.phabricator.iconSpec); }
        static PredefinedIcon phoenixFramework() { return new PredefinedIcon(IconSpecs.fab.phoenixFramework.iconSpec); }
        static PredefinedIcon phoenixSquadron() { return new PredefinedIcon(IconSpecs.fab.phoenixSquadron.iconSpec); }
        static PredefinedIcon php() { return new PredefinedIcon(IconSpecs.fab.php.iconSpec); }
        static PredefinedIcon piedPiper() { return new PredefinedIcon(IconSpecs.fab.piedPiper.iconSpec); }
        static PredefinedIcon piedPiperAlt() { return new PredefinedIcon(IconSpecs.fab.piedPiperAlt.iconSpec); }
        static PredefinedIcon piedPiperHat() { return new PredefinedIcon(IconSpecs.fab.piedPiperHat.iconSpec); }
        static PredefinedIcon piedPiperPp() { return new PredefinedIcon(IconSpecs.fab.piedPiperPp.iconSpec); }
        static PredefinedIcon piedPiperSquare() { return new PredefinedIcon(IconSpecs.fab.piedPiperSquare.iconSpec); }
        static PredefinedIcon pinterest() { return new PredefinedIcon(IconSpecs.fab.pinterest.iconSpec); }
        static PredefinedIcon pinterestP() { return new PredefinedIcon(IconSpecs.fab.pinterestP.iconSpec); }
        static PredefinedIcon pinterestSquare() { return new PredefinedIcon(IconSpecs.fab.pinterestSquare.iconSpec); }
        static PredefinedIcon playstation() { return new PredefinedIcon(IconSpecs.fab.playstation.iconSpec); }
        static PredefinedIcon productHunt() { return new PredefinedIcon(IconSpecs.fab.productHunt.iconSpec); }
        static PredefinedIcon pushed() { return new PredefinedIcon(IconSpecs.fab.pushed.iconSpec); }
        static PredefinedIcon python() { return new PredefinedIcon(IconSpecs.fab.python.iconSpec); }
        static PredefinedIcon qq() { return new PredefinedIcon(IconSpecs.fab.qq.iconSpec); }
        static PredefinedIcon quinscape() { return new PredefinedIcon(IconSpecs.fab.quinscape.iconSpec); }
        static PredefinedIcon quora() { return new PredefinedIcon(IconSpecs.fab.quora.iconSpec); }
        static PredefinedIcon rProject() { return new PredefinedIcon(IconSpecs.fab.rProject.iconSpec); }
        static PredefinedIcon raspberryPi() { return new PredefinedIcon(IconSpecs.fab.raspberryPi.iconSpec); }
        static PredefinedIcon ravelry() { return new PredefinedIcon(IconSpecs.fab.ravelry.iconSpec); }
        static PredefinedIcon react() { return new PredefinedIcon(IconSpecs.fab.react.iconSpec); }
        static PredefinedIcon reacteurope() { return new PredefinedIcon(IconSpecs.fab.reacteurope.iconSpec); }
        static PredefinedIcon readme() { return new PredefinedIcon(IconSpecs.fab.readme.iconSpec); }
        static PredefinedIcon rebel() { return new PredefinedIcon(IconSpecs.fab.rebel.iconSpec); }
        static PredefinedIcon redRiver() { return new PredefinedIcon(IconSpecs.fab.redRiver.iconSpec); }
        static PredefinedIcon reddit() { return new PredefinedIcon(IconSpecs.fab.reddit.iconSpec); }
        static PredefinedIcon redditAlien() { return new PredefinedIcon(IconSpecs.fab.redditAlien.iconSpec); }
        static PredefinedIcon redditSquare() { return new PredefinedIcon(IconSpecs.fab.redditSquare.iconSpec); }
        static PredefinedIcon redhat() { return new PredefinedIcon(IconSpecs.fab.redhat.iconSpec); }
        static PredefinedIcon renren() { return new PredefinedIcon(IconSpecs.fab.renren.iconSpec); }
        static PredefinedIcon replyd() { return new PredefinedIcon(IconSpecs.fab.replyd.iconSpec); }
        static PredefinedIcon researchgate() { return new PredefinedIcon(IconSpecs.fab.researchgate.iconSpec); }
        static PredefinedIcon resolving() { return new PredefinedIcon(IconSpecs.fab.resolving.iconSpec); }
        static PredefinedIcon rev() { return new PredefinedIcon(IconSpecs.fab.rev.iconSpec); }
        static PredefinedIcon rocketchat() { return new PredefinedIcon(IconSpecs.fab.rocketchat.iconSpec); }
        static PredefinedIcon rockrms() { return new PredefinedIcon(IconSpecs.fab.rockrms.iconSpec); }
        static PredefinedIcon rust() { return new PredefinedIcon(IconSpecs.fab.rust.iconSpec); }
        static PredefinedIcon safari() { return new PredefinedIcon(IconSpecs.fab.safari.iconSpec); }
        static PredefinedIcon salesforce() { return new PredefinedIcon(IconSpecs.fab.salesforce.iconSpec); }
        static PredefinedIcon sass() { return new PredefinedIcon(IconSpecs.fab.sass.iconSpec); }
        static PredefinedIcon schlix() { return new PredefinedIcon(IconSpecs.fab.schlix.iconSpec); }
        static PredefinedIcon scribd() { return new PredefinedIcon(IconSpecs.fab.scribd.iconSpec); }
        static PredefinedIcon searchengin() { return new PredefinedIcon(IconSpecs.fab.searchengin.iconSpec); }
        static PredefinedIcon sellcast() { return new PredefinedIcon(IconSpecs.fab.sellcast.iconSpec); }
        static PredefinedIcon sellsy() { return new PredefinedIcon(IconSpecs.fab.sellsy.iconSpec); }
        static PredefinedIcon servicestack() { return new PredefinedIcon(IconSpecs.fab.servicestack.iconSpec); }
        static PredefinedIcon shirtsinbulk() { return new PredefinedIcon(IconSpecs.fab.shirtsinbulk.iconSpec); }
        static PredefinedIcon shopify() { return new PredefinedIcon(IconSpecs.fab.shopify.iconSpec); }
        static PredefinedIcon shopware() { return new PredefinedIcon(IconSpecs.fab.shopware.iconSpec); }
        static PredefinedIcon simplybuilt() { return new PredefinedIcon(IconSpecs.fab.simplybuilt.iconSpec); }
        static PredefinedIcon sistrix() { return new PredefinedIcon(IconSpecs.fab.sistrix.iconSpec); }
        static PredefinedIcon sith() { return new PredefinedIcon(IconSpecs.fab.sith.iconSpec); }
        static PredefinedIcon sketch() { return new PredefinedIcon(IconSpecs.fab.sketch.iconSpec); }
        static PredefinedIcon skyatlas() { return new PredefinedIcon(IconSpecs.fab.skyatlas.iconSpec); }
        static PredefinedIcon skype() { return new PredefinedIcon(IconSpecs.fab.skype.iconSpec); }
        static PredefinedIcon slack() { return new PredefinedIcon(IconSpecs.fab.slack.iconSpec); }
        static PredefinedIcon slackHash() { return new PredefinedIcon(IconSpecs.fab.slackHash.iconSpec); }
        static PredefinedIcon slideshare() { return new PredefinedIcon(IconSpecs.fab.slideshare.iconSpec); }
        static PredefinedIcon snapchat() { return new PredefinedIcon(IconSpecs.fab.snapchat.iconSpec); }
        static PredefinedIcon snapchatGhost() { return new PredefinedIcon(IconSpecs.fab.snapchatGhost.iconSpec); }
        static PredefinedIcon snapchatSquare() { return new PredefinedIcon(IconSpecs.fab.snapchatSquare.iconSpec); }
        static PredefinedIcon soundcloud() { return new PredefinedIcon(IconSpecs.fab.soundcloud.iconSpec); }
        static PredefinedIcon sourcetree() { return new PredefinedIcon(IconSpecs.fab.sourcetree.iconSpec); }
        static PredefinedIcon speakap() { return new PredefinedIcon(IconSpecs.fab.speakap.iconSpec); }
        static PredefinedIcon speakerDeck() { return new PredefinedIcon(IconSpecs.fab.speakerDeck.iconSpec); }
        static PredefinedIcon spotify() { return new PredefinedIcon(IconSpecs.fab.spotify.iconSpec); }
        static PredefinedIcon squarespace() { return new PredefinedIcon(IconSpecs.fab.squarespace.iconSpec); }
        static PredefinedIcon stackExchange() { return new PredefinedIcon(IconSpecs.fab.stackExchange.iconSpec); }
        static PredefinedIcon stackOverflow() { return new PredefinedIcon(IconSpecs.fab.stackOverflow.iconSpec); }
        static PredefinedIcon stackpath() { return new PredefinedIcon(IconSpecs.fab.stackpath.iconSpec); }
        static PredefinedIcon staylinked() { return new PredefinedIcon(IconSpecs.fab.staylinked.iconSpec); }
        static PredefinedIcon steam() { return new PredefinedIcon(IconSpecs.fab.steam.iconSpec); }
        static PredefinedIcon steamSquare() { return new PredefinedIcon(IconSpecs.fab.steamSquare.iconSpec); }
        static PredefinedIcon steamSymbol() { return new PredefinedIcon(IconSpecs.fab.steamSymbol.iconSpec); }
        static PredefinedIcon stickerMule() { return new PredefinedIcon(IconSpecs.fab.stickerMule.iconSpec); }
        static PredefinedIcon strava() { return new PredefinedIcon(IconSpecs.fab.strava.iconSpec); }
        static PredefinedIcon stripe() { return new PredefinedIcon(IconSpecs.fab.stripe.iconSpec); }
        static PredefinedIcon stripeS() { return new PredefinedIcon(IconSpecs.fab.stripeS.iconSpec); }
        static PredefinedIcon studiovinari() { return new PredefinedIcon(IconSpecs.fab.studiovinari.iconSpec); }
        static PredefinedIcon stumbleupon() { return new PredefinedIcon(IconSpecs.fab.stumbleupon.iconSpec); }
        static PredefinedIcon stumbleuponCircle() { return new PredefinedIcon(IconSpecs.fab.stumbleuponCircle.iconSpec); }
        static PredefinedIcon superpowers() { return new PredefinedIcon(IconSpecs.fab.superpowers.iconSpec); }
        static PredefinedIcon supple() { return new PredefinedIcon(IconSpecs.fab.supple.iconSpec); }
        static PredefinedIcon suse() { return new PredefinedIcon(IconSpecs.fab.suse.iconSpec); }
        static PredefinedIcon swift() { return new PredefinedIcon(IconSpecs.fab.swift.iconSpec); }
        static PredefinedIcon symfony() { return new PredefinedIcon(IconSpecs.fab.symfony.iconSpec); }
        static PredefinedIcon teamspeak() { return new PredefinedIcon(IconSpecs.fab.teamspeak.iconSpec); }
        static PredefinedIcon telegram() { return new PredefinedIcon(IconSpecs.fab.telegram.iconSpec); }
        static PredefinedIcon telegramPlane() { return new PredefinedIcon(IconSpecs.fab.telegramPlane.iconSpec); }
        static PredefinedIcon tencentWeibo() { return new PredefinedIcon(IconSpecs.fab.tencentWeibo.iconSpec); }
        static PredefinedIcon theRedYeti() { return new PredefinedIcon(IconSpecs.fab.theRedYeti.iconSpec); }
        static PredefinedIcon themeco() { return new PredefinedIcon(IconSpecs.fab.themeco.iconSpec); }
        static PredefinedIcon themeisle() { return new PredefinedIcon(IconSpecs.fab.themeisle.iconSpec); }
        static PredefinedIcon thinkPeaks() { return new PredefinedIcon(IconSpecs.fab.thinkPeaks.iconSpec); }
        static PredefinedIcon tiktok() { return new PredefinedIcon(IconSpecs.fab.tiktok.iconSpec); }
        static PredefinedIcon tradeFederation() { return new PredefinedIcon(IconSpecs.fab.tradeFederation.iconSpec); }
        static PredefinedIcon trello() { return new PredefinedIcon(IconSpecs.fab.trello.iconSpec); }
        static PredefinedIcon tumblr() { return new PredefinedIcon(IconSpecs.fab.tumblr.iconSpec); }
        static PredefinedIcon tumblrSquare() { return new PredefinedIcon(IconSpecs.fab.tumblrSquare.iconSpec); }
        static PredefinedIcon twitch() { return new PredefinedIcon(IconSpecs.fab.twitch.iconSpec); }
        static PredefinedIcon twitter() { return new PredefinedIcon(IconSpecs.fab.twitter.iconSpec); }
        static PredefinedIcon twitterSquare() { return new PredefinedIcon(IconSpecs.fab.twitterSquare.iconSpec); }
        static PredefinedIcon typo3() { return new PredefinedIcon(IconSpecs.fab.typo3.iconSpec); }
        static PredefinedIcon uber() { return new PredefinedIcon(IconSpecs.fab.uber.iconSpec); }
        static PredefinedIcon ubuntu() { return new PredefinedIcon(IconSpecs.fab.ubuntu.iconSpec); }
        static PredefinedIcon uikit() { return new PredefinedIcon(IconSpecs.fab.uikit.iconSpec); }
        static PredefinedIcon umbraco() { return new PredefinedIcon(IconSpecs.fab.umbraco.iconSpec); }
        static PredefinedIcon uncharted() { return new PredefinedIcon(IconSpecs.fab.uncharted.iconSpec); }
        static PredefinedIcon uniregistry() { return new PredefinedIcon(IconSpecs.fab.uniregistry.iconSpec); }
        static PredefinedIcon unity() { return new PredefinedIcon(IconSpecs.fab.unity.iconSpec); }
        static PredefinedIcon unsplash() { return new PredefinedIcon(IconSpecs.fab.unsplash.iconSpec); }
        static PredefinedIcon untappd() { return new PredefinedIcon(IconSpecs.fab.untappd.iconSpec); }
        static PredefinedIcon ups() { return new PredefinedIcon(IconSpecs.fab.ups.iconSpec); }
        static PredefinedIcon usb() { return new PredefinedIcon(IconSpecs.fab.usb.iconSpec); }
        static PredefinedIcon usps() { return new PredefinedIcon(IconSpecs.fab.usps.iconSpec); }
        static PredefinedIcon ussunnah() { return new PredefinedIcon(IconSpecs.fab.ussunnah.iconSpec); }
        static PredefinedIcon vaadin() { return new PredefinedIcon(IconSpecs.fab.vaadin.iconSpec); }
        static PredefinedIcon viacoin() { return new PredefinedIcon(IconSpecs.fab.viacoin.iconSpec); }
        static PredefinedIcon viadeo() { return new PredefinedIcon(IconSpecs.fab.viadeo.iconSpec); }
        static PredefinedIcon viadeoSquare() { return new PredefinedIcon(IconSpecs.fab.viadeoSquare.iconSpec); }
        static PredefinedIcon viber() { return new PredefinedIcon(IconSpecs.fab.viber.iconSpec); }
        static PredefinedIcon vimeo() { return new PredefinedIcon(IconSpecs.fab.vimeo.iconSpec); }
        static PredefinedIcon vimeoSquare() { return new PredefinedIcon(IconSpecs.fab.vimeoSquare.iconSpec); }
        static PredefinedIcon vimeoV() { return new PredefinedIcon(IconSpecs.fab.vimeoV.iconSpec); }
        static PredefinedIcon vine() { return new PredefinedIcon(IconSpecs.fab.vine.iconSpec); }
        static PredefinedIcon vk() { return new PredefinedIcon(IconSpecs.fab.vk.iconSpec); }
        static PredefinedIcon vnv() { return new PredefinedIcon(IconSpecs.fab.vnv.iconSpec); }
        static PredefinedIcon vuejs() { return new PredefinedIcon(IconSpecs.fab.vuejs.iconSpec); }
        static PredefinedIcon watchmanMonitoring() { return new PredefinedIcon(IconSpecs.fab.watchmanMonitoring.iconSpec); }
        static PredefinedIcon waze() { return new PredefinedIcon(IconSpecs.fab.waze.iconSpec); }
        static PredefinedIcon weebly() { return new PredefinedIcon(IconSpecs.fab.weebly.iconSpec); }
        static PredefinedIcon weibo() { return new PredefinedIcon(IconSpecs.fab.weibo.iconSpec); }
        static PredefinedIcon weixin() { return new PredefinedIcon(IconSpecs.fab.weixin.iconSpec); }
        static PredefinedIcon whatsapp() { return new PredefinedIcon(IconSpecs.fab.whatsapp.iconSpec); }
        static PredefinedIcon whatsappSquare() { return new PredefinedIcon(IconSpecs.fab.whatsappSquare.iconSpec); }
        static PredefinedIcon whmcs() { return new PredefinedIcon(IconSpecs.fab.whmcs.iconSpec); }
        static PredefinedIcon wikipediaW() { return new PredefinedIcon(IconSpecs.fab.wikipediaW.iconSpec); }
        static PredefinedIcon windows() { return new PredefinedIcon(IconSpecs.fab.windows.iconSpec); }
        static PredefinedIcon wix() { return new PredefinedIcon(IconSpecs.fab.wix.iconSpec); }
        static PredefinedIcon wizardsOfTheCoast() { return new PredefinedIcon(IconSpecs.fab.wizardsOfTheCoast.iconSpec); }
        static PredefinedIcon wodu() { return new PredefinedIcon(IconSpecs.fab.wodu.iconSpec); }
        static PredefinedIcon wolfPackBattalion() { return new PredefinedIcon(IconSpecs.fab.wolfPackBattalion.iconSpec); }
        static PredefinedIcon wordpress() { return new PredefinedIcon(IconSpecs.fab.wordpress.iconSpec); }
        static PredefinedIcon wordpressSimple() { return new PredefinedIcon(IconSpecs.fab.wordpressSimple.iconSpec); }
        static PredefinedIcon wpbeginner() { return new PredefinedIcon(IconSpecs.fab.wpbeginner.iconSpec); }
        static PredefinedIcon wpexplorer() { return new PredefinedIcon(IconSpecs.fab.wpexplorer.iconSpec); }
        static PredefinedIcon wpforms() { return new PredefinedIcon(IconSpecs.fab.wpforms.iconSpec); }
        static PredefinedIcon wpressr() { return new PredefinedIcon(IconSpecs.fab.wpressr.iconSpec); }
        static PredefinedIcon xbox() { return new PredefinedIcon(IconSpecs.fab.xbox.iconSpec); }
        static PredefinedIcon xing() { return new PredefinedIcon(IconSpecs.fab.xing.iconSpec); }
        static PredefinedIcon xingSquare() { return new PredefinedIcon(IconSpecs.fab.xingSquare.iconSpec); }
        static PredefinedIcon yCombinator() { return new PredefinedIcon(IconSpecs.fab.yCombinator.iconSpec); }
        static PredefinedIcon yahoo() { return new PredefinedIcon(IconSpecs.fab.yahoo.iconSpec); }
        static PredefinedIcon yammer() { return new PredefinedIcon(IconSpecs.fab.yammer.iconSpec); }
        static PredefinedIcon yandex() { return new PredefinedIcon(IconSpecs.fab.yandex.iconSpec); }
        static PredefinedIcon yandexInternational() { return new PredefinedIcon(IconSpecs.fab.yandexInternational.iconSpec); }
        static PredefinedIcon yarn() { return new PredefinedIcon(IconSpecs.fab.yarn.iconSpec); }
        static PredefinedIcon yelp() { return new PredefinedIcon(IconSpecs.fab.yelp.iconSpec); }
        static PredefinedIcon yoast() { return new PredefinedIcon(IconSpecs.fab.yoast.iconSpec); }
        static PredefinedIcon youtube() { return new PredefinedIcon(IconSpecs.fab.youtube.iconSpec); }
        static PredefinedIcon youtubeSquare() { return new PredefinedIcon(IconSpecs.fab.youtubeSquare.iconSpec); }
        static PredefinedIcon zhihu() { return new PredefinedIcon(IconSpecs.fab.zhihu.iconSpec); }
    }
    public interface far {
        static PredefinedIcon addressBook() { return new PredefinedIcon(IconSpecs.far.addressBook.iconSpec); }
        static PredefinedIcon addressCard() { return new PredefinedIcon(IconSpecs.far.addressCard.iconSpec); }
        static PredefinedIcon angry() { return new PredefinedIcon(IconSpecs.far.angry.iconSpec); }
        static PredefinedIcon arrowAltCircleDown() { return new PredefinedIcon(IconSpecs.far.arrowAltCircleDown.iconSpec); }
        static PredefinedIcon arrowAltCircleLeft() { return new PredefinedIcon(IconSpecs.far.arrowAltCircleLeft.iconSpec); }
        static PredefinedIcon arrowAltCircleRight() { return new PredefinedIcon(IconSpecs.far.arrowAltCircleRight.iconSpec); }
        static PredefinedIcon arrowAltCircleUp() { return new PredefinedIcon(IconSpecs.far.arrowAltCircleUp.iconSpec); }
        static PredefinedIcon bell() { return new PredefinedIcon(IconSpecs.far.bell.iconSpec); }
        static PredefinedIcon bellSlash() { return new PredefinedIcon(IconSpecs.far.bellSlash.iconSpec); }
        static PredefinedIcon bookmark() { return new PredefinedIcon(IconSpecs.far.bookmark.iconSpec); }
        static PredefinedIcon building() { return new PredefinedIcon(IconSpecs.far.building.iconSpec); }
        static PredefinedIcon calendar() { return new PredefinedIcon(IconSpecs.far.calendar.iconSpec); }
        static PredefinedIcon calendarAlt() { return new PredefinedIcon(IconSpecs.far.calendarAlt.iconSpec); }
        static PredefinedIcon calendarCheck() { return new PredefinedIcon(IconSpecs.far.calendarCheck.iconSpec); }
        static PredefinedIcon calendarMinus() { return new PredefinedIcon(IconSpecs.far.calendarMinus.iconSpec); }
        static PredefinedIcon calendarPlus() { return new PredefinedIcon(IconSpecs.far.calendarPlus.iconSpec); }
        static PredefinedIcon calendarTimes() { return new PredefinedIcon(IconSpecs.far.calendarTimes.iconSpec); }
        static PredefinedIcon caretSquareDown() { return new PredefinedIcon(IconSpecs.far.caretSquareDown.iconSpec); }
        static PredefinedIcon caretSquareLeft() { return new PredefinedIcon(IconSpecs.far.caretSquareLeft.iconSpec); }
        static PredefinedIcon caretSquareRight() { return new PredefinedIcon(IconSpecs.far.caretSquareRight.iconSpec); }
        static PredefinedIcon caretSquareUp() { return new PredefinedIcon(IconSpecs.far.caretSquareUp.iconSpec); }
        static PredefinedIcon chartBar() { return new PredefinedIcon(IconSpecs.far.chartBar.iconSpec); }
        static PredefinedIcon checkCircle() { return new PredefinedIcon(IconSpecs.far.checkCircle.iconSpec); }
        static PredefinedIcon checkSquare() { return new PredefinedIcon(IconSpecs.far.checkSquare.iconSpec); }
        static PredefinedIcon circle() { return new PredefinedIcon(IconSpecs.far.circle.iconSpec); }
        static PredefinedIcon clipboard() { return new PredefinedIcon(IconSpecs.far.clipboard.iconSpec); }
        static PredefinedIcon clock() { return new PredefinedIcon(IconSpecs.far.clock.iconSpec); }
        static PredefinedIcon clone_() { return new PredefinedIcon(IconSpecs.far.clone_.iconSpec); }
        static PredefinedIcon closedCaptioning() { return new PredefinedIcon(IconSpecs.far.closedCaptioning.iconSpec); }
        static PredefinedIcon comment() { return new PredefinedIcon(IconSpecs.far.comment.iconSpec); }
        static PredefinedIcon commentAlt() { return new PredefinedIcon(IconSpecs.far.commentAlt.iconSpec); }
        static PredefinedIcon commentDots() { return new PredefinedIcon(IconSpecs.far.commentDots.iconSpec); }
        static PredefinedIcon comments() { return new PredefinedIcon(IconSpecs.far.comments.iconSpec); }
        static PredefinedIcon compass() { return new PredefinedIcon(IconSpecs.far.compass.iconSpec); }
        static PredefinedIcon copy() { return new PredefinedIcon(IconSpecs.far.copy.iconSpec); }
        static PredefinedIcon copyright() { return new PredefinedIcon(IconSpecs.far.copyright.iconSpec); }
        static PredefinedIcon creditCard() { return new PredefinedIcon(IconSpecs.far.creditCard.iconSpec); }
        static PredefinedIcon dizzy() { return new PredefinedIcon(IconSpecs.far.dizzy.iconSpec); }
        static PredefinedIcon dotCircle() { return new PredefinedIcon(IconSpecs.far.dotCircle.iconSpec); }
        static PredefinedIcon edit() { return new PredefinedIcon(IconSpecs.far.edit.iconSpec); }
        static PredefinedIcon envelope() { return new PredefinedIcon(IconSpecs.far.envelope.iconSpec); }
        static PredefinedIcon envelopeOpen() { return new PredefinedIcon(IconSpecs.far.envelopeOpen.iconSpec); }
        static PredefinedIcon eye() { return new PredefinedIcon(IconSpecs.far.eye.iconSpec); }
        static PredefinedIcon eyeSlash() { return new PredefinedIcon(IconSpecs.far.eyeSlash.iconSpec); }
        static PredefinedIcon file() { return new PredefinedIcon(IconSpecs.far.file.iconSpec); }
        static PredefinedIcon fileAlt() { return new PredefinedIcon(IconSpecs.far.fileAlt.iconSpec); }
        static PredefinedIcon fileArchive() { return new PredefinedIcon(IconSpecs.far.fileArchive.iconSpec); }
        static PredefinedIcon fileAudio() { return new PredefinedIcon(IconSpecs.far.fileAudio.iconSpec); }
        static PredefinedIcon fileCode() { return new PredefinedIcon(IconSpecs.far.fileCode.iconSpec); }
        static PredefinedIcon fileExcel() { return new PredefinedIcon(IconSpecs.far.fileExcel.iconSpec); }
        static PredefinedIcon fileImage() { return new PredefinedIcon(IconSpecs.far.fileImage.iconSpec); }
        static PredefinedIcon filePdf() { return new PredefinedIcon(IconSpecs.far.filePdf.iconSpec); }
        static PredefinedIcon filePowerpoint() { return new PredefinedIcon(IconSpecs.far.filePowerpoint.iconSpec); }
        static PredefinedIcon fileVideo() { return new PredefinedIcon(IconSpecs.far.fileVideo.iconSpec); }
        static PredefinedIcon fileWord() { return new PredefinedIcon(IconSpecs.far.fileWord.iconSpec); }
        static PredefinedIcon flag() { return new PredefinedIcon(IconSpecs.far.flag.iconSpec); }
        static PredefinedIcon flushed() { return new PredefinedIcon(IconSpecs.far.flushed.iconSpec); }
        static PredefinedIcon folder() { return new PredefinedIcon(IconSpecs.far.folder.iconSpec); }
        static PredefinedIcon folderOpen() { return new PredefinedIcon(IconSpecs.far.folderOpen.iconSpec); }
        static PredefinedIcon frown() { return new PredefinedIcon(IconSpecs.far.frown.iconSpec); }
        static PredefinedIcon frownOpen() { return new PredefinedIcon(IconSpecs.far.frownOpen.iconSpec); }
        static PredefinedIcon futbol() { return new PredefinedIcon(IconSpecs.far.futbol.iconSpec); }
        static PredefinedIcon gem() { return new PredefinedIcon(IconSpecs.far.gem.iconSpec); }
        static PredefinedIcon grimace() { return new PredefinedIcon(IconSpecs.far.grimace.iconSpec); }
        static PredefinedIcon grin() { return new PredefinedIcon(IconSpecs.far.grin.iconSpec); }
        static PredefinedIcon grinAlt() { return new PredefinedIcon(IconSpecs.far.grinAlt.iconSpec); }
        static PredefinedIcon grinBeam() { return new PredefinedIcon(IconSpecs.far.grinBeam.iconSpec); }
        static PredefinedIcon grinBeamSweat() { return new PredefinedIcon(IconSpecs.far.grinBeamSweat.iconSpec); }
        static PredefinedIcon grinHearts() { return new PredefinedIcon(IconSpecs.far.grinHearts.iconSpec); }
        static PredefinedIcon grinSquint() { return new PredefinedIcon(IconSpecs.far.grinSquint.iconSpec); }
        static PredefinedIcon grinSquintTears() { return new PredefinedIcon(IconSpecs.far.grinSquintTears.iconSpec); }
        static PredefinedIcon grinStars() { return new PredefinedIcon(IconSpecs.far.grinStars.iconSpec); }
        static PredefinedIcon grinTears() { return new PredefinedIcon(IconSpecs.far.grinTears.iconSpec); }
        static PredefinedIcon grinTongue() { return new PredefinedIcon(IconSpecs.far.grinTongue.iconSpec); }
        static PredefinedIcon grinTongueSquint() { return new PredefinedIcon(IconSpecs.far.grinTongueSquint.iconSpec); }
        static PredefinedIcon grinTongueWink() { return new PredefinedIcon(IconSpecs.far.grinTongueWink.iconSpec); }
        static PredefinedIcon grinWink() { return new PredefinedIcon(IconSpecs.far.grinWink.iconSpec); }
        static PredefinedIcon handLizard() { return new PredefinedIcon(IconSpecs.far.handLizard.iconSpec); }
        static PredefinedIcon handPaper() { return new PredefinedIcon(IconSpecs.far.handPaper.iconSpec); }
        static PredefinedIcon handPeace() { return new PredefinedIcon(IconSpecs.far.handPeace.iconSpec); }
        static PredefinedIcon handPointDown() { return new PredefinedIcon(IconSpecs.far.handPointDown.iconSpec); }
        static PredefinedIcon handPointLeft() { return new PredefinedIcon(IconSpecs.far.handPointLeft.iconSpec); }
        static PredefinedIcon handPointRight() { return new PredefinedIcon(IconSpecs.far.handPointRight.iconSpec); }
        static PredefinedIcon handPointUp() { return new PredefinedIcon(IconSpecs.far.handPointUp.iconSpec); }
        static PredefinedIcon handPointer() { return new PredefinedIcon(IconSpecs.far.handPointer.iconSpec); }
        static PredefinedIcon handRock() { return new PredefinedIcon(IconSpecs.far.handRock.iconSpec); }
        static PredefinedIcon handScissors() { return new PredefinedIcon(IconSpecs.far.handScissors.iconSpec); }
        static PredefinedIcon handSpock() { return new PredefinedIcon(IconSpecs.far.handSpock.iconSpec); }
        static PredefinedIcon handshake() { return new PredefinedIcon(IconSpecs.far.handshake.iconSpec); }
        static PredefinedIcon hdd() { return new PredefinedIcon(IconSpecs.far.hdd.iconSpec); }
        static PredefinedIcon heart() { return new PredefinedIcon(IconSpecs.far.heart.iconSpec); }
        static PredefinedIcon hospital() { return new PredefinedIcon(IconSpecs.far.hospital.iconSpec); }
        static PredefinedIcon hourglass() { return new PredefinedIcon(IconSpecs.far.hourglass.iconSpec); }
        static PredefinedIcon idBadge() { return new PredefinedIcon(IconSpecs.far.idBadge.iconSpec); }
        static PredefinedIcon idCard() { return new PredefinedIcon(IconSpecs.far.idCard.iconSpec); }
        static PredefinedIcon image() { return new PredefinedIcon(IconSpecs.far.image.iconSpec); }
        static PredefinedIcon images() { return new PredefinedIcon(IconSpecs.far.images.iconSpec); }
        static PredefinedIcon keyboard() { return new PredefinedIcon(IconSpecs.far.keyboard.iconSpec); }
        static PredefinedIcon kiss() { return new PredefinedIcon(IconSpecs.far.kiss.iconSpec); }
        static PredefinedIcon kissBeam() { return new PredefinedIcon(IconSpecs.far.kissBeam.iconSpec); }
        static PredefinedIcon kissWinkHeart() { return new PredefinedIcon(IconSpecs.far.kissWinkHeart.iconSpec); }
        static PredefinedIcon laugh() { return new PredefinedIcon(IconSpecs.far.laugh.iconSpec); }
        static PredefinedIcon laughBeam() { return new PredefinedIcon(IconSpecs.far.laughBeam.iconSpec); }
        static PredefinedIcon laughSquint() { return new PredefinedIcon(IconSpecs.far.laughSquint.iconSpec); }
        static PredefinedIcon laughWink() { return new PredefinedIcon(IconSpecs.far.laughWink.iconSpec); }
        static PredefinedIcon lemon() { return new PredefinedIcon(IconSpecs.far.lemon.iconSpec); }
        static PredefinedIcon lifeRing() { return new PredefinedIcon(IconSpecs.far.lifeRing.iconSpec); }
        static PredefinedIcon lightbulb() { return new PredefinedIcon(IconSpecs.far.lightbulb.iconSpec); }
        static PredefinedIcon listAlt() { return new PredefinedIcon(IconSpecs.far.listAlt.iconSpec); }
        static PredefinedIcon map() { return new PredefinedIcon(IconSpecs.far.map.iconSpec); }
        static PredefinedIcon meh() { return new PredefinedIcon(IconSpecs.far.meh.iconSpec); }
        static PredefinedIcon mehBlank() { return new PredefinedIcon(IconSpecs.far.mehBlank.iconSpec); }
        static PredefinedIcon mehRollingEyes() { return new PredefinedIcon(IconSpecs.far.mehRollingEyes.iconSpec); }
        static PredefinedIcon minusSquare() { return new PredefinedIcon(IconSpecs.far.minusSquare.iconSpec); }
        static PredefinedIcon moneyBillAlt() { return new PredefinedIcon(IconSpecs.far.moneyBillAlt.iconSpec); }
        static PredefinedIcon moon() { return new PredefinedIcon(IconSpecs.far.moon.iconSpec); }
        static PredefinedIcon newspaper() { return new PredefinedIcon(IconSpecs.far.newspaper.iconSpec); }
        static PredefinedIcon objectGroup() { return new PredefinedIcon(IconSpecs.far.objectGroup.iconSpec); }
        static PredefinedIcon objectUngroup() { return new PredefinedIcon(IconSpecs.far.objectUngroup.iconSpec); }
        static PredefinedIcon paperPlane() { return new PredefinedIcon(IconSpecs.far.paperPlane.iconSpec); }
        static PredefinedIcon pauseCircle() { return new PredefinedIcon(IconSpecs.far.pauseCircle.iconSpec); }
        static PredefinedIcon playCircle() { return new PredefinedIcon(IconSpecs.far.playCircle.iconSpec); }
        static PredefinedIcon plusSquare() { return new PredefinedIcon(IconSpecs.far.plusSquare.iconSpec); }
        static PredefinedIcon questionCircle() { return new PredefinedIcon(IconSpecs.far.questionCircle.iconSpec); }
        static PredefinedIcon registered() { return new PredefinedIcon(IconSpecs.far.registered.iconSpec); }
        static PredefinedIcon sadCry() { return new PredefinedIcon(IconSpecs.far.sadCry.iconSpec); }
        static PredefinedIcon sadTear() { return new PredefinedIcon(IconSpecs.far.sadTear.iconSpec); }
        static PredefinedIcon save() { return new PredefinedIcon(IconSpecs.far.save.iconSpec); }
        static PredefinedIcon shareSquare() { return new PredefinedIcon(IconSpecs.far.shareSquare.iconSpec); }
        static PredefinedIcon smile() { return new PredefinedIcon(IconSpecs.far.smile.iconSpec); }
        static PredefinedIcon smileBeam() { return new PredefinedIcon(IconSpecs.far.smileBeam.iconSpec); }
        static PredefinedIcon smileWink() { return new PredefinedIcon(IconSpecs.far.smileWink.iconSpec); }
        static PredefinedIcon snowflake() { return new PredefinedIcon(IconSpecs.far.snowflake.iconSpec); }
        static PredefinedIcon square() { return new PredefinedIcon(IconSpecs.far.square.iconSpec); }
        static PredefinedIcon star() { return new PredefinedIcon(IconSpecs.far.star.iconSpec); }
        static PredefinedIcon starHalf() { return new PredefinedIcon(IconSpecs.far.starHalf.iconSpec); }
        static PredefinedIcon stickyNote() { return new PredefinedIcon(IconSpecs.far.stickyNote.iconSpec); }
        static PredefinedIcon stopCircle() { return new PredefinedIcon(IconSpecs.far.stopCircle.iconSpec); }
        static PredefinedIcon sun() { return new PredefinedIcon(IconSpecs.far.sun.iconSpec); }
        static PredefinedIcon surprise() { return new PredefinedIcon(IconSpecs.far.surprise.iconSpec); }
        static PredefinedIcon thumbsDown() { return new PredefinedIcon(IconSpecs.far.thumbsDown.iconSpec); }
        static PredefinedIcon thumbsUp() { return new PredefinedIcon(IconSpecs.far.thumbsUp.iconSpec); }
        static PredefinedIcon timesCircle() { return new PredefinedIcon(IconSpecs.far.timesCircle.iconSpec); }
        static PredefinedIcon tired() { return new PredefinedIcon(IconSpecs.far.tired.iconSpec); }
        static PredefinedIcon trashAlt() { return new PredefinedIcon(IconSpecs.far.trashAlt.iconSpec); }
        static PredefinedIcon user() { return new PredefinedIcon(IconSpecs.far.user.iconSpec); }
        static PredefinedIcon userCircle() { return new PredefinedIcon(IconSpecs.far.userCircle.iconSpec); }
        static PredefinedIcon windowClose() { return new PredefinedIcon(IconSpecs.far.windowClose.iconSpec); }
        static PredefinedIcon windowMaximize() { return new PredefinedIcon(IconSpecs.far.windowMaximize.iconSpec); }
        static PredefinedIcon windowMinimize() { return new PredefinedIcon(IconSpecs.far.windowMinimize.iconSpec); }
        static PredefinedIcon windowRestore() { return new PredefinedIcon(IconSpecs.far.windowRestore.iconSpec); }
    }
    public interface fas {
        static PredefinedIcon ad() { return new PredefinedIcon(IconSpecs.fas.ad.iconSpec); }
        static PredefinedIcon addressBook() { return new PredefinedIcon(IconSpecs.fas.addressBook.iconSpec); }
        static PredefinedIcon addressCard() { return new PredefinedIcon(IconSpecs.fas.addressCard.iconSpec); }
        static PredefinedIcon adjust() { return new PredefinedIcon(IconSpecs.fas.adjust.iconSpec); }
        static PredefinedIcon airFreshener() { return new PredefinedIcon(IconSpecs.fas.airFreshener.iconSpec); }
        static PredefinedIcon alignCenter() { return new PredefinedIcon(IconSpecs.fas.alignCenter.iconSpec); }
        static PredefinedIcon alignJustify() { return new PredefinedIcon(IconSpecs.fas.alignJustify.iconSpec); }
        static PredefinedIcon alignLeft() { return new PredefinedIcon(IconSpecs.fas.alignLeft.iconSpec); }
        static PredefinedIcon alignRight() { return new PredefinedIcon(IconSpecs.fas.alignRight.iconSpec); }
        static PredefinedIcon allergies() { return new PredefinedIcon(IconSpecs.fas.allergies.iconSpec); }
        static PredefinedIcon ambulance() { return new PredefinedIcon(IconSpecs.fas.ambulance.iconSpec); }
        static PredefinedIcon americanSignLanguageInterpreting() { return new PredefinedIcon(IconSpecs.fas.americanSignLanguageInterpreting.iconSpec); }
        static PredefinedIcon anchor() { return new PredefinedIcon(IconSpecs.fas.anchor.iconSpec); }
        static PredefinedIcon angleDoubleDown() { return new PredefinedIcon(IconSpecs.fas.angleDoubleDown.iconSpec); }
        static PredefinedIcon angleDoubleLeft() { return new PredefinedIcon(IconSpecs.fas.angleDoubleLeft.iconSpec); }
        static PredefinedIcon angleDoubleRight() { return new PredefinedIcon(IconSpecs.fas.angleDoubleRight.iconSpec); }
        static PredefinedIcon angleDoubleUp() { return new PredefinedIcon(IconSpecs.fas.angleDoubleUp.iconSpec); }
        static PredefinedIcon angleDown() { return new PredefinedIcon(IconSpecs.fas.angleDown.iconSpec); }
        static PredefinedIcon angleLeft() { return new PredefinedIcon(IconSpecs.fas.angleLeft.iconSpec); }
        static PredefinedIcon angleRight() { return new PredefinedIcon(IconSpecs.fas.angleRight.iconSpec); }
        static PredefinedIcon angleUp() { return new PredefinedIcon(IconSpecs.fas.angleUp.iconSpec); }
        static PredefinedIcon angry() { return new PredefinedIcon(IconSpecs.fas.angry.iconSpec); }
        static PredefinedIcon ankh() { return new PredefinedIcon(IconSpecs.fas.ankh.iconSpec); }
        static PredefinedIcon appleAlt() { return new PredefinedIcon(IconSpecs.fas.appleAlt.iconSpec); }
        static PredefinedIcon archive() { return new PredefinedIcon(IconSpecs.fas.archive.iconSpec); }
        static PredefinedIcon archway() { return new PredefinedIcon(IconSpecs.fas.archway.iconSpec); }
        static PredefinedIcon arrowAltCircleDown() { return new PredefinedIcon(IconSpecs.fas.arrowAltCircleDown.iconSpec); }
        static PredefinedIcon arrowAltCircleLeft() { return new PredefinedIcon(IconSpecs.fas.arrowAltCircleLeft.iconSpec); }
        static PredefinedIcon arrowAltCircleRight() { return new PredefinedIcon(IconSpecs.fas.arrowAltCircleRight.iconSpec); }
        static PredefinedIcon arrowAltCircleUp() { return new PredefinedIcon(IconSpecs.fas.arrowAltCircleUp.iconSpec); }
        static PredefinedIcon arrowCircleDown() { return new PredefinedIcon(IconSpecs.fas.arrowCircleDown.iconSpec); }
        static PredefinedIcon arrowCircleLeft() { return new PredefinedIcon(IconSpecs.fas.arrowCircleLeft.iconSpec); }
        static PredefinedIcon arrowCircleRight() { return new PredefinedIcon(IconSpecs.fas.arrowCircleRight.iconSpec); }
        static PredefinedIcon arrowCircleUp() { return new PredefinedIcon(IconSpecs.fas.arrowCircleUp.iconSpec); }
        static PredefinedIcon arrowDown() { return new PredefinedIcon(IconSpecs.fas.arrowDown.iconSpec); }
        static PredefinedIcon arrowLeft() { return new PredefinedIcon(IconSpecs.fas.arrowLeft.iconSpec); }
        static PredefinedIcon arrowRight() { return new PredefinedIcon(IconSpecs.fas.arrowRight.iconSpec); }
        static PredefinedIcon arrowUp() { return new PredefinedIcon(IconSpecs.fas.arrowUp.iconSpec); }
        static PredefinedIcon arrowsAlt() { return new PredefinedIcon(IconSpecs.fas.arrowsAlt.iconSpec); }
        static PredefinedIcon arrowsAltH() { return new PredefinedIcon(IconSpecs.fas.arrowsAltH.iconSpec); }
        static PredefinedIcon arrowsAltV() { return new PredefinedIcon(IconSpecs.fas.arrowsAltV.iconSpec); }
        static PredefinedIcon assistiveListeningSystems() { return new PredefinedIcon(IconSpecs.fas.assistiveListeningSystems.iconSpec); }
        static PredefinedIcon asterisk() { return new PredefinedIcon(IconSpecs.fas.asterisk.iconSpec); }
        static PredefinedIcon at() { return new PredefinedIcon(IconSpecs.fas.at.iconSpec); }
        static PredefinedIcon atlas() { return new PredefinedIcon(IconSpecs.fas.atlas.iconSpec); }
        static PredefinedIcon atom() { return new PredefinedIcon(IconSpecs.fas.atom.iconSpec); }
        static PredefinedIcon audioDescription() { return new PredefinedIcon(IconSpecs.fas.audioDescription.iconSpec); }
        static PredefinedIcon award() { return new PredefinedIcon(IconSpecs.fas.award.iconSpec); }
        static PredefinedIcon baby() { return new PredefinedIcon(IconSpecs.fas.baby.iconSpec); }
        static PredefinedIcon babyCarriage() { return new PredefinedIcon(IconSpecs.fas.babyCarriage.iconSpec); }
        static PredefinedIcon backspace() { return new PredefinedIcon(IconSpecs.fas.backspace.iconSpec); }
        static PredefinedIcon backward() { return new PredefinedIcon(IconSpecs.fas.backward.iconSpec); }
        static PredefinedIcon bacon() { return new PredefinedIcon(IconSpecs.fas.bacon.iconSpec); }
        static PredefinedIcon bacteria() { return new PredefinedIcon(IconSpecs.fas.bacteria.iconSpec); }
        static PredefinedIcon bacterium() { return new PredefinedIcon(IconSpecs.fas.bacterium.iconSpec); }
        static PredefinedIcon bahai() { return new PredefinedIcon(IconSpecs.fas.bahai.iconSpec); }
        static PredefinedIcon balanceScale() { return new PredefinedIcon(IconSpecs.fas.balanceScale.iconSpec); }
        static PredefinedIcon balanceScaleLeft() { return new PredefinedIcon(IconSpecs.fas.balanceScaleLeft.iconSpec); }
        static PredefinedIcon balanceScaleRight() { return new PredefinedIcon(IconSpecs.fas.balanceScaleRight.iconSpec); }
        static PredefinedIcon ban() { return new PredefinedIcon(IconSpecs.fas.ban.iconSpec); }
        static PredefinedIcon bandAid() { return new PredefinedIcon(IconSpecs.fas.bandAid.iconSpec); }
        static PredefinedIcon barcode() { return new PredefinedIcon(IconSpecs.fas.barcode.iconSpec); }
        static PredefinedIcon bars() { return new PredefinedIcon(IconSpecs.fas.bars.iconSpec); }
        static PredefinedIcon baseballBall() { return new PredefinedIcon(IconSpecs.fas.baseballBall.iconSpec); }
        static PredefinedIcon basketballBall() { return new PredefinedIcon(IconSpecs.fas.basketballBall.iconSpec); }
        static PredefinedIcon bath() { return new PredefinedIcon(IconSpecs.fas.bath.iconSpec); }
        static PredefinedIcon batteryEmpty() { return new PredefinedIcon(IconSpecs.fas.batteryEmpty.iconSpec); }
        static PredefinedIcon batteryFull() { return new PredefinedIcon(IconSpecs.fas.batteryFull.iconSpec); }
        static PredefinedIcon batteryHalf() { return new PredefinedIcon(IconSpecs.fas.batteryHalf.iconSpec); }
        static PredefinedIcon batteryQuarter() { return new PredefinedIcon(IconSpecs.fas.batteryQuarter.iconSpec); }
        static PredefinedIcon batteryThreeQuarters() { return new PredefinedIcon(IconSpecs.fas.batteryThreeQuarters.iconSpec); }
        static PredefinedIcon bed() { return new PredefinedIcon(IconSpecs.fas.bed.iconSpec); }
        static PredefinedIcon beer() { return new PredefinedIcon(IconSpecs.fas.beer.iconSpec); }
        static PredefinedIcon bell() { return new PredefinedIcon(IconSpecs.fas.bell.iconSpec); }
        static PredefinedIcon bellSlash() { return new PredefinedIcon(IconSpecs.fas.bellSlash.iconSpec); }
        static PredefinedIcon bezierCurve() { return new PredefinedIcon(IconSpecs.fas.bezierCurve.iconSpec); }
        static PredefinedIcon bible() { return new PredefinedIcon(IconSpecs.fas.bible.iconSpec); }
        static PredefinedIcon bicycle() { return new PredefinedIcon(IconSpecs.fas.bicycle.iconSpec); }
        static PredefinedIcon biking() { return new PredefinedIcon(IconSpecs.fas.biking.iconSpec); }
        static PredefinedIcon binoculars() { return new PredefinedIcon(IconSpecs.fas.binoculars.iconSpec); }
        static PredefinedIcon biohazard() { return new PredefinedIcon(IconSpecs.fas.biohazard.iconSpec); }
        static PredefinedIcon birthdayCake() { return new PredefinedIcon(IconSpecs.fas.birthdayCake.iconSpec); }
        static PredefinedIcon blender() { return new PredefinedIcon(IconSpecs.fas.blender.iconSpec); }
        static PredefinedIcon blenderPhone() { return new PredefinedIcon(IconSpecs.fas.blenderPhone.iconSpec); }
        static PredefinedIcon blind() { return new PredefinedIcon(IconSpecs.fas.blind.iconSpec); }
        static PredefinedIcon blog() { return new PredefinedIcon(IconSpecs.fas.blog.iconSpec); }
        static PredefinedIcon bold() { return new PredefinedIcon(IconSpecs.fas.bold.iconSpec); }
        static PredefinedIcon bolt() { return new PredefinedIcon(IconSpecs.fas.bolt.iconSpec); }
        static PredefinedIcon bomb() { return new PredefinedIcon(IconSpecs.fas.bomb.iconSpec); }
        static PredefinedIcon bone() { return new PredefinedIcon(IconSpecs.fas.bone.iconSpec); }
        static PredefinedIcon bong() { return new PredefinedIcon(IconSpecs.fas.bong.iconSpec); }
        static PredefinedIcon book() { return new PredefinedIcon(IconSpecs.fas.book.iconSpec); }
        static PredefinedIcon bookDead() { return new PredefinedIcon(IconSpecs.fas.bookDead.iconSpec); }
        static PredefinedIcon bookMedical() { return new PredefinedIcon(IconSpecs.fas.bookMedical.iconSpec); }
        static PredefinedIcon bookOpen() { return new PredefinedIcon(IconSpecs.fas.bookOpen.iconSpec); }
        static PredefinedIcon bookReader() { return new PredefinedIcon(IconSpecs.fas.bookReader.iconSpec); }
        static PredefinedIcon bookmark() { return new PredefinedIcon(IconSpecs.fas.bookmark.iconSpec); }
        static PredefinedIcon borderAll() { return new PredefinedIcon(IconSpecs.fas.borderAll.iconSpec); }
        static PredefinedIcon borderNone() { return new PredefinedIcon(IconSpecs.fas.borderNone.iconSpec); }
        static PredefinedIcon borderStyle() { return new PredefinedIcon(IconSpecs.fas.borderStyle.iconSpec); }
        static PredefinedIcon bowlingBall() { return new PredefinedIcon(IconSpecs.fas.bowlingBall.iconSpec); }
        static PredefinedIcon box() { return new PredefinedIcon(IconSpecs.fas.box.iconSpec); }
        static PredefinedIcon boxOpen() { return new PredefinedIcon(IconSpecs.fas.boxOpen.iconSpec); }
        static PredefinedIcon boxTissue() { return new PredefinedIcon(IconSpecs.fas.boxTissue.iconSpec); }
        static PredefinedIcon boxes() { return new PredefinedIcon(IconSpecs.fas.boxes.iconSpec); }
        static PredefinedIcon braille() { return new PredefinedIcon(IconSpecs.fas.braille.iconSpec); }
        static PredefinedIcon brain() { return new PredefinedIcon(IconSpecs.fas.brain.iconSpec); }
        static PredefinedIcon breadSlice() { return new PredefinedIcon(IconSpecs.fas.breadSlice.iconSpec); }
        static PredefinedIcon briefcase() { return new PredefinedIcon(IconSpecs.fas.briefcase.iconSpec); }
        static PredefinedIcon briefcaseMedical() { return new PredefinedIcon(IconSpecs.fas.briefcaseMedical.iconSpec); }
        static PredefinedIcon broadcastTower() { return new PredefinedIcon(IconSpecs.fas.broadcastTower.iconSpec); }
        static PredefinedIcon broom() { return new PredefinedIcon(IconSpecs.fas.broom.iconSpec); }
        static PredefinedIcon brush() { return new PredefinedIcon(IconSpecs.fas.brush.iconSpec); }
        static PredefinedIcon bug() { return new PredefinedIcon(IconSpecs.fas.bug.iconSpec); }
        static PredefinedIcon building() { return new PredefinedIcon(IconSpecs.fas.building.iconSpec); }
        static PredefinedIcon bullhorn() { return new PredefinedIcon(IconSpecs.fas.bullhorn.iconSpec); }
        static PredefinedIcon bullseye() { return new PredefinedIcon(IconSpecs.fas.bullseye.iconSpec); }
        static PredefinedIcon burn() { return new PredefinedIcon(IconSpecs.fas.burn.iconSpec); }
        static PredefinedIcon bus() { return new PredefinedIcon(IconSpecs.fas.bus.iconSpec); }
        static PredefinedIcon busAlt() { return new PredefinedIcon(IconSpecs.fas.busAlt.iconSpec); }
        static PredefinedIcon businessTime() { return new PredefinedIcon(IconSpecs.fas.businessTime.iconSpec); }
        static PredefinedIcon calculator() { return new PredefinedIcon(IconSpecs.fas.calculator.iconSpec); }
        static PredefinedIcon calendar() { return new PredefinedIcon(IconSpecs.fas.calendar.iconSpec); }
        static PredefinedIcon calendarAlt() { return new PredefinedIcon(IconSpecs.fas.calendarAlt.iconSpec); }
        static PredefinedIcon calendarCheck() { return new PredefinedIcon(IconSpecs.fas.calendarCheck.iconSpec); }
        static PredefinedIcon calendarDay() { return new PredefinedIcon(IconSpecs.fas.calendarDay.iconSpec); }
        static PredefinedIcon calendarMinus() { return new PredefinedIcon(IconSpecs.fas.calendarMinus.iconSpec); }
        static PredefinedIcon calendarPlus() { return new PredefinedIcon(IconSpecs.fas.calendarPlus.iconSpec); }
        static PredefinedIcon calendarTimes() { return new PredefinedIcon(IconSpecs.fas.calendarTimes.iconSpec); }
        static PredefinedIcon calendarWeek() { return new PredefinedIcon(IconSpecs.fas.calendarWeek.iconSpec); }
        static PredefinedIcon camera() { return new PredefinedIcon(IconSpecs.fas.camera.iconSpec); }
        static PredefinedIcon cameraRetro() { return new PredefinedIcon(IconSpecs.fas.cameraRetro.iconSpec); }
        static PredefinedIcon campground() { return new PredefinedIcon(IconSpecs.fas.campground.iconSpec); }
        static PredefinedIcon candyCane() { return new PredefinedIcon(IconSpecs.fas.candyCane.iconSpec); }
        static PredefinedIcon cannabis() { return new PredefinedIcon(IconSpecs.fas.cannabis.iconSpec); }
        static PredefinedIcon capsules() { return new PredefinedIcon(IconSpecs.fas.capsules.iconSpec); }
        static PredefinedIcon car() { return new PredefinedIcon(IconSpecs.fas.car.iconSpec); }
        static PredefinedIcon carAlt() { return new PredefinedIcon(IconSpecs.fas.carAlt.iconSpec); }
        static PredefinedIcon carBattery() { return new PredefinedIcon(IconSpecs.fas.carBattery.iconSpec); }
        static PredefinedIcon carCrash() { return new PredefinedIcon(IconSpecs.fas.carCrash.iconSpec); }
        static PredefinedIcon carSide() { return new PredefinedIcon(IconSpecs.fas.carSide.iconSpec); }
        static PredefinedIcon caravan() { return new PredefinedIcon(IconSpecs.fas.caravan.iconSpec); }
        static PredefinedIcon caretDown() { return new PredefinedIcon(IconSpecs.fas.caretDown.iconSpec); }
        static PredefinedIcon caretLeft() { return new PredefinedIcon(IconSpecs.fas.caretLeft.iconSpec); }
        static PredefinedIcon caretRight() { return new PredefinedIcon(IconSpecs.fas.caretRight.iconSpec); }
        static PredefinedIcon caretSquareDown() { return new PredefinedIcon(IconSpecs.fas.caretSquareDown.iconSpec); }
        static PredefinedIcon caretSquareLeft() { return new PredefinedIcon(IconSpecs.fas.caretSquareLeft.iconSpec); }
        static PredefinedIcon caretSquareRight() { return new PredefinedIcon(IconSpecs.fas.caretSquareRight.iconSpec); }
        static PredefinedIcon caretSquareUp() { return new PredefinedIcon(IconSpecs.fas.caretSquareUp.iconSpec); }
        static PredefinedIcon caretUp() { return new PredefinedIcon(IconSpecs.fas.caretUp.iconSpec); }
        static PredefinedIcon carrot() { return new PredefinedIcon(IconSpecs.fas.carrot.iconSpec); }
        static PredefinedIcon cartArrowDown() { return new PredefinedIcon(IconSpecs.fas.cartArrowDown.iconSpec); }
        static PredefinedIcon cartPlus() { return new PredefinedIcon(IconSpecs.fas.cartPlus.iconSpec); }
        static PredefinedIcon cashRegister() { return new PredefinedIcon(IconSpecs.fas.cashRegister.iconSpec); }
        static PredefinedIcon cat() { return new PredefinedIcon(IconSpecs.fas.cat.iconSpec); }
        static PredefinedIcon certificate() { return new PredefinedIcon(IconSpecs.fas.certificate.iconSpec); }
        static PredefinedIcon chair() { return new PredefinedIcon(IconSpecs.fas.chair.iconSpec); }
        static PredefinedIcon chalkboard() { return new PredefinedIcon(IconSpecs.fas.chalkboard.iconSpec); }
        static PredefinedIcon chalkboardTeacher() { return new PredefinedIcon(IconSpecs.fas.chalkboardTeacher.iconSpec); }
        static PredefinedIcon chargingStation() { return new PredefinedIcon(IconSpecs.fas.chargingStation.iconSpec); }
        static PredefinedIcon chartArea() { return new PredefinedIcon(IconSpecs.fas.chartArea.iconSpec); }
        static PredefinedIcon chartBar() { return new PredefinedIcon(IconSpecs.fas.chartBar.iconSpec); }
        static PredefinedIcon chartLine() { return new PredefinedIcon(IconSpecs.fas.chartLine.iconSpec); }
        static PredefinedIcon chartPie() { return new PredefinedIcon(IconSpecs.fas.chartPie.iconSpec); }
        static PredefinedIcon check() { return new PredefinedIcon(IconSpecs.fas.check.iconSpec); }
        static PredefinedIcon checkCircle() { return new PredefinedIcon(IconSpecs.fas.checkCircle.iconSpec); }
        static PredefinedIcon checkDouble() { return new PredefinedIcon(IconSpecs.fas.checkDouble.iconSpec); }
        static PredefinedIcon checkSquare() { return new PredefinedIcon(IconSpecs.fas.checkSquare.iconSpec); }
        static PredefinedIcon cheese() { return new PredefinedIcon(IconSpecs.fas.cheese.iconSpec); }
        static PredefinedIcon chess() { return new PredefinedIcon(IconSpecs.fas.chess.iconSpec); }
        static PredefinedIcon chessBishop() { return new PredefinedIcon(IconSpecs.fas.chessBishop.iconSpec); }
        static PredefinedIcon chessBoard() { return new PredefinedIcon(IconSpecs.fas.chessBoard.iconSpec); }
        static PredefinedIcon chessKing() { return new PredefinedIcon(IconSpecs.fas.chessKing.iconSpec); }
        static PredefinedIcon chessKnight() { return new PredefinedIcon(IconSpecs.fas.chessKnight.iconSpec); }
        static PredefinedIcon chessPawn() { return new PredefinedIcon(IconSpecs.fas.chessPawn.iconSpec); }
        static PredefinedIcon chessQueen() { return new PredefinedIcon(IconSpecs.fas.chessQueen.iconSpec); }
        static PredefinedIcon chessRook() { return new PredefinedIcon(IconSpecs.fas.chessRook.iconSpec); }
        static PredefinedIcon chevronCircleDown() { return new PredefinedIcon(IconSpecs.fas.chevronCircleDown.iconSpec); }
        static PredefinedIcon chevronCircleLeft() { return new PredefinedIcon(IconSpecs.fas.chevronCircleLeft.iconSpec); }
        static PredefinedIcon chevronCircleRight() { return new PredefinedIcon(IconSpecs.fas.chevronCircleRight.iconSpec); }
        static PredefinedIcon chevronCircleUp() { return new PredefinedIcon(IconSpecs.fas.chevronCircleUp.iconSpec); }
        static PredefinedIcon chevronDown() { return new PredefinedIcon(IconSpecs.fas.chevronDown.iconSpec); }
        static PredefinedIcon chevronLeft() { return new PredefinedIcon(IconSpecs.fas.chevronLeft.iconSpec); }
        static PredefinedIcon chevronRight() { return new PredefinedIcon(IconSpecs.fas.chevronRight.iconSpec); }
        static PredefinedIcon chevronUp() { return new PredefinedIcon(IconSpecs.fas.chevronUp.iconSpec); }
        static PredefinedIcon child() { return new PredefinedIcon(IconSpecs.fas.child.iconSpec); }
        static PredefinedIcon church() { return new PredefinedIcon(IconSpecs.fas.church.iconSpec); }
        static PredefinedIcon circle() { return new PredefinedIcon(IconSpecs.fas.circle.iconSpec); }
        static PredefinedIcon circleNotch() { return new PredefinedIcon(IconSpecs.fas.circleNotch.iconSpec); }
        static PredefinedIcon city() { return new PredefinedIcon(IconSpecs.fas.city.iconSpec); }
        static PredefinedIcon clinicMedical() { return new PredefinedIcon(IconSpecs.fas.clinicMedical.iconSpec); }
        static PredefinedIcon clipboard() { return new PredefinedIcon(IconSpecs.fas.clipboard.iconSpec); }
        static PredefinedIcon clipboardCheck() { return new PredefinedIcon(IconSpecs.fas.clipboardCheck.iconSpec); }
        static PredefinedIcon clipboardList() { return new PredefinedIcon(IconSpecs.fas.clipboardList.iconSpec); }
        static PredefinedIcon clock() { return new PredefinedIcon(IconSpecs.fas.clock.iconSpec); }
        static PredefinedIcon clone_() { return new PredefinedIcon(IconSpecs.fas.clone_.iconSpec); }
        static PredefinedIcon closedCaptioning() { return new PredefinedIcon(IconSpecs.fas.closedCaptioning.iconSpec); }
        static PredefinedIcon cloud() { return new PredefinedIcon(IconSpecs.fas.cloud.iconSpec); }
        static PredefinedIcon cloudDownloadAlt() { return new PredefinedIcon(IconSpecs.fas.cloudDownloadAlt.iconSpec); }
        static PredefinedIcon cloudMeatball() { return new PredefinedIcon(IconSpecs.fas.cloudMeatball.iconSpec); }
        static PredefinedIcon cloudMoon() { return new PredefinedIcon(IconSpecs.fas.cloudMoon.iconSpec); }
        static PredefinedIcon cloudMoonRain() { return new PredefinedIcon(IconSpecs.fas.cloudMoonRain.iconSpec); }
        static PredefinedIcon cloudRain() { return new PredefinedIcon(IconSpecs.fas.cloudRain.iconSpec); }
        static PredefinedIcon cloudShowersHeavy() { return new PredefinedIcon(IconSpecs.fas.cloudShowersHeavy.iconSpec); }
        static PredefinedIcon cloudSun() { return new PredefinedIcon(IconSpecs.fas.cloudSun.iconSpec); }
        static PredefinedIcon cloudSunRain() { return new PredefinedIcon(IconSpecs.fas.cloudSunRain.iconSpec); }
        static PredefinedIcon cloudUploadAlt() { return new PredefinedIcon(IconSpecs.fas.cloudUploadAlt.iconSpec); }
        static PredefinedIcon cocktail() { return new PredefinedIcon(IconSpecs.fas.cocktail.iconSpec); }
        static PredefinedIcon code() { return new PredefinedIcon(IconSpecs.fas.code.iconSpec); }
        static PredefinedIcon codeBranch() { return new PredefinedIcon(IconSpecs.fas.codeBranch.iconSpec); }
        static PredefinedIcon coffee() { return new PredefinedIcon(IconSpecs.fas.coffee.iconSpec); }
        static PredefinedIcon cog() { return new PredefinedIcon(IconSpecs.fas.cog.iconSpec); }
        static PredefinedIcon cogs() { return new PredefinedIcon(IconSpecs.fas.cogs.iconSpec); }
        static PredefinedIcon coins() { return new PredefinedIcon(IconSpecs.fas.coins.iconSpec); }
        static PredefinedIcon columns() { return new PredefinedIcon(IconSpecs.fas.columns.iconSpec); }
        static PredefinedIcon comment() { return new PredefinedIcon(IconSpecs.fas.comment.iconSpec); }
        static PredefinedIcon commentAlt() { return new PredefinedIcon(IconSpecs.fas.commentAlt.iconSpec); }
        static PredefinedIcon commentDollar() { return new PredefinedIcon(IconSpecs.fas.commentDollar.iconSpec); }
        static PredefinedIcon commentDots() { return new PredefinedIcon(IconSpecs.fas.commentDots.iconSpec); }
        static PredefinedIcon commentMedical() { return new PredefinedIcon(IconSpecs.fas.commentMedical.iconSpec); }
        static PredefinedIcon commentSlash() { return new PredefinedIcon(IconSpecs.fas.commentSlash.iconSpec); }
        static PredefinedIcon comments() { return new PredefinedIcon(IconSpecs.fas.comments.iconSpec); }
        static PredefinedIcon commentsDollar() { return new PredefinedIcon(IconSpecs.fas.commentsDollar.iconSpec); }
        static PredefinedIcon compactDisc() { return new PredefinedIcon(IconSpecs.fas.compactDisc.iconSpec); }
        static PredefinedIcon compass() { return new PredefinedIcon(IconSpecs.fas.compass.iconSpec); }
        static PredefinedIcon compress() { return new PredefinedIcon(IconSpecs.fas.compress.iconSpec); }
        static PredefinedIcon compressAlt() { return new PredefinedIcon(IconSpecs.fas.compressAlt.iconSpec); }
        static PredefinedIcon compressArrowsAlt() { return new PredefinedIcon(IconSpecs.fas.compressArrowsAlt.iconSpec); }
        static PredefinedIcon conciergeBell() { return new PredefinedIcon(IconSpecs.fas.conciergeBell.iconSpec); }
        static PredefinedIcon cookie() { return new PredefinedIcon(IconSpecs.fas.cookie.iconSpec); }
        static PredefinedIcon cookieBite() { return new PredefinedIcon(IconSpecs.fas.cookieBite.iconSpec); }
        static PredefinedIcon copy() { return new PredefinedIcon(IconSpecs.fas.copy.iconSpec); }
        static PredefinedIcon copyright() { return new PredefinedIcon(IconSpecs.fas.copyright.iconSpec); }
        static PredefinedIcon couch() { return new PredefinedIcon(IconSpecs.fas.couch.iconSpec); }
        static PredefinedIcon creditCard() { return new PredefinedIcon(IconSpecs.fas.creditCard.iconSpec); }
        static PredefinedIcon crop() { return new PredefinedIcon(IconSpecs.fas.crop.iconSpec); }
        static PredefinedIcon cropAlt() { return new PredefinedIcon(IconSpecs.fas.cropAlt.iconSpec); }
        static PredefinedIcon cross() { return new PredefinedIcon(IconSpecs.fas.cross.iconSpec); }
        static PredefinedIcon crosshairs() { return new PredefinedIcon(IconSpecs.fas.crosshairs.iconSpec); }
        static PredefinedIcon crow() { return new PredefinedIcon(IconSpecs.fas.crow.iconSpec); }
        static PredefinedIcon crown() { return new PredefinedIcon(IconSpecs.fas.crown.iconSpec); }
        static PredefinedIcon crutch() { return new PredefinedIcon(IconSpecs.fas.crutch.iconSpec); }
        static PredefinedIcon cube() { return new PredefinedIcon(IconSpecs.fas.cube.iconSpec); }
        static PredefinedIcon cubes() { return new PredefinedIcon(IconSpecs.fas.cubes.iconSpec); }
        static PredefinedIcon cut() { return new PredefinedIcon(IconSpecs.fas.cut.iconSpec); }
        static PredefinedIcon database() { return new PredefinedIcon(IconSpecs.fas.database.iconSpec); }
        static PredefinedIcon deaf() { return new PredefinedIcon(IconSpecs.fas.deaf.iconSpec); }
        static PredefinedIcon democrat() { return new PredefinedIcon(IconSpecs.fas.democrat.iconSpec); }
        static PredefinedIcon desktop() { return new PredefinedIcon(IconSpecs.fas.desktop.iconSpec); }
        static PredefinedIcon dharmachakra() { return new PredefinedIcon(IconSpecs.fas.dharmachakra.iconSpec); }
        static PredefinedIcon diagnoses() { return new PredefinedIcon(IconSpecs.fas.diagnoses.iconSpec); }
        static PredefinedIcon dice() { return new PredefinedIcon(IconSpecs.fas.dice.iconSpec); }
        static PredefinedIcon diceD20() { return new PredefinedIcon(IconSpecs.fas.diceD20.iconSpec); }
        static PredefinedIcon diceD6() { return new PredefinedIcon(IconSpecs.fas.diceD6.iconSpec); }
        static PredefinedIcon diceFive() { return new PredefinedIcon(IconSpecs.fas.diceFive.iconSpec); }
        static PredefinedIcon diceFour() { return new PredefinedIcon(IconSpecs.fas.diceFour.iconSpec); }
        static PredefinedIcon diceOne() { return new PredefinedIcon(IconSpecs.fas.diceOne.iconSpec); }
        static PredefinedIcon diceSix() { return new PredefinedIcon(IconSpecs.fas.diceSix.iconSpec); }
        static PredefinedIcon diceThree() { return new PredefinedIcon(IconSpecs.fas.diceThree.iconSpec); }
        static PredefinedIcon diceTwo() { return new PredefinedIcon(IconSpecs.fas.diceTwo.iconSpec); }
        static PredefinedIcon digitalTachograph() { return new PredefinedIcon(IconSpecs.fas.digitalTachograph.iconSpec); }
        static PredefinedIcon directions() { return new PredefinedIcon(IconSpecs.fas.directions.iconSpec); }
        static PredefinedIcon disease() { return new PredefinedIcon(IconSpecs.fas.disease.iconSpec); }
        static PredefinedIcon divide() { return new PredefinedIcon(IconSpecs.fas.divide.iconSpec); }
        static PredefinedIcon dizzy() { return new PredefinedIcon(IconSpecs.fas.dizzy.iconSpec); }
        static PredefinedIcon dna() { return new PredefinedIcon(IconSpecs.fas.dna.iconSpec); }
        static PredefinedIcon dog() { return new PredefinedIcon(IconSpecs.fas.dog.iconSpec); }
        static PredefinedIcon dollarSign() { return new PredefinedIcon(IconSpecs.fas.dollarSign.iconSpec); }
        static PredefinedIcon dolly() { return new PredefinedIcon(IconSpecs.fas.dolly.iconSpec); }
        static PredefinedIcon dollyFlatbed() { return new PredefinedIcon(IconSpecs.fas.dollyFlatbed.iconSpec); }
        static PredefinedIcon donate() { return new PredefinedIcon(IconSpecs.fas.donate.iconSpec); }
        static PredefinedIcon doorClosed() { return new PredefinedIcon(IconSpecs.fas.doorClosed.iconSpec); }
        static PredefinedIcon doorOpen() { return new PredefinedIcon(IconSpecs.fas.doorOpen.iconSpec); }
        static PredefinedIcon dotCircle() { return new PredefinedIcon(IconSpecs.fas.dotCircle.iconSpec); }
        static PredefinedIcon dove() { return new PredefinedIcon(IconSpecs.fas.dove.iconSpec); }
        static PredefinedIcon download() { return new PredefinedIcon(IconSpecs.fas.download.iconSpec); }
        static PredefinedIcon draftingCompass() { return new PredefinedIcon(IconSpecs.fas.draftingCompass.iconSpec); }
        static PredefinedIcon dragon() { return new PredefinedIcon(IconSpecs.fas.dragon.iconSpec); }
        static PredefinedIcon drawPolygon() { return new PredefinedIcon(IconSpecs.fas.drawPolygon.iconSpec); }
        static PredefinedIcon drum() { return new PredefinedIcon(IconSpecs.fas.drum.iconSpec); }
        static PredefinedIcon drumSteelpan() { return new PredefinedIcon(IconSpecs.fas.drumSteelpan.iconSpec); }
        static PredefinedIcon drumstickBite() { return new PredefinedIcon(IconSpecs.fas.drumstickBite.iconSpec); }
        static PredefinedIcon dumbbell() { return new PredefinedIcon(IconSpecs.fas.dumbbell.iconSpec); }
        static PredefinedIcon dumpster() { return new PredefinedIcon(IconSpecs.fas.dumpster.iconSpec); }
        static PredefinedIcon dumpsterFire() { return new PredefinedIcon(IconSpecs.fas.dumpsterFire.iconSpec); }
        static PredefinedIcon dungeon() { return new PredefinedIcon(IconSpecs.fas.dungeon.iconSpec); }
        static PredefinedIcon edit() { return new PredefinedIcon(IconSpecs.fas.edit.iconSpec); }
        static PredefinedIcon egg() { return new PredefinedIcon(IconSpecs.fas.egg.iconSpec); }
        static PredefinedIcon eject() { return new PredefinedIcon(IconSpecs.fas.eject.iconSpec); }
        static PredefinedIcon ellipsisH() { return new PredefinedIcon(IconSpecs.fas.ellipsisH.iconSpec); }
        static PredefinedIcon ellipsisV() { return new PredefinedIcon(IconSpecs.fas.ellipsisV.iconSpec); }
        static PredefinedIcon envelope() { return new PredefinedIcon(IconSpecs.fas.envelope.iconSpec); }
        static PredefinedIcon envelopeOpen() { return new PredefinedIcon(IconSpecs.fas.envelopeOpen.iconSpec); }
        static PredefinedIcon envelopeOpenText() { return new PredefinedIcon(IconSpecs.fas.envelopeOpenText.iconSpec); }
        static PredefinedIcon envelopeSquare() { return new PredefinedIcon(IconSpecs.fas.envelopeSquare.iconSpec); }
        static PredefinedIcon equals() { return new PredefinedIcon(IconSpecs.fas.equals.iconSpec); }
        static PredefinedIcon eraser() { return new PredefinedIcon(IconSpecs.fas.eraser.iconSpec); }
        static PredefinedIcon ethernet() { return new PredefinedIcon(IconSpecs.fas.ethernet.iconSpec); }
        static PredefinedIcon euroSign() { return new PredefinedIcon(IconSpecs.fas.euroSign.iconSpec); }
        static PredefinedIcon exchangeAlt() { return new PredefinedIcon(IconSpecs.fas.exchangeAlt.iconSpec); }
        static PredefinedIcon exclamation() { return new PredefinedIcon(IconSpecs.fas.exclamation.iconSpec); }
        static PredefinedIcon exclamationCircle() { return new PredefinedIcon(IconSpecs.fas.exclamationCircle.iconSpec); }
        static PredefinedIcon exclamationTriangle() { return new PredefinedIcon(IconSpecs.fas.exclamationTriangle.iconSpec); }
        static PredefinedIcon expand() { return new PredefinedIcon(IconSpecs.fas.expand.iconSpec); }
        static PredefinedIcon expandAlt() { return new PredefinedIcon(IconSpecs.fas.expandAlt.iconSpec); }
        static PredefinedIcon expandArrowsAlt() { return new PredefinedIcon(IconSpecs.fas.expandArrowsAlt.iconSpec); }
        static PredefinedIcon externalLinkAlt() { return new PredefinedIcon(IconSpecs.fas.externalLinkAlt.iconSpec); }
        static PredefinedIcon externalLinkSquareAlt() { return new PredefinedIcon(IconSpecs.fas.externalLinkSquareAlt.iconSpec); }
        static PredefinedIcon eye() { return new PredefinedIcon(IconSpecs.fas.eye.iconSpec); }
        static PredefinedIcon eyeDropper() { return new PredefinedIcon(IconSpecs.fas.eyeDropper.iconSpec); }
        static PredefinedIcon eyeSlash() { return new PredefinedIcon(IconSpecs.fas.eyeSlash.iconSpec); }
        static PredefinedIcon fan() { return new PredefinedIcon(IconSpecs.fas.fan.iconSpec); }
        static PredefinedIcon fastBackward() { return new PredefinedIcon(IconSpecs.fas.fastBackward.iconSpec); }
        static PredefinedIcon fastForward() { return new PredefinedIcon(IconSpecs.fas.fastForward.iconSpec); }
        static PredefinedIcon faucet() { return new PredefinedIcon(IconSpecs.fas.faucet.iconSpec); }
        static PredefinedIcon fax() { return new PredefinedIcon(IconSpecs.fas.fax.iconSpec); }
        static PredefinedIcon feather() { return new PredefinedIcon(IconSpecs.fas.feather.iconSpec); }
        static PredefinedIcon featherAlt() { return new PredefinedIcon(IconSpecs.fas.featherAlt.iconSpec); }
        static PredefinedIcon female() { return new PredefinedIcon(IconSpecs.fas.female.iconSpec); }
        static PredefinedIcon fighterJet() { return new PredefinedIcon(IconSpecs.fas.fighterJet.iconSpec); }
        static PredefinedIcon file() { return new PredefinedIcon(IconSpecs.fas.file.iconSpec); }
        static PredefinedIcon fileAlt() { return new PredefinedIcon(IconSpecs.fas.fileAlt.iconSpec); }
        static PredefinedIcon fileArchive() { return new PredefinedIcon(IconSpecs.fas.fileArchive.iconSpec); }
        static PredefinedIcon fileAudio() { return new PredefinedIcon(IconSpecs.fas.fileAudio.iconSpec); }
        static PredefinedIcon fileCode() { return new PredefinedIcon(IconSpecs.fas.fileCode.iconSpec); }
        static PredefinedIcon fileContract() { return new PredefinedIcon(IconSpecs.fas.fileContract.iconSpec); }
        static PredefinedIcon fileCsv() { return new PredefinedIcon(IconSpecs.fas.fileCsv.iconSpec); }
        static PredefinedIcon fileDownload() { return new PredefinedIcon(IconSpecs.fas.fileDownload.iconSpec); }
        static PredefinedIcon fileExcel() { return new PredefinedIcon(IconSpecs.fas.fileExcel.iconSpec); }
        static PredefinedIcon fileExport() { return new PredefinedIcon(IconSpecs.fas.fileExport.iconSpec); }
        static PredefinedIcon fileImage() { return new PredefinedIcon(IconSpecs.fas.fileImage.iconSpec); }
        static PredefinedIcon fileImport() { return new PredefinedIcon(IconSpecs.fas.fileImport.iconSpec); }
        static PredefinedIcon fileInvoice() { return new PredefinedIcon(IconSpecs.fas.fileInvoice.iconSpec); }
        static PredefinedIcon fileInvoiceDollar() { return new PredefinedIcon(IconSpecs.fas.fileInvoiceDollar.iconSpec); }
        static PredefinedIcon fileMedical() { return new PredefinedIcon(IconSpecs.fas.fileMedical.iconSpec); }
        static PredefinedIcon fileMedicalAlt() { return new PredefinedIcon(IconSpecs.fas.fileMedicalAlt.iconSpec); }
        static PredefinedIcon filePdf() { return new PredefinedIcon(IconSpecs.fas.filePdf.iconSpec); }
        static PredefinedIcon filePowerpoint() { return new PredefinedIcon(IconSpecs.fas.filePowerpoint.iconSpec); }
        static PredefinedIcon filePrescription() { return new PredefinedIcon(IconSpecs.fas.filePrescription.iconSpec); }
        static PredefinedIcon fileSignature() { return new PredefinedIcon(IconSpecs.fas.fileSignature.iconSpec); }
        static PredefinedIcon fileUpload() { return new PredefinedIcon(IconSpecs.fas.fileUpload.iconSpec); }
        static PredefinedIcon fileVideo() { return new PredefinedIcon(IconSpecs.fas.fileVideo.iconSpec); }
        static PredefinedIcon fileWord() { return new PredefinedIcon(IconSpecs.fas.fileWord.iconSpec); }
        static PredefinedIcon fill() { return new PredefinedIcon(IconSpecs.fas.fill.iconSpec); }
        static PredefinedIcon fillDrip() { return new PredefinedIcon(IconSpecs.fas.fillDrip.iconSpec); }
        static PredefinedIcon film() { return new PredefinedIcon(IconSpecs.fas.film.iconSpec); }
        static PredefinedIcon filter() { return new PredefinedIcon(IconSpecs.fas.filter.iconSpec); }
        static PredefinedIcon fingerprint() { return new PredefinedIcon(IconSpecs.fas.fingerprint.iconSpec); }
        static PredefinedIcon fire() { return new PredefinedIcon(IconSpecs.fas.fire.iconSpec); }
        static PredefinedIcon fireAlt() { return new PredefinedIcon(IconSpecs.fas.fireAlt.iconSpec); }
        static PredefinedIcon fireExtinguisher() { return new PredefinedIcon(IconSpecs.fas.fireExtinguisher.iconSpec); }
        static PredefinedIcon firstAid() { return new PredefinedIcon(IconSpecs.fas.firstAid.iconSpec); }
        static PredefinedIcon fish() { return new PredefinedIcon(IconSpecs.fas.fish.iconSpec); }
        static PredefinedIcon fistRaised() { return new PredefinedIcon(IconSpecs.fas.fistRaised.iconSpec); }
        static PredefinedIcon flag() { return new PredefinedIcon(IconSpecs.fas.flag.iconSpec); }
        static PredefinedIcon flagCheckered() { return new PredefinedIcon(IconSpecs.fas.flagCheckered.iconSpec); }
        static PredefinedIcon flagUsa() { return new PredefinedIcon(IconSpecs.fas.flagUsa.iconSpec); }
        static PredefinedIcon flask() { return new PredefinedIcon(IconSpecs.fas.flask.iconSpec); }
        static PredefinedIcon flushed() { return new PredefinedIcon(IconSpecs.fas.flushed.iconSpec); }
        static PredefinedIcon folder() { return new PredefinedIcon(IconSpecs.fas.folder.iconSpec); }
        static PredefinedIcon folderMinus() { return new PredefinedIcon(IconSpecs.fas.folderMinus.iconSpec); }
        static PredefinedIcon folderOpen() { return new PredefinedIcon(IconSpecs.fas.folderOpen.iconSpec); }
        static PredefinedIcon folderPlus() { return new PredefinedIcon(IconSpecs.fas.folderPlus.iconSpec); }
        static PredefinedIcon font() { return new PredefinedIcon(IconSpecs.fas.font.iconSpec); }
        static PredefinedIcon footballBall() { return new PredefinedIcon(IconSpecs.fas.footballBall.iconSpec); }
        static PredefinedIcon forward() { return new PredefinedIcon(IconSpecs.fas.forward.iconSpec); }
        static PredefinedIcon frog() { return new PredefinedIcon(IconSpecs.fas.frog.iconSpec); }
        static PredefinedIcon frown() { return new PredefinedIcon(IconSpecs.fas.frown.iconSpec); }
        static PredefinedIcon frownOpen() { return new PredefinedIcon(IconSpecs.fas.frownOpen.iconSpec); }
        static PredefinedIcon funnelDollar() { return new PredefinedIcon(IconSpecs.fas.funnelDollar.iconSpec); }
        static PredefinedIcon futbol() { return new PredefinedIcon(IconSpecs.fas.futbol.iconSpec); }
        static PredefinedIcon gamepad() { return new PredefinedIcon(IconSpecs.fas.gamepad.iconSpec); }
        static PredefinedIcon gasPump() { return new PredefinedIcon(IconSpecs.fas.gasPump.iconSpec); }
        static PredefinedIcon gavel() { return new PredefinedIcon(IconSpecs.fas.gavel.iconSpec); }
        static PredefinedIcon gem() { return new PredefinedIcon(IconSpecs.fas.gem.iconSpec); }
        static PredefinedIcon genderless() { return new PredefinedIcon(IconSpecs.fas.genderless.iconSpec); }
        static PredefinedIcon ghost() { return new PredefinedIcon(IconSpecs.fas.ghost.iconSpec); }
        static PredefinedIcon gift() { return new PredefinedIcon(IconSpecs.fas.gift.iconSpec); }
        static PredefinedIcon gifts() { return new PredefinedIcon(IconSpecs.fas.gifts.iconSpec); }
        static PredefinedIcon glassCheers() { return new PredefinedIcon(IconSpecs.fas.glassCheers.iconSpec); }
        static PredefinedIcon glassMartini() { return new PredefinedIcon(IconSpecs.fas.glassMartini.iconSpec); }
        static PredefinedIcon glassMartiniAlt() { return new PredefinedIcon(IconSpecs.fas.glassMartiniAlt.iconSpec); }
        static PredefinedIcon glassWhiskey() { return new PredefinedIcon(IconSpecs.fas.glassWhiskey.iconSpec); }
        static PredefinedIcon glasses() { return new PredefinedIcon(IconSpecs.fas.glasses.iconSpec); }
        static PredefinedIcon globe() { return new PredefinedIcon(IconSpecs.fas.globe.iconSpec); }
        static PredefinedIcon globeAfrica() { return new PredefinedIcon(IconSpecs.fas.globeAfrica.iconSpec); }
        static PredefinedIcon globeAmericas() { return new PredefinedIcon(IconSpecs.fas.globeAmericas.iconSpec); }
        static PredefinedIcon globeAsia() { return new PredefinedIcon(IconSpecs.fas.globeAsia.iconSpec); }
        static PredefinedIcon globeEurope() { return new PredefinedIcon(IconSpecs.fas.globeEurope.iconSpec); }
        static PredefinedIcon golfBall() { return new PredefinedIcon(IconSpecs.fas.golfBall.iconSpec); }
        static PredefinedIcon gopuram() { return new PredefinedIcon(IconSpecs.fas.gopuram.iconSpec); }
        static PredefinedIcon graduationCap() { return new PredefinedIcon(IconSpecs.fas.graduationCap.iconSpec); }
        static PredefinedIcon greaterThan() { return new PredefinedIcon(IconSpecs.fas.greaterThan.iconSpec); }
        static PredefinedIcon greaterThanEqual() { return new PredefinedIcon(IconSpecs.fas.greaterThanEqual.iconSpec); }
        static PredefinedIcon grimace() { return new PredefinedIcon(IconSpecs.fas.grimace.iconSpec); }
        static PredefinedIcon grin() { return new PredefinedIcon(IconSpecs.fas.grin.iconSpec); }
        static PredefinedIcon grinAlt() { return new PredefinedIcon(IconSpecs.fas.grinAlt.iconSpec); }
        static PredefinedIcon grinBeam() { return new PredefinedIcon(IconSpecs.fas.grinBeam.iconSpec); }
        static PredefinedIcon grinBeamSweat() { return new PredefinedIcon(IconSpecs.fas.grinBeamSweat.iconSpec); }
        static PredefinedIcon grinHearts() { return new PredefinedIcon(IconSpecs.fas.grinHearts.iconSpec); }
        static PredefinedIcon grinSquint() { return new PredefinedIcon(IconSpecs.fas.grinSquint.iconSpec); }
        static PredefinedIcon grinSquintTears() { return new PredefinedIcon(IconSpecs.fas.grinSquintTears.iconSpec); }
        static PredefinedIcon grinStars() { return new PredefinedIcon(IconSpecs.fas.grinStars.iconSpec); }
        static PredefinedIcon grinTears() { return new PredefinedIcon(IconSpecs.fas.grinTears.iconSpec); }
        static PredefinedIcon grinTongue() { return new PredefinedIcon(IconSpecs.fas.grinTongue.iconSpec); }
        static PredefinedIcon grinTongueSquint() { return new PredefinedIcon(IconSpecs.fas.grinTongueSquint.iconSpec); }
        static PredefinedIcon grinTongueWink() { return new PredefinedIcon(IconSpecs.fas.grinTongueWink.iconSpec); }
        static PredefinedIcon grinWink() { return new PredefinedIcon(IconSpecs.fas.grinWink.iconSpec); }
        static PredefinedIcon gripHorizontal() { return new PredefinedIcon(IconSpecs.fas.gripHorizontal.iconSpec); }
        static PredefinedIcon gripLines() { return new PredefinedIcon(IconSpecs.fas.gripLines.iconSpec); }
        static PredefinedIcon gripLinesVertical() { return new PredefinedIcon(IconSpecs.fas.gripLinesVertical.iconSpec); }
        static PredefinedIcon gripVertical() { return new PredefinedIcon(IconSpecs.fas.gripVertical.iconSpec); }
        static PredefinedIcon guitar() { return new PredefinedIcon(IconSpecs.fas.guitar.iconSpec); }
        static PredefinedIcon hSquare() { return new PredefinedIcon(IconSpecs.fas.hSquare.iconSpec); }
        static PredefinedIcon hamburger() { return new PredefinedIcon(IconSpecs.fas.hamburger.iconSpec); }
        static PredefinedIcon hammer() { return new PredefinedIcon(IconSpecs.fas.hammer.iconSpec); }
        static PredefinedIcon hamsa() { return new PredefinedIcon(IconSpecs.fas.hamsa.iconSpec); }
        static PredefinedIcon handHolding() { return new PredefinedIcon(IconSpecs.fas.handHolding.iconSpec); }
        static PredefinedIcon handHoldingHeart() { return new PredefinedIcon(IconSpecs.fas.handHoldingHeart.iconSpec); }
        static PredefinedIcon handHoldingMedical() { return new PredefinedIcon(IconSpecs.fas.handHoldingMedical.iconSpec); }
        static PredefinedIcon handHoldingUsd() { return new PredefinedIcon(IconSpecs.fas.handHoldingUsd.iconSpec); }
        static PredefinedIcon handHoldingWater() { return new PredefinedIcon(IconSpecs.fas.handHoldingWater.iconSpec); }
        static PredefinedIcon handLizard() { return new PredefinedIcon(IconSpecs.fas.handLizard.iconSpec); }
        static PredefinedIcon handMiddleFinger() { return new PredefinedIcon(IconSpecs.fas.handMiddleFinger.iconSpec); }
        static PredefinedIcon handPaper() { return new PredefinedIcon(IconSpecs.fas.handPaper.iconSpec); }
        static PredefinedIcon handPeace() { return new PredefinedIcon(IconSpecs.fas.handPeace.iconSpec); }
        static PredefinedIcon handPointDown() { return new PredefinedIcon(IconSpecs.fas.handPointDown.iconSpec); }
        static PredefinedIcon handPointLeft() { return new PredefinedIcon(IconSpecs.fas.handPointLeft.iconSpec); }
        static PredefinedIcon handPointRight() { return new PredefinedIcon(IconSpecs.fas.handPointRight.iconSpec); }
        static PredefinedIcon handPointUp() { return new PredefinedIcon(IconSpecs.fas.handPointUp.iconSpec); }
        static PredefinedIcon handPointer() { return new PredefinedIcon(IconSpecs.fas.handPointer.iconSpec); }
        static PredefinedIcon handRock() { return new PredefinedIcon(IconSpecs.fas.handRock.iconSpec); }
        static PredefinedIcon handScissors() { return new PredefinedIcon(IconSpecs.fas.handScissors.iconSpec); }
        static PredefinedIcon handSparkles() { return new PredefinedIcon(IconSpecs.fas.handSparkles.iconSpec); }
        static PredefinedIcon handSpock() { return new PredefinedIcon(IconSpecs.fas.handSpock.iconSpec); }
        static PredefinedIcon hands() { return new PredefinedIcon(IconSpecs.fas.hands.iconSpec); }
        static PredefinedIcon handsHelping() { return new PredefinedIcon(IconSpecs.fas.handsHelping.iconSpec); }
        static PredefinedIcon handsWash() { return new PredefinedIcon(IconSpecs.fas.handsWash.iconSpec); }
        static PredefinedIcon handshake() { return new PredefinedIcon(IconSpecs.fas.handshake.iconSpec); }
        static PredefinedIcon handshakeAltSlash() { return new PredefinedIcon(IconSpecs.fas.handshakeAltSlash.iconSpec); }
        static PredefinedIcon handshakeSlash() { return new PredefinedIcon(IconSpecs.fas.handshakeSlash.iconSpec); }
        static PredefinedIcon hanukiah() { return new PredefinedIcon(IconSpecs.fas.hanukiah.iconSpec); }
        static PredefinedIcon hardHat() { return new PredefinedIcon(IconSpecs.fas.hardHat.iconSpec); }
        static PredefinedIcon hashtag() { return new PredefinedIcon(IconSpecs.fas.hashtag.iconSpec); }
        static PredefinedIcon hatCowboy() { return new PredefinedIcon(IconSpecs.fas.hatCowboy.iconSpec); }
        static PredefinedIcon hatCowboySide() { return new PredefinedIcon(IconSpecs.fas.hatCowboySide.iconSpec); }
        static PredefinedIcon hatWizard() { return new PredefinedIcon(IconSpecs.fas.hatWizard.iconSpec); }
        static PredefinedIcon hdd() { return new PredefinedIcon(IconSpecs.fas.hdd.iconSpec); }
        static PredefinedIcon headSideCough() { return new PredefinedIcon(IconSpecs.fas.headSideCough.iconSpec); }
        static PredefinedIcon headSideCoughSlash() { return new PredefinedIcon(IconSpecs.fas.headSideCoughSlash.iconSpec); }
        static PredefinedIcon headSideMask() { return new PredefinedIcon(IconSpecs.fas.headSideMask.iconSpec); }
        static PredefinedIcon headSideVirus() { return new PredefinedIcon(IconSpecs.fas.headSideVirus.iconSpec); }
        static PredefinedIcon heading() { return new PredefinedIcon(IconSpecs.fas.heading.iconSpec); }
        static PredefinedIcon headphones() { return new PredefinedIcon(IconSpecs.fas.headphones.iconSpec); }
        static PredefinedIcon headphonesAlt() { return new PredefinedIcon(IconSpecs.fas.headphonesAlt.iconSpec); }
        static PredefinedIcon headset() { return new PredefinedIcon(IconSpecs.fas.headset.iconSpec); }
        static PredefinedIcon heart() { return new PredefinedIcon(IconSpecs.fas.heart.iconSpec); }
        static PredefinedIcon heartBroken() { return new PredefinedIcon(IconSpecs.fas.heartBroken.iconSpec); }
        static PredefinedIcon heartbeat() { return new PredefinedIcon(IconSpecs.fas.heartbeat.iconSpec); }
        static PredefinedIcon helicopter() { return new PredefinedIcon(IconSpecs.fas.helicopter.iconSpec); }
        static PredefinedIcon highlighter() { return new PredefinedIcon(IconSpecs.fas.highlighter.iconSpec); }
        static PredefinedIcon hiking() { return new PredefinedIcon(IconSpecs.fas.hiking.iconSpec); }
        static PredefinedIcon hippo() { return new PredefinedIcon(IconSpecs.fas.hippo.iconSpec); }
        static PredefinedIcon history() { return new PredefinedIcon(IconSpecs.fas.history.iconSpec); }
        static PredefinedIcon hockeyPuck() { return new PredefinedIcon(IconSpecs.fas.hockeyPuck.iconSpec); }
        static PredefinedIcon hollyBerry() { return new PredefinedIcon(IconSpecs.fas.hollyBerry.iconSpec); }
        static PredefinedIcon home() { return new PredefinedIcon(IconSpecs.fas.home.iconSpec); }
        static PredefinedIcon horse() { return new PredefinedIcon(IconSpecs.fas.horse.iconSpec); }
        static PredefinedIcon horseHead() { return new PredefinedIcon(IconSpecs.fas.horseHead.iconSpec); }
        static PredefinedIcon hospital() { return new PredefinedIcon(IconSpecs.fas.hospital.iconSpec); }
        static PredefinedIcon hospitalAlt() { return new PredefinedIcon(IconSpecs.fas.hospitalAlt.iconSpec); }
        static PredefinedIcon hospitalSymbol() { return new PredefinedIcon(IconSpecs.fas.hospitalSymbol.iconSpec); }
        static PredefinedIcon hospitalUser() { return new PredefinedIcon(IconSpecs.fas.hospitalUser.iconSpec); }
        static PredefinedIcon hotTub() { return new PredefinedIcon(IconSpecs.fas.hotTub.iconSpec); }
        static PredefinedIcon hotdog() { return new PredefinedIcon(IconSpecs.fas.hotdog.iconSpec); }
        static PredefinedIcon hotel() { return new PredefinedIcon(IconSpecs.fas.hotel.iconSpec); }
        static PredefinedIcon hourglass() { return new PredefinedIcon(IconSpecs.fas.hourglass.iconSpec); }
        static PredefinedIcon hourglassEnd() { return new PredefinedIcon(IconSpecs.fas.hourglassEnd.iconSpec); }
        static PredefinedIcon hourglassHalf() { return new PredefinedIcon(IconSpecs.fas.hourglassHalf.iconSpec); }
        static PredefinedIcon hourglassStart() { return new PredefinedIcon(IconSpecs.fas.hourglassStart.iconSpec); }
        static PredefinedIcon houseDamage() { return new PredefinedIcon(IconSpecs.fas.houseDamage.iconSpec); }
        static PredefinedIcon houseUser() { return new PredefinedIcon(IconSpecs.fas.houseUser.iconSpec); }
        static PredefinedIcon hryvnia() { return new PredefinedIcon(IconSpecs.fas.hryvnia.iconSpec); }
        static PredefinedIcon iCursor() { return new PredefinedIcon(IconSpecs.fas.iCursor.iconSpec); }
        static PredefinedIcon iceCream() { return new PredefinedIcon(IconSpecs.fas.iceCream.iconSpec); }
        static PredefinedIcon icicles() { return new PredefinedIcon(IconSpecs.fas.icicles.iconSpec); }
        static PredefinedIcon icons() { return new PredefinedIcon(IconSpecs.fas.icons.iconSpec); }
        static PredefinedIcon idBadge() { return new PredefinedIcon(IconSpecs.fas.idBadge.iconSpec); }
        static PredefinedIcon idCard() { return new PredefinedIcon(IconSpecs.fas.idCard.iconSpec); }
        static PredefinedIcon idCardAlt() { return new PredefinedIcon(IconSpecs.fas.idCardAlt.iconSpec); }
        static PredefinedIcon igloo() { return new PredefinedIcon(IconSpecs.fas.igloo.iconSpec); }
        static PredefinedIcon image() { return new PredefinedIcon(IconSpecs.fas.image.iconSpec); }
        static PredefinedIcon images() { return new PredefinedIcon(IconSpecs.fas.images.iconSpec); }
        static PredefinedIcon inbox() { return new PredefinedIcon(IconSpecs.fas.inbox.iconSpec); }
        static PredefinedIcon indent() { return new PredefinedIcon(IconSpecs.fas.indent.iconSpec); }
        static PredefinedIcon industry() { return new PredefinedIcon(IconSpecs.fas.industry.iconSpec); }
        static PredefinedIcon infinity() { return new PredefinedIcon(IconSpecs.fas.infinity.iconSpec); }
        static PredefinedIcon info() { return new PredefinedIcon(IconSpecs.fas.info.iconSpec); }
        static PredefinedIcon infoCircle() { return new PredefinedIcon(IconSpecs.fas.infoCircle.iconSpec); }
        static PredefinedIcon italic() { return new PredefinedIcon(IconSpecs.fas.italic.iconSpec); }
        static PredefinedIcon jedi() { return new PredefinedIcon(IconSpecs.fas.jedi.iconSpec); }
        static PredefinedIcon joint() { return new PredefinedIcon(IconSpecs.fas.joint.iconSpec); }
        static PredefinedIcon journalWhills() { return new PredefinedIcon(IconSpecs.fas.journalWhills.iconSpec); }
        static PredefinedIcon kaaba() { return new PredefinedIcon(IconSpecs.fas.kaaba.iconSpec); }
        static PredefinedIcon key() { return new PredefinedIcon(IconSpecs.fas.key.iconSpec); }
        static PredefinedIcon keyboard() { return new PredefinedIcon(IconSpecs.fas.keyboard.iconSpec); }
        static PredefinedIcon khanda() { return new PredefinedIcon(IconSpecs.fas.khanda.iconSpec); }
        static PredefinedIcon kiss() { return new PredefinedIcon(IconSpecs.fas.kiss.iconSpec); }
        static PredefinedIcon kissBeam() { return new PredefinedIcon(IconSpecs.fas.kissBeam.iconSpec); }
        static PredefinedIcon kissWinkHeart() { return new PredefinedIcon(IconSpecs.fas.kissWinkHeart.iconSpec); }
        static PredefinedIcon kiwiBird() { return new PredefinedIcon(IconSpecs.fas.kiwiBird.iconSpec); }
        static PredefinedIcon landmark() { return new PredefinedIcon(IconSpecs.fas.landmark.iconSpec); }
        static PredefinedIcon language() { return new PredefinedIcon(IconSpecs.fas.language.iconSpec); }
        static PredefinedIcon laptop() { return new PredefinedIcon(IconSpecs.fas.laptop.iconSpec); }
        static PredefinedIcon laptopCode() { return new PredefinedIcon(IconSpecs.fas.laptopCode.iconSpec); }
        static PredefinedIcon laptopHouse() { return new PredefinedIcon(IconSpecs.fas.laptopHouse.iconSpec); }
        static PredefinedIcon laptopMedical() { return new PredefinedIcon(IconSpecs.fas.laptopMedical.iconSpec); }
        static PredefinedIcon laugh() { return new PredefinedIcon(IconSpecs.fas.laugh.iconSpec); }
        static PredefinedIcon laughBeam() { return new PredefinedIcon(IconSpecs.fas.laughBeam.iconSpec); }
        static PredefinedIcon laughSquint() { return new PredefinedIcon(IconSpecs.fas.laughSquint.iconSpec); }
        static PredefinedIcon laughWink() { return new PredefinedIcon(IconSpecs.fas.laughWink.iconSpec); }
        static PredefinedIcon layerGroup() { return new PredefinedIcon(IconSpecs.fas.layerGroup.iconSpec); }
        static PredefinedIcon leaf() { return new PredefinedIcon(IconSpecs.fas.leaf.iconSpec); }
        static PredefinedIcon lemon() { return new PredefinedIcon(IconSpecs.fas.lemon.iconSpec); }
        static PredefinedIcon lessThan() { return new PredefinedIcon(IconSpecs.fas.lessThan.iconSpec); }
        static PredefinedIcon lessThanEqual() { return new PredefinedIcon(IconSpecs.fas.lessThanEqual.iconSpec); }
        static PredefinedIcon levelDownAlt() { return new PredefinedIcon(IconSpecs.fas.levelDownAlt.iconSpec); }
        static PredefinedIcon levelUpAlt() { return new PredefinedIcon(IconSpecs.fas.levelUpAlt.iconSpec); }
        static PredefinedIcon lifeRing() { return new PredefinedIcon(IconSpecs.fas.lifeRing.iconSpec); }
        static PredefinedIcon lightbulb() { return new PredefinedIcon(IconSpecs.fas.lightbulb.iconSpec); }
        static PredefinedIcon link() { return new PredefinedIcon(IconSpecs.fas.link.iconSpec); }
        static PredefinedIcon liraSign() { return new PredefinedIcon(IconSpecs.fas.liraSign.iconSpec); }
        static PredefinedIcon list() { return new PredefinedIcon(IconSpecs.fas.list.iconSpec); }
        static PredefinedIcon listAlt() { return new PredefinedIcon(IconSpecs.fas.listAlt.iconSpec); }
        static PredefinedIcon listOl() { return new PredefinedIcon(IconSpecs.fas.listOl.iconSpec); }
        static PredefinedIcon listUl() { return new PredefinedIcon(IconSpecs.fas.listUl.iconSpec); }
        static PredefinedIcon locationArrow() { return new PredefinedIcon(IconSpecs.fas.locationArrow.iconSpec); }
        static PredefinedIcon lock() { return new PredefinedIcon(IconSpecs.fas.lock.iconSpec); }
        static PredefinedIcon lockOpen() { return new PredefinedIcon(IconSpecs.fas.lockOpen.iconSpec); }
        static PredefinedIcon longArrowAltDown() { return new PredefinedIcon(IconSpecs.fas.longArrowAltDown.iconSpec); }
        static PredefinedIcon longArrowAltLeft() { return new PredefinedIcon(IconSpecs.fas.longArrowAltLeft.iconSpec); }
        static PredefinedIcon longArrowAltRight() { return new PredefinedIcon(IconSpecs.fas.longArrowAltRight.iconSpec); }
        static PredefinedIcon longArrowAltUp() { return new PredefinedIcon(IconSpecs.fas.longArrowAltUp.iconSpec); }
        static PredefinedIcon lowVision() { return new PredefinedIcon(IconSpecs.fas.lowVision.iconSpec); }
        static PredefinedIcon luggageCart() { return new PredefinedIcon(IconSpecs.fas.luggageCart.iconSpec); }
        static PredefinedIcon lungs() { return new PredefinedIcon(IconSpecs.fas.lungs.iconSpec); }
        static PredefinedIcon lungsVirus() { return new PredefinedIcon(IconSpecs.fas.lungsVirus.iconSpec); }
        static PredefinedIcon magic() { return new PredefinedIcon(IconSpecs.fas.magic.iconSpec); }
        static PredefinedIcon magnet() { return new PredefinedIcon(IconSpecs.fas.magnet.iconSpec); }
        static PredefinedIcon mailBulk() { return new PredefinedIcon(IconSpecs.fas.mailBulk.iconSpec); }
        static PredefinedIcon male() { return new PredefinedIcon(IconSpecs.fas.male.iconSpec); }
        static PredefinedIcon map() { return new PredefinedIcon(IconSpecs.fas.map.iconSpec); }
        static PredefinedIcon mapMarked() { return new PredefinedIcon(IconSpecs.fas.mapMarked.iconSpec); }
        static PredefinedIcon mapMarkedAlt() { return new PredefinedIcon(IconSpecs.fas.mapMarkedAlt.iconSpec); }
        static PredefinedIcon mapMarker() { return new PredefinedIcon(IconSpecs.fas.mapMarker.iconSpec); }
        static PredefinedIcon mapMarkerAlt() { return new PredefinedIcon(IconSpecs.fas.mapMarkerAlt.iconSpec); }
        static PredefinedIcon mapPin() { return new PredefinedIcon(IconSpecs.fas.mapPin.iconSpec); }
        static PredefinedIcon mapSigns() { return new PredefinedIcon(IconSpecs.fas.mapSigns.iconSpec); }
        static PredefinedIcon marker() { return new PredefinedIcon(IconSpecs.fas.marker.iconSpec); }
        static PredefinedIcon mars() { return new PredefinedIcon(IconSpecs.fas.mars.iconSpec); }
        static PredefinedIcon marsDouble() { return new PredefinedIcon(IconSpecs.fas.marsDouble.iconSpec); }
        static PredefinedIcon marsStroke() { return new PredefinedIcon(IconSpecs.fas.marsStroke.iconSpec); }
        static PredefinedIcon marsStrokeH() { return new PredefinedIcon(IconSpecs.fas.marsStrokeH.iconSpec); }
        static PredefinedIcon marsStrokeV() { return new PredefinedIcon(IconSpecs.fas.marsStrokeV.iconSpec); }
        static PredefinedIcon mask() { return new PredefinedIcon(IconSpecs.fas.mask.iconSpec); }
        static PredefinedIcon medal() { return new PredefinedIcon(IconSpecs.fas.medal.iconSpec); }
        static PredefinedIcon medkit() { return new PredefinedIcon(IconSpecs.fas.medkit.iconSpec); }
        static PredefinedIcon meh() { return new PredefinedIcon(IconSpecs.fas.meh.iconSpec); }
        static PredefinedIcon mehBlank() { return new PredefinedIcon(IconSpecs.fas.mehBlank.iconSpec); }
        static PredefinedIcon mehRollingEyes() { return new PredefinedIcon(IconSpecs.fas.mehRollingEyes.iconSpec); }
        static PredefinedIcon memory() { return new PredefinedIcon(IconSpecs.fas.memory.iconSpec); }
        static PredefinedIcon menorah() { return new PredefinedIcon(IconSpecs.fas.menorah.iconSpec); }
        static PredefinedIcon mercury() { return new PredefinedIcon(IconSpecs.fas.mercury.iconSpec); }
        static PredefinedIcon meteor() { return new PredefinedIcon(IconSpecs.fas.meteor.iconSpec); }
        static PredefinedIcon microchip() { return new PredefinedIcon(IconSpecs.fas.microchip.iconSpec); }
        static PredefinedIcon microphone() { return new PredefinedIcon(IconSpecs.fas.microphone.iconSpec); }
        static PredefinedIcon microphoneAlt() { return new PredefinedIcon(IconSpecs.fas.microphoneAlt.iconSpec); }
        static PredefinedIcon microphoneAltSlash() { return new PredefinedIcon(IconSpecs.fas.microphoneAltSlash.iconSpec); }
        static PredefinedIcon microphoneSlash() { return new PredefinedIcon(IconSpecs.fas.microphoneSlash.iconSpec); }
        static PredefinedIcon microscope() { return new PredefinedIcon(IconSpecs.fas.microscope.iconSpec); }
        static PredefinedIcon minus() { return new PredefinedIcon(IconSpecs.fas.minus.iconSpec); }
        static PredefinedIcon minusCircle() { return new PredefinedIcon(IconSpecs.fas.minusCircle.iconSpec); }
        static PredefinedIcon minusSquare() { return new PredefinedIcon(IconSpecs.fas.minusSquare.iconSpec); }
        static PredefinedIcon mitten() { return new PredefinedIcon(IconSpecs.fas.mitten.iconSpec); }
        static PredefinedIcon mobile() { return new PredefinedIcon(IconSpecs.fas.mobile.iconSpec); }
        static PredefinedIcon mobileAlt() { return new PredefinedIcon(IconSpecs.fas.mobileAlt.iconSpec); }
        static PredefinedIcon moneyBill() { return new PredefinedIcon(IconSpecs.fas.moneyBill.iconSpec); }
        static PredefinedIcon moneyBillAlt() { return new PredefinedIcon(IconSpecs.fas.moneyBillAlt.iconSpec); }
        static PredefinedIcon moneyBillWave() { return new PredefinedIcon(IconSpecs.fas.moneyBillWave.iconSpec); }
        static PredefinedIcon moneyBillWaveAlt() { return new PredefinedIcon(IconSpecs.fas.moneyBillWaveAlt.iconSpec); }
        static PredefinedIcon moneyCheck() { return new PredefinedIcon(IconSpecs.fas.moneyCheck.iconSpec); }
        static PredefinedIcon moneyCheckAlt() { return new PredefinedIcon(IconSpecs.fas.moneyCheckAlt.iconSpec); }
        static PredefinedIcon monument() { return new PredefinedIcon(IconSpecs.fas.monument.iconSpec); }
        static PredefinedIcon moon() { return new PredefinedIcon(IconSpecs.fas.moon.iconSpec); }
        static PredefinedIcon mortarPestle() { return new PredefinedIcon(IconSpecs.fas.mortarPestle.iconSpec); }
        static PredefinedIcon mosque() { return new PredefinedIcon(IconSpecs.fas.mosque.iconSpec); }
        static PredefinedIcon motorcycle() { return new PredefinedIcon(IconSpecs.fas.motorcycle.iconSpec); }
        static PredefinedIcon mountain() { return new PredefinedIcon(IconSpecs.fas.mountain.iconSpec); }
        static PredefinedIcon mouse() { return new PredefinedIcon(IconSpecs.fas.mouse.iconSpec); }
        static PredefinedIcon mousePointer() { return new PredefinedIcon(IconSpecs.fas.mousePointer.iconSpec); }
        static PredefinedIcon mugHot() { return new PredefinedIcon(IconSpecs.fas.mugHot.iconSpec); }
        static PredefinedIcon music() { return new PredefinedIcon(IconSpecs.fas.music.iconSpec); }
        static PredefinedIcon networkWired() { return new PredefinedIcon(IconSpecs.fas.networkWired.iconSpec); }
        static PredefinedIcon neuter() { return new PredefinedIcon(IconSpecs.fas.neuter.iconSpec); }
        static PredefinedIcon newspaper() { return new PredefinedIcon(IconSpecs.fas.newspaper.iconSpec); }
        static PredefinedIcon notEqual() { return new PredefinedIcon(IconSpecs.fas.notEqual.iconSpec); }
        static PredefinedIcon notesMedical() { return new PredefinedIcon(IconSpecs.fas.notesMedical.iconSpec); }
        static PredefinedIcon objectGroup() { return new PredefinedIcon(IconSpecs.fas.objectGroup.iconSpec); }
        static PredefinedIcon objectUngroup() { return new PredefinedIcon(IconSpecs.fas.objectUngroup.iconSpec); }
        static PredefinedIcon oilCan() { return new PredefinedIcon(IconSpecs.fas.oilCan.iconSpec); }
        static PredefinedIcon om() { return new PredefinedIcon(IconSpecs.fas.om.iconSpec); }
        static PredefinedIcon otter() { return new PredefinedIcon(IconSpecs.fas.otter.iconSpec); }
        static PredefinedIcon outdent() { return new PredefinedIcon(IconSpecs.fas.outdent.iconSpec); }
        static PredefinedIcon pager() { return new PredefinedIcon(IconSpecs.fas.pager.iconSpec); }
        static PredefinedIcon paintBrush() { return new PredefinedIcon(IconSpecs.fas.paintBrush.iconSpec); }
        static PredefinedIcon paintRoller() { return new PredefinedIcon(IconSpecs.fas.paintRoller.iconSpec); }
        static PredefinedIcon palette() { return new PredefinedIcon(IconSpecs.fas.palette.iconSpec); }
        static PredefinedIcon pallet() { return new PredefinedIcon(IconSpecs.fas.pallet.iconSpec); }
        static PredefinedIcon paperPlane() { return new PredefinedIcon(IconSpecs.fas.paperPlane.iconSpec); }
        static PredefinedIcon paperclip() { return new PredefinedIcon(IconSpecs.fas.paperclip.iconSpec); }
        static PredefinedIcon parachuteBox() { return new PredefinedIcon(IconSpecs.fas.parachuteBox.iconSpec); }
        static PredefinedIcon paragraph() { return new PredefinedIcon(IconSpecs.fas.paragraph.iconSpec); }
        static PredefinedIcon parking() { return new PredefinedIcon(IconSpecs.fas.parking.iconSpec); }
        static PredefinedIcon passport() { return new PredefinedIcon(IconSpecs.fas.passport.iconSpec); }
        static PredefinedIcon pastafarianism() { return new PredefinedIcon(IconSpecs.fas.pastafarianism.iconSpec); }
        static PredefinedIcon paste() { return new PredefinedIcon(IconSpecs.fas.paste.iconSpec); }
        static PredefinedIcon pause() { return new PredefinedIcon(IconSpecs.fas.pause.iconSpec); }
        static PredefinedIcon pauseCircle() { return new PredefinedIcon(IconSpecs.fas.pauseCircle.iconSpec); }
        static PredefinedIcon paw() { return new PredefinedIcon(IconSpecs.fas.paw.iconSpec); }
        static PredefinedIcon peace() { return new PredefinedIcon(IconSpecs.fas.peace.iconSpec); }
        static PredefinedIcon pen() { return new PredefinedIcon(IconSpecs.fas.pen.iconSpec); }
        static PredefinedIcon penAlt() { return new PredefinedIcon(IconSpecs.fas.penAlt.iconSpec); }
        static PredefinedIcon penFancy() { return new PredefinedIcon(IconSpecs.fas.penFancy.iconSpec); }
        static PredefinedIcon penNib() { return new PredefinedIcon(IconSpecs.fas.penNib.iconSpec); }
        static PredefinedIcon penSquare() { return new PredefinedIcon(IconSpecs.fas.penSquare.iconSpec); }
        static PredefinedIcon pencilAlt() { return new PredefinedIcon(IconSpecs.fas.pencilAlt.iconSpec); }
        static PredefinedIcon pencilRuler() { return new PredefinedIcon(IconSpecs.fas.pencilRuler.iconSpec); }
        static PredefinedIcon peopleArrows() { return new PredefinedIcon(IconSpecs.fas.peopleArrows.iconSpec); }
        static PredefinedIcon peopleCarry() { return new PredefinedIcon(IconSpecs.fas.peopleCarry.iconSpec); }
        static PredefinedIcon pepperHot() { return new PredefinedIcon(IconSpecs.fas.pepperHot.iconSpec); }
        static PredefinedIcon percent() { return new PredefinedIcon(IconSpecs.fas.percent.iconSpec); }
        static PredefinedIcon percentage() { return new PredefinedIcon(IconSpecs.fas.percentage.iconSpec); }
        static PredefinedIcon personBooth() { return new PredefinedIcon(IconSpecs.fas.personBooth.iconSpec); }
        static PredefinedIcon phone() { return new PredefinedIcon(IconSpecs.fas.phone.iconSpec); }
        static PredefinedIcon phoneAlt() { return new PredefinedIcon(IconSpecs.fas.phoneAlt.iconSpec); }
        static PredefinedIcon phoneSlash() { return new PredefinedIcon(IconSpecs.fas.phoneSlash.iconSpec); }
        static PredefinedIcon phoneSquare() { return new PredefinedIcon(IconSpecs.fas.phoneSquare.iconSpec); }
        static PredefinedIcon phoneSquareAlt() { return new PredefinedIcon(IconSpecs.fas.phoneSquareAlt.iconSpec); }
        static PredefinedIcon phoneVolume() { return new PredefinedIcon(IconSpecs.fas.phoneVolume.iconSpec); }
        static PredefinedIcon photoVideo() { return new PredefinedIcon(IconSpecs.fas.photoVideo.iconSpec); }
        static PredefinedIcon piggyBank() { return new PredefinedIcon(IconSpecs.fas.piggyBank.iconSpec); }
        static PredefinedIcon pills() { return new PredefinedIcon(IconSpecs.fas.pills.iconSpec); }
        static PredefinedIcon pizzaSlice() { return new PredefinedIcon(IconSpecs.fas.pizzaSlice.iconSpec); }
        static PredefinedIcon placeOfWorship() { return new PredefinedIcon(IconSpecs.fas.placeOfWorship.iconSpec); }
        static PredefinedIcon plane() { return new PredefinedIcon(IconSpecs.fas.plane.iconSpec); }
        static PredefinedIcon planeArrival() { return new PredefinedIcon(IconSpecs.fas.planeArrival.iconSpec); }
        static PredefinedIcon planeDeparture() { return new PredefinedIcon(IconSpecs.fas.planeDeparture.iconSpec); }
        static PredefinedIcon planeSlash() { return new PredefinedIcon(IconSpecs.fas.planeSlash.iconSpec); }
        static PredefinedIcon play() { return new PredefinedIcon(IconSpecs.fas.play.iconSpec); }
        static PredefinedIcon playCircle() { return new PredefinedIcon(IconSpecs.fas.playCircle.iconSpec); }
        static PredefinedIcon plug() { return new PredefinedIcon(IconSpecs.fas.plug.iconSpec); }
        static PredefinedIcon plus() { return new PredefinedIcon(IconSpecs.fas.plus.iconSpec); }
        static PredefinedIcon plusCircle() { return new PredefinedIcon(IconSpecs.fas.plusCircle.iconSpec); }
        static PredefinedIcon plusSquare() { return new PredefinedIcon(IconSpecs.fas.plusSquare.iconSpec); }
        static PredefinedIcon podcast() { return new PredefinedIcon(IconSpecs.fas.podcast.iconSpec); }
        static PredefinedIcon poll() { return new PredefinedIcon(IconSpecs.fas.poll.iconSpec); }
        static PredefinedIcon pollH() { return new PredefinedIcon(IconSpecs.fas.pollH.iconSpec); }
        static PredefinedIcon poo() { return new PredefinedIcon(IconSpecs.fas.poo.iconSpec); }
        static PredefinedIcon pooStorm() { return new PredefinedIcon(IconSpecs.fas.pooStorm.iconSpec); }
        static PredefinedIcon poop() { return new PredefinedIcon(IconSpecs.fas.poop.iconSpec); }
        static PredefinedIcon portrait() { return new PredefinedIcon(IconSpecs.fas.portrait.iconSpec); }
        static PredefinedIcon poundSign() { return new PredefinedIcon(IconSpecs.fas.poundSign.iconSpec); }
        static PredefinedIcon powerOff() { return new PredefinedIcon(IconSpecs.fas.powerOff.iconSpec); }
        static PredefinedIcon pray() { return new PredefinedIcon(IconSpecs.fas.pray.iconSpec); }
        static PredefinedIcon prayingHands() { return new PredefinedIcon(IconSpecs.fas.prayingHands.iconSpec); }
        static PredefinedIcon prescription() { return new PredefinedIcon(IconSpecs.fas.prescription.iconSpec); }
        static PredefinedIcon prescriptionBottle() { return new PredefinedIcon(IconSpecs.fas.prescriptionBottle.iconSpec); }
        static PredefinedIcon prescriptionBottleAlt() { return new PredefinedIcon(IconSpecs.fas.prescriptionBottleAlt.iconSpec); }
        static PredefinedIcon print() { return new PredefinedIcon(IconSpecs.fas.print.iconSpec); }
        static PredefinedIcon procedures() { return new PredefinedIcon(IconSpecs.fas.procedures.iconSpec); }
        static PredefinedIcon projectDiagram() { return new PredefinedIcon(IconSpecs.fas.projectDiagram.iconSpec); }
        static PredefinedIcon pumpMedical() { return new PredefinedIcon(IconSpecs.fas.pumpMedical.iconSpec); }
        static PredefinedIcon pumpSoap() { return new PredefinedIcon(IconSpecs.fas.pumpSoap.iconSpec); }
        static PredefinedIcon puzzlePiece() { return new PredefinedIcon(IconSpecs.fas.puzzlePiece.iconSpec); }
        static PredefinedIcon qrcode() { return new PredefinedIcon(IconSpecs.fas.qrcode.iconSpec); }
        static PredefinedIcon question() { return new PredefinedIcon(IconSpecs.fas.question.iconSpec); }
        static PredefinedIcon questionCircle() { return new PredefinedIcon(IconSpecs.fas.questionCircle.iconSpec); }
        static PredefinedIcon quidditch() { return new PredefinedIcon(IconSpecs.fas.quidditch.iconSpec); }
        static PredefinedIcon quoteLeft() { return new PredefinedIcon(IconSpecs.fas.quoteLeft.iconSpec); }
        static PredefinedIcon quoteRight() { return new PredefinedIcon(IconSpecs.fas.quoteRight.iconSpec); }
        static PredefinedIcon quran() { return new PredefinedIcon(IconSpecs.fas.quran.iconSpec); }
        static PredefinedIcon radiation() { return new PredefinedIcon(IconSpecs.fas.radiation.iconSpec); }
        static PredefinedIcon radiationAlt() { return new PredefinedIcon(IconSpecs.fas.radiationAlt.iconSpec); }
        static PredefinedIcon rainbow() { return new PredefinedIcon(IconSpecs.fas.rainbow.iconSpec); }
        static PredefinedIcon random() { return new PredefinedIcon(IconSpecs.fas.random.iconSpec); }
        static PredefinedIcon receipt() { return new PredefinedIcon(IconSpecs.fas.receipt.iconSpec); }
        static PredefinedIcon recordVinyl() { return new PredefinedIcon(IconSpecs.fas.recordVinyl.iconSpec); }
        static PredefinedIcon recycle() { return new PredefinedIcon(IconSpecs.fas.recycle.iconSpec); }
        static PredefinedIcon redo() { return new PredefinedIcon(IconSpecs.fas.redo.iconSpec); }
        static PredefinedIcon redoAlt() { return new PredefinedIcon(IconSpecs.fas.redoAlt.iconSpec); }
        static PredefinedIcon registered() { return new PredefinedIcon(IconSpecs.fas.registered.iconSpec); }
        static PredefinedIcon removeFormat() { return new PredefinedIcon(IconSpecs.fas.removeFormat.iconSpec); }
        static PredefinedIcon reply() { return new PredefinedIcon(IconSpecs.fas.reply.iconSpec); }
        static PredefinedIcon replyAll() { return new PredefinedIcon(IconSpecs.fas.replyAll.iconSpec); }
        static PredefinedIcon republican() { return new PredefinedIcon(IconSpecs.fas.republican.iconSpec); }
        static PredefinedIcon restroom() { return new PredefinedIcon(IconSpecs.fas.restroom.iconSpec); }
        static PredefinedIcon retweet() { return new PredefinedIcon(IconSpecs.fas.retweet.iconSpec); }
        static PredefinedIcon ribbon() { return new PredefinedIcon(IconSpecs.fas.ribbon.iconSpec); }
        static PredefinedIcon ring() { return new PredefinedIcon(IconSpecs.fas.ring.iconSpec); }
        static PredefinedIcon road() { return new PredefinedIcon(IconSpecs.fas.road.iconSpec); }
        static PredefinedIcon robot() { return new PredefinedIcon(IconSpecs.fas.robot.iconSpec); }
        static PredefinedIcon rocket() { return new PredefinedIcon(IconSpecs.fas.rocket.iconSpec); }
        static PredefinedIcon route() { return new PredefinedIcon(IconSpecs.fas.route.iconSpec); }
        static PredefinedIcon rss() { return new PredefinedIcon(IconSpecs.fas.rss.iconSpec); }
        static PredefinedIcon rssSquare() { return new PredefinedIcon(IconSpecs.fas.rssSquare.iconSpec); }
        static PredefinedIcon rubleSign() { return new PredefinedIcon(IconSpecs.fas.rubleSign.iconSpec); }
        static PredefinedIcon ruler() { return new PredefinedIcon(IconSpecs.fas.ruler.iconSpec); }
        static PredefinedIcon rulerCombined() { return new PredefinedIcon(IconSpecs.fas.rulerCombined.iconSpec); }
        static PredefinedIcon rulerHorizontal() { return new PredefinedIcon(IconSpecs.fas.rulerHorizontal.iconSpec); }
        static PredefinedIcon rulerVertical() { return new PredefinedIcon(IconSpecs.fas.rulerVertical.iconSpec); }
        static PredefinedIcon running() { return new PredefinedIcon(IconSpecs.fas.running.iconSpec); }
        static PredefinedIcon rupeeSign() { return new PredefinedIcon(IconSpecs.fas.rupeeSign.iconSpec); }
        static PredefinedIcon sadCry() { return new PredefinedIcon(IconSpecs.fas.sadCry.iconSpec); }
        static PredefinedIcon sadTear() { return new PredefinedIcon(IconSpecs.fas.sadTear.iconSpec); }
        static PredefinedIcon satellite() { return new PredefinedIcon(IconSpecs.fas.satellite.iconSpec); }
        static PredefinedIcon satelliteDish() { return new PredefinedIcon(IconSpecs.fas.satelliteDish.iconSpec); }
        static PredefinedIcon save() { return new PredefinedIcon(IconSpecs.fas.save.iconSpec); }
        static PredefinedIcon school() { return new PredefinedIcon(IconSpecs.fas.school.iconSpec); }
        static PredefinedIcon screwdriver() { return new PredefinedIcon(IconSpecs.fas.screwdriver.iconSpec); }
        static PredefinedIcon scroll() { return new PredefinedIcon(IconSpecs.fas.scroll.iconSpec); }
        static PredefinedIcon sdCard() { return new PredefinedIcon(IconSpecs.fas.sdCard.iconSpec); }
        static PredefinedIcon search() { return new PredefinedIcon(IconSpecs.fas.search.iconSpec); }
        static PredefinedIcon searchDollar() { return new PredefinedIcon(IconSpecs.fas.searchDollar.iconSpec); }
        static PredefinedIcon searchLocation() { return new PredefinedIcon(IconSpecs.fas.searchLocation.iconSpec); }
        static PredefinedIcon searchMinus() { return new PredefinedIcon(IconSpecs.fas.searchMinus.iconSpec); }
        static PredefinedIcon searchPlus() { return new PredefinedIcon(IconSpecs.fas.searchPlus.iconSpec); }
        static PredefinedIcon seedling() { return new PredefinedIcon(IconSpecs.fas.seedling.iconSpec); }
        static PredefinedIcon server() { return new PredefinedIcon(IconSpecs.fas.server.iconSpec); }
        static PredefinedIcon shapes() { return new PredefinedIcon(IconSpecs.fas.shapes.iconSpec); }
        static PredefinedIcon share() { return new PredefinedIcon(IconSpecs.fas.share.iconSpec); }
        static PredefinedIcon shareAlt() { return new PredefinedIcon(IconSpecs.fas.shareAlt.iconSpec); }
        static PredefinedIcon shareAltSquare() { return new PredefinedIcon(IconSpecs.fas.shareAltSquare.iconSpec); }
        static PredefinedIcon shareSquare() { return new PredefinedIcon(IconSpecs.fas.shareSquare.iconSpec); }
        static PredefinedIcon shekelSign() { return new PredefinedIcon(IconSpecs.fas.shekelSign.iconSpec); }
        static PredefinedIcon shieldAlt() { return new PredefinedIcon(IconSpecs.fas.shieldAlt.iconSpec); }
        static PredefinedIcon shieldVirus() { return new PredefinedIcon(IconSpecs.fas.shieldVirus.iconSpec); }
        static PredefinedIcon ship() { return new PredefinedIcon(IconSpecs.fas.ship.iconSpec); }
        static PredefinedIcon shippingFast() { return new PredefinedIcon(IconSpecs.fas.shippingFast.iconSpec); }
        static PredefinedIcon shoePrints() { return new PredefinedIcon(IconSpecs.fas.shoePrints.iconSpec); }
        static PredefinedIcon shoppingBag() { return new PredefinedIcon(IconSpecs.fas.shoppingBag.iconSpec); }
        static PredefinedIcon shoppingBasket() { return new PredefinedIcon(IconSpecs.fas.shoppingBasket.iconSpec); }
        static PredefinedIcon shoppingCart() { return new PredefinedIcon(IconSpecs.fas.shoppingCart.iconSpec); }
        static PredefinedIcon shower() { return new PredefinedIcon(IconSpecs.fas.shower.iconSpec); }
        static PredefinedIcon shuttleVan() { return new PredefinedIcon(IconSpecs.fas.shuttleVan.iconSpec); }
        static PredefinedIcon sign() { return new PredefinedIcon(IconSpecs.fas.sign.iconSpec); }
        static PredefinedIcon signInAlt() { return new PredefinedIcon(IconSpecs.fas.signInAlt.iconSpec); }
        static PredefinedIcon signLanguage() { return new PredefinedIcon(IconSpecs.fas.signLanguage.iconSpec); }
        static PredefinedIcon signOutAlt() { return new PredefinedIcon(IconSpecs.fas.signOutAlt.iconSpec); }
        static PredefinedIcon signal() { return new PredefinedIcon(IconSpecs.fas.signal.iconSpec); }
        static PredefinedIcon signature() { return new PredefinedIcon(IconSpecs.fas.signature.iconSpec); }
        static PredefinedIcon simCard() { return new PredefinedIcon(IconSpecs.fas.simCard.iconSpec); }
        static PredefinedIcon sink() { return new PredefinedIcon(IconSpecs.fas.sink.iconSpec); }
        static PredefinedIcon sitemap() { return new PredefinedIcon(IconSpecs.fas.sitemap.iconSpec); }
        static PredefinedIcon skating() { return new PredefinedIcon(IconSpecs.fas.skating.iconSpec); }
        static PredefinedIcon skiing() { return new PredefinedIcon(IconSpecs.fas.skiing.iconSpec); }
        static PredefinedIcon skiingNordic() { return new PredefinedIcon(IconSpecs.fas.skiingNordic.iconSpec); }
        static PredefinedIcon skull() { return new PredefinedIcon(IconSpecs.fas.skull.iconSpec); }
        static PredefinedIcon skullCrossbones() { return new PredefinedIcon(IconSpecs.fas.skullCrossbones.iconSpec); }
        static PredefinedIcon slash() { return new PredefinedIcon(IconSpecs.fas.slash.iconSpec); }
        static PredefinedIcon sleigh() { return new PredefinedIcon(IconSpecs.fas.sleigh.iconSpec); }
        static PredefinedIcon slidersH() { return new PredefinedIcon(IconSpecs.fas.slidersH.iconSpec); }
        static PredefinedIcon smile() { return new PredefinedIcon(IconSpecs.fas.smile.iconSpec); }
        static PredefinedIcon smileBeam() { return new PredefinedIcon(IconSpecs.fas.smileBeam.iconSpec); }
        static PredefinedIcon smileWink() { return new PredefinedIcon(IconSpecs.fas.smileWink.iconSpec); }
        static PredefinedIcon smog() { return new PredefinedIcon(IconSpecs.fas.smog.iconSpec); }
        static PredefinedIcon smoking() { return new PredefinedIcon(IconSpecs.fas.smoking.iconSpec); }
        static PredefinedIcon smokingBan() { return new PredefinedIcon(IconSpecs.fas.smokingBan.iconSpec); }
        static PredefinedIcon sms() { return new PredefinedIcon(IconSpecs.fas.sms.iconSpec); }
        static PredefinedIcon snowboarding() { return new PredefinedIcon(IconSpecs.fas.snowboarding.iconSpec); }
        static PredefinedIcon snowflake() { return new PredefinedIcon(IconSpecs.fas.snowflake.iconSpec); }
        static PredefinedIcon snowman() { return new PredefinedIcon(IconSpecs.fas.snowman.iconSpec); }
        static PredefinedIcon snowplow() { return new PredefinedIcon(IconSpecs.fas.snowplow.iconSpec); }
        static PredefinedIcon soap() { return new PredefinedIcon(IconSpecs.fas.soap.iconSpec); }
        static PredefinedIcon socks() { return new PredefinedIcon(IconSpecs.fas.socks.iconSpec); }
        static PredefinedIcon solarPanel() { return new PredefinedIcon(IconSpecs.fas.solarPanel.iconSpec); }
        static PredefinedIcon sort() { return new PredefinedIcon(IconSpecs.fas.sort.iconSpec); }
        static PredefinedIcon sortAlphaDown() { return new PredefinedIcon(IconSpecs.fas.sortAlphaDown.iconSpec); }
        static PredefinedIcon sortAlphaDownAlt() { return new PredefinedIcon(IconSpecs.fas.sortAlphaDownAlt.iconSpec); }
        static PredefinedIcon sortAlphaUp() { return new PredefinedIcon(IconSpecs.fas.sortAlphaUp.iconSpec); }
        static PredefinedIcon sortAlphaUpAlt() { return new PredefinedIcon(IconSpecs.fas.sortAlphaUpAlt.iconSpec); }
        static PredefinedIcon sortAmountDown() { return new PredefinedIcon(IconSpecs.fas.sortAmountDown.iconSpec); }
        static PredefinedIcon sortAmountDownAlt() { return new PredefinedIcon(IconSpecs.fas.sortAmountDownAlt.iconSpec); }
        static PredefinedIcon sortAmountUp() { return new PredefinedIcon(IconSpecs.fas.sortAmountUp.iconSpec); }
        static PredefinedIcon sortAmountUpAlt() { return new PredefinedIcon(IconSpecs.fas.sortAmountUpAlt.iconSpec); }
        static PredefinedIcon sortDown() { return new PredefinedIcon(IconSpecs.fas.sortDown.iconSpec); }
        static PredefinedIcon sortNumericDown() { return new PredefinedIcon(IconSpecs.fas.sortNumericDown.iconSpec); }
        static PredefinedIcon sortNumericDownAlt() { return new PredefinedIcon(IconSpecs.fas.sortNumericDownAlt.iconSpec); }
        static PredefinedIcon sortNumericUp() { return new PredefinedIcon(IconSpecs.fas.sortNumericUp.iconSpec); }
        static PredefinedIcon sortNumericUpAlt() { return new PredefinedIcon(IconSpecs.fas.sortNumericUpAlt.iconSpec); }
        static PredefinedIcon sortUp() { return new PredefinedIcon(IconSpecs.fas.sortUp.iconSpec); }
        static PredefinedIcon spa() { return new PredefinedIcon(IconSpecs.fas.spa.iconSpec); }
        static PredefinedIcon spaceShuttle() { return new PredefinedIcon(IconSpecs.fas.spaceShuttle.iconSpec); }
        static PredefinedIcon spellCheck() { return new PredefinedIcon(IconSpecs.fas.spellCheck.iconSpec); }
        static PredefinedIcon spider() { return new PredefinedIcon(IconSpecs.fas.spider.iconSpec); }
        static PredefinedIcon spinner() { return new PredefinedIcon(IconSpecs.fas.spinner.iconSpec); }
        static PredefinedIcon splotch() { return new PredefinedIcon(IconSpecs.fas.splotch.iconSpec); }
        static PredefinedIcon sprayCan() { return new PredefinedIcon(IconSpecs.fas.sprayCan.iconSpec); }
        static PredefinedIcon square() { return new PredefinedIcon(IconSpecs.fas.square.iconSpec); }
        static PredefinedIcon squareFull() { return new PredefinedIcon(IconSpecs.fas.squareFull.iconSpec); }
        static PredefinedIcon squareRootAlt() { return new PredefinedIcon(IconSpecs.fas.squareRootAlt.iconSpec); }
        static PredefinedIcon stamp() { return new PredefinedIcon(IconSpecs.fas.stamp.iconSpec); }
        static PredefinedIcon star() { return new PredefinedIcon(IconSpecs.fas.star.iconSpec); }
        static PredefinedIcon starAndCrescent() { return new PredefinedIcon(IconSpecs.fas.starAndCrescent.iconSpec); }
        static PredefinedIcon starHalf() { return new PredefinedIcon(IconSpecs.fas.starHalf.iconSpec); }
        static PredefinedIcon starHalfAlt() { return new PredefinedIcon(IconSpecs.fas.starHalfAlt.iconSpec); }
        static PredefinedIcon starOfDavid() { return new PredefinedIcon(IconSpecs.fas.starOfDavid.iconSpec); }
        static PredefinedIcon starOfLife() { return new PredefinedIcon(IconSpecs.fas.starOfLife.iconSpec); }
        static PredefinedIcon stepBackward() { return new PredefinedIcon(IconSpecs.fas.stepBackward.iconSpec); }
        static PredefinedIcon stepForward() { return new PredefinedIcon(IconSpecs.fas.stepForward.iconSpec); }
        static PredefinedIcon stethoscope() { return new PredefinedIcon(IconSpecs.fas.stethoscope.iconSpec); }
        static PredefinedIcon stickyNote() { return new PredefinedIcon(IconSpecs.fas.stickyNote.iconSpec); }
        static PredefinedIcon stop() { return new PredefinedIcon(IconSpecs.fas.stop.iconSpec); }
        static PredefinedIcon stopCircle() { return new PredefinedIcon(IconSpecs.fas.stopCircle.iconSpec); }
        static PredefinedIcon stopwatch() { return new PredefinedIcon(IconSpecs.fas.stopwatch.iconSpec); }
        static PredefinedIcon stopwatch20() { return new PredefinedIcon(IconSpecs.fas.stopwatch20.iconSpec); }
        static PredefinedIcon store() { return new PredefinedIcon(IconSpecs.fas.store.iconSpec); }
        static PredefinedIcon storeAlt() { return new PredefinedIcon(IconSpecs.fas.storeAlt.iconSpec); }
        static PredefinedIcon storeAltSlash() { return new PredefinedIcon(IconSpecs.fas.storeAltSlash.iconSpec); }
        static PredefinedIcon storeSlash() { return new PredefinedIcon(IconSpecs.fas.storeSlash.iconSpec); }
        static PredefinedIcon stream() { return new PredefinedIcon(IconSpecs.fas.stream.iconSpec); }
        static PredefinedIcon streetView() { return new PredefinedIcon(IconSpecs.fas.streetView.iconSpec); }
        static PredefinedIcon strikethrough() { return new PredefinedIcon(IconSpecs.fas.strikethrough.iconSpec); }
        static PredefinedIcon stroopwafel() { return new PredefinedIcon(IconSpecs.fas.stroopwafel.iconSpec); }
        static PredefinedIcon subscript() { return new PredefinedIcon(IconSpecs.fas.subscript.iconSpec); }
        static PredefinedIcon subway() { return new PredefinedIcon(IconSpecs.fas.subway.iconSpec); }
        static PredefinedIcon suitcase() { return new PredefinedIcon(IconSpecs.fas.suitcase.iconSpec); }
        static PredefinedIcon suitcaseRolling() { return new PredefinedIcon(IconSpecs.fas.suitcaseRolling.iconSpec); }
        static PredefinedIcon sun() { return new PredefinedIcon(IconSpecs.fas.sun.iconSpec); }
        static PredefinedIcon superscript() { return new PredefinedIcon(IconSpecs.fas.superscript.iconSpec); }
        static PredefinedIcon surprise() { return new PredefinedIcon(IconSpecs.fas.surprise.iconSpec); }
        static PredefinedIcon swatchbook() { return new PredefinedIcon(IconSpecs.fas.swatchbook.iconSpec); }
        static PredefinedIcon swimmer() { return new PredefinedIcon(IconSpecs.fas.swimmer.iconSpec); }
        static PredefinedIcon swimmingPool() { return new PredefinedIcon(IconSpecs.fas.swimmingPool.iconSpec); }
        static PredefinedIcon synagogue() { return new PredefinedIcon(IconSpecs.fas.synagogue.iconSpec); }
        static PredefinedIcon sync() { return new PredefinedIcon(IconSpecs.fas.sync.iconSpec); }
        static PredefinedIcon syncAlt() { return new PredefinedIcon(IconSpecs.fas.syncAlt.iconSpec); }
        static PredefinedIcon syringe() { return new PredefinedIcon(IconSpecs.fas.syringe.iconSpec); }
        static PredefinedIcon table() { return new PredefinedIcon(IconSpecs.fas.table.iconSpec); }
        static PredefinedIcon tableTennis() { return new PredefinedIcon(IconSpecs.fas.tableTennis.iconSpec); }
        static PredefinedIcon tablet() { return new PredefinedIcon(IconSpecs.fas.tablet.iconSpec); }
        static PredefinedIcon tabletAlt() { return new PredefinedIcon(IconSpecs.fas.tabletAlt.iconSpec); }
        static PredefinedIcon tablets() { return new PredefinedIcon(IconSpecs.fas.tablets.iconSpec); }
        static PredefinedIcon tachometerAlt() { return new PredefinedIcon(IconSpecs.fas.tachometerAlt.iconSpec); }
        static PredefinedIcon tag() { return new PredefinedIcon(IconSpecs.fas.tag.iconSpec); }
        static PredefinedIcon tags() { return new PredefinedIcon(IconSpecs.fas.tags.iconSpec); }
        static PredefinedIcon tape() { return new PredefinedIcon(IconSpecs.fas.tape.iconSpec); }
        static PredefinedIcon tasks() { return new PredefinedIcon(IconSpecs.fas.tasks.iconSpec); }
        static PredefinedIcon taxi() { return new PredefinedIcon(IconSpecs.fas.taxi.iconSpec); }
        static PredefinedIcon teeth() { return new PredefinedIcon(IconSpecs.fas.teeth.iconSpec); }
        static PredefinedIcon teethOpen() { return new PredefinedIcon(IconSpecs.fas.teethOpen.iconSpec); }
        static PredefinedIcon temperatureHigh() { return new PredefinedIcon(IconSpecs.fas.temperatureHigh.iconSpec); }
        static PredefinedIcon temperatureLow() { return new PredefinedIcon(IconSpecs.fas.temperatureLow.iconSpec); }
        static PredefinedIcon tenge() { return new PredefinedIcon(IconSpecs.fas.tenge.iconSpec); }
        static PredefinedIcon terminal() { return new PredefinedIcon(IconSpecs.fas.terminal.iconSpec); }
        static PredefinedIcon textHeight() { return new PredefinedIcon(IconSpecs.fas.textHeight.iconSpec); }
        static PredefinedIcon textWidth() { return new PredefinedIcon(IconSpecs.fas.textWidth.iconSpec); }
        static PredefinedIcon th() { return new PredefinedIcon(IconSpecs.fas.th.iconSpec); }
        static PredefinedIcon thLarge() { return new PredefinedIcon(IconSpecs.fas.thLarge.iconSpec); }
        static PredefinedIcon thList() { return new PredefinedIcon(IconSpecs.fas.thList.iconSpec); }
        static PredefinedIcon theaterMasks() { return new PredefinedIcon(IconSpecs.fas.theaterMasks.iconSpec); }
        static PredefinedIcon thermometer() { return new PredefinedIcon(IconSpecs.fas.thermometer.iconSpec); }
        static PredefinedIcon thermometerEmpty() { return new PredefinedIcon(IconSpecs.fas.thermometerEmpty.iconSpec); }
        static PredefinedIcon thermometerFull() { return new PredefinedIcon(IconSpecs.fas.thermometerFull.iconSpec); }
        static PredefinedIcon thermometerHalf() { return new PredefinedIcon(IconSpecs.fas.thermometerHalf.iconSpec); }
        static PredefinedIcon thermometerQuarter() { return new PredefinedIcon(IconSpecs.fas.thermometerQuarter.iconSpec); }
        static PredefinedIcon thermometerThreeQuarters() { return new PredefinedIcon(IconSpecs.fas.thermometerThreeQuarters.iconSpec); }
        static PredefinedIcon thumbsDown() { return new PredefinedIcon(IconSpecs.fas.thumbsDown.iconSpec); }
        static PredefinedIcon thumbsUp() { return new PredefinedIcon(IconSpecs.fas.thumbsUp.iconSpec); }
        static PredefinedIcon thumbtack() { return new PredefinedIcon(IconSpecs.fas.thumbtack.iconSpec); }
        static PredefinedIcon ticketAlt() { return new PredefinedIcon(IconSpecs.fas.ticketAlt.iconSpec); }
        static PredefinedIcon times() { return new PredefinedIcon(IconSpecs.fas.times.iconSpec); }
        static PredefinedIcon timesCircle() { return new PredefinedIcon(IconSpecs.fas.timesCircle.iconSpec); }
        static PredefinedIcon tint() { return new PredefinedIcon(IconSpecs.fas.tint.iconSpec); }
        static PredefinedIcon tintSlash() { return new PredefinedIcon(IconSpecs.fas.tintSlash.iconSpec); }
        static PredefinedIcon tired() { return new PredefinedIcon(IconSpecs.fas.tired.iconSpec); }
        static PredefinedIcon toggleOff() { return new PredefinedIcon(IconSpecs.fas.toggleOff.iconSpec); }
        static PredefinedIcon toggleOn() { return new PredefinedIcon(IconSpecs.fas.toggleOn.iconSpec); }
        static PredefinedIcon toilet() { return new PredefinedIcon(IconSpecs.fas.toilet.iconSpec); }
        static PredefinedIcon toiletPaper() { return new PredefinedIcon(IconSpecs.fas.toiletPaper.iconSpec); }
        static PredefinedIcon toiletPaperSlash() { return new PredefinedIcon(IconSpecs.fas.toiletPaperSlash.iconSpec); }
        static PredefinedIcon toolbox() { return new PredefinedIcon(IconSpecs.fas.toolbox.iconSpec); }
        static PredefinedIcon tools() { return new PredefinedIcon(IconSpecs.fas.tools.iconSpec); }
        static PredefinedIcon tooth() { return new PredefinedIcon(IconSpecs.fas.tooth.iconSpec); }
        static PredefinedIcon torah() { return new PredefinedIcon(IconSpecs.fas.torah.iconSpec); }
        static PredefinedIcon toriiGate() { return new PredefinedIcon(IconSpecs.fas.toriiGate.iconSpec); }
        static PredefinedIcon tractor() { return new PredefinedIcon(IconSpecs.fas.tractor.iconSpec); }
        static PredefinedIcon trademark() { return new PredefinedIcon(IconSpecs.fas.trademark.iconSpec); }
        static PredefinedIcon trafficLight() { return new PredefinedIcon(IconSpecs.fas.trafficLight.iconSpec); }
        static PredefinedIcon trailer() { return new PredefinedIcon(IconSpecs.fas.trailer.iconSpec); }
        static PredefinedIcon train() { return new PredefinedIcon(IconSpecs.fas.train.iconSpec); }
        static PredefinedIcon tram() { return new PredefinedIcon(IconSpecs.fas.tram.iconSpec); }
        static PredefinedIcon transgender() { return new PredefinedIcon(IconSpecs.fas.transgender.iconSpec); }
        static PredefinedIcon transgenderAlt() { return new PredefinedIcon(IconSpecs.fas.transgenderAlt.iconSpec); }
        static PredefinedIcon trash() { return new PredefinedIcon(IconSpecs.fas.trash.iconSpec); }
        static PredefinedIcon trashAlt() { return new PredefinedIcon(IconSpecs.fas.trashAlt.iconSpec); }
        static PredefinedIcon trashRestore() { return new PredefinedIcon(IconSpecs.fas.trashRestore.iconSpec); }
        static PredefinedIcon trashRestoreAlt() { return new PredefinedIcon(IconSpecs.fas.trashRestoreAlt.iconSpec); }
        static PredefinedIcon tree() { return new PredefinedIcon(IconSpecs.fas.tree.iconSpec); }
        static PredefinedIcon trophy() { return new PredefinedIcon(IconSpecs.fas.trophy.iconSpec); }
        static PredefinedIcon truck() { return new PredefinedIcon(IconSpecs.fas.truck.iconSpec); }
        static PredefinedIcon truckLoading() { return new PredefinedIcon(IconSpecs.fas.truckLoading.iconSpec); }
        static PredefinedIcon truckMonster() { return new PredefinedIcon(IconSpecs.fas.truckMonster.iconSpec); }
        static PredefinedIcon truckMoving() { return new PredefinedIcon(IconSpecs.fas.truckMoving.iconSpec); }
        static PredefinedIcon truckPickup() { return new PredefinedIcon(IconSpecs.fas.truckPickup.iconSpec); }
        static PredefinedIcon tshirt() { return new PredefinedIcon(IconSpecs.fas.tshirt.iconSpec); }
        static PredefinedIcon tty() { return new PredefinedIcon(IconSpecs.fas.tty.iconSpec); }
        static PredefinedIcon tv() { return new PredefinedIcon(IconSpecs.fas.tv.iconSpec); }
        static PredefinedIcon umbrella() { return new PredefinedIcon(IconSpecs.fas.umbrella.iconSpec); }
        static PredefinedIcon umbrellaBeach() { return new PredefinedIcon(IconSpecs.fas.umbrellaBeach.iconSpec); }
        static PredefinedIcon underline() { return new PredefinedIcon(IconSpecs.fas.underline.iconSpec); }
        static PredefinedIcon undo() { return new PredefinedIcon(IconSpecs.fas.undo.iconSpec); }
        static PredefinedIcon undoAlt() { return new PredefinedIcon(IconSpecs.fas.undoAlt.iconSpec); }
        static PredefinedIcon universalAccess() { return new PredefinedIcon(IconSpecs.fas.universalAccess.iconSpec); }
        static PredefinedIcon university() { return new PredefinedIcon(IconSpecs.fas.university.iconSpec); }
        static PredefinedIcon unlink() { return new PredefinedIcon(IconSpecs.fas.unlink.iconSpec); }
        static PredefinedIcon unlock() { return new PredefinedIcon(IconSpecs.fas.unlock.iconSpec); }
        static PredefinedIcon unlockAlt() { return new PredefinedIcon(IconSpecs.fas.unlockAlt.iconSpec); }
        static PredefinedIcon upload() { return new PredefinedIcon(IconSpecs.fas.upload.iconSpec); }
        static PredefinedIcon user() { return new PredefinedIcon(IconSpecs.fas.user.iconSpec); }
        static PredefinedIcon userAlt() { return new PredefinedIcon(IconSpecs.fas.userAlt.iconSpec); }
        static PredefinedIcon userAltSlash() { return new PredefinedIcon(IconSpecs.fas.userAltSlash.iconSpec); }
        static PredefinedIcon userAstronaut() { return new PredefinedIcon(IconSpecs.fas.userAstronaut.iconSpec); }
        static PredefinedIcon userCheck() { return new PredefinedIcon(IconSpecs.fas.userCheck.iconSpec); }
        static PredefinedIcon userCircle() { return new PredefinedIcon(IconSpecs.fas.userCircle.iconSpec); }
        static PredefinedIcon userClock() { return new PredefinedIcon(IconSpecs.fas.userClock.iconSpec); }
        static PredefinedIcon userCog() { return new PredefinedIcon(IconSpecs.fas.userCog.iconSpec); }
        static PredefinedIcon userEdit() { return new PredefinedIcon(IconSpecs.fas.userEdit.iconSpec); }
        static PredefinedIcon userFriends() { return new PredefinedIcon(IconSpecs.fas.userFriends.iconSpec); }
        static PredefinedIcon userGraduate() { return new PredefinedIcon(IconSpecs.fas.userGraduate.iconSpec); }
        static PredefinedIcon userInjured() { return new PredefinedIcon(IconSpecs.fas.userInjured.iconSpec); }
        static PredefinedIcon userLock() { return new PredefinedIcon(IconSpecs.fas.userLock.iconSpec); }
        static PredefinedIcon userMd() { return new PredefinedIcon(IconSpecs.fas.userMd.iconSpec); }
        static PredefinedIcon userMinus() { return new PredefinedIcon(IconSpecs.fas.userMinus.iconSpec); }
        static PredefinedIcon userNinja() { return new PredefinedIcon(IconSpecs.fas.userNinja.iconSpec); }
        static PredefinedIcon userNurse() { return new PredefinedIcon(IconSpecs.fas.userNurse.iconSpec); }
        static PredefinedIcon userPlus() { return new PredefinedIcon(IconSpecs.fas.userPlus.iconSpec); }
        static PredefinedIcon userSecret() { return new PredefinedIcon(IconSpecs.fas.userSecret.iconSpec); }
        static PredefinedIcon userShield() { return new PredefinedIcon(IconSpecs.fas.userShield.iconSpec); }
        static PredefinedIcon userSlash() { return new PredefinedIcon(IconSpecs.fas.userSlash.iconSpec); }
        static PredefinedIcon userTag() { return new PredefinedIcon(IconSpecs.fas.userTag.iconSpec); }
        static PredefinedIcon userTie() { return new PredefinedIcon(IconSpecs.fas.userTie.iconSpec); }
        static PredefinedIcon userTimes() { return new PredefinedIcon(IconSpecs.fas.userTimes.iconSpec); }
        static PredefinedIcon users() { return new PredefinedIcon(IconSpecs.fas.users.iconSpec); }
        static PredefinedIcon usersCog() { return new PredefinedIcon(IconSpecs.fas.usersCog.iconSpec); }
        static PredefinedIcon usersSlash() { return new PredefinedIcon(IconSpecs.fas.usersSlash.iconSpec); }
        static PredefinedIcon utensilSpoon() { return new PredefinedIcon(IconSpecs.fas.utensilSpoon.iconSpec); }
        static PredefinedIcon utensils() { return new PredefinedIcon(IconSpecs.fas.utensils.iconSpec); }
        static PredefinedIcon vectorSquare() { return new PredefinedIcon(IconSpecs.fas.vectorSquare.iconSpec); }
        static PredefinedIcon venus() { return new PredefinedIcon(IconSpecs.fas.venus.iconSpec); }
        static PredefinedIcon venusDouble() { return new PredefinedIcon(IconSpecs.fas.venusDouble.iconSpec); }
        static PredefinedIcon venusMars() { return new PredefinedIcon(IconSpecs.fas.venusMars.iconSpec); }
        static PredefinedIcon vest() { return new PredefinedIcon(IconSpecs.fas.vest.iconSpec); }
        static PredefinedIcon vestPatches() { return new PredefinedIcon(IconSpecs.fas.vestPatches.iconSpec); }
        static PredefinedIcon vial() { return new PredefinedIcon(IconSpecs.fas.vial.iconSpec); }
        static PredefinedIcon vials() { return new PredefinedIcon(IconSpecs.fas.vials.iconSpec); }
        static PredefinedIcon video() { return new PredefinedIcon(IconSpecs.fas.video.iconSpec); }
        static PredefinedIcon videoSlash() { return new PredefinedIcon(IconSpecs.fas.videoSlash.iconSpec); }
        static PredefinedIcon vihara() { return new PredefinedIcon(IconSpecs.fas.vihara.iconSpec); }
        static PredefinedIcon virus() { return new PredefinedIcon(IconSpecs.fas.virus.iconSpec); }
        static PredefinedIcon virusSlash() { return new PredefinedIcon(IconSpecs.fas.virusSlash.iconSpec); }
        static PredefinedIcon viruses() { return new PredefinedIcon(IconSpecs.fas.viruses.iconSpec); }
        static PredefinedIcon voicemail() { return new PredefinedIcon(IconSpecs.fas.voicemail.iconSpec); }
        static PredefinedIcon volleyballBall() { return new PredefinedIcon(IconSpecs.fas.volleyballBall.iconSpec); }
        static PredefinedIcon volumeDown() { return new PredefinedIcon(IconSpecs.fas.volumeDown.iconSpec); }
        static PredefinedIcon volumeMute() { return new PredefinedIcon(IconSpecs.fas.volumeMute.iconSpec); }
        static PredefinedIcon volumeOff() { return new PredefinedIcon(IconSpecs.fas.volumeOff.iconSpec); }
        static PredefinedIcon volumeUp() { return new PredefinedIcon(IconSpecs.fas.volumeUp.iconSpec); }
        static PredefinedIcon voteYea() { return new PredefinedIcon(IconSpecs.fas.voteYea.iconSpec); }
        static PredefinedIcon vrCardboard() { return new PredefinedIcon(IconSpecs.fas.vrCardboard.iconSpec); }
        static PredefinedIcon walking() { return new PredefinedIcon(IconSpecs.fas.walking.iconSpec); }
        static PredefinedIcon wallet() { return new PredefinedIcon(IconSpecs.fas.wallet.iconSpec); }
        static PredefinedIcon warehouse() { return new PredefinedIcon(IconSpecs.fas.warehouse.iconSpec); }
        static PredefinedIcon water() { return new PredefinedIcon(IconSpecs.fas.water.iconSpec); }
        static PredefinedIcon waveSquare() { return new PredefinedIcon(IconSpecs.fas.waveSquare.iconSpec); }
        static PredefinedIcon weight() { return new PredefinedIcon(IconSpecs.fas.weight.iconSpec); }
        static PredefinedIcon weightHanging() { return new PredefinedIcon(IconSpecs.fas.weightHanging.iconSpec); }
        static PredefinedIcon wheelchair() { return new PredefinedIcon(IconSpecs.fas.wheelchair.iconSpec); }
        static PredefinedIcon wifi() { return new PredefinedIcon(IconSpecs.fas.wifi.iconSpec); }
        static PredefinedIcon wind() { return new PredefinedIcon(IconSpecs.fas.wind.iconSpec); }
        static PredefinedIcon windowClose() { return new PredefinedIcon(IconSpecs.fas.windowClose.iconSpec); }
        static PredefinedIcon windowMaximize() { return new PredefinedIcon(IconSpecs.fas.windowMaximize.iconSpec); }
        static PredefinedIcon windowMinimize() { return new PredefinedIcon(IconSpecs.fas.windowMinimize.iconSpec); }
        static PredefinedIcon windowRestore() { return new PredefinedIcon(IconSpecs.fas.windowRestore.iconSpec); }
        static PredefinedIcon wineBottle() { return new PredefinedIcon(IconSpecs.fas.wineBottle.iconSpec); }
        static PredefinedIcon wineGlass() { return new PredefinedIcon(IconSpecs.fas.wineGlass.iconSpec); }
        static PredefinedIcon wineGlassAlt() { return new PredefinedIcon(IconSpecs.fas.wineGlassAlt.iconSpec); }
        static PredefinedIcon wonSign() { return new PredefinedIcon(IconSpecs.fas.wonSign.iconSpec); }
        static PredefinedIcon wrench() { return new PredefinedIcon(IconSpecs.fas.wrench.iconSpec); }
        static PredefinedIcon xRay() { return new PredefinedIcon(IconSpecs.fas.xRay.iconSpec); }
        static PredefinedIcon yenSign() { return new PredefinedIcon(IconSpecs.fas.yenSign.iconSpec); }
        static PredefinedIcon yinYang() { return new PredefinedIcon(IconSpecs.fas.yinYang.iconSpec); }
    }
    public interface patternfly {
        static PredefinedIcon addCircleO() { return new PredefinedIcon(IconSpecs.patternfly.addCircleO.iconSpec); }
        static PredefinedIcon ansibleTower() { return new PredefinedIcon(IconSpecs.patternfly.ansibleTower.iconSpec); }
        static PredefinedIcon applications() { return new PredefinedIcon(IconSpecs.patternfly.applications.iconSpec); }
        static PredefinedIcon arrow() { return new PredefinedIcon(IconSpecs.patternfly.arrow.iconSpec); }
        static PredefinedIcon asleep() { return new PredefinedIcon(IconSpecs.patternfly.asleep.iconSpec); }
        static PredefinedIcon attentionBell() { return new PredefinedIcon(IconSpecs.patternfly.attentionBell.iconSpec); }
        static PredefinedIcon automation() { return new PredefinedIcon(IconSpecs.patternfly.automation.iconSpec); }
        static PredefinedIcon bell() { return new PredefinedIcon(IconSpecs.patternfly.bell.iconSpec); }
        static PredefinedIcon blueprint() { return new PredefinedIcon(IconSpecs.patternfly.blueprint.iconSpec); }
        static PredefinedIcon build() { return new PredefinedIcon(IconSpecs.patternfly.build.iconSpec); }
        static PredefinedIcon builderImage() { return new PredefinedIcon(IconSpecs.patternfly.builderImage.iconSpec); }
        static PredefinedIcon bundle() { return new PredefinedIcon(IconSpecs.patternfly.bundle.iconSpec); }
        static PredefinedIcon catalog() { return new PredefinedIcon(IconSpecs.patternfly.catalog.iconSpec); }
        static PredefinedIcon chat() { return new PredefinedIcon(IconSpecs.patternfly.chat.iconSpec); }
        static PredefinedIcon close() { return new PredefinedIcon(IconSpecs.patternfly.close.iconSpec); }
        static PredefinedIcon cloudSecurity() { return new PredefinedIcon(IconSpecs.patternfly.cloudSecurity.iconSpec); }
        static PredefinedIcon cloudTenant() { return new PredefinedIcon(IconSpecs.patternfly.cloudTenant.iconSpec); }
        static PredefinedIcon cluster() { return new PredefinedIcon(IconSpecs.patternfly.cluster.iconSpec); }
        static PredefinedIcon connected() { return new PredefinedIcon(IconSpecs.patternfly.connected.iconSpec); }
        static PredefinedIcon containerNode() { return new PredefinedIcon(IconSpecs.patternfly.containerNode.iconSpec); }
        static PredefinedIcon cpu() { return new PredefinedIcon(IconSpecs.patternfly.cpu.iconSpec); }
        static PredefinedIcon criticalRisk() { return new PredefinedIcon(IconSpecs.patternfly.criticalRisk.iconSpec); }
        static PredefinedIcon dataProcessor() { return new PredefinedIcon(IconSpecs.patternfly.dataProcessor.iconSpec); }
        static PredefinedIcon dataSink() { return new PredefinedIcon(IconSpecs.patternfly.dataSink.iconSpec); }
        static PredefinedIcon dataSource() { return new PredefinedIcon(IconSpecs.patternfly.dataSource.iconSpec); }
        static PredefinedIcon degraded() { return new PredefinedIcon(IconSpecs.patternfly.degraded.iconSpec); }
        static PredefinedIcon disconnected() { return new PredefinedIcon(IconSpecs.patternfly.disconnected.iconSpec); }
        static PredefinedIcon domain() { return new PredefinedIcon(IconSpecs.patternfly.domain.iconSpec); }
        static PredefinedIcon editAlt() { return new PredefinedIcon(IconSpecs.patternfly.editAlt.iconSpec); }
        static PredefinedIcon enhancement() { return new PredefinedIcon(IconSpecs.patternfly.enhancement.iconSpec); }
        static PredefinedIcon enterprise() { return new PredefinedIcon(IconSpecs.patternfly.enterprise.iconSpec); }
        static PredefinedIcon equalizer() { return new PredefinedIcon(IconSpecs.patternfly.equalizer.iconSpec); }
        static PredefinedIcon errorCircleO() { return new PredefinedIcon(IconSpecs.patternfly.errorCircleO.iconSpec); }
        static PredefinedIcon export() { return new PredefinedIcon(IconSpecs.patternfly.export.iconSpec); }
        static PredefinedIcon filterAlt() { return new PredefinedIcon(IconSpecs.patternfly.filterAlt.iconSpec); }
        static PredefinedIcon flavor() { return new PredefinedIcon(IconSpecs.patternfly.flavor.iconSpec); }
        static PredefinedIcon folderClose() { return new PredefinedIcon(IconSpecs.patternfly.folderClose.iconSpec); }
        static PredefinedIcon folderOpenAlt() { return new PredefinedIcon(IconSpecs.patternfly.folderOpenAlt.iconSpec); }
        static PredefinedIcon globeRoute() { return new PredefinedIcon(IconSpecs.patternfly.globeRoute.iconSpec); }
        static PredefinedIcon help() { return new PredefinedIcon(IconSpecs.patternfly.help.iconSpec); }
        static PredefinedIcon homeAlt() { return new PredefinedIcon(IconSpecs.patternfly.homeAlt.iconSpec); }
        static PredefinedIcon import_() { return new PredefinedIcon(IconSpecs.patternfly.import_.iconSpec); }
        static PredefinedIcon inProgress() { return new PredefinedIcon(IconSpecs.patternfly.inProgress.iconSpec); }
        static PredefinedIcon infoAlt() { return new PredefinedIcon(IconSpecs.patternfly.infoAlt.iconSpec); }
        static PredefinedIcon infrastructure() { return new PredefinedIcon(IconSpecs.patternfly.infrastructure.iconSpec); }
        static PredefinedIcon integration() { return new PredefinedIcon(IconSpecs.patternfly.integration.iconSpec); }
        static PredefinedIcon key() { return new PredefinedIcon(IconSpecs.patternfly.key.iconSpec); }
        static PredefinedIcon locked() { return new PredefinedIcon(IconSpecs.patternfly.locked.iconSpec); }
        static PredefinedIcon maintenance() { return new PredefinedIcon(IconSpecs.patternfly.maintenance.iconSpec); }
        static PredefinedIcon memoryAlt() { return new PredefinedIcon(IconSpecs.patternfly.memoryAlt.iconSpec); }
        static PredefinedIcon messages() { return new PredefinedIcon(IconSpecs.patternfly.messages.iconSpec); }
        static PredefinedIcon middleware() { return new PredefinedIcon(IconSpecs.patternfly.middleware.iconSpec); }
        static PredefinedIcon migration() { return new PredefinedIcon(IconSpecs.patternfly.migration.iconSpec); }
        static PredefinedIcon module() { return new PredefinedIcon(IconSpecs.patternfly.module.iconSpec); }
        static PredefinedIcon monitoring() { return new PredefinedIcon(IconSpecs.patternfly.monitoring.iconSpec); }
        static PredefinedIcon namespaces() { return new PredefinedIcon(IconSpecs.patternfly.namespaces.iconSpec); }
        static PredefinedIcon notStarted() { return new PredefinedIcon(IconSpecs.patternfly.notStarted.iconSpec); }
        static PredefinedIcon network() { return new PredefinedIcon(IconSpecs.patternfly.network.iconSpec); }
        static PredefinedIcon newProcess() { return new PredefinedIcon(IconSpecs.patternfly.newProcess.iconSpec); }
        static PredefinedIcon off() { return new PredefinedIcon(IconSpecs.patternfly.off.iconSpec); }
        static PredefinedIcon ok() { return new PredefinedIcon(IconSpecs.patternfly.ok.iconSpec); }
        static PredefinedIcon onRunning() { return new PredefinedIcon(IconSpecs.patternfly.onRunning.iconSpec); }
        static PredefinedIcon on() { return new PredefinedIcon(IconSpecs.patternfly.on.iconSpec); }
        static PredefinedIcon openDrawerRight() { return new PredefinedIcon(IconSpecs.patternfly.openDrawerRight.iconSpec); }
        static PredefinedIcon openshift() { return new PredefinedIcon(IconSpecs.patternfly.openshift.iconSpec); }
        static PredefinedIcon openstack() { return new PredefinedIcon(IconSpecs.patternfly.openstack.iconSpec); }
        static PredefinedIcon optimize() { return new PredefinedIcon(IconSpecs.patternfly.optimize.iconSpec); }
        static PredefinedIcon orders() { return new PredefinedIcon(IconSpecs.patternfly.orders.iconSpec); }
        static PredefinedIcon osImage() { return new PredefinedIcon(IconSpecs.patternfly.osImage.iconSpec); }
        static PredefinedIcon package_() { return new PredefinedIcon(IconSpecs.patternfly.package_.iconSpec); }
        static PredefinedIcon panelOpen() { return new PredefinedIcon(IconSpecs.patternfly.panelOpen.iconSpec); }
        static PredefinedIcon panelClose() { return new PredefinedIcon(IconSpecs.patternfly.panelClose.iconSpec); }
        static PredefinedIcon paused() { return new PredefinedIcon(IconSpecs.patternfly.paused.iconSpec); }
        static PredefinedIcon pending() { return new PredefinedIcon(IconSpecs.patternfly.pending.iconSpec); }
        static PredefinedIcon pficonDragdrop() { return new PredefinedIcon(IconSpecs.patternfly.pficonDragdrop.iconSpec); }
        static PredefinedIcon pficonHistory() { return new PredefinedIcon(IconSpecs.patternfly.pficonHistory.iconSpec); }
        static PredefinedIcon pficonNetworkRange() { return new PredefinedIcon(IconSpecs.patternfly.pficonNetworkRange.iconSpec); }
        static PredefinedIcon pficonSatellite() { return new PredefinedIcon(IconSpecs.patternfly.pficonSatellite.iconSpec); }
        static PredefinedIcon pficonSortCommonAsc() { return new PredefinedIcon(IconSpecs.patternfly.pficonSortCommonAsc.iconSpec); }
        static PredefinedIcon pficonSortCommonDesc() { return new PredefinedIcon(IconSpecs.patternfly.pficonSortCommonDesc.iconSpec); }
        static PredefinedIcon pficonTemplate() { return new PredefinedIcon(IconSpecs.patternfly.pficonTemplate.iconSpec); }
        static PredefinedIcon pficonVcenter() { return new PredefinedIcon(IconSpecs.patternfly.pficonVcenter.iconSpec); }
        static PredefinedIcon plugged() { return new PredefinedIcon(IconSpecs.patternfly.plugged.iconSpec); }
        static PredefinedIcon port() { return new PredefinedIcon(IconSpecs.patternfly.port.iconSpec); }
        static PredefinedIcon printAlt() { return new PredefinedIcon(IconSpecs.patternfly.printAlt.iconSpec); }
        static PredefinedIcon private_() { return new PredefinedIcon(IconSpecs.patternfly.private_.iconSpec); }
        static PredefinedIcon processAutomation() { return new PredefinedIcon(IconSpecs.patternfly.processAutomation.iconSpec); }
        static PredefinedIcon project() { return new PredefinedIcon(IconSpecs.patternfly.project.iconSpec); }
        static PredefinedIcon rebalance() { return new PredefinedIcon(IconSpecs.patternfly.rebalance.iconSpec); }
        static PredefinedIcon rebooting() { return new PredefinedIcon(IconSpecs.patternfly.rebooting.iconSpec); }
        static PredefinedIcon regions() { return new PredefinedIcon(IconSpecs.patternfly.regions.iconSpec); }
        static PredefinedIcon registry() { return new PredefinedIcon(IconSpecs.patternfly.registry.iconSpec); }
        static PredefinedIcon remove2() { return new PredefinedIcon(IconSpecs.patternfly.remove2.iconSpec); }
        static PredefinedIcon replicator() { return new PredefinedIcon(IconSpecs.patternfly.replicator.iconSpec); }
        static PredefinedIcon repository() { return new PredefinedIcon(IconSpecs.patternfly.repository.iconSpec); }
        static PredefinedIcon resourcePool() { return new PredefinedIcon(IconSpecs.patternfly.resourcePool.iconSpec); }
        static PredefinedIcon resourcesAlmostEmpty() { return new PredefinedIcon(IconSpecs.patternfly.resourcesAlmostEmpty.iconSpec); }
        static PredefinedIcon resourcesAlmostFull() { return new PredefinedIcon(IconSpecs.patternfly.resourcesAlmostFull.iconSpec); }
        static PredefinedIcon resourcesEmpty() { return new PredefinedIcon(IconSpecs.patternfly.resourcesEmpty.iconSpec); }
        static PredefinedIcon resourcesFull() { return new PredefinedIcon(IconSpecs.patternfly.resourcesFull.iconSpec); }
        static PredefinedIcon running() { return new PredefinedIcon(IconSpecs.patternfly.running.iconSpec); }
        static PredefinedIcon saveAlt() { return new PredefinedIcon(IconSpecs.patternfly.saveAlt.iconSpec); }
        static PredefinedIcon screen() { return new PredefinedIcon(IconSpecs.patternfly.screen.iconSpec); }
        static PredefinedIcon security() { return new PredefinedIcon(IconSpecs.patternfly.security.iconSpec); }
        static PredefinedIcon serverGroup() { return new PredefinedIcon(IconSpecs.patternfly.serverGroup.iconSpec); }
        static PredefinedIcon serverAlt() { return new PredefinedIcon(IconSpecs.patternfly.serverAlt.iconSpec); }
        static PredefinedIcon serviceCatalog() { return new PredefinedIcon(IconSpecs.patternfly.serviceCatalog.iconSpec); }
        static PredefinedIcon service() { return new PredefinedIcon(IconSpecs.patternfly.service.iconSpec); }
        static PredefinedIcon services() { return new PredefinedIcon(IconSpecs.patternfly.services.iconSpec); }
        static PredefinedIcon spinnerAlt() { return new PredefinedIcon(IconSpecs.patternfly.spinnerAlt.iconSpec); }
        static PredefinedIcon spinner2() { return new PredefinedIcon(IconSpecs.patternfly.spinner2.iconSpec); }
        static PredefinedIcon storageDomain() { return new PredefinedIcon(IconSpecs.patternfly.storageDomain.iconSpec); }
        static PredefinedIcon task() { return new PredefinedIcon(IconSpecs.patternfly.task.iconSpec); }
        static PredefinedIcon tenant() { return new PredefinedIcon(IconSpecs.patternfly.tenant.iconSpec); }
        static PredefinedIcon thumbTack() { return new PredefinedIcon(IconSpecs.patternfly.thumbTack.iconSpec); }
        static PredefinedIcon topology() { return new PredefinedIcon(IconSpecs.patternfly.topology.iconSpec); }
        static PredefinedIcon trendDown() { return new PredefinedIcon(IconSpecs.patternfly.trendDown.iconSpec); }
        static PredefinedIcon trendUp() { return new PredefinedIcon(IconSpecs.patternfly.trendUp.iconSpec); }
        static PredefinedIcon unknown() { return new PredefinedIcon(IconSpecs.patternfly.unknown.iconSpec); }
        static PredefinedIcon unlocked() { return new PredefinedIcon(IconSpecs.patternfly.unlocked.iconSpec); }
        static PredefinedIcon unplugged() { return new PredefinedIcon(IconSpecs.patternfly.unplugged.iconSpec); }
        static PredefinedIcon userSec() { return new PredefinedIcon(IconSpecs.patternfly.userSec.iconSpec); }
        static PredefinedIcon usersAlt() { return new PredefinedIcon(IconSpecs.patternfly.usersAlt.iconSpec); }
        static PredefinedIcon virtualMachine() { return new PredefinedIcon(IconSpecs.patternfly.virtualMachine.iconSpec); }
        static PredefinedIcon volume() { return new PredefinedIcon(IconSpecs.patternfly.volume.iconSpec); }
        static PredefinedIcon warningTriangle() { return new PredefinedIcon(IconSpecs.patternfly.warningTriangle.iconSpec); }
        static PredefinedIcon zone() { return new PredefinedIcon(IconSpecs.patternfly.zone.iconSpec); }
        static PredefinedIcon ansibeTower() { return new PredefinedIcon(IconSpecs.patternfly.ansibeTower.iconSpec); }
        static PredefinedIcon cloudCircle() { return new PredefinedIcon(IconSpecs.patternfly.cloudCircle.iconSpec); }
        static PredefinedIcon cloudServer() { return new PredefinedIcon(IconSpecs.patternfly.cloudServer.iconSpec); }
        static PredefinedIcon chartSpike() { return new PredefinedIcon(IconSpecs.patternfly.chartSpike.iconSpec); }
        static PredefinedIcon paperPlaneAlt() { return new PredefinedIcon(IconSpecs.patternfly.paperPlaneAlt.iconSpec); }
        static PredefinedIcon azure() { return new PredefinedIcon(IconSpecs.patternfly.azure.iconSpec); }
        static PredefinedIcon svgPathDataMissing() { return new PredefinedIcon(IconSpecs.patternfly.svgPathDataMissing.iconSpec); }
    }
}
