/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import antlr.RecognitionException;
import antlr.TokenStreamRecognitionException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import processing.app.Base;
import processing.app.Library;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.SketchException;
import processing.app.Util;
import processing.app.exec.ProcessHelper;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.data.StringList;
import processing.data.XML;
import processing.mode.java.Compiler;
import processing.mode.java.preproc.PdePreprocessor;
import processing.mode.java.preproc.PreprocessorResult;
import processing.mode.java.preproc.SurfaceInfo;

public class JavaBuild {
    public static final String PACKAGE_REGEX = "(?:^|\\s|;)package\\s+(\\S+)\\;";
    protected Sketch sketch;
    protected Mode mode;
    protected File srcFolder;
    protected File binFolder;
    private boolean foundMain = false;
    private String classPath;
    protected String sketchClassName;
    private String javaLibraryPath;
    private List<Library> importedLibraries;
    static Boolean xcodeInstalled;

    public JavaBuild(Sketch sketch) {
        this.sketch = sketch;
        this.mode = sketch.getMode();
    }

    public String build(boolean sizeWarning) throws SketchException {
        return this.build(this.sketch.makeTempFolder(), this.sketch.makeTempFolder(), sizeWarning);
    }

    public String build(File srcFolder, File binFolder, boolean sizeWarning) throws SketchException {
        this.srcFolder = srcFolder;
        this.binFolder = binFolder;
        String classNameFound = this.preprocess(srcFolder, sizeWarning);
        if (Compiler.compile(this)) {
            this.sketchClassName = classNameFound;
            return classNameFound;
        }
        return null;
    }

    public String getSketchClassName() {
        return this.sketchClassName;
    }

    public String preprocess(File srcFolder, boolean sizeWarning) throws SketchException {
        return this.preprocess(srcFolder, null, new PdePreprocessor(this.sketch.getName()), sizeWarning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String preprocess(File srcFolder, String packageName, PdePreprocessor preprocessor, boolean sizeWarning) throws SketchException {
        PreprocessorResult result;
        this.sketch.ensureExistence();
        this.classPath = this.binFolder.getAbsolutePath();
        StringList codeFolderPackages = null;
        if (this.sketch.hasCodeFolder()) {
            File codeFolder = this.sketch.getCodeFolder();
            this.javaLibraryPath = codeFolder.getAbsolutePath();
            String codeFolderClassPath = Util.contentsToClassPath((File)codeFolder);
            this.classPath = this.classPath + File.pathSeparator + codeFolderClassPath;
            codeFolderPackages = Util.packageListFromClassPath((String)codeFolderClassPath);
        } else {
            this.javaLibraryPath = "";
        }
        StringBuilder bigCode = new StringBuilder();
        int bigCount = 0;
        for (SketchCode sc : this.sketch.getCode()) {
            if (!sc.isExtension("pde")) continue;
            sc.setPreprocOffset(bigCount);
            bigCode.append(sc.getProgram());
            bigCode.append('\n');
            bigCount += sc.getLineCount();
        }
        SurfaceInfo sizeInfo = preprocessor.initSketchSize(this.sketch.getMainProgram(), sizeWarning);
        if (sizeInfo == null) {
            return null;
        }
        if (sizeInfo != null && sizeInfo.hasSettings()) {
            for (String stmt : sizeInfo.getStatements()) {
                int index = bigCode.indexOf(stmt = stmt.trim());
                if (index != -1) {
                    bigCode.delete(index, index + stmt.length());
                    continue;
                }
                System.err.format("Error removing '%s' from the code.", stmt);
            }
        }
        try {
            File outputFolder = packageName == null ? srcFolder : new File(srcFolder, packageName.replace('.', '/'));
            outputFolder.mkdirs();
            File java = new File(outputFolder, this.sketch.getName() + ".java");
            try (PrintWriter stream = new PrintWriter(new FileWriter(java));){
                result = preprocessor.write(stream, bigCode.toString(), codeFolderPackages);
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            String msg = "Build folder disappeared or could not be written";
            throw new SketchException(msg);
        }
        catch (RecognitionException re) {
            int errorLine = re.getLine() - 1;
            int errorFile = this.findErrorFile(errorLine);
            errorLine -= this.sketch.getCode(errorFile).getPreprocOffset();
            String msg = re.getMessage();
            if (msg.contains("expecting RCURLY")) {
                throw new SketchException("Found one too many { characters without a } to match it.", errorFile, errorLine, re.getColumn(), false);
            }
            if (msg.contains("expecting LCURLY")) {
                System.err.println(msg);
                String suffix = ".";
                String[] m = PApplet.match((String)msg, (String)"found ('.*')");
                if (m != null) {
                    suffix = ", not " + m[1] + ".";
                }
                throw new SketchException("Was expecting a { character" + suffix, errorFile, errorLine, re.getColumn(), false);
            }
            if (msg.indexOf("expecting RBRACK") != -1) {
                System.err.println(msg);
                throw new SketchException("Syntax error, maybe a missing ] character?", errorFile, errorLine, re.getColumn(), false);
            }
            if (msg.indexOf("expecting SEMI") != -1) {
                System.err.println(msg);
                throw new SketchException("Syntax error, maybe a missing semicolon?", errorFile, errorLine, re.getColumn(), false);
            }
            if (msg.indexOf("expecting RPAREN") != -1) {
                System.err.println(msg);
                throw new SketchException("Syntax error, maybe a missing right parenthesis?", errorFile, errorLine, re.getColumn(), false);
            }
            if (msg.indexOf("preproc.web_colors") != -1) {
                throw new SketchException("A web color (such as #ffcc00) must be six digits.", errorFile, errorLine, re.getColumn(), false);
            }
            throw new SketchException(msg, errorFile, errorLine, re.getColumn(), false);
        }
        catch (TokenStreamRecognitionException tsre) {
            String mess = "^line (\\d+):(\\d+):\\s";
            String[] matches = PApplet.match((String)tsre.toString(), (String)mess);
            if (matches != null) {
                int errorLine = Integer.parseInt(matches[1]) - 1;
                int errorColumn = Integer.parseInt(matches[2]);
                int errorFile = 0;
                for (int i = 1; i < this.sketch.getCodeCount(); ++i) {
                    SketchCode sc = this.sketch.getCode(i);
                    if (!sc.isExtension("pde") || sc.getPreprocOffset() >= errorLine) continue;
                    errorFile = i;
                }
                throw new SketchException(tsre.getMessage(), errorFile, errorLine -= this.sketch.getCode(errorFile).getPreprocOffset(), errorColumn);
            }
            String msg = tsre.toString();
            throw new SketchException(msg, 0, -1, -1);
        }
        catch (SketchException pe) {
            throw pe;
        }
        catch (Exception ex) {
            System.err.println("Uncaught exception type:" + ex.getClass());
            ex.printStackTrace();
            throw new SketchException(ex.toString());
        }
        this.importedLibraries = new ArrayList<Library>();
        Library core = this.mode.getCoreLibrary();
        if (core != null) {
            this.importedLibraries.add(core);
            this.classPath = this.classPath + core.getClassPath();
            this.javaLibraryPath = this.javaLibraryPath + File.pathSeparator + core.getNativePath();
        }
        for (String item : result.extraImports) {
            Library library;
            String entry;
            int dot = item.lastIndexOf(46);
            String string = entry = dot == -1 ? item : item.substring(0, dot);
            if (item.startsWith("static ")) {
                int dot2 = item.lastIndexOf(46);
                entry = entry.substring(7, dot2 == -1 ? entry.length() : dot2);
            }
            if ((library = this.mode.getLibrary(entry)) != null) {
                if (this.importedLibraries.contains(library)) continue;
                this.importedLibraries.add(library);
                this.classPath = this.classPath + library.getClassPath();
                this.javaLibraryPath = this.javaLibraryPath + File.pathSeparator + library.getNativePath();
                continue;
            }
            boolean found = false;
            if (codeFolderPackages != null) {
                String itemPkg = entry;
                for (String pkg : codeFolderPackages) {
                    if (!pkg.equals(itemPkg)) continue;
                    found = true;
                    break;
                }
            }
            if (this.ignorableImport(entry + '.')) {
                found = true;
            }
            if (found) continue;
            System.err.println("No library found for " + entry);
        }
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath.startsWith("\"") && javaClassPath.endsWith("\"")) {
            javaClassPath = javaClassPath.substring(1, javaClassPath.length() - 1);
        }
        this.classPath = this.classPath + File.pathSeparator + javaClassPath;
        for (SketchCode sc : this.sketch.getCode()) {
            if (sc.isExtension("java")) {
                String filename = sc.getFileName();
                try {
                    String javaCode = sc.getProgram();
                    String[] packageMatch = PApplet.match((String)javaCode, (String)PACKAGE_REGEX);
                    if (packageMatch == null && packageName == null) {
                        sc.copyTo(new File(srcFolder, filename));
                        continue;
                    }
                    if (packageMatch == null) {
                        packageMatch = new String[]{"", packageName};
                        javaCode = "package " + packageName + ";" + javaCode;
                    }
                    File packageFolder = new File(srcFolder, packageMatch[1].replace('.', File.separatorChar));
                    packageFolder.mkdirs();
                    Util.saveFile((String)javaCode, (File)new File(packageFolder, filename));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String msg = "Problem moving " + filename + " to the build folder";
                    throw new SketchException(msg);
                }
            }
            if (!sc.isExtension("pde")) continue;
            sc.addPreprocOffset(result.headerOffset);
        }
        this.foundMain = preprocessor.hasMethod("main");
        return result.className;
    }

    protected boolean ignorableImport(String pkg) {
        if (pkg.startsWith("java.")) {
            return true;
        }
        if (pkg.startsWith("javax.")) {
            return true;
        }
        if (pkg.startsWith("processing.core.")) {
            return true;
        }
        if (pkg.startsWith("processing.data.")) {
            return true;
        }
        if (pkg.startsWith("processing.event.")) {
            return true;
        }
        return pkg.startsWith("processing.opengl.");
    }

    protected int findErrorFile(int errorLine) {
        for (int i = this.sketch.getCodeCount() - 1; i > 0; --i) {
            SketchCode sc = this.sketch.getCode(i);
            if (!sc.isExtension("pde") || sc.getPreprocOffset() > errorLine) continue;
            return i;
        }
        return 0;
    }

    public File getSrcFolder() {
        return this.srcFolder;
    }

    public File getBinFolder() {
        return this.binFolder;
    }

    public String getSketchPath() {
        return this.sketch.getFolder().getAbsolutePath();
    }

    public String getClassPath() {
        return this.classPath;
    }

    public String getJavaLibraryPath() {
        return this.javaLibraryPath;
    }

    public boolean getFoundMain() {
        return this.foundMain;
    }

    public List<Library> getImportedLibraries() {
        return this.importedLibraries;
    }

    public SketchException placeException(String message, String dotJavaFilename, int dotJavaLine) {
        SketchCode code;
        int i;
        int codeIndex = 0;
        int codeLine = -1;
        for (i = 0; i < this.sketch.getCodeCount(); ++i) {
            code = this.sketch.getCode(i);
            if (!code.isExtension("java") || !dotJavaFilename.equals(code.getFileName())) continue;
            codeIndex = i;
            codeLine = dotJavaLine;
            return new SketchException(message, codeIndex, codeLine);
        }
        if (!dotJavaFilename.equals(this.sketch.getName() + ".java")) {
            return null;
        }
        codeIndex = 0;
        for (i = 0; i < this.sketch.getCodeCount(); ++i) {
            code = this.sketch.getCode(i);
            if (!code.isExtension("pde") || code.getPreprocOffset() > dotJavaLine) continue;
            codeIndex = i;
            codeLine = dotJavaLine - code.getPreprocOffset();
        }
        return new SketchException(message, codeIndex, codeLine, -1, false);
    }

    protected boolean exportApplication() throws IOException, SketchException {
        String foundName = this.build(true);
        if (foundName == null) {
            return false;
        }
        if (!this.sketch.getName().equals(foundName)) {
            Messages.showWarning((String)"Error during export", (String)("Sketch name is " + this.sketch.getName() + " but the sketch\n" + "name in the code was " + foundName), null);
            return false;
        }
        File folder = null;
        for (String platformName : PConstants.platformNames) {
            boolean embedJava;
            int platform = Platform.getIndex((String)platformName);
            boolean bl = embedJava = platform == PApplet.platform && Preferences.getBoolean((String)"export.application.embed_java");
            if (!Preferences.getBoolean((String)("export.application.platform_" + platformName))) continue;
            if (Library.hasMultipleArch((int)platform, this.importedLibraries)) {
                folder = new File(this.sketch.getFolder(), "application." + platformName + "32");
                if (!this.exportApplication(folder, platform, "32", embedJava && Platform.getNativeBits() == 32 && "x86".equals(Platform.getNativeArch()))) {
                    return false;
                }
                folder = new File(this.sketch.getFolder(), "application." + platformName + "64");
                if (!this.exportApplication(folder, platform, "64", embedJava && Platform.getNativeBits() == 64 && "amd64".equals(Platform.getNativeArch()))) {
                    return false;
                }
                if (platform != 3 || this.exportApplication(folder = new File(this.sketch.getFolder(), "application.linux-armv6hf"), platform, "armv6hf", embedJava && Platform.getNativeBits() == 32 && "arm".equals(Platform.getNativeArch()))) continue;
                return false;
            }
            folder = new File(this.sketch.getFolder(), "application." + platformName);
            if (this.exportApplication(folder, platform, "", embedJava)) continue;
            return false;
        }
        return true;
    }

    protected boolean exportApplication(File destFolder, int exportPlatform, String exportVariant, boolean embedJava) throws IOException, SketchException {
        int i;
        for (Library library : this.importedLibraries) {
            if (library.supportsArch(exportPlatform, exportVariant)) continue;
            String pn = PConstants.platformNames[exportPlatform];
            Messages.showWarning((String)"Quibbles 'n Bits", (String)("The application." + pn + exportVariant + " folder will not be created\n" + "because no " + exportVariant + " version of " + library.getName() + " is available for " + pn), null);
            return true;
        }
        this.mode.prepareExportFolder(destFolder);
        File jarFolder = new File(destFolder, "lib");
        File dotAppFolder = null;
        String jvmRuntime = "";
        String jdkPath = null;
        if (exportPlatform == 2) {
            dotAppFolder = new File(destFolder, this.sketch.getName() + ".app");
            File contentsOrig = new File(Platform.getJavaHome(), "../../../../..");
            if (embedJava) {
                File jdkFolder = new File(Platform.getJavaHome(), "../../..");
                String jdkFolderName = jdkFolder.getCanonicalFile().getName();
                jvmRuntime = "<key>JVMRuntime</key>\n    <string>" + jdkFolderName + "</string>";
                jdkPath = new File(dotAppFolder, "Contents/PlugIns/" + jdkFolderName).getAbsolutePath();
            }
            File contentsFolder = new File(dotAppFolder, "Contents");
            contentsFolder.mkdirs();
            jarFolder = new File(contentsFolder, "Java");
            File macosFolder = new File(contentsFolder, "MacOS");
            macosFolder.mkdirs();
            Util.copyFile((File)new File(contentsOrig, "MacOS/Processing"), (File)new File(contentsFolder, "MacOS/" + this.sketch.getName()));
            File pkgInfo = new File(contentsFolder, "PkgInfo");
            PrintWriter writer = PApplet.createWriter((File)pkgInfo);
            writer.println("APPL????");
            writer.flush();
            writer.close();
            if (embedJava) {
                Util.copyDirNative((File)new File(contentsOrig, "PlugIns"), (File)new File(contentsFolder, "PlugIns"));
            }
            File resourcesFolder = new File(contentsFolder, "Resources");
            Util.copyDir((File)new File(contentsOrig, "Resources/en.lproj"), (File)new File(resourcesFolder, "en.lproj"));
            Util.copyFile((File)this.mode.getContentFile("application/sketch.icns"), (File)new File(resourcesFolder, "sketch.icns"));
        } else if (exportPlatform == 3) {
            if (embedJava) {
                Util.copyDirNative((File)Platform.getJavaHome(), (File)new File(destFolder, "java"));
            }
        } else if (exportPlatform == 1 && embedJava) {
            Util.copyDir((File)Platform.getJavaHome(), (File)new File(destFolder, "java"));
        }
        if (!jarFolder.exists()) {
            jarFolder.mkdirs();
        }
        Vector<String> jarListVector = new Vector<String>();
        FileOutputStream zipOutputFile = new FileOutputStream(new File(jarFolder, this.sketch.getName() + ".jar"));
        ZipOutputStream zos = new ZipOutputStream(zipOutputFile);
        this.addManifest(zos);
        this.addClasses(zos, this.binFolder);
        if (this.sketch.hasDataFolder()) {
            if (exportPlatform == 2) {
                Util.copyDir((File)this.sketch.getDataFolder(), (File)new File(jarFolder, "data"));
            } else {
                Util.copyDir((File)this.sketch.getDataFolder(), (File)new File(destFolder, "data"));
            }
        }
        if (this.sketch.hasCodeFolder()) {
            String includes = Util.contentsToClassPath((File)this.sketch.getCodeFolder());
            String[] codeList = PApplet.splitTokens((String)includes, (String)File.pathSeparator);
            for (int i2 = 0; i2 < codeList.length; ++i2) {
                if (!codeList[i2].toLowerCase().endsWith(".jar") && !codeList[i2].toLowerCase().endsWith(".zip")) continue;
                File exportFile = new File(codeList[i2]);
                String exportFilename = exportFile.getName();
                Util.copyFile((File)exportFile, (File)new File(jarFolder, exportFilename));
                jarListVector.add(exportFilename);
            }
        }
        zos.flush();
        zos.close();
        jarListVector.add(this.sketch.getName() + ".jar");
        for (Library library : this.importedLibraries) {
            for (File exportFile : library.getApplicationExports(exportPlatform, exportVariant)) {
                String exportName = exportFile.getName();
                if (!exportFile.exists()) {
                    System.err.println(exportFile.getName() + " is mentioned in export.txt, but it's " + "a big fat lie and does not exist.");
                    continue;
                }
                if (exportFile.isDirectory()) {
                    Util.copyDir((File)exportFile, (File)new File(jarFolder, exportName));
                    continue;
                }
                if (exportName.toLowerCase().endsWith(".zip") || exportName.toLowerCase().endsWith(".jar")) {
                    Util.copyFile((File)exportFile, (File)new File(jarFolder, exportName));
                    jarListVector.add(exportName);
                    continue;
                }
                Util.copyFile((File)exportFile, (File)new File(jarFolder, exportName));
            }
        }
        Object[] jarList = new String[jarListVector.size()];
        jarListVector.copyInto(jarList);
        StringBuilder exportClassPath = new StringBuilder();
        if (exportPlatform == 2) {
            for (i = 0; i < jarList.length; ++i) {
                if (i != 0) {
                    exportClassPath.append(":");
                }
                exportClassPath.append("$JAVAROOT/" + (String)jarList[i]);
            }
        } else if (exportPlatform == 1) {
            for (i = 0; i < jarList.length; ++i) {
                if (i != 0) {
                    exportClassPath.append(",");
                }
                exportClassPath.append((String)jarList[i]);
            }
        } else {
            exportClassPath.append("$APPDIR");
            for (i = 0; i < jarList.length; ++i) {
                exportClassPath.append(":$APPDIR/lib/" + (String)jarList[i]);
            }
        }
        ArrayList<String> runOptions = new ArrayList<String>();
        if (Preferences.getBoolean((String)"run.options.memory") && !exportVariant.equals("armv6hf")) {
            runOptions.add("-Xms" + Preferences.get((String)"run.options.memory.initial") + "m");
            runOptions.add("-Xmx" + Preferences.get((String)"run.options.memory.maximum") + "m");
        }
        runOptions.add("-Djna.nosys=true");
        if (exportPlatform == 1) {
            runOptions.add("-Djava.library.path=\"%EXEDIR%\\lib\"");
        }
        if (exportPlatform == 2) {
            StringBuilder runOptionsXML = new StringBuilder();
            for (String opt : runOptions) {
                runOptionsXML.append("      <string>");
                runOptionsXML.append(opt);
                runOptionsXML.append("</string>");
                runOptionsXML.append('\n');
            }
            String PLIST_TEMPLATE = "Info.plist.tmpl";
            File plistTemplate = new File(this.sketch.getFolder(), PLIST_TEMPLATE);
            if (!plistTemplate.exists()) {
                plistTemplate = this.mode.getContentFile("application/" + PLIST_TEMPLATE);
            }
            File plistFile = new File(dotAppFolder, "Contents/Info.plist");
            PrintWriter pw = PApplet.createWriter((File)plistFile);
            String[] lines = PApplet.loadStrings((File)plistTemplate);
            for (int i3 = 0; i3 < lines.length; ++i3) {
                if (lines[i3].indexOf("@@") != -1) {
                    StringBuilder sb = new StringBuilder(lines[i3]);
                    int index = 0;
                    while ((index = sb.indexOf("@@jvm_runtime@@")) != -1) {
                        sb.replace(index, index + "@@jvm_runtime@@".length(), jvmRuntime);
                    }
                    while ((index = sb.indexOf("@@jvm_options_list@@")) != -1) {
                        sb.replace(index, index + "@@jvm_options_list@@".length(), runOptionsXML.toString());
                    }
                    while ((index = sb.indexOf("@@sketch@@")) != -1) {
                        sb.replace(index, index + "@@sketch@@".length(), this.sketch.getName());
                    }
                    while ((index = sb.indexOf("@@lsuipresentationmode@@")) != -1) {
                        sb.replace(index, index + "@@lsuipresentationmode@@".length(), Preferences.getBoolean((String)"export.application.present") ? "4" : "0");
                    }
                    lines[i3] = sb.toString();
                }
                pw.print(lines[i3] + "\n");
            }
            pw.flush();
            pw.close();
            if (Platform.isMacOS() && JavaBuild.isXcodeInstalled()) {
                if (embedJava) {
                    ProcessHelper.ffs((String[])new String[]{"codesign", "--force", "--sign", "-", jdkPath});
                }
                String appPath = dotAppFolder.getAbsolutePath();
                ProcessHelper.ffs((String[])new String[]{"codesign", "--force", "--sign", "-", appPath});
            }
        } else if (exportPlatform == 1) {
            File buildFile = new File(destFolder, "launch4j-build.xml");
            File configFile = new File(destFolder, "launch4j-config.xml");
            XML project = new XML("project");
            XML target = project.addChild("target");
            target.setString("name", "windows");
            XML taskdef = target.addChild("taskdef");
            taskdef.setString("name", "launch4j");
            taskdef.setString("classname", "net.sf.launch4j.ant.Launch4jTask");
            String launchPath = this.mode.getContentFile("application/launch4j").getAbsolutePath();
            taskdef.setString("classpath", launchPath + "/launch4j.jar:" + launchPath + "/lib/xstream.jar");
            XML launch4j = target.addChild("launch4j");
            launch4j.setString("configFile", configFile.getAbsolutePath());
            XML config = new XML("launch4jConfig");
            config.addChild("headerType").setContent("gui");
            config.addChild("dontWrapJar").setContent("true");
            config.addChild("downloadUrl").setContent("http://java.com/download");
            File exeFile = new File(destFolder, this.sketch.getName() + ".exe");
            config.addChild("outfile").setContent(exeFile.getAbsolutePath());
            File iconFile = this.mode.getContentFile("application/sketch.ico");
            config.addChild("icon").setContent(iconFile.getAbsolutePath());
            XML clazzPath = config.addChild("classPath");
            clazzPath.addChild("mainClass").setContent(this.sketch.getName());
            for (Object jarName : jarList) {
                clazzPath.addChild("cp").setContent("lib/" + (String)jarName);
            }
            XML jre = config.addChild("jre");
            if (embedJava) {
                jre.addChild("path").setContent("java");
            }
            jre.addChild("minVersion").setContent("1.7.0_40");
            for (String opt : runOptions) {
                jre.addChild("opt").setContent(opt);
            }
            config.save(configFile);
            project.save(buildFile);
            if (!this.buildWindowsLauncher(buildFile, "windows")) {
                return false;
            }
            configFile.delete();
            buildFile.delete();
        } else {
            File shellScript = new File(destFolder, this.sketch.getName());
            SketchCode[] pw = PApplet.createWriter((File)shellScript);
            pw.print("#!/bin/sh\n\n");
            pw.print("APPDIR=$(readlink -f \"$0\")\n");
            pw.print("APPDIR=$(dirname \"$APPDIR\")\n");
            if (embedJava) {
                pw.print("$APPDIR/java/bin/");
            }
            String runOptionsStr = PApplet.join((String[])runOptions.toArray(new String[0]), (String)" ");
            pw.print("java " + runOptionsStr + " -Djava.library.path=\"$APPDIR:$APPDIR/lib\"" + " -cp \"" + exportClassPath + "\"" + " " + this.sketch.getName() + " \"$@\"\n");
            pw.flush();
            pw.close();
            String shellPath = shellScript.getAbsolutePath();
            if (!Platform.isWindows()) {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", shellPath});
            }
        }
        File sourceFolder = new File(destFolder, "source");
        sourceFolder.mkdirs();
        for (SketchCode code : this.sketch.getCode()) {
            try {
                code.copyTo(new File(sourceFolder, code.getFileName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String preprocFilename = this.sketch.getName() + ".java";
        File preprocFile = new File(this.srcFolder, preprocFilename);
        if (preprocFile.exists()) {
            Util.copyFile((File)preprocFile, (File)new File(sourceFolder, preprocFilename));
        } else {
            System.err.println("Could not copy source file: " + preprocFile.getAbsolutePath());
        }
        return true;
    }

    protected static boolean isXcodeInstalled() {
        if (xcodeInstalled == null) {
            Process p = PApplet.launch((String[])new String[]{"xcode-select", "-p"});
            int result = -1;
            try {
                result = p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            xcodeInstalled = result == 0;
        }
        return xcodeInstalled;
    }

    protected boolean buildWindowsLauncher(File buildFile, String target) {
        Project p = new Project();
        String path = buildFile.getAbsolutePath().replace('\\', '/');
        p.setUserProperty("ant.file", path);
        p.setUserProperty("build.compiler", "extJavac");
        DefaultLogger errorLogger = new DefaultLogger();
        ByteArrayOutputStream errb = new ByteArrayOutputStream();
        PrintStream errp = new PrintStream(errb);
        errorLogger.setErrorPrintStream(errp);
        ByteArrayOutputStream outb = new ByteArrayOutputStream();
        PrintStream outp = new PrintStream(outb);
        errorLogger.setOutputPrintStream(outp);
        errorLogger.setMessageOutputLevel(2);
        p.addBuildListener((BuildListener)errorLogger);
        try {
            p.fireBuildStarted();
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)buildFile);
            p.executeTarget(target);
            return true;
        }
        catch (BuildException e) {
            p.fireBuildFinished((Throwable)e);
            String out = new String(outb.toByteArray());
            String err = new String(errb.toByteArray());
            System.out.println(out);
            System.err.println(err);
            return false;
        }
    }

    protected void addManifest(ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry("META-INF/MANIFEST.MF");
        zos.putNextEntry(entry);
        String contents = "Manifest-Version: 1.0\nCreated-By: Processing " + Base.getVersionName() + "\n" + "Main-Class: " + this.sketch.getName() + "\n";
        zos.write(contents.getBytes());
        zos.closeEntry();
    }

    protected void addClasses(ZipOutputStream zos, File dir) throws IOException {
        String path = dir.getAbsolutePath();
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + '/';
        }
        this.addClasses(zos, dir, path);
    }

    protected void addClasses(ZipOutputStream zos, File dir, String rootPath) throws IOException {
        File[] files;
        for (File sub : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.charAt(0) != '.';
            }
        })) {
            String relativePath = sub.getAbsolutePath().substring(rootPath.length());
            if (sub.isDirectory()) {
                this.addClasses(zos, sub, rootPath);
                continue;
            }
            if (!sub.getName().endsWith(".class")) continue;
            ZipEntry entry = new ZipEntry(relativePath);
            zos.putNextEntry(entry);
            PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(sub));
            zos.closeEntry();
        }
    }

    protected void addDataFolder(ZipOutputStream zos) throws IOException {
        if (this.sketch.hasDataFolder()) {
            String[] dataFiles = Util.listFiles((File)this.sketch.getDataFolder(), (boolean)false);
            int offset = this.sketch.getFolder().getAbsolutePath().length() + 1;
            for (String path : dataFiles) {
                File dataFile;
                if (Platform.isWindows()) {
                    path = path.replace('\\', '/');
                }
                if ((dataFile = new File(path)).isDirectory() || dataFile.getName().charAt(0) == '.') continue;
                ZipEntry entry = new ZipEntry(path.substring(offset));
                zos.putNextEntry(entry);
                PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(dataFile));
                zos.closeEntry();
            }
        }
    }

    protected void packClassPathIntoZipFile(String path, ZipOutputStream zos, HashMap<String, Object> zipFileContents) throws IOException {
        String[] pieces = PApplet.split((String)path, (char)File.pathSeparatorChar);
        for (int i = 0; i < pieces.length; ++i) {
            if (pieces[i].length() == 0) continue;
            if (pieces[i].toLowerCase().endsWith(".jar") || pieces[i].toLowerCase().endsWith(".zip")) {
                try {
                    ZipFile file = new ZipFile(pieces[i]);
                    Enumeration<? extends ZipEntry> entries = file.entries();
                    while (entries.hasMoreElements()) {
                        int count;
                        String entryName;
                        ZipEntry entry = entries.nextElement();
                        if (entry.isDirectory() || (entryName = entry.getName()).indexOf("META-INF") == 0 || zipFileContents.get(entryName) != null) continue;
                        zipFileContents.put(entryName, new Object());
                        ZipEntry entree = new ZipEntry(entryName);
                        zos.putNextEntry(entree);
                        byte[] buffer = new byte[(int)entry.getSize()];
                        InputStream is = file.getInputStream(entry);
                        int offset = 0;
                        for (int remaining = buffer.length; remaining > 0; remaining -= count) {
                            count = is.read(buffer, offset, remaining);
                            offset += count;
                        }
                        zos.write(buffer);
                        zos.flush();
                        zos.closeEntry();
                    }
                    file.close();
                }
                catch (IOException e) {
                    System.err.println("Error in file " + pieces[i]);
                    e.printStackTrace();
                }
                continue;
            }
            File dir = new File(pieces[i]);
            if (!dir.exists()) continue;
            JavaBuild.packClassPathIntoZipFileRecursive(dir, null, zos);
        }
    }

    protected static void packClassPathIntoZipFileRecursive(File dir, String sofar, ZipOutputStream zos) throws IOException {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            String nowfar;
            if (files[i].charAt(0) == '.') continue;
            File sub = new File(dir, files[i]);
            String string = nowfar = sofar == null ? files[i] : sofar + "/" + files[i];
            if (sub.isDirectory()) {
                JavaBuild.packClassPathIntoZipFileRecursive(sub, nowfar, zos);
                continue;
            }
            if (files[i].toLowerCase().endsWith(".jar") || files[i].toLowerCase().endsWith(".zip") || files[i].charAt(0) == '.') continue;
            ZipEntry entry = new ZipEntry(nowfar);
            zos.putNextEntry(entry);
            PApplet.saveStream((OutputStream)zos, (InputStream)new FileInputStream(sub));
            zos.closeEntry();
        }
    }
}

