/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import processing.app.SketchException;
import processing.app.Util;
import processing.app.ui.Editor;
import processing.core.PApplet;
import processing.mode.java.JavaBuild;

public class Compiler {
    static HashMap<String, String> importSuggestions = new HashMap();

    static {
        importSuggestions.put("Arrays", "java.util.Arrays");
        importSuggestions.put("Collections", "java.util.Collections");
        importSuggestions.put("Date", "java.util.Date");
        importSuggestions.put("Frame", "java.awt.Frame");
        importSuggestions.put("Iterator", "java.util.Iterator");
    }

    /*
     * Unable to fully structure code
     */
    public static boolean compile(JavaBuild build) throws SketchException {
        exception = null;
        success = false;
        baseCommand = new String[]{"-g", "-Xemacs", "-source", "1.7", "-target", "1.7", "-classpath", build.getClassPath(), "-nowarn", "-d", build.getBinFolder().getAbsolutePath()};
        sourceFiles = Util.listFiles((File)build.getSrcFolder(), (boolean)false, (String)".java");
        command = PApplet.concat((String[])baseCommand, (String[])sourceFiles);
        try {
            errorBuffer = new StringBuilder();
            internalWriter = new Writer(){

                @Override
                public void write(char[] buf, int off, int len) {
                    errorBuffer.append(buf, off, len);
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() {
                }
            };
            writer = new PrintWriter(internalWriter);
            outWriter = new PrintWriter(System.out);
            loader = build.mode.getClassLoader();
            try {
                batchClass = Class.forName("org.eclipse.jdt.core.compiler.batch.BatchCompiler", false, loader);
                progressClass = Class.forName("org.eclipse.jdt.core.compiler.CompilationProgress", false, loader);
                compileArgs = new Class[]{String[].class, PrintWriter.class, PrintWriter.class, progressClass};
                compileMethod = batchClass.getMethod("compile", compileArgs);
                v0 = new Object[4];
                v0[0] = command;
                v0[1] = outWriter;
                v0[2] = writer;
                success = (Boolean)compileMethod.invoke(null, v0);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SketchException("Unknown error inside the compiler.");
            }
            writer.flush();
            writer.close();
            reader = new BufferedReader(new StringReader(errorBuffer.toString()));
            line = null;
            while ((line = reader.readLine()) != null) {
                block32: {
                    block30: {
                        block31: {
                            block29: {
                                errorFormat = "([\\w\\d_]+.java):(\\d+):\\s*(.*):\\s*(.*)\\s*";
                                pieces = PApplet.match((String)line, (String)errorFormat);
                                if (pieces == null) {
                                    exception = new SketchException("Cannot parse error text: " + line);
                                    exception.hideStackTrace();
                                    System.err.println(line);
                                    while ((line = reader.readLine()) != null) {
                                        System.err.println(line);
                                    }
                                    break;
                                }
                                errorMessage = pieces[4];
                                dotJavaFilename = pieces[1];
                                dotJavaLineIndex = PApplet.parseInt((String)pieces[2]) - 1;
                                exception = build.placeException(errorMessage, dotJavaFilename, dotJavaLineIndex);
                                if (exception == null) {
                                    exception = new SketchException(errorMessage);
                                }
                                if (!errorMessage.startsWith("The import ") || !errorMessage.endsWith("cannot be resolved")) break block29;
                                m = PApplet.match((String)errorMessage, (String)"The import (.*) cannot be resolved");
                                if (m != null) {
                                    if (m[1].equals("processing.xml")) {
                                        exception.setMessage("processing.xml no longer exists, this code needs to be updated for 2.0.");
                                        System.err.println("The processing.xml library has been replaced with a new 'XML' class that's built-in.");
                                        Compiler.handleCrustyCode();
                                    } else {
                                        exception.setMessage("The package \u201c" + m[1] + "\u201d" + " does not exist. " + "You might be missing a library.");
                                        System.err.println("Libraries must be installed in a folder named 'libraries' inside the 'sketchbook' folder.");
                                    }
                                }
                                ** GOTO lbl-1000
                            }
                            if (!errorMessage.endsWith("cannot be resolved to a type")) break block30;
                            what = errorMessage.substring(0, errorMessage.indexOf(32));
                            if (!what.equals("BFont") && !what.equals("BGraphics") && !what.equals("BImage")) break block31;
                            exception.setMessage(String.valueOf(what) + " has been replaced with P" + what.substring(1));
                            Compiler.handleCrustyCode();
                            ** GOTO lbl-1000
                        }
                        exception.setMessage("Cannot find a class or type named \u201c" + what + "\u201d");
                        suggestion = Compiler.importSuggestions.get(what);
                        if (suggestion == null) ** GOTO lbl-1000
                        System.err.println("You may need to add \"import " + suggestion + ";\" to the top of your sketch.");
                        System.err.println("To make sketches more portable, imports that are not part of the Processing API have been removed from Processing 2.0.");
                        System.err.println("See the changes page for more information: http://wiki.processing.org/w/Changes");
                        ** GOTO lbl-1000
                    }
                    if (!errorMessage.endsWith("cannot be resolved")) break block32;
                    what = errorMessage.substring(0, errorMessage.indexOf(32));
                    if (what.equals("LINE_LOOP") || what.equals("LINE_STRIP")) {
                        exception.setMessage("LINE_LOOP and LINE_STRIP are not available, please update your code.");
                        Compiler.handleCrustyCode();
                    } else if (what.equals("framerate")) {
                        exception.setMessage("framerate should be changed to frameRate.");
                        Compiler.handleCrustyCode();
                    } else if (what.equals("screen")) {
                        exception.setMessage("Change screen.width and screen.height to displayWidth and displayHeight.");
                        Compiler.handleCrustyCode();
                    } else if (what.equals("screenWidth") || what.equals("screenHeight")) {
                        exception.setMessage("Change screenWidth and screenHeight to displayWidth and displayHeight.");
                        Compiler.handleCrustyCode();
                    } else {
                        exception.setMessage("Cannot find anything named \u201c" + what + "\u201d");
                    }
                    ** GOTO lbl-1000
                }
                if (errorMessage.startsWith("Duplicate")) ** GOTO lbl-1000
                parts = null;
                undefined = "The method (\\S+\\(.*\\)) is undefined for the type (.*)";
                parts = PApplet.match((String)errorMessage, (String)undefined);
                if (parts != null) {
                    if (parts[1].equals("framerate(int)")) {
                        exception.setMessage("framerate() no longer exists, use frameRate() instead.");
                        Compiler.handleCrustyCode();
                    } else if (parts[1].equals("push()")) {
                        exception.setMessage("push() no longer exists, use pushMatrix() instead.");
                        Compiler.handleCrustyCode();
                    } else if (parts[1].equals("pop()")) {
                        exception.setMessage("pop() no longer exists, use popMatrix() instead.");
                        Compiler.handleCrustyCode();
                    } else {
                        mess = "The function " + parts[1] + " does not exist.";
                        exception.setMessage(mess);
                    }
                } else lbl-1000:
                // 12 sources

                {
                    if (exception == null) continue;
                    exception.hideStackTrace();
                }
                break;
            }
        }
        catch (IOException e) {
            bigSigh = "Error while compiling. (" + e.getMessage() + ")";
            exception = new SketchException(bigSigh);
            e.printStackTrace();
            success = false;
        }
        if (exception != null) {
            throw exception;
        }
        return success;
    }

    protected static void handleCrustyCode() {
        System.err.println("This code needs to be updated for this version of Processing, please read the Changes page on the Wiki.");
        Editor.showChanges();
    }

    protected int caretColumn(String caretLine) {
        return caretLine.indexOf("^");
    }
}

