/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.debug;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import processing.app.Messages;
import processing.mode.java.Debugger;
import processing.mode.java.debug.ClassLoadListener;
import processing.mode.java.debug.LineID;

public class LineBreakpoint
implements ClassLoadListener {
    protected Debugger dbg;
    protected LineID line;
    protected BreakpointRequest bpr;
    protected ReferenceType theClass;

    public LineBreakpoint(LineID line, Debugger dbg) {
        this.line = line;
        line.startTracking(dbg.getEditor().getTab(line.fileName()).getDocument());
        this.dbg = dbg;
        this.theClass = dbg.getClass(this.className());
        this.set();
        Logger.getLogger(LineBreakpoint.class.getName()).log(Level.INFO, "LBP Created " + this.toString() + " class: " + this.className(), new Object[0]);
    }

    public LineBreakpoint(int lineIdx, Debugger dbg) {
        this(dbg.getEditor().getLineIDInCurrentTab(lineIdx), dbg);
    }

    public LineID lineID() {
        return this.line;
    }

    public boolean isOnLine(LineID testLine) {
        return this.line.equals(testLine);
    }

    protected void attach() {
        if (!this.dbg.isPaused()) {
            Logger.getLogger(LineBreakpoint.class.getName()).log(Level.WARNING, "can't attach breakpoint, debugger not paused");
            return;
        }
        if (this.theClass == null) {
            Logger.getLogger(LineBreakpoint.class.getName()).log(Level.WARNING, "can't attach breakpoint, class not loaded: {0}", this.className());
            return;
        }
        LineID javaLine = this.dbg.sketchToJavaLine(this.line);
        if (javaLine == null) {
            Logger.getLogger(LineBreakpoint.class.getName()).log(Level.WARNING, "couldn't find line {0} in the java code", this.line);
            return;
        }
        try {
            Logger.getLogger(LineBreakpoint.class.getName()).log(Level.WARNING, "BPs of class: {0} , line " + (javaLine.lineIdx() + 1), new Object[]{this.theClass});
            List<Location> locations = this.theClass.locationsOfLine(javaLine.lineIdx() + 1);
            if (locations.isEmpty()) {
                Logger.getLogger(LineBreakpoint.class.getName()).log(Level.WARNING, "no location found for line {0} -> {1}", new Object[]{this.line, javaLine});
                return;
            }
            this.bpr = this.dbg.vm().eventRequestManager().createBreakpointRequest(locations.get(0));
            this.bpr.enable();
            Logger.getLogger(LineBreakpoint.class.getName()).log(Level.INFO, "attached breakpoint to {0} -> {1}", new Object[]{this.line, javaLine});
        }
        catch (AbsentInformationException ex) {
            Logger.getLogger(Debugger.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void detach() {
        if (this.bpr != null) {
            this.dbg.vm().eventRequestManager().deleteEventRequest(this.bpr);
            this.bpr = null;
        }
    }

    protected void set() {
        this.dbg.addClassLoadListener(this);
        this.dbg.getEditor().addBreakpointedLine(this.line);
        if (this.theClass != null && this.dbg.isPaused()) {
            this.attach();
        }
        if (this.dbg.getEditor().isInCurrentTab(this.line)) {
            this.dbg.getEditor().getSketch().setModified(true);
        }
    }

    public void remove() {
        this.dbg.removeClassLoadListener(this);
        this.dbg.getEditor().removeBreakpointedLine(this.line.lineIdx());
        if (this.dbg.isPaused()) {
            this.detach();
        }
        this.line.stopTracking();
        if (this.dbg.getEditor().isInCurrentTab(this.line)) {
            this.dbg.getEditor().getSketch().setModified(true);
        }
    }

    public String toString() {
        return this.line.toString();
    }

    protected String className() {
        if (this.line.fileName().endsWith(".pde")) {
            ReferenceType mainClass = this.dbg.getMainClass();
            if (mainClass == null) {
                return null;
            }
            return this.dbg.getMainClass().name();
        }
        if (this.line.fileName().endsWith(".java")) {
            return this.line.fileName().substring(0, this.line.fileName().lastIndexOf(".java"));
        }
        return null;
    }

    @Override
    public void classLoaded(ReferenceType theClass) {
        Messages.log((String)("Class Loaded: " + theClass.name()));
        if (theClass.name().equals(this.className())) {
            this.theClass = theClass;
            this.attach();
        }
        for (ReferenceType ct : theClass.nestedTypes()) {
            Messages.log((String)("Nested " + ct.name()));
        }
    }
}

