/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class TemplateAntTask
extends MatchingTask {
    protected File mappingFile;
    protected String python;
    protected File destdir;
    protected Path src;
    protected File scriptDir;
    protected boolean verbose = false;

    public void setMappingFile(String string) {
        String string2 = this.getProject().replaceProperties(string);
        this.mappingFile = new File(string2);
    }

    public void setPython(String string) {
        this.python = string;
    }

    public void setDestdir(String string) {
        this.destdir = new File(this.getProject().replaceProperties(string));
    }

    public Path createSrc() {
        if (null == this.src) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setSrcdir(Path path) {
        if (null == this.src) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public void setScriptdir(String string) {
        this.scriptDir = new File(this.getProject().replaceProperties(string));
    }

    public void setVerbose(String string) {
        this.verbose = new Boolean(this.getProject().replaceProperties(string));
    }

    public void execute() {
        Map map;
        if (null == this.mappingFile) {
            throw new BuildException("no mappingFile specified");
        }
        if (!this.mappingFile.canRead()) {
            throw new BuildException("Can't read mappingFile: " + this.mappingFile);
        }
        if (null == this.python) {
            this.python = "python";
        }
        if (null == this.destdir) {
            throw new BuildException("no destdir specified");
        }
        if (!this.destdir.exists()) {
            throw new BuildException("destdir '" + this.destdir + "' doesn't exist");
        }
        try {
            map = this.fileToMap(this.mappingFile);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.toString(), (Throwable)iOException);
        }
        if (null == this.scriptDir) {
            throw new BuildException("no scriptdir specified");
        }
        if (!this.scriptDir.exists()) {
            throw new BuildException("scriptdir '" + this.scriptDir + "' doesn't exist");
        }
        File file = new File(this.scriptDir.getAbsolutePath() + File.separator + "gexpose.py");
        File file2 = new File(this.scriptDir.getAbsolutePath() + File.separator + "gderived.py");
        if (!file.exists()) {
            throw new BuildException("no gexpose.py script found at: " + file);
        }
        if (!file2.exists()) {
            throw new BuildException("no gderive.py script found at: " + file2);
        }
        String[] stringArray = this.src.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file3 = this.getProject().resolveFile(stringArray[i]);
            if (!file3.exists()) {
                throw new BuildException("srcDir '" + stringArray[i] + "' does not exist");
            }
            DirectoryScanner directoryScanner = this.getDirectoryScanner(file3);
            String[] stringArray2 = directoryScanner.getIncludedFiles();
            for (int j = 0; j < stringArray2.length; ++j) {
                String[] stringArray3;
                if (null == map.get(stringArray2[j])) {
                    if (!this.verbose) continue;
                    this.log("ignoring file (" + stringArray2[j] + ") with no mapping");
                    continue;
                }
                String string = file3.getAbsolutePath() + File.separator + stringArray2[j];
                String string2 = (String)map.get(stringArray2[j]);
                String string3 = string2.replace('.', File.separatorChar) + ".java";
                String string4 = this.destdir.getAbsolutePath() + File.separator + string3;
                if (!new File(string).exists()) {
                    throw new BuildException("source file '" + string + "' does not exist");
                }
                if (!new File(string4).exists()) {
                    throw new BuildException("destination file '" + string4 + "' (from class named " + string2 + ") does not exist");
                }
                if (string.endsWith(".expose")) {
                    stringArray3 = new String[]{this.python, file.getAbsolutePath(), string, string4};
                } else if (string.endsWith(".derived")) {
                    stringArray3 = new String[]{this.python, file2.getAbsolutePath(), string, string4};
                } else {
                    throw new BuildException("source file: '" + string + "' has unknown extension; expected .derived or .expose");
                }
                Execute execute = new Execute();
                execute.setWorkingDirectory(this.scriptDir);
                execute.setCommandline(stringArray3);
                if (this.verbose) {
                    String string5 = "";
                    for (int k = 0; k < execute.getCommandline().length; ++k) {
                        string5 = string5 + execute.getCommandline()[k] + " ";
                    }
                    this.log("executing: " + string5);
                }
                try {
                    execute.execute();
                    continue;
                }
                catch (IOException iOException) {
                    throw new BuildException(iOException.toString(), (Throwable)iOException);
                }
            }
        }
    }

    protected Map fileToMap(File file) throws IOException, BuildException {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while (null != (string = bufferedReader.readLine())) {
            if (string.trim().startsWith("#") || 0 == string.trim().compareTo("")) continue;
            int n = string.indexOf(":");
            if (-1 == n) {
                throw new BuildException("invalid mapping syntax; no ':' on line: '" + string + "'");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            hashMap.put(string2, string3);
        }
        return hashMap;
    }
}

