/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.schema.Column;

class ColumnNamesExtractor {
    static final ColumnNamesExtractor INSTANCE = new ColumnNamesExtractor();

    private ColumnNamesExtractor() {
    }

    Set<String> findColumnNamesOf(Expression expression) {
        HashSet<String> columnNames = new HashSet<String>();
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            Collection<String> leftRightColumnNames = this.extractColumnNamesOf(binaryExpression);
            columnNames.addAll(leftRightColumnNames);
        } else if (expression != null) {
            ColumnExpressionVisitor columnExpressionVisitor = new ColumnExpressionVisitor();
            expression.accept((ExpressionVisitor)columnExpressionVisitor);
            String visitedColumnName = columnExpressionVisitor.getVisitedColumnName();
            if (visitedColumnName != null) {
                columnNames.add(visitedColumnName);
            }
        }
        return columnNames;
    }

    private Collection<String> extractColumnNamesOf(BinaryExpression binaryExpression) {
        ArrayList<String> leftRightColumnNames = new ArrayList<String>();
        Set<String> leftColumnNames = this.findColumnNamesOf(binaryExpression.getLeftExpression());
        Set<String> rightColumnNames = this.findColumnNamesOf(binaryExpression.getRightExpression());
        leftRightColumnNames.addAll(leftColumnNames);
        leftRightColumnNames.addAll(rightColumnNames);
        return leftRightColumnNames;
    }

    private static class ColumnExpressionVisitor
    extends ExpressionVisitorAdapter {
        private String visitedColumnName;

        private ColumnExpressionVisitor() {
        }

        public void visit(Column column) {
            this.visitedColumnName = column.getColumnName();
        }

        String getVisitedColumnName() {
            return this.visitedColumnName;
        }
    }
}

