/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.qstd.DatabaseMetadataFinder;
import org.qstd.DatasetRow;
import org.qstd.DatasetRowSet;
import org.qstd.DatasetRowsFinder;
import org.qstd.SqlQuery;
import org.qstd.dbtype.DatabaseType;

class DatasetRowsGenerator {
    private final DataSource dataSource;
    private final DatabaseType dbType;
    private final DatabaseMetadataFinder databaseMetadataFinder;
    private final DatasetRowsFinder datasetRowsFinder;

    DatasetRowsGenerator(DataSource dataSource, DatabaseType dbType, DatabaseMetadataFinder databaseMetadataFinder) {
        this.dataSource = dataSource;
        this.dbType = dbType;
        this.databaseMetadataFinder = databaseMetadataFinder;
        this.datasetRowsFinder = new DatasetRowsFinder(dataSource);
    }

    List<DatasetRow> generateDatasetRowsFor(List<SqlQuery> sqlQueries) {
        DatasetRowSet datasetRowSet = new DatasetRowSet(this.dataSource, this.dbType, this.databaseMetadataFinder);
        for (SqlQuery sqlQuery : sqlQueries) {
            Collection<DatasetRow> datasetRows = this.datasetRowsFinder.findDatasetRowsOf(sqlQuery);
            datasetRowSet.add(datasetRows);
        }
        return datasetRowSet.sort();
    }
}

