/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.qstd.ColumnValueFormatter;
import org.qstd.DatasetRow;
import org.qstd.dbtype.DatabaseType;

class InsertStatementsGenerator {
    private final DatabaseType dbType;

    InsertStatementsGenerator(DatabaseType dbType) {
        this.dbType = dbType;
    }

    String generateInsertScriptFor(List<DatasetRow> datasetRows) {
        return datasetRows.stream().map(this::generateInsertStatementFrom).map(insertStatement -> insertStatement + ";" + System.lineSeparator()).collect(Collectors.joining());
    }

    private String generateInsertStatementFrom(DatasetRow datasetRow) {
        String tableName = datasetRow.getTableName();
        Set<String> columnNames = datasetRow.getColumnNames();
        Collection<Object> columnValues = datasetRow.getColumnValues();
        return "INSERT INTO " + tableName + "(" + this.formatColumnNames(columnNames) + ") VALUES(" + this.formatColumnValues(columnValues) + ")";
    }

    private String formatColumnNames(Set<String> columnNames) {
        return String.join((CharSequence)", ", columnNames);
    }

    private String formatColumnValues(Collection<Object> columnValues) {
        return columnValues.stream().map(columnValue -> ColumnValueFormatter.INSTANCE.formatColumnValue(columnValue, this.dbType)).collect(Collectors.joining(", "));
    }

    List<String> generateInsertStatementsFor(List<DatasetRow> datasetRows) {
        return datasetRows.stream().map(this::generateInsertStatementFrom).collect(Collectors.toList());
    }
}

