/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.qstd.DatabaseMetadataFinder;
import org.qstd.DatasetRow;
import org.qstd.RowFinder;
import org.qstd.dbtype.DatabaseType;

class MissingNotNullColumnsFinder {
    private final DataSource dataSource;
    private final DatabaseType dbType;
    private final DatabaseMetadataFinder databaseMetadataFinder;

    MissingNotNullColumnsFinder(DataSource dataSource, DatabaseType dbType, DatabaseMetadataFinder databaseMetadataFinder) {
        this.dataSource = dataSource;
        this.dbType = dbType;
        this.databaseMetadataFinder = databaseMetadataFinder;
    }

    Map<String, Object> findMissingNoNullColumnsOf(DatasetRow datasetRow) {
        String tableName = datasetRow.getTableName();
        Collection<String> notNullColumns = this.databaseMetadataFinder.findNotNullColumnsOf(tableName);
        Collection missingNotNullColumns = notNullColumns.stream().filter(columnName -> !datasetRow.hasNotNullValueForColumn((String)columnName)).collect(Collectors.toList());
        if (!missingNotNullColumns.isEmpty()) {
            RowFinder rowFinder = new RowFinder(this.dataSource, this.dbType);
            DatasetRow datasetRowWithMissingNotNullColumns = rowFinder.findOneRowFrom(datasetRow.getTableName(), missingNotNullColumns, datasetRow);
            return datasetRowWithMissingNotNullColumns.getColumnValueByColumnName();
        }
        return Collections.emptyMap();
    }
}

