/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.qstd.DatabaseMetadataFinder;
import org.qstd.DatasetRow;
import org.qstd.DatasetRowsGenerator;
import org.qstd.InsertStatementsGenerator;
import org.qstd.SqlQuery;
import org.qstd.dbtype.DatabaseMetadataFinderFactory;
import org.qstd.dbtype.DatabaseMetadataFinderWithCache;
import org.qstd.dbtype.DatabaseType;
import org.qstd.dbtype.DatabaseUrlFinder;

public class QuickSqlTestData {
    private final DatasetRowsGenerator datasetRowsGenerator;
    private final DatabaseType dbType;
    private InsertStatementsGenerator insertStatementGenerator;

    private QuickSqlTestData(DatasetRowsGenerator datasetRowsGenerator, DatabaseType dbType) {
        this.datasetRowsGenerator = datasetRowsGenerator;
        this.dbType = dbType;
        this.insertStatementGenerator = new InsertStatementsGenerator(dbType);
    }

    public static QuickSqlTestData buildFrom(DataSource dataSource) {
        String dbUrl = DatabaseUrlFinder.findDbUrlFrom(dataSource);
        DatabaseType dbType = DatabaseType.findFromDbUrl(dbUrl);
        DatabaseMetadataFinder databaseMetadataFinder = DatabaseMetadataFinderFactory.createDatabaseMetadataFinderFrom(dataSource, dbType);
        DatabaseMetadataFinder databaseMetadataFinderWithCache = DatabaseMetadataFinderWithCache.buildFrom(databaseMetadataFinder);
        return QuickSqlTestData.buildFrom(dataSource, dbType, databaseMetadataFinderWithCache);
    }

    public static QuickSqlTestData buildFrom(DataSource dataSource, DatabaseType dbType, DatabaseMetadataFinder databaseMetadataFinder) {
        DatasetRowsGenerator datasetRowsGenerator = new DatasetRowsGenerator(dataSource, dbType, databaseMetadataFinder);
        return new QuickSqlTestData(datasetRowsGenerator, dbType);
    }

    public String generateInsertScriptFor(String sqlQuery) {
        return this.generateInsertScriptFor(sqlQuery, Collections.emptyList());
    }

    public String generateInsertScriptFor(String query, List<Object> parameters) {
        List<SqlQuery> sqlQueries = Collections.singletonList(new SqlQuery(query, parameters));
        return this.generateInsertScriptFor(sqlQueries);
    }

    public String generateInsertScriptFor(List<SqlQuery> sqlQueries) {
        List<DatasetRow> datasetRows = this.datasetRowsGenerator.generateDatasetRowsFor(sqlQueries);
        return this.insertStatementGenerator.generateInsertScriptFor(datasetRows);
    }

    public String generateInsertScriptFor(String ... sqlQueries) {
        List<SqlQuery> queries = Arrays.stream(sqlQueries).map(SqlQuery::new).collect(Collectors.toList());
        return this.generateInsertScriptFor(queries);
    }

    public List<String> generateInsertListFor(DatasetRow datasetRow) {
        SqlQuery sqlQuery = SqlQuery.buildFromRow(datasetRow, this.dbType);
        return this.generateInsertListFor(sqlQuery.toString());
    }

    public List<String> generateInsertListFor(String ... sqlQueries) {
        List<SqlQuery> sqlQueryObjects = Arrays.stream(sqlQueries).map(SqlQuery::new).collect(Collectors.toList());
        List<DatasetRow> datasetRows = this.datasetRowsGenerator.generateDatasetRowsFor(sqlQueryObjects);
        return this.insertStatementGenerator.generateInsertStatementsFor(datasetRows);
    }
}

