/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.qstd.ColumnValueFormatter;
import org.qstd.DatasetRow;
import org.qstd.dbtype.DatabaseType;

public class SqlQuery {
    private final String queryAsString;
    private final List<Object> parameters;

    public SqlQuery(String queryAsString) {
        this.queryAsString = queryAsString;
        this.parameters = Collections.emptyList();
    }

    public SqlQuery(String queryAsString, List<Object> parameters) {
        this.queryAsString = queryAsString;
        this.parameters = parameters;
    }

    static SqlQuery buildFromRow(DatasetRow rowToSearch, DatabaseType dbType) {
        Set<String> columnNames = rowToSearch.getColumnNames();
        return SqlQuery.buildFromRow(columnNames, rowToSearch, dbType);
    }

    static SqlQuery buildFromRow(Collection<String> columnNamesToSearch, DatasetRow rowToSearch, DatabaseType dbType) {
        Map<String, Object> valuesToMatch = rowToSearch.getColumnValueByColumnName();
        String whereConditions = valuesToMatch.entrySet().stream().map(entry -> {
            String columnName = (String)entry.getKey();
            return columnName + (entry.getValue() == null ? " IS NULL" : "=" + ColumnValueFormatter.INSTANCE.formatColumnValue(entry.getValue(), dbType));
        }).collect(Collectors.joining(" AND "));
        String queryAsString = "SELECT " + String.join((CharSequence)", ", columnNamesToSearch) + " FROM " + rowToSearch.getTableName() + " WHERE " + whereConditions;
        return new SqlQuery(queryAsString);
    }

    public String toString() {
        return this.getQueryAsString();
    }

    String getQueryAsString() {
        return this.queryAsString;
    }

    List<Object> getParameters() {
        return this.parameters;
    }
}

