/*
 * Decompiled with CFR 0.152.
 */
package org.qstd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.update.Update;
import org.qstd.ColumnNamesExtractor;
import org.qstd.SelectTransformer;
import org.qstd.SqlQuery;

class UpdateToSelectTransformer
implements SelectTransformer {
    private Update updateStatement;

    UpdateToSelectTransformer(Update update) {
        this.updateStatement = update;
    }

    @Override
    public Optional<SqlQuery> toSelect(SqlQuery sqlQuery) {
        String tableName = this.updateStatement.getTable().getName();
        String selectAsString = " SELECT " + this.findSelectedColumnsSeparatedWithCommas() + " FROM " + tableName + this.findWhereClauseIfExists();
        List<Object> parameters = sqlQuery.getParameters();
        SqlQuery selectQuery = new SqlQuery(selectAsString, parameters);
        return Optional.of(selectQuery);
    }

    private String findSelectedColumnsSeparatedWithCommas() {
        Collection<String> columns = this.findColumnsToSelect();
        return String.join((CharSequence)", ", columns);
    }

    private Collection<String> findColumnsToSelect() {
        List<String> columnNames = this.findUpdatedColumnNames();
        ArrayList<String> columnsToSelect = new ArrayList<String>(columnNames);
        Collection<String> whereColumnNames = this.findWhereColumnNames();
        columnsToSelect.addAll(whereColumnNames);
        return columnsToSelect;
    }

    private List<String> findUpdatedColumnNames() {
        return this.updateStatement.getColumns().stream().map(Column::getColumnName).collect(Collectors.toList());
    }

    private String findWhereClauseIfExists() {
        Expression whereExpression = this.updateStatement.getWhere();
        return whereExpression == null ? "" : " WHERE " + whereExpression;
    }

    private Collection<String> findWhereColumnNames() {
        Expression whereExpression = this.updateStatement.getWhere();
        return ColumnNamesExtractor.INSTANCE.findColumnNamesOf(whereExpression);
    }
}

