/*
 * Decompiled with CFR 0.152.
 */
package org.qstd.dbtype;

import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.qstd.ColumnsMappingGroup;
import org.qstd.ColumnsMappingsFinder;
import org.qstd.DatabaseMetadataFinder;
import org.qstd.NotNullColumnsFinder;
import org.qstd.PrimaryKeyColumnsFinder;
import org.qstd.ReferencedTableSet;
import org.qstd.ReferencedTablesFinder;
import org.qstd.SqlQuery;
import org.qstd.dbtype.BaseColumnsMappingsFinder;
import org.qstd.dbtype.BaseReferencedTablesFinder;
import org.qstd.dbtype.DefaultColumnOrdersFinder;
import org.qstd.dbtype.DefaultNotNullColumnsFinder;
import org.qstd.dbtype.DefaultPrimaryKeyColumnsFinder;

class H2MetadataFinder
implements DatabaseMetadataFinder {
    private static final SqlQuery H2_REFERENCED_TABLES_QUERY = new SqlQuery("with\n    recursive parent_child_tree (table_name, ref_table_name, level) as\n    (\n    select distinct\n        child.table_name     as table_name,\n        parent.table_name    as ref_table_name,\n        1                    as level\n    from information_schema.table_constraints child\n    join information_schema.referential_constraints rco\n    on rco.constraint_name = child.constraint_name\n    join information_schema.constraints parent\n    on parent.unique_index_name = rco.unique_constraint_name\n    where\n        child.table_name != parent.table_name and\n        child.table_name=?\n    UNION ALL\n    select pc.table_name, pc.ref_table_name, pct.level + 1 as level\n    from\n        (\n        select \n            child.table_name     as table_name,\n            parent.table_name    as ref_table_name,\n            1                    as level\n        from information_schema.table_constraints child\n        join information_schema.referential_constraints rco\n        on rco.constraint_name = child.constraint_name\n        join information_schema.constraints parent\n        on parent.unique_index_name = rco.unique_constraint_name\n        where\n            child.table_name != parent.table_name\n        ) pc\n    join parent_child_tree pct on (pc.table_name = pct.ref_table_name)\n    )\nselect distinct *\nfrom parent_child_tree\norder by level desc");
    private static final SqlQuery H2_COLUMNS_MAPPINGS_QUERY = new SqlQuery("select \n        fktable_schema as table_schema,\n        fktable_name   as table_name,\n        fkcolumn_name  as column_name,\n        pktable_schema as ref_table_schema,\n        pktable_name   as ref_table_name,\n        pkcolumn_name  as ref_column_name\n  from information_schema.cross_references \n  where fktable_name = ?");
    private final DefaultColumnOrdersFinder defaultColumnOrdersFinder;
    private final NotNullColumnsFinder defaultNotNullColumnsFinder;
    private final ReferencedTablesFinder h2ReferencedTablesFinder;
    private final ColumnsMappingsFinder h2ColumnsMappingsFinder;
    private final PrimaryKeyColumnsFinder primaryKeyColumnsFinder;

    H2MetadataFinder(DataSource dataSource) {
        this.defaultColumnOrdersFinder = new DefaultColumnOrdersFinder(dataSource);
        this.defaultNotNullColumnsFinder = new DefaultNotNullColumnsFinder(dataSource);
        this.h2ReferencedTablesFinder = new BaseReferencedTablesFinder(dataSource, H2_REFERENCED_TABLES_QUERY);
        this.h2ColumnsMappingsFinder = new BaseColumnsMappingsFinder(dataSource, H2_COLUMNS_MAPPINGS_QUERY);
        this.primaryKeyColumnsFinder = new DefaultPrimaryKeyColumnsFinder(dataSource);
    }

    @Override
    public List<String> findDatabaseColumnOrdersOf(String tableName) {
        return this.defaultColumnOrdersFinder.findDatabaseColumnOrdersOf(tableName);
    }

    @Override
    public Collection<String> findNotNullColumnsOf(String tableName) {
        return this.defaultNotNullColumnsFinder.findNotNullColumnsOf(tableName);
    }

    @Override
    public ReferencedTableSet findReferencedTablesOf(String tableName) {
        return this.h2ReferencedTablesFinder.findReferencedTablesOf(tableName);
    }

    @Override
    public ColumnsMappingGroup findColumnsMappingsOf(String tableName) {
        return this.h2ColumnsMappingsFinder.findColumnsMappingsOf(tableName);
    }

    @Override
    public List<String> findPrimaryColumnsOf(String tableName) {
        return this.primaryKeyColumnsFinder.findPrimaryColumnsOf(tableName);
    }
}

