/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec.impls;

import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.refcodes.codec.BaseCodecBuilder;
import org.refcodes.codec.BaseCodecConfig;
import org.refcodes.codec.BaseCodecMetrics;
import org.refcodes.codec.impls.BaseCodecBuilderImpl;
import org.refcodes.codec.impls.BaseCodecMetricsImpl;
import org.refcodes.data.NumberBaseConsts;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.mixin.VerifyMode;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.impls.RandomTextGenerartorImpl;
import org.refcodes.textual.impls.TableBuilderImpl;

public class BaseCodecBuilderTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    protected static final int WEAK_INTENSITY_LOOPS = 10240;
    protected static final int STRONG_INTENSITY_LOOPS = 150000;
    protected static final int MAX_DATA_LENGTH = 8192;

    @Ignore(value="All-tests now OK as of performance enhancements")
    @Test
    public void testSomeRandomText1() {
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BIN, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.OCT, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.DEC, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.HEX, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE17, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE21, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE25, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE27, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE32, true);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE64, true);
    }

    @Ignore(value="All-tests now OK as of performance enhancements")
    @Test
    public void testSomeRandomText2() {
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BIN, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.OCT, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.DEC, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.HEX, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE17, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE21, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE25, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE27, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE32, false);
        this.runRandomTextTest((BaseCodecMetrics)BaseCodecConfig.BASE64, false);
    }

    @Ignore(value="All-tests now OK as of performance enhancements")
    @Test
    public void testSomeRandomBytes1() {
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BIN, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.OCT, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.DEC, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.HEX, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE17, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE21, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE25, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE27, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE32, true);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE64, true);
    }

    @Ignore(value="All-tests now OK as of performance enhancements")
    @Test
    public void testSomeRandomBytes2() {
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BIN, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.OCT, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.DEC, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.HEX, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE17, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE21, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE25, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE27, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE32, false);
        this.runRandomBytesTest((BaseCodecMetrics)BaseCodecConfig.BASE64, false);
    }

    @Test
    public void testAllRandomText() {
        boolean isTestSideEffectFreeCall = true;
        for (BaseCodecConfig eCodec : BaseCodecConfig.values()) {
            this.runRandomTextTest((BaseCodecMetrics)eCodec, isTestSideEffectFreeCall);
            isTestSideEffectFreeCall = !isTestSideEffectFreeCall;
        }
    }

    @Test
    public void testAllRandomBytes() {
        boolean isTestSideEffectFreeCall = true;
        for (BaseCodecConfig eCodec : BaseCodecConfig.values()) {
            this.runRandomBytesTest((BaseCodecMetrics)eCodec, isTestSideEffectFreeCall);
            isTestSideEffectFreeCall = !isTestSideEffectFreeCall;
        }
    }

    @Test
    public void showCodecMetrics() {
        TableBuilder theTableBuilder = new TableBuilderImpl().withTableStyle(TableStyle.SINGLE_DOUBLE);
        theTableBuilder.printHeader(new String[]{"ENUM", "BASE", "BYTES/INT", "BITS/DIGIT", "DIGITS/BYTE", "DIGITS/INT"});
        for (BaseCodecConfig eBaseCodec : BaseCodecConfig.values()) {
            theTableBuilder.printRow(new String[]{eBaseCodec.name(), "" + eBaseCodec.getNumberBase(), "" + eBaseCodec.getBytesPerInt(), "" + eBaseCodec.getBitsPerDigit(), "" + eBaseCodec.getDigitsPerByte(), "" + eBaseCodec.getDigitsPerInt()});
        }
        theTableBuilder.printTail();
    }

    @Ignore(value="Just for debugging purposes")
    @Test
    public void debugBase10Codec() {
        BaseCodecConfig theBase10 = BaseCodecConfig.BASE10;
        this.runRandomTextTest((BaseCodecMetrics)theBase10, false);
    }

    @Test
    public void debugBase17Codec() {
        BaseCodecMetricsImpl theBase17 = new BaseCodecMetricsImpl(17, NumberBaseConsts.ARABIC_BASE_CHARS);
        this.runRandomTextTest((BaseCodecMetrics)theBase17, false);
    }

    @Test
    public void debugBase23Codec() {
        BaseCodecMetricsImpl theBase23 = new BaseCodecMetricsImpl(23, NumberBaseConsts.ARABIC_BASE_CHARS);
        this.runRandomTextTest((BaseCodecMetrics)theBase23, true);
    }

    @Test
    public void debugBase64Codec() {
        BaseCodecMetricsImpl theBase64 = new BaseCodecMetricsImpl(64, NumberBaseConsts.BASE64_CHARS);
        this.runRandomTextTest((BaseCodecMetrics)theBase64, true);
    }

    @Test
    public void debugGetBytesFromText() {
        BaseCodecBuilder theBaseCodeBuilder = new BaseCodecBuilderImpl().withBaseCodecMetrics((BaseCodecMetrics)BaseCodecConfig.BASE64);
        theBaseCodeBuilder.withDecodedData("Hello world!".getBytes());
        LOGGER.debug(theBaseCodeBuilder.getEncodedText());
    }

    @Ignore(value="Just for throughput measurement")
    @Test
    public void testEncodeRefcodes() {
        RandomTextGenerartor theRndGen = new RandomTextGenerartorImpl().withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        BaseCodecBuilder theBaseCodeBuilder = new BaseCodecBuilderImpl().withBaseCodecMetrics((BaseCodecMetrics)BaseCodecConfig.BASE64);
        for (int i = 0; i < 150000; ++i) {
            theRndGen.withColumnWidth(i % 8192);
            String theRndText = (String)theRndGen.next();
            byte[] eBytes = theRndText.getBytes();
            theBaseCodeBuilder.withDecodedData(eBytes).getEncodedText();
        }
    }

    @Ignore(value="Just for throughput measurement")
    @Test
    public void testEncodeApache() {
        RandomTextGenerartor theRndGen = new RandomTextGenerartorImpl().withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        for (int i = 0; i < 150000; ++i) {
            theRndGen.withColumnWidth(i % 8192);
            String theRndText = (String)theRndGen.next();
            byte[] eBytes = theRndText.getBytes();
            Base64.encodeBase64String((byte[])eBytes);
        }
    }

    @Ignore(value="Just for throughput measurement")
    @Test
    public void testEncodeJava() {
        RandomTextGenerartor theRndGen = new RandomTextGenerartorImpl().withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        for (int i = 0; i < 150000; ++i) {
            theRndGen.withColumnWidth(i % 8192);
            String theRndText = (String)theRndGen.next();
            byte[] eBytes = theRndText.getBytes();
            java.util.Base64.getEncoder().encodeToString(eBytes);
        }
    }

    private void runRandomTextTest(BaseCodecMetrics aBaseCodecMetrics, boolean isWithSideEffectFreeShortcut) {
        LOGGER.info("Running random text tests for base <" + aBaseCodecMetrics.getNumberBase() + "> (shortcut = <" + isWithSideEffectFreeShortcut + ">) ...");
        RandomTextGenerartor theRndGen = new RandomTextGenerartorImpl().withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        BaseCodecBuilder theBaseCodeBuilder = (BaseCodecBuilder)new BaseCodecBuilderImpl().withBaseCodecMetrics(aBaseCodecMetrics).withVerifyMode(VerifyMode.NONE);
        for (int i = 0; i < 10240; ++i) {
            theRndGen.withColumnWidth(i % 8192);
            String eRndText = (String)theRndGen.next();
            byte[] eInputBytes = eRndText.getBytes();
            String eEncodedText = !isWithSideEffectFreeShortcut ? theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText() : theBaseCodeBuilder.toEncodedText(eInputBytes);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assert.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseCodecMetrics != BaseCodecConfig.BASE64) continue;
            String eReferenceEncodedText = java.util.Base64.getEncoder().encodeToString(eInputBytes);
            Assert.assertEquals((String)"Expecting our BASE64 encoding to be compatible with standard Java 8 encoding!", (Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }

    private void runRandomBytesTest(BaseCodecMetrics aBaseCodecMetrics, boolean isWithSideEffectFreeShortcut) {
        LOGGER.info("Running random bytes tests for base <" + aBaseCodecMetrics.getNumberBase() + "> (shortcut = <" + isWithSideEffectFreeShortcut + ">) ...");
        BaseCodecBuilder theBaseCodeBuilder = (BaseCodecBuilder)new BaseCodecBuilderImpl().withBaseCodecMetrics(aBaseCodecMetrics).withVerifyMode(VerifyMode.NONE);
        for (int i = 0; i < 10240; ++i) {
            int eMod = i % 8192;
            byte[] eInputBytes = new byte[eMod];
            new Random().nextBytes(eInputBytes);
            String eEncodedText = !isWithSideEffectFreeShortcut ? theBaseCodeBuilder.withDecodedData(eInputBytes).getEncodedText() : theBaseCodeBuilder.toEncodedText(eInputBytes);
            byte[] eDecodedBytes = theBaseCodeBuilder.withEncodedText(eEncodedText).getDecodedData();
            Assert.assertArrayEquals((byte[])eInputBytes, (byte[])eDecodedBytes);
            if (aBaseCodecMetrics != BaseCodecConfig.BASE64) continue;
            String eReferenceEncodedText = java.util.Base64.getEncoder().encodeToString(eInputBytes);
            Assert.assertEquals((String)"Expecting our BASE64 encoding to be compatible with standard Java 8 encoding!", (Object)eReferenceEncodedText, (Object)eEncodedText);
        }
    }
}

